/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.core.networkmanager.impl;

import com.aelitis.azureus.core.networkmanager.VirtualChannelSelector;
import com.aelitis.azureus.core.networkmanager.impl.RateControlledEntity;
import java.util.ArrayList;
import org.gudy.azureus2.core3.util.AEMonitor;
import org.gudy.azureus2.core3.util.AEThread;
import org.gudy.azureus2.core3.util.Debug;

public class ReadController {
    private final VirtualChannelSelector read_selector = new VirtualChannelSelector(1, true);
    private volatile ArrayList normal_priority_entities = new ArrayList();
    private volatile ArrayList high_priority_entities = new ArrayList();
    private final AEMonitor entities_mon = new AEMonitor("ReadController:EM");
    private int next_normal_position = 0;
    private int next_high_position = 0;
    private static final int IDLE_SLEEP_TIME = 25;
    private static final int SELECT_LOOP_TIME = 25;

    public ReadController() {
        AEThread read_selector_thread = new AEThread("ReadController:ReadSelector"){

            public void runSupport() {
                ReadController.this.readSelectorLoop();
            }
        };
        read_selector_thread.setDaemon(true);
        read_selector_thread.setPriority(8);
        read_selector_thread.start();
        AEThread read_processor_thread = new AEThread("ReadController:ReadProcessor"){

            public void runSupport() {
                ReadController.this.readProcessorLoop();
            }
        };
        read_processor_thread.setDaemon(true);
        read_processor_thread.setPriority(9);
        read_processor_thread.start();
    }

    private void readSelectorLoop() {
        while (true) {
            try {
                while (true) {
                    this.read_selector.select(25L);
                }
            }
            catch (Throwable t) {
                Debug.out("readSelectorLoop() EXCEPTION: ", t);
                continue;
            }
            break;
        }
    }

    private void readProcessorLoop() {
        boolean check_high_first = true;
        block6: while (true) {
            try {
                while (true) {
                    if (check_high_first) {
                        check_high_first = false;
                        if (this.doHighPriorityRead() || this.doNormalPriorityRead()) continue;
                        try {
                            Thread.sleep(25L);
                            continue block6;
                        }
                        catch (Exception e) {
                            Debug.printStackTrace(e);
                            continue;
                        }
                    }
                    check_high_first = true;
                    if (this.doNormalPriorityRead() || this.doHighPriorityRead()) continue;
                    try {
                        Thread.sleep(25L);
                        continue block6;
                    }
                    catch (Exception e) {
                        Debug.printStackTrace(e);
                        continue;
                    }
                    break;
                }
            }
            catch (Throwable t) {
                Debug.out("readProcessorLoop() EXCEPTION: ", t);
                continue;
            }
            break;
        }
    }

    private boolean doNormalPriorityRead() {
        RateControlledEntity ready_entity = this.getNextReadyNormalPriorityEntity();
        return ready_entity != null && ready_entity.doProcessing();
    }

    private boolean doHighPriorityRead() {
        RateControlledEntity ready_entity = this.getNextReadyHighPriorityEntity();
        return ready_entity != null && ready_entity.doProcessing();
    }

    private RateControlledEntity getNextReadyNormalPriorityEntity() {
        ArrayList ref = this.normal_priority_entities;
        int size = ref.size();
        for (int num_checked = 0; num_checked < size; ++num_checked) {
            this.next_normal_position = this.next_normal_position >= size ? 0 : this.next_normal_position;
            RateControlledEntity entity = (RateControlledEntity)ref.get(this.next_normal_position);
            ++this.next_normal_position;
            if (!entity.canProcess()) continue;
            return entity;
        }
        return null;
    }

    private RateControlledEntity getNextReadyHighPriorityEntity() {
        ArrayList ref = this.high_priority_entities;
        int size = ref.size();
        for (int num_checked = 0; num_checked < size; ++num_checked) {
            this.next_high_position = this.next_high_position >= size ? 0 : this.next_high_position;
            RateControlledEntity entity = (RateControlledEntity)ref.get(this.next_high_position);
            ++this.next_high_position;
            if (!entity.canProcess()) continue;
            return entity;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addReadEntity(RateControlledEntity entity) {
        try {
            this.entities_mon.enter();
            if (entity.getPriority() == 1) {
                ArrayList<RateControlledEntity> high_new = new ArrayList<RateControlledEntity>(this.high_priority_entities.size() + 1);
                high_new.addAll(this.high_priority_entities);
                high_new.add(entity);
                this.high_priority_entities = high_new;
            } else {
                ArrayList<RateControlledEntity> norm_new = new ArrayList<RateControlledEntity>(this.normal_priority_entities.size() + 1);
                norm_new.addAll(this.normal_priority_entities);
                norm_new.add(entity);
                this.normal_priority_entities = norm_new;
            }
        }
        finally {
            this.entities_mon.exit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeReadEntity(RateControlledEntity entity) {
        try {
            this.entities_mon.enter();
            if (entity.getPriority() == 1) {
                ArrayList high_new = new ArrayList(this.high_priority_entities);
                high_new.remove(entity);
                this.high_priority_entities = high_new;
            } else {
                ArrayList norm_new = new ArrayList(this.normal_priority_entities);
                norm_new.remove(entity);
                this.normal_priority_entities = norm_new;
            }
        }
        finally {
            this.entities_mon.exit();
        }
    }

    public VirtualChannelSelector getReadSelector() {
        return this.read_selector;
    }
}

