/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.core.networkmanager.impl;

import com.aelitis.azureus.core.networkmanager.impl.TCPTransportHelper;
import com.aelitis.azureus.core.networkmanager.impl.TCPTransportHelperFilter;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.SocketChannel;

public class TCPTransportHelperFilterTransparent
implements TCPTransportHelperFilter {
    private TCPTransportHelper transport;
    private boolean is_plain;
    private ByteBuffer read_insert;

    protected TCPTransportHelperFilterTransparent(TCPTransportHelper _transport, boolean _is_plain) {
        this.transport = _transport;
        this.is_plain = _is_plain;
    }

    protected void insertRead(ByteBuffer _read_insert) {
        this.read_insert = _read_insert;
    }

    public boolean isFlushed() {
        return true;
    }

    public long write(ByteBuffer[] buffers, int array_offset, int length) throws IOException {
        return this.transport.write(buffers, array_offset, length);
    }

    public int write(ByteBuffer buffer) throws IOException {
        return this.transport.write(buffer);
    }

    public long read(ByteBuffer[] buffers, int array_offset, int length) throws IOException {
        int len = 0;
        if (this.read_insert != null) {
            int pos_before = this.read_insert.position();
            for (int i = array_offset; i < array_offset + length; ++i) {
                buffers[i].put(this.read_insert);
                if (!this.read_insert.hasRemaining()) break;
            }
            len = this.read_insert.position() - pos_before;
            if (this.read_insert.hasRemaining()) {
                return len;
            }
            this.read_insert = null;
        }
        return (long)len + this.transport.read(buffers, array_offset, length);
    }

    public int read(ByteBuffer buffer) throws IOException {
        if (this.read_insert != null) {
            return (int)this.read(new ByteBuffer[]{buffer}, 0, 1);
        }
        return this.transport.read(buffer);
    }

    public SocketChannel getSocketChannel() {
        return this.transport.getSocketChannel();
    }

    public String getName() {
        return this.is_plain ? "Plain" : "None";
    }
}

