/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.core.peermanager.control.impl;

import com.aelitis.azureus.core.peermanager.control.PeerControlInstance;
import com.aelitis.azureus.core.peermanager.control.PeerControlScheduler;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Random;
import org.gudy.azureus2.core3.util.AEMonitor;
import org.gudy.azureus2.core3.util.AEThread;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.core3.util.SystemTime;

public class PeerControlSchedulerImpl
implements PeerControlScheduler {
    private static final PeerControlSchedulerImpl singleton = new PeerControlSchedulerImpl();
    private Random random = new Random();
    private Map instance_map = new HashMap();
    private List pending_registrations = new ArrayList();
    private volatile boolean registrations_changed;
    private volatile long latest_time;
    protected AEMonitor this_mon = new AEMonitor("PeerControlScheduler");

    public static PeerControlScheduler getSingleton() {
        return singleton;
    }

    protected PeerControlSchedulerImpl() {
        new AEThread("PeerControlScheduler", true){

            public void runSupport() {
                PeerControlSchedulerImpl.this.schedule();
            }
        }.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void schedule() {
        this.latest_time = SystemTime.getCurrentTime();
        SystemTime.registerConsumer(new SystemTime.consumer(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void timeRead(long time) {
                PeerControlSchedulerImpl peerControlSchedulerImpl = PeerControlSchedulerImpl.this;
                synchronized (peerControlSchedulerImpl) {
                    PeerControlSchedulerImpl.this.latest_time = time;
                    PeerControlSchedulerImpl.this.notify();
                }
            }
        });
        LinkedList instances = new LinkedList();
        long latest_time_used = 0L;
        long tick_count = 0L;
        long last_stats_time = this.latest_time;
        while (true) {
            if (this.registrations_changed) {
                try {
                    this.this_mon.enter();
                    Iterator it = instances.iterator();
                    while (it.hasNext()) {
                        if (!((instanceWrapper)it.next()).isUnregistered()) continue;
                        it.remove();
                    }
                    for (int i = 0; i < this.pending_registrations.size(); ++i) {
                        instances.add(this.pending_registrations.get(i));
                    }
                    this.pending_registrations.clear();
                    this.registrations_changed = false;
                }
                finally {
                    this.this_mon.exit();
                }
            }
            for (int i = 0; i < instances.size(); ++i) {
                instanceWrapper inst = (instanceWrapper)instances.get(i);
                long target = inst.getNextTick();
                long diff = target - latest_time_used;
                if (diff > 0L && diff <= 100L) continue;
                ++tick_count;
                inst.schedule();
                long new_target = target + 100L;
                diff = new_target - latest_time_used;
                if (diff <= 0L || diff > 100L) {
                    new_target = latest_time_used + 100L;
                }
                inst.setNextTick(new_target);
            }
            PeerControlSchedulerImpl i = this;
            synchronized (i) {
                if (this.latest_time == latest_time_used) {
                    try {
                        this.wait();
                    }
                    catch (Throwable e) {
                        Debug.printStackTrace(e);
                    }
                } else {
                    Thread.yield();
                }
                latest_time_used = this.latest_time;
            }
            long stats_diff = latest_time_used - last_stats_time;
            if (stats_diff <= 10000L) continue;
            last_stats_time = latest_time_used;
            tick_count = 0L;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void register(PeerControlInstance instance) {
        instanceWrapper wrapper = new instanceWrapper(instance);
        wrapper.setNextTick(this.latest_time + (long)this.random.nextInt(100));
        try {
            this.this_mon.enter();
            HashMap<PeerControlInstance, instanceWrapper> new_map = new HashMap<PeerControlInstance, instanceWrapper>(this.instance_map);
            new_map.put(instance, wrapper);
            this.instance_map = new_map;
            this.pending_registrations.add(wrapper);
            this.registrations_changed = true;
        }
        finally {
            this.this_mon.exit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unregister(PeerControlInstance instance) {
        try {
            this.this_mon.enter();
            HashMap new_map = new HashMap(this.instance_map);
            instanceWrapper wrapper = (instanceWrapper)new_map.remove(instance);
            if (wrapper == null) {
                Debug.out("instance wrapper not found");
                return;
            }
            wrapper.unregister();
            this.instance_map = new_map;
            this.registrations_changed = true;
        }
        finally {
            this.this_mon.exit();
        }
    }

    protected static class instanceWrapper {
        private PeerControlInstance instance;
        private boolean unregistered;
        private long next_tick;

        protected instanceWrapper(PeerControlInstance _instance) {
            this.instance = _instance;
        }

        protected void unregister() {
            this.unregistered = true;
        }

        protected boolean isUnregistered() {
            return this.unregistered;
        }

        protected void setNextTick(long t) {
            this.next_tick = t;
        }

        protected long getNextTick() {
            return this.next_tick;
        }

        protected PeerControlInstance getInstance() {
            return this.instance;
        }

        protected void schedule() {
            try {
                this.instance.schedule();
            }
            catch (Throwable e) {
                Debug.printStackTrace(e);
            }
        }
    }
}

