/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.core.versioncheck;

import com.aelitis.azureus.core.AzureusCoreFactory;
import com.aelitis.azureus.core.clientmessageservice.ClientMessageService;
import com.aelitis.azureus.core.clientmessageservice.ClientMessageServiceClient;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.gudy.azureus2.core3.config.COConfigurationManager;
import org.gudy.azureus2.core3.logging.LogEvent;
import org.gudy.azureus2.core3.logging.LogIDs;
import org.gudy.azureus2.core3.logging.Logger;
import org.gudy.azureus2.core3.stats.transfer.OverallStats;
import org.gudy.azureus2.core3.stats.transfer.StatsFactory;
import org.gudy.azureus2.core3.util.AEMonitor;
import org.gudy.azureus2.core3.util.Constants;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.core3.util.SystemProperties;
import org.gudy.azureus2.core3.util.SystemTime;
import org.gudy.azureus2.plugins.PluginInterface;

public class VersionCheckClient {
    private static final LogIDs LOGID = LogIDs.CORE;
    public static final String REASON_UPDATE_CHECK_START = "us";
    public static final String REASON_UPDATE_CHECK_PERIODIC = "up";
    public static final String REASON_CHECK_SWT = "sw";
    public static final String REASON_DHT_EXTENDED_ALLOWED = "dx";
    public static final String REASON_DHT_ENABLE_ALLOWED = "de";
    public static final String REASON_EXTERNAL_IP = "ip";
    public static final String REASON_RECOMMENDED_PLUGINS = "rp";
    private static final String SERVER_ADDRESS = "version.aelitis.com";
    private static final int SERVER_PORT = 27001;
    private static final String MESSAGE_TYPE_ID = "AZVER";
    private static final long CACHE_PERIOD = 300000L;
    private static final VersionCheckClient instance = new VersionCheckClient();
    private Map last_check_data = null;
    private final AEMonitor check_mon = new AEMonitor("versioncheckclient");
    private long last_check_time = 0L;

    private VersionCheckClient() {
    }

    public static VersionCheckClient getSingleton() {
        return instance;
    }

    public Map getVersionCheckInfo(String reason) {
        return this.getVersionCheckInfo(reason, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map getVersionCheckInfo(String reason, boolean only_if_cached) {
        try {
            boolean force;
            this.check_mon.enter();
            long time_diff = SystemTime.getCurrentTime() - this.last_check_time;
            boolean bl = force = time_diff > 300000L || time_diff < 0L;
            if (this.last_check_data == null || this.last_check_data.size() == 0 || force) {
                if (only_if_cached && this.last_check_data != null) {
                    HashMap hashMap = new HashMap();
                    return hashMap;
                }
                try {
                    this.last_check_data = this.performVersionCheck(this.constructVersionCheckMessage(reason));
                }
                catch (Throwable t) {
                    t.printStackTrace();
                    this.last_check_data = new HashMap();
                }
            } else {
                Logger.log(new LogEvent(LOGID, "VersionCheckClient is using cached version check info. Using " + this.last_check_data.size() + " reply keys."));
            }
        }
        finally {
            this.check_mon.exit();
        }
        if (this.last_check_data == null) {
            this.last_check_data = new HashMap();
        }
        return this.last_check_data;
    }

    private boolean isVersionCheckDataValid() {
        return this.last_check_data != null && this.last_check_data.size() > 0;
    }

    public String getExternalIpAddress(boolean only_if_cached) {
        Map reply = this.getVersionCheckInfo(REASON_EXTERNAL_IP, only_if_cached);
        byte[] address = (byte[])reply.get("source_ip_address");
        if (address != null) {
            return new String(address);
        }
        return null;
    }

    public boolean DHTEnableAllowed() {
        Map reply = this.getVersionCheckInfo(REASON_DHT_ENABLE_ALLOWED);
        boolean res = false;
        byte[] value = (byte[])reply.get("enable_dht");
        if (value != null) {
            res = new String(value).equalsIgnoreCase("true");
        }
        if (!res) {
            res = !this.isVersionCheckDataValid();
        }
        return res;
    }

    public boolean DHTExtendedUseAllowed() {
        Map reply = this.getVersionCheckInfo(REASON_DHT_EXTENDED_ALLOWED);
        boolean res = false;
        byte[] value = (byte[])reply.get("enable_dht_extended_use");
        if (value != null) {
            res = new String(value).equalsIgnoreCase("true");
        }
        if (!res) {
            res = !this.isVersionCheckDataValid();
        }
        return res;
    }

    public String[] getRecommendedPlugins() {
        Map reply = this.getVersionCheckInfo(REASON_RECOMMENDED_PLUGINS);
        List l = (List)reply.get("recommended_plugins");
        if (l == null) {
            return new String[0];
        }
        String[] res = new String[l.size()];
        for (int i = 0; i < l.size(); ++i) {
            res[i] = new String((byte[])l.get(i));
        }
        return res;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map performVersionCheck(Map data_to_send) throws Exception {
        if (Logger.isEnabled()) {
            Logger.log(new LogEvent(LOGID, "VersionCheckClient retrieving version information from version.aelitis.com:27001"));
        }
        ClientMessageService msg_service = null;
        Map reply = null;
        try {
            msg_service = ClientMessageServiceClient.getServerService(SERVER_ADDRESS, 27001, MESSAGE_TYPE_ID);
            msg_service.sendMessage(data_to_send);
            reply = msg_service.receiveMessage();
        }
        finally {
            if (msg_service != null) {
                msg_service.close();
            }
        }
        if (Logger.isEnabled()) {
            Logger.log(new LogEvent(LOGID, "VersionCheckClient server version check successful. Received " + reply.size() + " reply keys."));
        }
        this.last_check_time = SystemTime.getCurrentTime();
        return reply;
    }

    private Map constructVersionCheckMessage(String reason) {
        HashMap<String, Object> message = new HashMap<String, Object>();
        message.put("appid", SystemProperties.getApplicationIdentifier());
        message.put("version", "2.3.0.7_B51");
        String id = COConfigurationManager.getStringParameter("ID", null);
        boolean send_info = COConfigurationManager.getBooleanParameter("Send Version Info");
        int last_send_time = COConfigurationManager.getIntParameter("Send Version Info Last Time", -1);
        int current_send_time = (int)(SystemTime.getCurrentTime() / 1000L);
        COConfigurationManager.setParameter("Send Version Info Last Time", current_send_time);
        if (id != null && send_info) {
            message.put("id", id);
            message.put("os", Constants.OSName);
            message.put("os_version", System.getProperty("os.version"));
            message.put("os_arch", System.getProperty("os.arch"));
            if (last_send_time != -1 && last_send_time < current_send_time) {
                message.put("tsl", new Long(current_send_time - last_send_time));
            }
            message.put("reason", reason);
            String java_version = System.getProperty("java.version");
            if (java_version == null) {
                java_version = "unknown";
            }
            message.put("java", java_version);
            String java_vendor = System.getProperty("java.vm.vendor");
            if (java_vendor == null) {
                java_vendor = "unknown";
            }
            message.put("javavendor", java_vendor);
            long max_mem = Runtime.getRuntime().maxMemory() / 0x100000L;
            message.put("javamx", new Long(max_mem));
            OverallStats stats = StatsFactory.getStats();
            if (stats != null) {
                long total_bytes_downloaded = stats.getDownloadedBytes();
                long total_bytes_uploaded = stats.getUploadedBytes();
                long total_uptime = stats.getTotalUpTime();
                message.put("total_bytes_downloaded", new Long(total_bytes_downloaded));
                message.put("total_bytes_uploaded", new Long(total_bytes_uploaded));
                message.put("total_uptime", new Long(total_uptime));
            }
            if (AzureusCoreFactory.isCoreAvailable()) {
                PluginInterface[] plugins = AzureusCoreFactory.getSingleton().getPluginManager().getPluginInterfaces();
                ArrayList<String> pids = new ArrayList<String>();
                for (int i = 0; i < plugins.length; ++i) {
                    String pid = plugins[i].getPluginID();
                    String info = plugins[i].getPluginconfig().getPluginStringParameter("plugin.info");
                    if ((info == null || info.length() <= 0) && (pid.startsWith("<") || pid.startsWith("azbp") || pid.startsWith("azupdater") || pid.startsWith("azplatform") || pids.contains(pid))) continue;
                    if (info != null && info.length() > 0) {
                        if (info.length() < 256) {
                            pid = pid + ":" + info;
                        } else {
                            Debug.out("Plugin '" + pid + "' reported excessive info string '" + info + "'");
                        }
                    }
                    pids.add(pid);
                }
                message.put("plugins", pids);
            }
        }
        try {
            Class<?> c = Class.forName("org.eclipse.swt.SWT");
            String swt_platform = (String)c.getMethod("getPlatform", new Class[0]).invoke(null, new Object[0]);
            message.put("swt_platform", swt_platform);
            if (send_info) {
                Integer swt_version = (Integer)c.getMethod("getVersion", new Class[0]).invoke(null, new Object[0]);
                message.put("swt_version", new Long(swt_version.longValue()));
            }
        }
        catch (ClassNotFoundException e) {
        }
        catch (NoClassDefFoundError er) {
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
        return message;
    }
}

