/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.plugins.jpc;

import com.aelitis.azureus.plugins.jpc.cache.impl.JPCCacheManagerImpl;
import com.aelitis.azureus.plugins.jpc.peer.PeerController;
import com.aelitis.azureus.plugins.jpc.peer.impl.PeerControllerImpl;
import java.util.Timer;
import org.gudy.azureus2.plugins.Plugin;
import org.gudy.azureus2.plugins.PluginInterface;
import org.gudy.azureus2.plugins.logging.LoggerChannel;
import org.gudy.azureus2.plugins.logging.LoggerChannelListener;
import org.gudy.azureus2.plugins.ui.config.BooleanParameter;
import org.gudy.azureus2.plugins.ui.config.Parameter;
import org.gudy.azureus2.plugins.ui.config.ParameterListener;
import org.gudy.azureus2.plugins.ui.model.BasicPluginConfigModel;
import org.gudy.azureus2.plugins.ui.model.BasicPluginViewModel;

public class JPCPlugin
implements Plugin {
    public static final boolean USE_TEST_CACHE = false;
    public static final int LOG_PUBLIC = 1;
    public static final int LOG_DEBUG = 2;
    public static final String PLUGIN_VERSION = "1.2";
    public static final String PLUGIN_NAME = "JPC";
    public static final String PLUGIN_LANG_RESOURCE = "com.aelitis.azureus.plugins.jpc.internat.Messages";
    private PluginInterface plugin_interface;
    private PeerController peer_controller;
    private LoggerChannel logger;
    private Timer plugin_timer;
    private BooleanParameter enable_uploader;
    private BooleanParameter enable_downloader;

    public void initialize(PluginInterface _pi) {
        this.plugin_interface = _pi;
        this.plugin_timer = new Timer(true);
        this.logger = this.plugin_interface.getLogger().getChannel(PLUGIN_NAME);
        this.plugin_interface.getPluginProperties().setProperty("plugin.version", PLUGIN_VERSION);
        this.plugin_interface.getPluginProperties().setProperty("plugin.name", PLUGIN_NAME);
        this.plugin_interface.getUtilities().getLocaleUtilities().integrateLocalisedMessageBundle(PLUGIN_LANG_RESOURCE);
        BasicPluginConfigModel config = this.plugin_interface.getUIManager().createBasicPluginConfigModel("Plugins", "azjpc.name");
        this.enable_uploader = config.addBooleanParameter2("azjpc.enableuploader", "azjpc.enableuploader", true);
        this.enable_downloader = config.addBooleanParameter2("azjpc.enabledownloader", "azjpc.enabledownloader", true);
        final BasicPluginViewModel model = this.plugin_interface.getUIManager().createBasicPluginViewModel(PLUGIN_NAME);
        model.getActivity().setVisible(false);
        model.getProgress().setVisible(false);
        model.getStatus().setText("Loading...");
        this.logger.addListener(new LoggerChannelListener(){

            public void messageLogged(int type, String message) {
                model.getLogArea().appendText(message + "\n");
            }

            public void messageLogged(String str, Throwable error) {
                model.getLogArea().appendText(error.toString() + "\n");
            }
        });
        this.enable_downloader.addListener(new ParameterListener(){

            public void parameterChanged(Parameter param) {
                JPCPlugin.this.activate(model);
            }
        });
        this.enable_uploader.addListener(new ParameterListener(){

            public void parameterChanged(Parameter param) {
                JPCPlugin.this.activate(model);
            }
        });
        this.activate(model);
    }

    private void activate(BasicPluginViewModel model) {
        if (!this.isCacheDownloadEnabled()) {
            this.log("Cache DOWNLOAD usage disabled in config.", 1);
            if (this.peer_controller != null) {
                this.peer_controller.dropDownloadCacheSession();
            }
        }
        if (!this.isCacheUploadEnabled()) {
            this.log("Cache UPLOAD usage disabled in config.", 1);
        }
        if (this.isCacheDownloadEnabled() || this.isCacheUploadEnabled()) {
            model.getStatus().setText("Running");
            if (this.peer_controller == null) {
                this.peer_controller = new PeerControllerImpl(this, new JPCCacheManagerImpl(this));
                this.peer_controller.startPeerProcessing();
            }
            if (this.isCacheDownloadEnabled()) {
                this.peer_controller.establishDownloadCacheSession();
            }
        } else {
            model.getStatus().setText("Stopped");
            if (this.peer_controller != null) {
                this.peer_controller.stopPeerProcessing();
                this.peer_controller = null;
            }
        }
    }

    public PluginInterface getPluginInterface() {
        return this.plugin_interface;
    }

    public Timer getPluginTimer() {
        return this.plugin_timer;
    }

    public void log(String txt, int level) {
        this.logger.log(txt);
    }

    public void log(String txt, Throwable e, int level) {
        this.logger.log(txt, e);
    }

    public boolean isCacheUploadEnabled() {
        return this.enable_uploader.getValue();
    }

    public boolean isCacheDownloadEnabled() {
        return this.enable_downloader.getValue();
    }

    public void updateVersionCheckString(String info) {
        this.plugin_interface.getPluginconfig().setPluginParameter("plugin.info", info);
        try {
            this.plugin_interface.getPluginconfig().save();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

