/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.plugins.jpc.cache.impl.messaging;

import com.aelitis.azureus.plugins.jpc.cache.impl.messaging.JPCCacheMessage;
import java.nio.ByteBuffer;
import org.gudy.azureus2.plugins.messaging.Message;
import org.gudy.azureus2.plugins.messaging.MessageException;

public class JPCError
implements JPCCacheMessage {
    private final String description;
    private final ByteBuffer buffer;
    private final int session_id;
    private final short error_code;

    public JPCError(int session_id, short error_code) {
        this.session_id = session_id;
        this.error_code = error_code;
        this.description = this.getID() + " from session id #" + session_id + " error #" + error_code;
        this.buffer = ByteBuffer.allocate(6);
        this.buffer.putInt(session_id);
        this.buffer.putShort(error_code);
        this.buffer.flip();
    }

    public int getSessionID() {
        return this.session_id;
    }

    public short getErrorCode() {
        return this.error_code;
    }

    public String getID() {
        return "JPC_ERROR";
    }

    public byte getVersion() {
        return 1;
    }

    public int getType() {
        return 0;
    }

    public String getDescription() {
        return this.description;
    }

    public ByteBuffer[] getPayload() {
        return new ByteBuffer[]{this.buffer};
    }

    public void destroy() {
    }

    public Message create(ByteBuffer data) throws MessageException {
        if (data == null) {
            throw new MessageException("[" + this.getID() + ":" + this.getVersion() + "] decode error: data == null");
        }
        if (data.remaining() != 6) {
            throw new MessageException("[" + this.getID() + ":" + this.getVersion() + "] decode error: payload.remaining[" + data.remaining() + "] != 6");
        }
        int id = data.getInt();
        short code = data.getShort();
        return new JPCError(id, code);
    }
}

