/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.plugins.jpc.cache.impl.messaging;

import com.aelitis.azureus.plugins.jpc.cache.impl.messaging.JPCCacheMessage;
import java.nio.ByteBuffer;
import org.gudy.azureus2.plugins.messaging.Message;
import org.gudy.azureus2.plugins.messaging.MessageException;

public class JPCReply
implements JPCCacheMessage {
    private final String description;
    private final ByteBuffer buffer;
    private final int session_id;
    private final int idle_time;
    private final int drop_time;

    public JPCReply(int session_id, int session_idle_time, int session_drop_time) {
        this.session_id = session_id;
        this.idle_time = session_idle_time;
        this.drop_time = session_drop_time;
        this.description = this.getID() + " for session id# " + session_id + " with idle time=" + this.idle_time + ", drop time=" + this.drop_time;
        this.buffer = ByteBuffer.allocate(12);
        this.buffer.putInt(session_id);
        this.buffer.putInt(this.idle_time);
        this.buffer.putInt(this.drop_time);
        this.buffer.flip();
    }

    public int getSessionID() {
        return this.session_id;
    }

    public int getSessionIdleTime() {
        return this.idle_time;
    }

    public int getSessionDropTime() {
        return this.drop_time;
    }

    public String getID() {
        return "JPC_REPLY";
    }

    public byte getVersion() {
        return 1;
    }

    public int getType() {
        return 0;
    }

    public String getDescription() {
        return this.description;
    }

    public ByteBuffer[] getPayload() {
        return new ByteBuffer[]{this.buffer};
    }

    public void destroy() {
    }

    public Message create(ByteBuffer data) throws MessageException {
        if (data == null) {
            throw new MessageException("[" + this.getID() + ":" + this.getVersion() + "] decode error: data == null");
        }
        if (data.remaining() < 4) {
            throw new MessageException("[" + this.getID() + ":" + this.getVersion() + "] decode error: payload.remaining[" + data.remaining() + "] < 4");
        }
        int id = data.getInt();
        int idle = -1;
        int drop = -1;
        if (data.hasRemaining()) {
            idle = data.getInt();
            drop = data.getInt();
        }
        return new JPCReply(id, idle, drop);
    }
}

