/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.core3.disk;

import java.io.File;
import org.gudy.azureus2.core3.disk.DiskManagerCheckRequest;
import org.gudy.azureus2.core3.disk.DiskManagerCheckRequestListener;
import org.gudy.azureus2.core3.disk.DiskManagerFileInfo;
import org.gudy.azureus2.core3.disk.DiskManagerListener;
import org.gudy.azureus2.core3.disk.DiskManagerPiece;
import org.gudy.azureus2.core3.disk.DiskManagerReadRequest;
import org.gudy.azureus2.core3.disk.DiskManagerReadRequestListener;
import org.gudy.azureus2.core3.disk.DiskManagerWriteRequest;
import org.gudy.azureus2.core3.disk.DiskManagerWriteRequestListener;
import org.gudy.azureus2.core3.disk.impl.piecemapper.DMPieceList;
import org.gudy.azureus2.core3.torrent.TOTorrent;
import org.gudy.azureus2.core3.util.DirectByteBuffer;

public interface DiskManager {
    public static final int INITIALIZING = 1;
    public static final int ALLOCATING = 2;
    public static final int CHECKING = 3;
    public static final int READY = 4;
    public static final int FAULTY = 10;
    public static final int BLOCK_SIZE = 16384;

    public void start();

    public void stop();

    public boolean filesExist();

    public DirectByteBuffer readBlock(int var1, int var2, int var3);

    public DiskManagerWriteRequest createWriteRequest(int var1, int var2, DirectByteBuffer var3, Object var4);

    public void enqueueWriteRequest(DiskManagerWriteRequest var1, DiskManagerWriteRequestListener var2);

    public DiskManagerReadRequest createReadRequest(int var1, int var2, int var3);

    public void enqueueReadRequest(DiskManagerReadRequest var1, DiskManagerReadRequestListener var2);

    public DiskManagerCheckRequest createCheckRequest(int var1, Object var2);

    public void enqueueCheckRequest(DiskManagerCheckRequest var1, DiskManagerCheckRequestListener var2);

    public void enqueueCompleteRecheckRequest(DiskManagerCheckRequest var1, DiskManagerCheckRequestListener var2);

    public void dumpResumeDataToDisk(boolean var1, boolean var2) throws Exception;

    public DiskManagerPiece[] getPieces();

    public int getNbPieces();

    public DiskManagerFileInfo[] getFiles();

    public DiskManagerPiece getPiece(int var1);

    public DMPieceList getPieceList(int var1);

    public int getState();

    public long getTotalLength();

    public int getPieceLength();

    public int getLastPieceLength();

    public long getRemaining();

    public long getRemainingExcludingDND();

    public int getPercentDone();

    public String getErrorMessage();

    public void downloadEnded();

    public void moveDataFiles(File var1);

    public int getCompleteRecheckStatus();

    public boolean checkBlockConsistency(int var1, int var2, DirectByteBuffer var3);

    public boolean checkBlockConsistency(int var1, int var2, int var3);

    public TOTorrent getTorrent();

    public File getSaveLocation();

    public void addListener(DiskManagerListener var1);

    public void removeListener(DiskManagerListener var1);

    public void saveState();

    public boolean isInteresting(int var1);

    public boolean isDone(int var1);
}

