/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.core3.internat;

import java.io.File;
import java.io.UnsupportedEncodingException;
import org.gudy.azureus2.core3.internat.LocaleUtilDecoder;
import org.gudy.azureus2.core3.util.ByteFormatter;
import org.gudy.azureus2.core3.util.SHA1Hasher;

public class LocaleUtilDecoderFallback
implements LocaleUtilDecoder {
    public static String NAME = "Fallback";
    private static volatile int max_ok_name_length = 64;
    private static volatile boolean max_ok_name_length_determined;
    private static final String VALID_CHARS = "abcdefghijklmnopqrstuvwxyz1234567890_-.";
    private int index;

    protected LocaleUtilDecoderFallback(int _index) {
        this.index = _index;
    }

    public String getName() {
        return NAME;
    }

    public int getIndex() {
        return this.index;
    }

    public String tryDecode(byte[] bytes, boolean lax) {
        return this.decode(bytes);
    }

    public String decodeString(byte[] bytes) throws UnsupportedEncodingException {
        return this.decode(bytes);
    }

    protected String decode(byte[] data) {
        if (data == null) {
            return null;
        }
        String res = "";
        for (int i = 0; i < data.length; ++i) {
            byte c = data[i];
            res = VALID_CHARS.indexOf(Character.toLowerCase((char)c)) != -1 ? res + (char)c : res + "_" + ByteFormatter.nicePrint(c);
        }
        int len = res.length();
        if (len > max_ok_name_length) {
            if (!max_ok_name_length_determined && this.fileLengthOK(len)) {
                max_ok_name_length = len;
            } else {
                if (!max_ok_name_length_determined) {
                    int i = max_ok_name_length + 16;
                    while (i < len) {
                        if (this.fileLengthOK(i)) {
                            max_ok_name_length = i;
                        }
                        i += 16;
                    }
                    max_ok_name_length_determined = true;
                }
                String extension = null;
                int pos = res.lastIndexOf(".");
                if (pos != -1 && ((extension = res.substring(pos)).length() == 1 || extension.length() > 4)) {
                    extension = null;
                }
                byte[] hash = new SHA1Hasher().calculateHash(data);
                String hash_str = ByteFormatter.nicePrint(hash, true);
                res = res.substring(0, max_ok_name_length - hash_str.length() - (extension == null ? 0 : extension.length())) + hash_str;
                if (extension != null) {
                    res = res + extension;
                }
            }
        }
        return res;
    }

    protected boolean fileLengthOK(int len) {
        String n = "";
        for (int i = 0; i < len; ++i) {
            n = n + "A";
        }
        try {
            File f = File.createTempFile(n, "");
            f.delete();
            return true;
        }
        catch (Throwable e) {
            return false;
        }
    }
}

