/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.core3.peer.impl.control;

import com.aelitis.azureus.core.networkmanager.LimitedRateGroup;
import com.aelitis.azureus.core.networkmanager.impl.ConnectDisconnectManager;
import com.aelitis.azureus.core.peermanager.PeerManager;
import com.aelitis.azureus.core.peermanager.control.PeerControlInstance;
import com.aelitis.azureus.core.peermanager.control.PeerControlSchedulerFactory;
import com.aelitis.azureus.core.peermanager.peerdb.PeerDatabase;
import com.aelitis.azureus.core.peermanager.peerdb.PeerDatabaseFactory;
import com.aelitis.azureus.core.peermanager.peerdb.PeerExchangerItem;
import com.aelitis.azureus.core.peermanager.peerdb.PeerItem;
import com.aelitis.azureus.core.peermanager.peerdb.PeerItemFactory;
import com.aelitis.azureus.core.peermanager.piecepicker.PiecePicker;
import com.aelitis.azureus.core.peermanager.piecepicker.PiecePickerFactory;
import com.aelitis.azureus.core.peermanager.unchoker.DownloadingUnchoker;
import com.aelitis.azureus.core.peermanager.unchoker.SeedingUnchoker;
import com.aelitis.azureus.core.peermanager.unchoker.Unchoker;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.gudy.azureus2.core3.config.COConfigurationManager;
import org.gudy.azureus2.core3.config.ParameterListener;
import org.gudy.azureus2.core3.disk.DiskManager;
import org.gudy.azureus2.core3.disk.DiskManagerCheckRequest;
import org.gudy.azureus2.core3.disk.DiskManagerCheckRequestListener;
import org.gudy.azureus2.core3.disk.DiskManagerPiece;
import org.gudy.azureus2.core3.disk.DiskManagerReadRequest;
import org.gudy.azureus2.core3.disk.DiskManagerWriteRequest;
import org.gudy.azureus2.core3.disk.DiskManagerWriteRequestListener;
import org.gudy.azureus2.core3.ipfilter.BannedIp;
import org.gudy.azureus2.core3.ipfilter.IPFilterListener;
import org.gudy.azureus2.core3.ipfilter.IpFilter;
import org.gudy.azureus2.core3.ipfilter.IpFilterManager;
import org.gudy.azureus2.core3.ipfilter.IpFilterManagerFactory;
import org.gudy.azureus2.core3.logging.LogEvent;
import org.gudy.azureus2.core3.logging.LogIDs;
import org.gudy.azureus2.core3.logging.LogRelation;
import org.gudy.azureus2.core3.logging.Logger;
import org.gudy.azureus2.core3.peer.PEPeer;
import org.gudy.azureus2.core3.peer.PEPeerManagerAdapter;
import org.gudy.azureus2.core3.peer.PEPeerManagerListener;
import org.gudy.azureus2.core3.peer.PEPeerManagerStats;
import org.gudy.azureus2.core3.peer.PEPeerStats;
import org.gudy.azureus2.core3.peer.PEPiece;
import org.gudy.azureus2.core3.peer.impl.PEPeerControl;
import org.gudy.azureus2.core3.peer.impl.PEPeerManagerStatsImpl;
import org.gudy.azureus2.core3.peer.impl.PEPeerStatsImpl;
import org.gudy.azureus2.core3.peer.impl.PEPeerTransport;
import org.gudy.azureus2.core3.peer.impl.PEPeerTransportFactory;
import org.gudy.azureus2.core3.peer.impl.PEPieceImpl;
import org.gudy.azureus2.core3.peer.impl.PEPieceWriteImpl;
import org.gudy.azureus2.core3.peer.impl.control.SuperSeedPeer;
import org.gudy.azureus2.core3.peer.impl.control.SuperSeedPiece;
import org.gudy.azureus2.core3.peer.util.PeerIdentityDataID;
import org.gudy.azureus2.core3.peer.util.PeerIdentityManager;
import org.gudy.azureus2.core3.peer.util.PeerUtils;
import org.gudy.azureus2.core3.torrent.TOTorrentException;
import org.gudy.azureus2.core3.tracker.client.TRTrackerAnnouncerResponse;
import org.gudy.azureus2.core3.tracker.client.TRTrackerAnnouncerResponsePeer;
import org.gudy.azureus2.core3.tracker.client.TRTrackerScraperResponse;
import org.gudy.azureus2.core3.util.AEMonitor;
import org.gudy.azureus2.core3.util.Average;
import org.gudy.azureus2.core3.util.BrokenMd5Hasher;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.core3.util.DirectByteBuffer;
import org.gudy.azureus2.core3.util.SystemTime;
import org.gudy.azureus2.core3.util.TimeFormatter;

public class PEPeerControlImpl
extends LogRelation
implements PEPeerControl,
ParameterListener,
DiskManagerWriteRequestListener,
PeerControlInstance,
DiskManagerCheckRequestListener,
IPFilterListener {
    private static final LogIDs LOGID = LogIDs.PEER;
    private static final int WARNINGS_LIMIT = 2;
    private static final int CHECK_REASON_DOWNLOADED = 1;
    private static final int CHECK_REASON_COMPLETE = 2;
    private static final int CHECK_REASON_SCAN = 3;
    private static boolean disconnect_seeds_when_seeding = COConfigurationManager.getBooleanParameter("Disconnect Seed", true);
    private static IpFilter ip_filter = IpFilterManagerFactory.getSingleton().getIPFilter();
    private volatile boolean is_running = false;
    private volatile ArrayList peer_transports_cow = new ArrayList();
    private AEMonitor peer_transports_mon = new AEMonitor("PEPeerControl:PT");
    protected PEPeerManagerAdapter adapter;
    private DiskManager disk_mgr;
    private DiskManagerPiece[] dm_pieces;
    private PiecePicker piecePicker;
    private long lastNeededUndonePieceChange;
    private boolean seeding_mode;
    private boolean restart_initiated;
    protected int _nbPieces = -1;
    private PEPieceImpl[] pePieces;
    private PeerIdentityDataID _hash;
    private byte[] _myPeerId;
    protected PEPeerManagerStats _stats;
    private int _seeds;
    private int _peers;
    private int _remotes;
    private long last_remote_time;
    private long _timeStarted;
    private long _timeStartedSeeding = -1L;
    private long _timeFinished;
    private Average _averageReceptionSpeed;
    private long mainloop_loop_count;
    private static final int MAINLOOP_ONE_SECOND_INTERVAL = 10;
    private static final int MAINLOOP_FIVE_SECOND_INTERVAL = 50;
    private static final int MAINLOOP_TEN_SECOND_INTERVAL = 100;
    private static final int MAINLOOP_THIRTY_SECOND_INTERVAL = 300;
    private static final int MAINLOOP_SIXTY_SECOND_INTERVAL = 600;
    private static final int MAINLOOP_TEN_MINUTE_INTERVAL = 6000;
    private volatile ArrayList peer_manager_listeners_cow = new ArrayList();
    private List piece_check_result_list = new ArrayList();
    private AEMonitor piece_check_result_list_mon = new AEMonitor("PEPeerControl:PCRL");
    private boolean superSeedMode;
    private int superSeedModeCurrentPiece;
    private int superSeedModeNumberOfAnnounces;
    private SuperSeedPiece[] superSeedPieces;
    private AEMonitor this_mon = new AEMonitor("PEPeerControl");
    private long ip_filter_last_update_time;
    private Map user_data;
    private Unchoker unchoker;
    private PeerDatabase peer_database;
    private int next_rescan_piece = -1;
    private long rescan_piece_time = -1L;
    private long last_eta;
    private long last_eta_calculation;
    private final LimitedRateGroup upload_limited_rate_group = new LimitedRateGroup(){

        public int getRateLimitBytesPerSecond() {
            return PEPeerControlImpl.this.adapter.getUploadRateLimitBytesPerSecond();
        }
    };
    private final LimitedRateGroup download_limited_rate_group = new LimitedRateGroup(){

        public int getRateLimitBytesPerSecond() {
            return PEPeerControlImpl.this.adapter.getDownloadRateLimitBytesPerSecond();
        }
    };

    public PEPeerControlImpl(byte[] _peer_id, PEPeerManagerAdapter _adapter, DiskManager diskManager) {
        this._myPeerId = _peer_id;
        this.adapter = _adapter;
        this.disk_mgr = diskManager;
        this._nbPieces = this.disk_mgr.getNbPieces();
        this.piecePicker = PiecePickerFactory.create(this);
        COConfigurationManager.addParameterListener("Ip Filter Enabled", this);
        COConfigurationManager.addParameterListener("Disconnect Seed", this);
        ip_filter.addListener(this);
    }

    public void start() {
        try {
            this._hash = PeerIdentityManager.createDataID(this.disk_mgr.getTorrent().getHash());
        }
        catch (TOTorrentException e) {
            Debug.printStackTrace(e);
            this._hash = PeerIdentityManager.createDataID(new byte[20]);
        }
        this.dm_pieces = this.disk_mgr.getPieces();
        this.pePieces = new PEPieceImpl[this._nbPieces];
        for (int i = 0; i < this._nbPieces; ++i) {
            DiskManagerPiece dmPiece = this.dm_pieces[i];
            if (dmPiece.isDone() || dmPiece.getNbWritten() <= 0) continue;
            this.addPiece(new PEPieceImpl(this, dmPiece, 0), i);
        }
        this.peer_transports_cow = new ArrayList();
        this.mainloop_loop_count = 0L;
        this._averageReceptionSpeed = Average.getInstance(1000, 30);
        this._stats = new PEPeerManagerStatsImpl(this);
        this.superSeedMode = COConfigurationManager.getBooleanParameter("Use Super Seeding") && this.getRemaining() == 0L;
        this.superSeedModeCurrentPiece = 0;
        if (this.superSeedMode) {
            this.initialiseSuperSeedMode();
        }
        this.peer_database = PeerDatabaseFactory.createPeerDatabase();
        PeerManager.getSingleton().registerLegacyManager(this);
        this.checkFinished(true);
        PeerControlSchedulerFactory.getSingleton().register(this);
        this.lastNeededUndonePieceChange = Long.MIN_VALUE;
        this._timeStarted = SystemTime.getCurrentTime();
        this.is_running = true;
    }

    public void stopAll() {
        this.is_running = false;
        PeerControlSchedulerFactory.getSingleton().unregister(this);
        this.peer_database = null;
        PeerManager.getSingleton().deregisterLegacyManager(this);
        this.closeAndRemoveAllPeers("download stopped", false);
        for (int i = 0; i < this._nbPieces; ++i) {
            if (this.pePieces[i] == null) continue;
            this.removePiece(this.pePieces[i], i);
        }
        COConfigurationManager.removeParameterListener("Ip Filter Enabled", this);
        COConfigurationManager.removeParameterListener("Disconnect Seed", this);
        ip_filter.removeListener(this);
    }

    public DiskManager getDiskManager() {
        return this.disk_mgr;
    }

    public PiecePicker getPiecePicker() {
        return this.piecePicker;
    }

    public PEPeerManagerAdapter getAdapter() {
        return this.adapter;
    }

    public String getDisplayName() {
        return this.adapter.getDisplayName();
    }

    public void schedule() {
        try {
            this.updateTrackerAnnounceInterval();
            this.doConnectionChecks();
            this.processPieceChecks();
            this.checkCompletedPieces();
            this.updateStats();
            this.checkInterested();
            this.piecePicker.updateAvailability();
            boolean forcenoseeds = disconnect_seeds_when_seeding;
            if (!this.seeding_mode) {
                this.checkRequests();
                forcenoseeds = !this.piecePicker.checkDownloadPossible();
                this.checkRescan();
                this.checkSpeedAndReserved();
            }
            this.checkSeeds(forcenoseeds);
            this.updatePeersInSuperSeedMode();
            this.doUnchokes();
        }
        catch (Throwable e) {
            Debug.printStackTrace(e);
        }
        ++this.mainloop_loop_count;
    }

    private void analyseTrackerResponse(TRTrackerAnnouncerResponse tracker_response) {
        Map extensions;
        TRTrackerAnnouncerResponsePeer[] peers = tracker_response.getPeers();
        if (peers != null) {
            this.addPeersFromTracker(tracker_response.getPeers());
        }
        if ((extensions = tracker_response.getExtensions()) != null) {
            this.addExtendedPeersFromTracker(extensions);
        }
    }

    public void processTrackerResponse(TRTrackerAnnouncerResponse response) {
        if (this.is_running) {
            this.analyseTrackerResponse(response);
        }
    }

    private void addExtendedPeersFromTracker(Map extensions) {
        Map protocols = (Map)extensions.get("protocols");
        if (protocols != null) {
            System.out.println("PEPeerControl: tracker response contained protocol extensions");
            Iterator protocol_it = protocols.keySet().iterator();
            while (protocol_it.hasNext()) {
                String protocol_name = (String)protocol_it.next();
                Map protocol = (Map)protocols.get(protocol_name);
                List transports = PEPeerTransportFactory.createExtendedTransports(this, protocol_name, protocol);
                for (int i = 0; i < transports.size(); ++i) {
                    PEPeer transport = (PEPeer)transports.get(i);
                    this.addPeer(transport);
                }
            }
        }
    }

    public List getPeers() {
        return new ArrayList(this.peer_transports_cow);
    }

    public void addPeer(PEPeer _transport) {
        if (!(_transport instanceof PEPeerTransport)) {
            throw new RuntimeException("invalid class");
        }
        PEPeerTransport transport = (PEPeerTransport)_transport;
        if (!ip_filter.isInRange(transport.getIp(), this.adapter.getDisplayName())) {
            ArrayList peer_transports = this.peer_transports_cow;
            if (!peer_transports.contains(transport)) {
                this.addToPeerTransports(transport);
            } else {
                Debug.out("addPeer():: peer_transports.contains(transport): SHOULD NEVER HAPPEN !");
                transport.closeConnection("already connected");
            }
        } else {
            transport.closeConnection("IP address blocked by filters");
        }
    }

    public void removePeer(PEPeer _transport) {
        if (!(_transport instanceof PEPeerTransport)) {
            throw new RuntimeException("invalid class");
        }
        PEPeerTransport transport = (PEPeerTransport)_transport;
        this.closeAndRemovePeer(transport, "remove peer", true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void closeAndRemovePeer(PEPeerTransport peer, String reason, boolean log_if_not_found) {
        boolean removed = false;
        try {
            this.peer_transports_mon.enter();
            if (this.peer_transports_cow.contains(peer)) {
                ArrayList new_peer_transports = new ArrayList(this.peer_transports_cow);
                new_peer_transports.remove(peer);
                this.peer_transports_cow = new_peer_transports;
                removed = true;
            }
        }
        finally {
            this.peer_transports_mon.exit();
        }
        if (removed) {
            peer.closeConnection(reason);
            this.peerRemoved(peer);
        } else if (log_if_not_found) {
            Debug.out("closeAndRemovePeer(): peer not removed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void closeAndRemoveAllPeers(String reason, boolean reconnect) {
        PEPeerTransport peer;
        int i;
        ArrayList peer_transports;
        try {
            this.peer_transports_mon.enter();
            peer_transports = this.peer_transports_cow;
            this.peer_transports_cow = new ArrayList(0);
        }
        finally {
            this.peer_transports_mon.exit();
        }
        for (i = 0; i < peer_transports.size(); ++i) {
            peer = (PEPeerTransport)peer_transports.get(i);
            try {
                peer.closeConnection(reason);
            }
            catch (Throwable e) {
                Debug.printStackTrace(e);
            }
            try {
                this.peerRemoved(peer);
                continue;
            }
            catch (Throwable e) {
                Debug.printStackTrace(e);
            }
        }
        if (reconnect) {
            for (i = 0; i < peer_transports.size(); ++i) {
                peer = (PEPeerTransport)peer_transports.get(i);
                if (peer.getTCPListenPort() <= 0) continue;
                boolean use_crypto = peer.getPeerItemIdentity().getHandshakeType() == 1;
                PEPeerTransport new_conn = PEPeerTransportFactory.createTransport(this, peer.getPeerSource(), peer.getIp(), peer.getTCPListenPort(), use_crypto);
                this.addToPeerTransports(new_conn);
            }
        }
    }

    public void addPeer(String ip_address, int port) {
        boolean use_crypto;
        boolean added;
        PeerItem peer_item = PeerItemFactory.createPeerItem(ip_address, port, PeerItem.convertSourceID("Plugin"), 0);
        if (!this.isAlreadyConnected(peer_item) && !(added = this.makeNewOutgoingConnection("Plugin", ip_address, port, use_crypto = peer_item.getHandshakeType() == 1))) {
            Debug.out("injected peer was not added");
        }
    }

    private void addPeersFromTracker(TRTrackerAnnouncerResponsePeer[] peers) {
        for (int i = 0; i < peers.length; ++i) {
            TRTrackerAnnouncerResponsePeer peer = peers[i];
            ArrayList peer_transports = this.peer_transports_cow;
            boolean already_connected = false;
            for (int x = 0; x < peer_transports.size(); ++x) {
                boolean same_allowed;
                PEPeerTransport transport = (PEPeerTransport)peer_transports.get(x);
                if (!peer.getAddress().equals(transport.getIp())) continue;
                boolean bl = same_allowed = COConfigurationManager.getBooleanParameter("Allow Same IP Peers") || transport.getIp().equals("127.0.0.1");
                if (same_allowed && peer.getPort() != transport.getPort()) continue;
                already_connected = true;
                break;
            }
            if (already_connected || this.peer_database == null) continue;
            int type = peer.getProtocol() == 2 ? 1 : 0;
            PeerItem item = PeerItemFactory.createPeerItem(peer.getAddress(), peer.getPort(), PeerItem.convertSourceID(peer.getSource()), type);
            this.peer_database.addDiscoveredPeer(item);
        }
    }

    private boolean makeNewOutgoingConnection(String peer_source, String address, int port, boolean require_crypto) {
        boolean same_allowed;
        if (ip_filter.isInRange(address, this.adapter.getDisplayName())) {
            return false;
        }
        int needed = this.getMaxNewConnectionsAllowed();
        if (needed == 0) {
            return false;
        }
        boolean bl = same_allowed = COConfigurationManager.getBooleanParameter("Allow Same IP Peers") || address.equals("127.0.0.1");
        if (!same_allowed && PeerIdentityManager.containsIPAddress(this._hash, address)) {
            return false;
        }
        if (PeerUtils.ignorePeerPort(port)) {
            if (Logger.isEnabled()) {
                Logger.log(new LogEvent(this.disk_mgr.getTorrent(), LOGID, "Skipping connect with " + address + ":" + port + " as peer port is in ignore list."));
            }
            return false;
        }
        PEPeerTransport real = PEPeerTransportFactory.createTransport(this, peer_source, address, port, require_crypto);
        this.addToPeerTransports(real);
        return true;
    }

    private void checkCompletedPieces() {
        for (int i = 0; i < this._nbPieces; ++i) {
            DiskManagerPiece dmPiece = this.dm_pieces[i];
            if (!dmPiece.calcWritten() || dmPiece.isChecking() || dmPiece.isDone()) continue;
            dmPiece.setChecking();
            DiskManagerCheckRequest req = this.disk_mgr.createCheckRequest(i, new Integer(1));
            req.setAdHoc(false);
            this.disk_mgr.enqueueCheckRequest(req, this);
        }
    }

    private boolean checkEmptyPiece(int pieceNumber) {
        PEPieceImpl pePiece = this.pePieces[pieceNumber];
        DiskManagerPiece dmPiece = this.dm_pieces[pieceNumber];
        if (pePiece == null || dmPiece.isRequested()) {
            return false;
        }
        if (dmPiece.getNbWritten() > 0 || pePiece.getNbRequests() > 0 || pePiece.getSpeed() > 0 || pePiece.getReservedBy() != null) {
            return false;
        }
        this.removePiece(pePiece, pieceNumber);
        return true;
    }

    private void checkSpeedAndReserved() {
        if (this.mainloop_loop_count % 50L != 0L) {
            return;
        }
        long now = SystemTime.getCurrentTime();
        int nbPieces = this._nbPieces;
        PEPieceImpl[] pieces = this.pePieces;
        for (int i = 0; i < nbPieces; ++i) {
            long timeSinceActivity;
            PEPieceImpl pePiece = pieces[i];
            if (pePiece == null || (timeSinceActivity = pePiece.getTimeSinceLastActivity()) <= 4000L) continue;
            int oldSpeed = pePiece.getSpeed();
            if (oldSpeed > 0) {
                DiskManagerPiece dmPiece = this.dm_pieces[i];
                if (dmPiece.isRequested() || timeSinceActivity > 29000L) {
                    pePiece.setSpeed(0);
                    continue;
                }
                long calcSpeed = (long)(dmPiece.getNbWritten() * 16384) / timeSinceActivity - 1L;
                if (calcSpeed >= (long)oldSpeed) continue;
                pePiece.setSpeed((int)(calcSpeed > 0L ? calcSpeed : 0L));
                continue;
            }
            if (timeSinceActivity <= 120000L) continue;
            String reservingPeer = pePiece.getReservedBy();
            if (reservingPeer != null) {
                if (this.needsMD5CheckOnCompletion(i)) {
                    this.badPeerDetected(reservingPeer);
                } else {
                    PEPeerTransport pt = this.getTransportFromAddress(reservingPeer);
                    if (pt != null) {
                        this.closeAndRemovePeer(pt, "Reserved piece data timeout; 120 seconds", true);
                    }
                }
                pePiece.setReservedBy(null);
            }
            this.checkEmptyPiece(i);
        }
    }

    private void checkInterested() {
        if (this.mainloop_loop_count % 10L != 0L) {
            return;
        }
        if (this.lastNeededUndonePieceChange >= this.piecePicker.getNeededUndonePieceChange()) {
            return;
        }
        this.lastNeededUndonePieceChange = this.piecePicker.getNeededUndonePieceChange();
        ArrayList peer_transports = this.peer_transports_cow;
        for (int i = 0; i < peer_transports.size(); ++i) {
            PEPeerTransport peer = (PEPeerTransport)peer_transports.get(i);
            peer.checkInterested();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processPieceChecks() {
        if (this.piece_check_result_list.size() > 0) {
            ArrayList pieces;
            try {
                this.piece_check_result_list_mon.enter();
                pieces = new ArrayList(this.piece_check_result_list);
                this.piece_check_result_list.clear();
            }
            finally {
                this.piece_check_result_list_mon.exit();
            }
            Iterator it = pieces.iterator();
            while (it.hasNext()) {
                Object[] data = (Object[])it.next();
                this.processPieceCheckResult((DiskManagerCheckRequest)data[0], (Integer)data[1]);
            }
        }
    }

    protected void checkRescan() {
        long piece_size;
        long millis_per_piece;
        if (this.rescan_piece_time == 0L) {
            return;
        }
        if (this.next_rescan_piece == -1) {
            if (this.mainloop_loop_count % 50L == 0L && this.adapter.isPeriodicRescanEnabled()) {
                this.next_rescan_piece = 0;
            }
        } else if (this.mainloop_loop_count % 6000L == 0L && !this.adapter.isPeriodicRescanEnabled()) {
            this.next_rescan_piece = -1;
        }
        if (this.next_rescan_piece == -1) {
            return;
        }
        long now = SystemTime.getCurrentTime();
        if (this.rescan_piece_time > now) {
            this.rescan_piece_time = now;
        }
        if (now - this.rescan_piece_time < (millis_per_piece = (piece_size = (long)this.disk_mgr.getPieceLength()) / 250L)) {
            return;
        }
        while (this.next_rescan_piece != -1) {
            int this_piece = this.next_rescan_piece++;
            if (this.next_rescan_piece == this._nbPieces) {
                this.next_rescan_piece = -1;
            }
            if (this.pePieces[this_piece] != null || this.dm_pieces[this_piece].isDone()) continue;
            DiskManagerCheckRequest req = this.disk_mgr.createCheckRequest(this_piece, new Integer(3));
            if (Logger.isEnabled()) {
                Logger.log(new LogEvent(this.disk_mgr.getTorrent(), LOGID, "Rescanning piece " + this_piece));
            }
            this.rescan_piece_time = 0L;
            try {
                this.disk_mgr.enqueueCheckRequest(req, this);
            }
            catch (Throwable e) {
                this.rescan_piece_time = now;
                Debug.printStackTrace(e);
            }
            break;
        }
    }

    private void checkFinished(boolean start_of_day) {
        boolean all_pieces_done;
        boolean bl = all_pieces_done = this.disk_mgr.getRemaining() == 0L;
        if (all_pieces_done) {
            this.seeding_mode = true;
            this.piecePicker.clearEndGameChunks();
            if (!start_of_day) {
                this.adapter.setStateFinishing();
            }
            this._timeFinished = SystemTime.getCurrentTime();
            ArrayList peer_transports = this.peer_transports_cow;
            for (int i = 0; i < peer_transports.size(); ++i) {
                PEPeerTransport pc = (PEPeerTransport)peer_transports.get(i);
                pc.setSnubbed(false);
            }
            this.checkSeeds(true);
            boolean checkPieces = COConfigurationManager.getBooleanParameter("Check Pieces on Completion", true);
            if (checkPieces && !start_of_day) {
                DiskManagerCheckRequest req = this.disk_mgr.createCheckRequest(-1, new Integer(2));
                this.disk_mgr.enqueueCompleteRecheckRequest(req, this);
            }
            this.disk_mgr.downloadEnded();
            this._timeStartedSeeding = SystemTime.getCurrentTime();
            this.adapter.setStateSeeding(start_of_day);
        }
    }

    private void checkRequests() {
        long now = SystemTime.getCurrentTime();
        ArrayList peer_transports = this.peer_transports_cow;
        for (int i = peer_transports.size() - 1; i >= 0; --i) {
            long dataTime;
            PEPeerTransport pc = (PEPeerTransport)peer_transports.get(i);
            if (pc.getPeerState() != 30) continue;
            boolean isSeed = pc.isSeed();
            List expired = pc.getExpiredRequests();
            if (expired == null || expired.size() <= 0) continue;
            long goodTime = pc.getTimeSinceGoodDataReceived();
            if (goodTime == -1L || goodTime > 60000L) {
                pc.setSnubbed(true);
            }
            boolean noData = (dataTime = pc.getTimeSinceLastDataMessageReceived()) == -1L || now - dataTime > (long)(1000 * (isSeed ? 120 : 60));
            for (int j = 0; j < expired.size(); ++j) {
                DiskManagerReadRequest request2 = (DiskManagerReadRequest)expired.get(j);
                if (j <= 0 && (!noData || now - request2.getTimeCreated() <= 120000L)) continue;
                pc.sendCancel(request2);
                int pieceNumber = request2.getPieceNumber();
                PEPieceImpl pePiece = this.pePieces[pieceNumber];
                if (pePiece != null) {
                    pePiece.clearRequested(request2.getOffset() / 16384);
                }
                this.dm_pieces[pieceNumber].clearRequested();
                if (this.piecePicker.isInEndGameMode()) continue;
                this.checkEmptyPiece(pieceNumber);
            }
            if (!noData || goodTime != -1L && goodTime <= 240000L) continue;
            float f = this.piecePicker.getMinAvailability();
            int n = isSeed ? 2 : 1;
            if (!(f > (float)n)) continue;
            this.closeAndRemovePeer(pc, "Peer not responsive to piece requests.", true);
        }
    }

    private void updateTrackerAnnounceInterval() {
        if (this.mainloop_loop_count % 50L != 0L) {
            return;
        }
        int WANT_LIMIT = 100;
        int num_wanted = this.getMaxNewConnectionsAllowed();
        boolean has_remote = this.adapter.isNATHealthy();
        if (has_remote) {
            num_wanted = (int)((double)num_wanted / 1.5);
        }
        if (num_wanted < 0 || num_wanted > 100) {
            num_wanted = 100;
        }
        int current_connection_count = PeerIdentityManager.getIdentityCount(this._hash);
        TRTrackerScraperResponse tsr = this.adapter.getTrackerScrapeResponse();
        if (tsr != null && tsr.isValid()) {
            int swarm_size;
            int num_seeds = tsr.getSeeds();
            int num_peers = tsr.getPeers();
            if (this.seeding_mode) {
                float ratio = (float)num_peers / (float)(num_seeds + num_peers);
                swarm_size = (int)((float)num_peers * ratio);
            } else {
                swarm_size = num_peers + num_seeds;
            }
            if (swarm_size < num_wanted) {
                num_wanted = swarm_size;
            }
        }
        if (num_wanted < 1) {
            this.adapter.setTrackerRefreshDelayOverrides(100);
            return;
        }
        if (current_connection_count == 0) {
            current_connection_count = 1;
        }
        int current_percent = current_connection_count * 100 / (current_connection_count + num_wanted);
        this.adapter.setTrackerRefreshDelayOverrides(current_percent);
    }

    public boolean hasDownloadablePiece() {
        return this.piecePicker.hasDownloadablePiece();
    }

    public int[] getAvailability() {
        return this.piecePicker.getAvailability();
    }

    public float getMinAvailability() {
        return this.piecePicker.getMinAvailability();
    }

    public float getAvgAvail() {
        return this.piecePicker.getAvgAvail();
    }

    public void addPeerTransport(PEPeerTransport transport) {
        if (!ip_filter.isInRange(transport.getIp(), this.adapter.getDisplayName())) {
            ArrayList peer_transports = this.peer_transports_cow;
            if (!peer_transports.contains(transport)) {
                this.addToPeerTransports(transport);
            } else {
                Debug.out("addPeerTransport():: peer_transports.contains(transport): SHOULD NEVER HAPPEN !");
                transport.closeConnection("already connected");
            }
        } else {
            transport.closeConnection("IP address blocked by filters");
        }
    }

    private void doUnchokes() {
        block9: {
            PEPeerTransport peer;
            int i;
            ArrayList peer_transports;
            int max_to_unchoke;
            block8: {
                PEPeerTransport peer2;
                int i2;
                max_to_unchoke = this.adapter.getMaxUploads();
                peer_transports = this.peer_transports_cow;
                if (this.seeding_mode) {
                    if (this.unchoker == null || !(this.unchoker instanceof SeedingUnchoker)) {
                        this.unchoker = new SeedingUnchoker();
                    }
                } else if (this.unchoker == null || !(this.unchoker instanceof DownloadingUnchoker)) {
                    this.unchoker = new DownloadingUnchoker();
                }
                if (this.mainloop_loop_count % 100L != 0L) break block8;
                boolean refresh = this.mainloop_loop_count % 300L == 0L;
                this.unchoker.calculateUnchokes(max_to_unchoke, peer_transports, refresh);
                ArrayList peers_to_choke = this.unchoker.getChokes();
                ArrayList peers_to_unchoke = this.unchoker.getUnchokes();
                for (i2 = 0; i2 < peers_to_choke.size(); ++i2) {
                    peer2 = (PEPeerTransport)peers_to_choke.get(i2);
                    if (peer2.isChokedByMe()) continue;
                    peer2.sendChoke();
                }
                for (i2 = 0; i2 < peers_to_unchoke.size(); ++i2) {
                    peer2 = (PEPeerTransport)peers_to_unchoke.get(i2);
                    if (!peer2.isChokedByMe()) continue;
                    peer2.sendUnChoke();
                }
                break block9;
            }
            if (this.mainloop_loop_count % 10L != 0L) break block9;
            ArrayList peers_to_unchoke = this.unchoker.getImmediateUnchokes(max_to_unchoke, peer_transports);
            for (i = 0; i < peer_transports.size(); ++i) {
                peer = (PEPeerTransport)peer_transports.get(i);
                if (!peer.isLANLocal()) continue;
                peers_to_unchoke.add(peer);
            }
            for (i = 0; i < peers_to_unchoke.size(); ++i) {
                peer = (PEPeerTransport)peers_to_unchoke.get(i);
                if (!peer.isChokedByMe()) continue;
                peer.sendUnChoke();
            }
        }
    }

    private void sendHave(int pieceNumber) {
        ArrayList peer_transports = this.peer_transports_cow;
        for (int i = 0; i < peer_transports.size(); ++i) {
            PEPeerTransport pc = (PEPeerTransport)peer_transports.get(i);
            pc.sendHave(pieceNumber);
        }
    }

    private void checkSeeds(boolean forceDisconnect) {
        int i;
        if (this.mainloop_loop_count % 10L != 0L) {
            return;
        }
        if (!disconnect_seeds_when_seeding || !forceDisconnect && !this.seeding_mode) {
            return;
        }
        ArrayList<PEPeerTransport> to_close = null;
        ArrayList peer_transports = this.peer_transports_cow;
        for (i = 0; i < peer_transports.size(); ++i) {
            PEPeerTransport pc = (PEPeerTransport)peer_transports.get(i);
            if (pc == null || pc.getPeerState() != 30 || !pc.isSeed()) continue;
            if (to_close == null) {
                to_close = new ArrayList<PEPeerTransport>();
            }
            to_close.add(pc);
        }
        if (to_close != null) {
            for (i = 0; i < to_close.size(); ++i) {
                this.closeAndRemovePeer((PEPeerTransport)to_close.get(i), "disconnect other seed when seeding", false);
            }
        }
    }

    private void updateStats() {
        ArrayList peer_transports = this.peer_transports_cow;
        this._remotes = 0;
        this._peers = 0;
        this._seeds = 0;
        for (int i = 0; i < peer_transports.size(); ++i) {
            PEPeerTransport pc = (PEPeerTransport)peer_transports.get(i);
            if (pc.getPeerState() != 30) continue;
            if (pc.isSeed()) {
                ++this._seeds;
            } else {
                ++this._peers;
            }
            if (!pc.isIncoming()) continue;
            ++this._remotes;
        }
    }

    public void requestCanceled(DiskManagerReadRequest request2) {
        int pieceNumber = request2.getPieceNumber();
        int pieceOffset = request2.getOffset();
        if (this.pePieces[pieceNumber] != null) {
            this.pePieces[pieceNumber].clearRequested(pieceOffset / 16384);
        }
        this.dm_pieces[pieceNumber].clearRequested();
    }

    public PEPeerControl getControl() {
        return this;
    }

    public byte[] getTorrentHash() {
        try {
            return this.disk_mgr.getTorrent().getHash();
        }
        catch (Throwable e) {
            Debug.printStackTrace(e);
            return null;
        }
    }

    public byte[] getHash() {
        return this._hash.getDataID();
    }

    public PeerIdentityDataID getPeerIdentityDataID() {
        return this._hash;
    }

    public byte[] getPeerId() {
        return this._myPeerId;
    }

    public long getRemaining() {
        return this.disk_mgr.getRemaining();
    }

    public void discarded(int length) {
        if (length > 0) {
            this._stats.discarded(length);
        }
    }

    public void dataBytesReceived(int length) {
        if (length > 0) {
            this._stats.dataBytesReceived(length);
            this._averageReceptionSpeed.addValue(length);
        }
    }

    public void protocolBytesReceived(int length) {
        if (length > 0) {
            this._stats.protocolBytesReceived(length);
        }
    }

    public void dataBytesSent(int length) {
        if (length > 0) {
            this._stats.dataBytesSent(length);
        }
    }

    public void protocolBytesSent(int length) {
        if (length > 0) {
            this._stats.protocolBytesSent(length);
        }
    }

    public void writeCompleted(DiskManagerWriteRequest request2) {
        PEPieceImpl pePiece;
        int pieceNumber = request2.getPieceNumber();
        if (!this.dm_pieces[pieceNumber].isDone() && (pePiece = this.pePieces[pieceNumber]) != null) {
            pePiece.setWritten((PEPeer)request2.getUserData(), request2.getOffset() / 16384);
        }
    }

    public void writeFailed(DiskManagerWriteRequest request2, Throwable cause) {
    }

    public void writeBlock(int pieceNumber, int offset, DirectByteBuffer data, PEPeer sender, boolean cancel) {
        DiskManagerPiece dmPiece = this.dm_pieces[pieceNumber];
        int blockNumber = offset / 16384;
        if (dmPiece.isWritten(blockNumber)) {
            data.returnToPool();
            return;
        }
        DiskManagerWriteRequest request2 = this.disk_mgr.createWriteRequest(pieceNumber, offset, data, sender);
        this.disk_mgr.enqueueWriteRequest(request2, this);
        if (this.piecePicker.isInEndGameMode()) {
            this.piecePicker.removeFromEndGameModeChunks(pieceNumber, offset);
            cancel = true;
        }
        if (cancel) {
            ArrayList peer_transports = this.peer_transports_cow;
            for (int i = 0; i < peer_transports.size(); ++i) {
                PEPeerTransport connection = (PEPeerTransport)peer_transports.get(i);
                DiskManagerReadRequest dmr = this.disk_mgr.createReadRequest(pieceNumber, offset, dmPiece.getBlockSize(blockNumber));
                connection.sendCancel(dmr);
            }
        }
    }

    public boolean isWritten(int piece_number, int offset) {
        return this.dm_pieces[piece_number].isWritten(offset / 16384);
    }

    public boolean checkBlock(int pieceNumber, int offset, int length) {
        return this.disk_mgr.checkBlockConsistency(pieceNumber, offset, length);
    }

    public boolean checkBlock(int pieceNumber, int offset, DirectByteBuffer data) {
        return this.disk_mgr.checkBlockConsistency(pieceNumber, offset, data);
    }

    public int getAvailability(int pieceNumber) {
        return this.piecePicker.getAvailability(pieceNumber);
    }

    public void havePiece(int pieceNumber, int pieceLength, PEPeer pcOrigin) {
        int availability;
        this.piecePicker.addHavePiece(pieceNumber);
        this._stats.haveNewPiece(pieceLength);
        if (this.superSeedMode) {
            this.superSeedPieces[pieceNumber].peerHasPiece(pcOrigin);
            if (pieceNumber == pcOrigin.getUniqueAnnounce()) {
                pcOrigin.setUniqueAnnounce(-1);
                --this.superSeedModeNumberOfAnnounces;
            }
        }
        if ((availability = this.piecePicker.getAvailability(pieceNumber) - 1) < 4) {
            if (this.dm_pieces[pieceNumber].isDone()) {
                --availability;
            }
            if (availability <= 0) {
                return;
            }
            ArrayList peer_transports = this.peer_transports_cow;
            for (int i = peer_transports.size() - 1; i >= 0; --i) {
                PEPeerTransport pc = (PEPeerTransport)peer_transports.get(i);
                if (pc == pcOrigin || pc.getPeerState() != 30 || !pc.isPieceAvailable(pieceNumber)) continue;
                ((PEPeerStatsImpl)pc.getStats()).statisticalSentPiece(pieceLength / availability);
            }
        }
    }

    public int getPieceLength(int pieceNumber) {
        if (pieceNumber == this._nbPieces - 1) {
            return this.disk_mgr.getLastPieceLength();
        }
        return this.disk_mgr.getPieceLength();
    }

    public int getNbPeers() {
        return this._peers;
    }

    public int getNbSeeds() {
        return this._seeds;
    }

    public int getNbRemoteConnections() {
        return this._remotes;
    }

    public long getLastRemoteConnectionTime() {
        return this.last_remote_time;
    }

    public PEPeerManagerStats getStats() {
        return this._stats;
    }

    public long getETA() {
        long now = SystemTime.getCurrentTime();
        if (now < this.last_eta_calculation || now - this.last_eta_calculation > 900L) {
            long result;
            long dataRemaining = this.disk_mgr.getRemainingExcludingDND();
            if (dataRemaining > 0L) {
                int writtenNotChecked = 0;
                for (int i = 0; i < this._nbPieces; ++i) {
                    if (!this.dm_pieces[i].isInteresting()) continue;
                    writtenNotChecked += this.dm_pieces[i].getNbWritten() * 16384;
                }
                if ((dataRemaining -= (long)writtenNotChecked) < 0L) {
                    dataRemaining = 0L;
                }
            }
            if (dataRemaining == 0L) {
                long timeElapsed = (this._timeFinished - this._timeStarted) / 1000L;
                result = timeElapsed > 1L ? timeElapsed * -1L : 0L;
            } else {
                long lETA;
                long averageSpeed = this._averageReceptionSpeed.getAverage();
                long l = lETA = averageSpeed == 0L ? 31536000L : dataRemaining / averageSpeed;
                if (lETA == 0L) {
                    lETA = 1L;
                }
                result = lETA;
            }
            this.last_eta = result;
            this.last_eta_calculation = now;
        }
        return this.last_eta;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addToPeerTransports(PEPeerTransport peer) {
        boolean added = false;
        try {
            this.peer_transports_mon.enter();
            if (this.peer_transports_cow.contains(peer)) {
                Debug.out("Transport added twice");
                return;
            }
            if (this.is_running) {
                ArrayList<PEPeerTransport> new_peer_transports = new ArrayList<PEPeerTransport>(this.peer_transports_cow.size() + 1);
                new_peer_transports.addAll(this.peer_transports_cow);
                new_peer_transports.add(peer);
                this.peer_transports_cow = new_peer_transports;
                added = true;
            }
        }
        finally {
            this.peer_transports_mon.exit();
        }
        if (added) {
            long connect_time;
            if (peer.isIncoming() && (connect_time = SystemTime.getCurrentTime()) > this.last_remote_time) {
                this.last_remote_time = connect_time;
            }
            this.peerAdded(peer);
        } else {
            peer.closeConnection("PeerTransport added when manager not running");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void peerConnectionClosed(PEPeerTransport peer) {
        boolean connection_found = false;
        try {
            this.peer_transports_mon.enter();
            if (this.peer_transports_cow.contains(peer)) {
                ArrayList new_peer_transports = new ArrayList(this.peer_transports_cow);
                new_peer_transports.remove(peer);
                this.peer_transports_cow = new_peer_transports;
                connection_found = true;
            }
        }
        finally {
            this.peer_transports_mon.exit();
        }
        if (connection_found) {
            if (peer.getPeerState() != 50) {
                System.out.println("peer.getPeerState() != PEPeer.DISCONNECTED: " + peer.getPeerState());
            }
            this.peerRemoved(peer);
        }
    }

    public void peerAdded(PEPeer pc) {
        this.adapter.addPeer(pc);
        ArrayList peer_manager_listeners = this.peer_manager_listeners_cow;
        for (int i = 0; i < peer_manager_listeners.size(); ++i) {
            ((PEPeerManagerListener)peer_manager_listeners.get(i)).peerAdded(this, pc);
        }
    }

    public void peerRemoved(PEPeer pc) {
        int piece = pc.getUniqueAnnounce();
        if (piece != -1 && this.superSeedMode) {
            --this.superSeedModeNumberOfAnnounces;
            this.superSeedPieces[piece].peerLeft();
        }
        this.adapter.removePeer(pc);
        ArrayList peer_manager_listeners = this.peer_manager_listeners_cow;
        for (int i = 0; i < peer_manager_listeners.size(); ++i) {
            ((PEPeerManagerListener)peer_manager_listeners.get(i)).peerRemoved(this, pc);
        }
    }

    public void addPiece(PEPiece piece, int pieceNumber) {
        this.pePieces[pieceNumber] = (PEPieceImpl)piece;
        this.adapter.addPiece(piece);
    }

    public void removePiece(PEPiece pePiece, int pieceNumber) {
        this.adapter.removePiece(pePiece);
        this.pePieces[pieceNumber] = null;
    }

    public String getElapsedTime() {
        return TimeFormatter.format((SystemTime.getCurrentTime() - this._timeStarted) / 1000L);
    }

    public long getTimeStarted() {
        return this._timeStarted;
    }

    public long getTimeStartedSeeding() {
        return this._timeStartedSeeding;
    }

    private byte[] computeMd5Hash(DirectByteBuffer buffer) {
        BrokenMd5Hasher md5 = new BrokenMd5Hasher();
        md5.reset();
        int position = buffer.position((byte)8);
        md5.update(buffer.getBuffer((byte)8));
        buffer.position((byte)8, position);
        ByteBuffer md5Result = ByteBuffer.allocate(16);
        md5Result.position(0);
        md5.finalDigest(md5Result);
        byte[] result = new byte[16];
        md5Result.position(0);
        for (int i = 0; i < result.length; ++i) {
            result[i] = md5Result.get();
        }
        return result;
    }

    private void MD5CheckPiece(PEPiece piece, boolean correct) {
        String[] writers = piece.getWriters();
        int offset = 0;
        for (int i = 0; i < writers.length; ++i) {
            DirectByteBuffer buffer;
            int length = piece.getBlockSize(i);
            String peer = writers[i];
            if (peer != null && (buffer = this.disk_mgr.readBlock(piece.getPieceNumber(), offset, length)) != null) {
                byte[] hash = this.computeMd5Hash(buffer);
                buffer.returnToPool();
                buffer = null;
                piece.addWrite(i, peer, hash, correct);
            }
            offset += length;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void checkCompleted(DiskManagerCheckRequest request2, boolean passed) {
        try {
            this.piece_check_result_list_mon.enter();
            this.piece_check_result_list.add(new Object[]{request2, new Integer(passed ? 1 : 0)});
        }
        finally {
            this.piece_check_result_list_mon.exit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void checkCancelled(DiskManagerCheckRequest request2) {
        try {
            this.piece_check_result_list_mon.enter();
            this.piece_check_result_list.add(new Object[]{request2, new Integer(2)});
        }
        finally {
            this.piece_check_result_list_mon.exit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void checkFailed(DiskManagerCheckRequest request2, Throwable cause) {
        try {
            this.piece_check_result_list_mon.enter();
            this.piece_check_result_list.add(new Object[]{request2, new Integer(0)});
        }
        finally {
            this.piece_check_result_list_mon.exit();
        }
    }

    public boolean needsMD5CheckOnCompletion(int pieceNumber) {
        PEPieceImpl piece = this.pePieces[pieceNumber];
        if (piece == null) {
            return false;
        }
        return piece.getPieceWrites().size() > 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void processPieceCheckResult(DiskManagerCheckRequest request2, int outcome) {
        block26: {
            block27: {
                int check_type = (Integer)request2.getUserData();
                try {
                    int pieceNumber = request2.getPieceNumber();
                    if (check_type == 2) {
                        if (outcome == 0) {
                            Debug.out("Piece #" + pieceNumber + " failed final re-check. Re-downloading...");
                            if (!this.restart_initiated) {
                                this.restart_initiated = true;
                                this.adapter.restartDownload(false);
                            }
                        }
                        Object var17_5 = null;
                        if (check_type != 3) break block26;
                        break block27;
                    }
                    PEPieceImpl pePiece = this.pePieces[pieceNumber];
                    if (outcome == 1) {
                        if (pePiece != null) {
                            List list;
                            if (this.needsMD5CheckOnCompletion(pieceNumber)) {
                                this.MD5CheckPiece(pePiece, true);
                            }
                            if ((list = pePiece.getPieceWrites()).size() > 0) {
                                for (int i = 0; i < pePiece.getNbBlocks(); ++i) {
                                    PEPieceWriteImpl write;
                                    List listPerBlock = pePiece.getPieceWrites(i);
                                    byte[] correctHash = null;
                                    Iterator iterPerBlock = listPerBlock.iterator();
                                    while (iterPerBlock.hasNext()) {
                                        write = (PEPieceWriteImpl)iterPerBlock.next();
                                        if (!write.isCorrect()) continue;
                                        correctHash = write.getHash();
                                    }
                                    if (correctHash == null) continue;
                                    iterPerBlock = listPerBlock.iterator();
                                    while (iterPerBlock.hasNext()) {
                                        write = (PEPieceWriteImpl)iterPerBlock.next();
                                        if (Arrays.equals(write.getHash(), correctHash)) continue;
                                        this.badPeerDetected(write.getSender());
                                    }
                                }
                            }
                            this.removePiece(pePiece, pieceNumber);
                        }
                        this.sendHave(pieceNumber);
                    } else if (outcome == 0 && pePiece != null) {
                        this.MD5CheckPiece(pePiece, false);
                        String[] writers = pePiece.getWriters();
                        ArrayList<String> uniqueWriters = new ArrayList<String>();
                        int[] writesPerWriter = new int[writers.length];
                        for (int i = 0; i < writers.length; ++i) {
                            String writer = writers[i];
                            if (writer == null) continue;
                            int writerId = uniqueWriters.indexOf(writer);
                            if (writerId == -1) {
                                uniqueWriters.add(writer);
                                writerId = uniqueWriters.size() - 1;
                            }
                            int n = writerId;
                            writesPerWriter[n] = writesPerWriter[n] + 1;
                        }
                        int nbWriters = uniqueWriters.size();
                        if (nbWriters == 1) {
                            this.badPeerDetected((String)uniqueWriters.get(0));
                            pePiece.reset();
                        } else if (nbWriters > 1) {
                            int i;
                            int maxWrites = 0;
                            String bestWriter = null;
                            for (i = 0; i < uniqueWriters.size(); ++i) {
                                String writer;
                                PEPeerTransport pt;
                                int writes = writesPerWriter[i];
                                if (writes <= maxWrites || (pt = this.getTransportFromAddress(writer = (String)uniqueWriters.get(i))) == null || pt.getReservedPieceNumber() != -1 || ip_filter.isInRange(writer, this.adapter.getDisplayName())) continue;
                                bestWriter = writer;
                                maxWrites = writes;
                            }
                            if (bestWriter != null) {
                                pePiece.setReservedBy(bestWriter);
                                this.getTransportFromAddress(bestWriter).setReservedPieceNumber(pePiece.getPieceNumber());
                                pePiece.setRequestable();
                                for (i = 0; i < pePiece.getNbBlocks(); ++i) {
                                    if (writers[i] != null && writers[i].equals(bestWriter)) continue;
                                    pePiece.reDownloadBlock(i);
                                }
                            } else {
                                pePiece.reset();
                            }
                        } else {
                            pePiece.reset();
                        }
                        this.piecePicker.addEndGameChunks(pePiece);
                        this._stats.hashFailed(pePiece.getLength());
                    }
                    Object var17_6 = null;
                    if (check_type == 3) {
                        this.rescan_piece_time = SystemTime.getCurrentTime();
                    }
                    if (this.seeding_mode) return;
                    this.checkFinished(false);
                    return;
                }
                catch (Throwable throwable) {
                    Object var17_7 = null;
                    if (check_type == 3) {
                        this.rescan_piece_time = SystemTime.getCurrentTime();
                    }
                    if (this.seeding_mode) throw throwable;
                    this.checkFinished(false);
                    throw throwable;
                }
            }
            this.rescan_piece_time = SystemTime.getCurrentTime();
        }
        if (this.seeding_mode) return;
        this.checkFinished(false);
    }

    private void badPeerDetected(String ip) {
        PEPeerTransport peer = this.getTransportFromAddress(ip);
        IpFilterManager filter_manager = IpFilterManagerFactory.getSingleton();
        int nbWarnings = filter_manager.getBadIps().addWarningForIp(ip);
        if (nbWarnings > 2 && COConfigurationManager.getBooleanParameter("Ip Filter Enable Banning")) {
            if (ip_filter.ban(ip, this.adapter.getDisplayName())) {
                this.checkForBannedConnections();
            }
            if (peer != null) {
                int ps = peer.getPeerState();
                if (ps != 40 && ps != 50) {
                    this.closeAndRemovePeer(peer, "has sent too many bad pieces, 2 max.", true);
                }
                if (Logger.isEnabled()) {
                    Logger.log(new LogEvent((Object)peer, LOGID, 3, ip + " : has been banned and won't be able " + "to connect until you restart azureus"));
                }
            }
        }
    }

    public PEPiece[] getPieces() {
        return this.pePieces;
    }

    public PEPiece getPiece(int pieceNumber) {
        return this.pePieces[pieceNumber];
    }

    public PEPeerStats createPeerStats() {
        return new PEPeerStatsImpl();
    }

    public DiskManagerReadRequest createDiskManagerRequest(int pieceNumber, int offset, int length) {
        return this.disk_mgr.createReadRequest(pieceNumber, offset, length);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addListener(PEPeerManagerListener l) {
        try {
            this.this_mon.enter();
            ArrayList<PEPeerManagerListener> peer_manager_listeners = new ArrayList<PEPeerManagerListener>(this.peer_manager_listeners_cow.size() + 1);
            peer_manager_listeners.addAll(this.peer_manager_listeners_cow);
            peer_manager_listeners.add(l);
            this.peer_manager_listeners_cow = peer_manager_listeners;
        }
        finally {
            this.this_mon.exit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeListener(PEPeerManagerListener l) {
        try {
            this.this_mon.enter();
            ArrayList peer_manager_listeners = new ArrayList(this.peer_manager_listeners_cow);
            peer_manager_listeners.remove(l);
            this.peer_manager_listeners_cow = peer_manager_listeners;
        }
        finally {
            this.this_mon.exit();
        }
    }

    public void parameterChanged(String parameterName) {
        disconnect_seeds_when_seeding = COConfigurationManager.getBooleanParameter("Disconnect Seed", true);
        if (parameterName.equals("Ip Filter Enabled")) {
            this.checkForBannedConnections();
        }
    }

    protected void checkForBannedConnections() {
        if (ip_filter.isEnabled()) {
            int i;
            ArrayList<PEPeerTransport> to_close = null;
            ArrayList peer_transports = this.peer_transports_cow;
            for (i = 0; i < peer_transports.size(); ++i) {
                PEPeerTransport conn = (PEPeerTransport)peer_transports.get(i);
                if (!ip_filter.isInRange(conn.getIp(), this.adapter.getDisplayName())) continue;
                if (to_close == null) {
                    to_close = new ArrayList<PEPeerTransport>();
                }
                to_close.add(conn);
            }
            if (to_close != null) {
                for (i = 0; i < to_close.size(); ++i) {
                    this.closeAndRemovePeer((PEPeerTransport)to_close.get(i), "IPFilter banned IP address", true);
                }
            }
        }
    }

    public boolean isSuperSeedMode() {
        return this.superSeedMode;
    }

    public boolean isInEndGameMode() {
        return this.piecePicker.isInEndGameMode();
    }

    public void setSuperSeedMode(boolean _superSeedMode) {
        if (_superSeedMode && this.superSeedPieces == null) {
            this.initialiseSuperSeedMode();
        }
        this.superSeedMode = _superSeedMode;
    }

    private void initialiseSuperSeedMode() {
        this.superSeedPieces = new SuperSeedPiece[this._nbPieces];
        for (int i = 0; i < this._nbPieces; ++i) {
            this.superSeedPieces[i] = new SuperSeedPiece(this, i);
        }
    }

    private void updatePeersInSuperSeedMode() {
        if (!this.superSeedMode) {
            return;
        }
        for (int i = 0; i < this.superSeedPieces.length; ++i) {
            this.superSeedPieces[i].updateTime();
        }
        int nbUnchoke = this.adapter.getMaxUploads();
        if (this.superSeedModeNumberOfAnnounces >= 2 * nbUnchoke) {
            return;
        }
        PEPeer selectedPeer = null;
        ArrayList<SuperSeedPeer> sortedPeers = null;
        ArrayList peer_transports = this.peer_transports_cow;
        sortedPeers = new ArrayList<SuperSeedPeer>(peer_transports.size());
        Iterator iter = peer_transports.iterator();
        while (iter.hasNext()) {
            sortedPeers.add(new SuperSeedPeer((PEPeer)iter.next()));
        }
        Collections.sort(sortedPeers);
        iter = sortedPeers.iterator();
        while (iter.hasNext()) {
            PEPeer peer = ((SuperSeedPeer)iter.next()).peer;
            if (peer.getUniqueAnnounce() != -1 || peer.getPeerState() != 30) continue;
            selectedPeer = peer;
            break;
        }
        if (selectedPeer == null || selectedPeer.getPeerState() >= 40) {
            return;
        }
        if (selectedPeer.getUploadHint() == 0) {
            selectedPeer.setUploadHint(31536000);
        }
        boolean found = false;
        SuperSeedPiece piece = null;
        while (!found) {
            piece = this.superSeedPieces[this.superSeedModeCurrentPiece];
            if (piece.getLevel() > 0) {
                piece = null;
                ++this.superSeedModeCurrentPiece;
                if (this.superSeedModeCurrentPiece < this._nbPieces) continue;
                this.superSeedModeCurrentPiece = 0;
                this.superSeedMode = false;
                this.closeAndRemoveAllPeers("quiting SuperSeed mode", true);
                return;
            }
            found = true;
        }
        if (piece == null) {
            return;
        }
        if (selectedPeer.isPieceAvailable(piece.getPieceNumber())) {
            return;
        }
        selectedPeer.setUniqueAnnounce(piece.getPieceNumber());
        ++this.superSeedModeNumberOfAnnounces;
        piece.pieceRevealedToPeer();
        ((PEPeerTransport)selectedPeer).sendHave(piece.getPieceNumber());
    }

    public void updateSuperSeedPiece(PEPeer peer, int pieceNumber) {
        if (!this.superSeedMode) {
            return;
        }
        this.superSeedPieces[pieceNumber].peerHasPiece(null);
        if (peer.getUniqueAnnounce() == pieceNumber) {
            peer.setUniqueAnnounce(-1);
            --this.superSeedModeNumberOfAnnounces;
        }
    }

    public boolean isAZMessagingEnabled() {
        return this.adapter.isAZMessagingEnabled();
    }

    public boolean isPeerExchangeEnabled() {
        return this.adapter.isPeerExchangeEnabled();
    }

    public LimitedRateGroup getUploadLimitedRateGroup() {
        return this.upload_limited_rate_group;
    }

    public LimitedRateGroup getDownloadLimitedRateGroup() {
        return this.download_limited_rate_group;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getData(String key) {
        try {
            this.this_mon.enter();
            if (this.user_data == null) {
                Object var2_2 = null;
                return var2_2;
            }
            Object v = this.user_data.get(key);
            return v;
        }
        finally {
            this.this_mon.exit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setData(String key, Object value) {
        try {
            this.this_mon.enter();
            if (this.user_data == null) {
                this.user_data = new HashMap();
            }
            if (value == null) {
                if (this.user_data.containsKey(key)) {
                    this.user_data.remove(key);
                }
            } else {
                this.user_data.put(key, value);
            }
        }
        finally {
            this.this_mon.exit();
        }
    }

    private void doConnectionChecks() {
        long last_update;
        ArrayList peer_transports;
        if (this.mainloop_loop_count % 10L == 0L) {
            peer_transports = this.peer_transports_cow;
            int num_waiting_establishments = 0;
            for (int i = 0; i < peer_transports.size(); ++i) {
                PEPeerTransport transport = (PEPeerTransport)peer_transports.get(i);
                int state = transport.getConnectionState();
                if (state != 0 && state != 1) continue;
                ++num_waiting_establishments;
            }
            int allowed = this.getMaxNewConnectionsAllowed();
            if (allowed < 0 || allowed > 1000) {
                allowed = 1000;
            }
            if (this.adapter.isNATHealthy()) {
                int free = PeerUtils.MAX_CONNECTIONS_PER_TORRENT / 20;
                allowed -= free;
            }
            if (allowed > 0) {
                PeerItem item;
                int wanted = ConnectDisconnectManager.MAX_SIMULTANIOUS_CONNECT_ATTEMPTS - num_waiting_establishments;
                if (wanted > allowed) {
                    num_waiting_establishments += wanted - allowed;
                }
                while (num_waiting_establishments < ConnectDisconnectManager.MAX_SIMULTANIOUS_CONNECT_ATTEMPTS && this.peer_database != null && this.is_running && (item = this.peer_database.getNextOptimisticConnectPeer()) != null && this.is_running) {
                    boolean use_crypto;
                    PeerItem self = this.peer_database.getSelfPeer();
                    if (self != null && self.equals(item) || this.isAlreadyConnected(item)) continue;
                    String source = PeerItem.convertSourceString(item.getSource());
                    boolean bl = use_crypto = item.getHandshakeType() == 1;
                    if (!this.makeNewOutgoingConnection(source, item.getAddressString(), item.getPort(), use_crypto)) continue;
                    ++num_waiting_establishments;
                }
            }
        }
        if (this.mainloop_loop_count % 50L == 0L) {
            peer_transports = this.peer_transports_cow;
            for (int i = 0; i < peer_transports.size(); ++i) {
                PEPeerTransport transport = (PEPeerTransport)peer_transports.get(i);
                if (transport.doTimeoutChecks()) continue;
                transport.doKeepAliveCheck();
                transport.doPerformanceTuningCheck();
            }
            int allowed = this.getMaxNewConnectionsAllowed();
            if (allowed == -1) {
                allowed = 100;
            }
        }
        if (this.mainloop_loop_count % 100L == 0L && (last_update = ip_filter.getLastUpdateTime()) != this.ip_filter_last_update_time) {
            this.ip_filter_last_update_time = last_update;
            this.checkForBannedConnections();
        }
        if (this.mainloop_loop_count % 300L == 0L && this.getMaxNewConnectionsAllowed() == 0) {
            ArrayList peer_transports2 = this.peer_transports_cow;
            PEPeerTransport max_transport = null;
            long max_time = 0L;
            for (int i = 0; i < peer_transports2.size(); ++i) {
                long time;
                PEPeerTransport peer = (PEPeerTransport)peer_transports2.get(i);
                if (peer.getConnectionState() != 4) continue;
                long last_time = 0L;
                if (this.seeding_mode) {
                    time = peer.getTimeSinceLastDataMessageSent();
                    if (time != -1L) {
                        last_time = time;
                    }
                } else {
                    time = peer.getTimeSinceGoodDataReceived();
                    last_time = time == -1L ? peer.getTimeSinceConnectionEstablished() : time;
                    last_time += peer.getSnubbedTime();
                }
                if (!peer.isIncoming()) {
                    last_time *= 2L;
                }
                if (last_time <= max_time) continue;
                max_time = last_time;
                max_transport = peer;
            }
            if (max_transport != null && max_time > 60000L) {
                this.closeAndRemovePeer(max_transport, "timed out by optimistic-connect", true);
            }
        }
        if (this.mainloop_loop_count % 600L == 0L) {
            ArrayList peer_transports3 = this.peer_transports_cow;
            for (int i = 0; i < peer_transports3.size(); ++i) {
                PEPeerTransport peer = (PEPeerTransport)peer_transports3.get(i);
                peer.updatePeerExchange();
            }
        }
    }

    public PeerExchangerItem createPeerExchangeConnection(final PEPeerTransport base_peer) {
        if (this.peer_database != null && base_peer.getTCPListenPort() > 0) {
            PeerItem peer = PeerItemFactory.createPeerItem(base_peer.getIp(), base_peer.getTCPListenPort(), 2, base_peer.getPeerItemIdentity().getHandshakeType());
            return this.peer_database.registerPeerConnection(peer, new PeerExchangerItem.Helper(){

                public boolean isSeed() {
                    return base_peer.isSeed();
                }
            });
        }
        return null;
    }

    private boolean isAlreadyConnected(PeerItem peer_id) {
        ArrayList peer_transports = this.peer_transports_cow;
        for (int i = 0; i < peer_transports.size(); ++i) {
            PEPeerTransport peer = (PEPeerTransport)peer_transports.get(i);
            if (!peer.getPeerItemIdentity().equals(peer_id)) continue;
            return true;
        }
        return false;
    }

    public void peerVerifiedAsSelf(PEPeerTransport self) {
        if (this.peer_database != null && self.getTCPListenPort() > 0) {
            PeerItem peer = PeerItemFactory.createPeerItem(self.getIp(), self.getTCPListenPort(), PeerItem.convertSourceID(self.getPeerSource()), self.getPeerItemIdentity().getHandshakeType());
            this.peer_database.setSelfPeer(peer);
        }
    }

    public void IPBanned(BannedIp ip) {
        for (int i = 0; i < this._nbPieces; ++i) {
            if (this.pePieces[i] == null) continue;
            this.pePieces[i].reDownloadBlocks(ip.getIp());
            if (this.dm_pieces[i].isWritten()) continue;
            this.dm_pieces[i].clearRequested();
        }
    }

    public int getAverageCompletionInThousandNotation() {
        ArrayList peers = this.peer_transports_cow;
        if (peers != null) {
            long total = this.disk_mgr.getTotalLength();
            int my_completion = total == 0L ? 1000 : (int)(1000L * (total - this.disk_mgr.getRemaining()) / total);
            int sum = my_completion == 1000 ? 0 : my_completion;
            int num = my_completion == 1000 ? 0 : 1;
            for (int i = 0; i < peers.size(); ++i) {
                PEPeer peer = (PEPeer)peers.get(i);
                if (peer.getPeerState() != 30 || peer.isSeed()) continue;
                ++num;
                sum += peer.getPercentDoneInThousandNotation();
            }
            return num > 0 ? sum / num : 0;
        }
        return -1;
    }

    public int getMaxConnections() {
        return this.adapter.getMaxConnections();
    }

    public int getMaxNewConnectionsAllowed() {
        int dl_max = this.getMaxConnections();
        int allowed_peers = PeerUtils.numNewConnectionsAllowed(this.getPeerIdentityDataID(), dl_max);
        return allowed_peers;
    }

    public String getRelationText() {
        return this.adapter.getLogRelation().getRelationText();
    }

    public Object[] getQueryableInterfaces() {
        return this.adapter.getLogRelation().getQueryableInterfaces();
    }

    public PEPeerTransport getTransportFromIdentity(byte[] peer_id) {
        ArrayList peer_transports = this.peer_transports_cow;
        for (int i = 0; i < peer_transports.size(); ++i) {
            PEPeerTransport conn = (PEPeerTransport)peer_transports.get(i);
            if (!Arrays.equals(peer_id, conn.getId())) continue;
            return conn;
        }
        return null;
    }

    public PEPeerTransport getTransportFromAddress(String peer) {
        ArrayList peer_transports = this.peer_transports_cow;
        for (int i = 0; i < peer_transports.size(); ++i) {
            PEPeerTransport pt = (PEPeerTransport)peer_transports.get(i);
            if (!peer.equals(pt.getIp())) continue;
            return pt;
        }
        return null;
    }
}

