/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.core3.util;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Stack;
import org.gudy.azureus2.core3.util.AERunnable;
import org.gudy.azureus2.core3.util.AESemaphore;
import org.gudy.azureus2.core3.util.AEThread;
import org.gudy.azureus2.core3.util.DebugLight;
import org.gudy.azureus2.core3.util.SimpleTimer;
import org.gudy.azureus2.core3.util.SystemTime;
import org.gudy.azureus2.core3.util.ThreadPool;
import org.gudy.azureus2.core3.util.ThreadPoolTask;
import org.gudy.azureus2.core3.util.TimerEvent;
import org.gudy.azureus2.core3.util.TimerEventPerformer;

public class ThreadPool {
    protected static final int IDLE_LINGER_TIME = 10000;
    protected static final boolean LOG_WARNINGS = false;
    protected static final int WARN_TIME = 10000;
    protected static List busy_pools = new ArrayList();
    protected static boolean busy_pool_timer_set = false;
    private static ThreadLocal tls = new ThreadLocal(){

        public Object initialValue() {
            return null;
        }
    };
    private String name;
    private int thread_name_index = 1;
    private long execution_limit;
    private Stack thread_pool;
    private List busy;
    private boolean queue_when_full;
    private List task_queue = new ArrayList();
    private AESemaphore thread_sem;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static void checkAllTimeouts() {
        ArrayList pools;
        List list = busy_pools;
        synchronized (list) {
            pools = new ArrayList(busy_pools);
        }
        for (int i = 0; i < pools.size(); ++i) {
            ((ThreadPool)pools.get(i)).checkTimeouts();
        }
    }

    public ThreadPool(String _name, int max_size) {
        this(_name, max_size, false);
    }

    public ThreadPool(String _name, int _max_size, boolean _queue_when_full) {
        this.name = _name;
        this.queue_when_full = _queue_when_full;
        this.thread_sem = new AESemaphore("ThreadPool::" + this.name, _max_size);
        this.thread_pool = new Stack();
        this.busy = new ArrayList(_max_size);
    }

    public void setExecutionLimit(long millis) {
        this.execution_limit = millis;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public threadPoolWorker run(AERunnable runnable) {
        threadPoolWorker allocated_worker;
        if (!this.queue_when_full && !this.thread_sem.reserveIfAvailable()) {
            threadPoolWorker recursive_worker = (threadPoolWorker)tls.get();
            if (recursive_worker == null || recursive_worker.getOwner() != this) {
                this.thread_sem.reserve();
            } else {
                if (runnable instanceof ThreadPoolTask) {
                    ThreadPoolTask task2 = (ThreadPoolTask)runnable;
                    task2.worker = recursive_worker;
                    try {
                        task2.taskStarted();
                        task2.run();
                    }
                    finally {
                        task2.taskCompleted();
                    }
                } else {
                    runnable.runSupport();
                }
                return recursive_worker;
            }
        }
        ThreadPool threadPool = this;
        synchronized (threadPool) {
            if (this.queue_when_full && !this.thread_sem.reserveIfAvailable()) {
                allocated_worker = null;
                this.task_queue.add(runnable);
            } else {
                allocated_worker = this.thread_pool.isEmpty() ? new threadPoolWorker(this) : (threadPoolWorker)this.thread_pool.pop();
                if (runnable instanceof ThreadPoolTask) {
                    ((ThreadPoolTask)runnable).worker = allocated_worker;
                }
                allocated_worker.run(runnable);
            }
        }
        return this.queue_when_full ? null : allocated_worker;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AERunnable[] getQueuedTasks() {
        ThreadPool threadPool = this;
        synchronized (threadPool) {
            AERunnable[] res = new AERunnable[this.task_queue.size()];
            this.task_queue.toArray(res);
            return res;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isQueued(AERunnable task2) {
        ThreadPool threadPool = this;
        synchronized (threadPool) {
            return this.task_queue.contains(task2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AERunnable[] getRunningTasks() {
        ArrayList<AERunnable> runnables = new ArrayList<AERunnable>();
        ThreadPool threadPool = this;
        synchronized (threadPool) {
            Iterator it = this.busy.iterator();
            while (it.hasNext()) {
                threadPoolWorker worker = (threadPoolWorker)it.next();
                AERunnable runnable = worker.getRunnable();
                if (runnable == null) continue;
                runnables.add(runnable);
            }
        }
        AERunnable[] res = new AERunnable[runnables.size()];
        runnables.toArray(res);
        return res;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void checkTimeouts() {
        ThreadPool threadPool = this;
        synchronized (threadPool) {
            long now = SystemTime.getCurrentTime();
            for (int i = 0; i < this.busy.size(); ++i) {
                threadPoolWorker x = (threadPoolWorker)this.busy.get(i);
                long elapsed = now - x.run_start_time;
                if (elapsed <= (long)(10000 * (x.warn_count + 1))) continue;
                x.warn_count++;
                if (this.execution_limit <= 0L || elapsed <= this.execution_limit) continue;
                AERunnable r = x.runnable;
                try {
                    if (r instanceof ThreadPoolTask) {
                        ((ThreadPoolTask)r).interruptTask();
                        continue;
                    }
                    x.worker_thread.interrupt();
                    continue;
                }
                catch (Throwable e) {
                    DebugLight.printStackTrace(e);
                }
            }
        }
    }

    public String getName() {
        return this.name;
    }

    static /* synthetic */ ThreadLocal access$600() {
        return tls;
    }

    static /* synthetic */ Stack access$900(ThreadPool x0) {
        return x0.thread_pool;
    }

    static /* synthetic */ List access$1000(ThreadPool x0) {
        return x0.busy;
    }

    static /* synthetic */ List access$1200(ThreadPool x0) {
        return x0.task_queue;
    }

    static /* synthetic */ AESemaphore access$1300(ThreadPool x0) {
        return x0.thread_sem;
    }

    public class threadPoolWorker {
        private ThreadPool owner;
        private String worker_name;
        private Thread worker_thread;
        private AESemaphore my_sem = new AESemaphore("TPWorker");
        private AERunnable runnable;
        private long run_start_time;
        private int warn_count;
        private String state = "<none>";

        protected threadPoolWorker(ThreadPool _owner) {
            this.owner = _owner;
            this.worker_name = ThreadPool.this.name + "[" + ThreadPool.this.thread_name_index++ + "]";
            this.worker_thread = new AEThread(this, this.worker_name, ThreadPool.this){
                private final /* synthetic */ ThreadPool val$this$0;
                private final /* synthetic */ threadPoolWorker this$1;
                {
                    this.this$1 = this$1;
                    this.val$this$0 = val$this$0;
                    super(x0);
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 * Unable to fully structure code
                 * Enabled aggressive block sorting
                 * Enabled unnecessary exception pruning
                 * Enabled aggressive exception aggregation
                 */
                public void runSupport() {
                    ThreadPool.access$600().set(this.this$1);
                    time_to_die = false;
                    try {
                        while (true) {
                            try {
                                while (true) {
                                    if (!threadPoolWorker.access$700(this.this$1).reserve(10000L)) {
                                        var2_6 = threadPoolWorker.access$800(this.this$1);
                                        synchronized (var2_6) {
                                            if (threadPoolWorker.access$200(this.this$1) == null) {
                                                time_to_die = true;
                                                ThreadPool.access$900(threadPoolWorker.access$800(this.this$1)).remove(this.this$1);
                                                // MONITOREXIT @DISABLED, blocks:[0, 32, 48, 1, 49, 12, 31] lbl14 : MonitorExitStatement: MONITOREXIT : var2_6
                                                var16_2 = null;
                                                if (time_to_die != false) return;
                                                var17_4 = threadPoolWorker.access$800(this.this$1);
                                                synchronized (var17_4) {
                                                    ThreadPool.access$900(threadPoolWorker.access$800(this.this$1)).push(this.this$1);
                                                }
                                                ThreadPool.access$1300(threadPoolWorker.access$800(this.this$1)).release();
                                                return;
                                            }
                                            continue;
                                        }
                                    }
                                    while (threadPoolWorker.access$200(this.this$1) != null) {
                                        try {
                                            block51: {
                                                try {
                                                    var2_6 = threadPoolWorker.access$800(this.this$1);
                                                    synchronized (var2_6) {
                                                        threadPoolWorker.access$002(this.this$1, SystemTime.getCurrentTime());
                                                        threadPoolWorker.access$102(this.this$1, 0);
                                                        ThreadPool.access$1000(threadPoolWorker.access$800(this.this$1)).add(this.this$1);
                                                        if (ThreadPool.access$1000(threadPoolWorker.access$800(this.this$1)).size() == 1) {
                                                            var3_9 = ThreadPool.busy_pools;
                                                            synchronized (var3_9) {
                                                                ThreadPool.busy_pools.add(threadPoolWorker.access$800(this.this$1));
                                                                if (!ThreadPool.busy_pool_timer_set) {
                                                                    ThreadPool.busy_pool_timer_set = true;
                                                                    SimpleTimer.addPeriodicEvent(10000L, new TimerEventPerformer(this){
                                                                        private final /* synthetic */ 2 this$2;
                                                                        {
                                                                            this.this$2 = this$2;
                                                                        }

                                                                        public void perform(TimerEvent event) {
                                                                            ThreadPool.checkAllTimeouts();
                                                                        }
                                                                    });
                                                                }
                                                            }
                                                        }
                                                        ** if (!(threadPoolWorker.access$200((threadPoolWorker)this.this$1) instanceof ThreadPoolTask)) goto lbl54
                                                    }
lbl-1000:
                                                    // 1 sources

                                                    {
                                                        tpt = (ThreadPoolTask)threadPoolWorker.access$200(this.this$1);
                                                        try {
                                                            tpt.taskStarted();
                                                            threadPoolWorker.access$200(this.this$1).run();
                                                            break block51;
                                                        }
                                                        finally {
                                                            tpt.taskCompleted();
                                                        }
                                                    }
lbl54:
                                                    // 1 sources

                                                    threadPoolWorker.access$200(this.this$1).run();
                                                }
                                                catch (Throwable e) {
                                                    DebugLight.printStackTrace(e);
                                                    var8_10 = null;
                                                    var9_11 = threadPoolWorker.access$800(this.this$1);
                                                    synchronized (var9_11) {
                                                        elapsed = SystemTime.getCurrentTime() - threadPoolWorker.access$000(this.this$1);
                                                        if (elapsed > 10000L) {
                                                            // empty if block
                                                        }
                                                        ThreadPool.access$1000(threadPoolWorker.access$800(this.this$1)).remove(this.this$1);
                                                        if (ThreadPool.access$1000(threadPoolWorker.access$800(this.this$1)).size() == 0) {
                                                            var12_13 = ThreadPool.busy_pools;
                                                            synchronized (var12_13) {
                                                                ThreadPool.busy_pools.remove(threadPoolWorker.access$800(this.this$1));
                                                            }
                                                        }
                                                        if (ThreadPool.access$1200(threadPoolWorker.access$800(this.this$1)).size() > 0) {
                                                            threadPoolWorker.access$202(this.this$1, (AERunnable)ThreadPool.access$1200(threadPoolWorker.access$800(this.this$1)).remove(0));
                                                        } else {
                                                            threadPoolWorker.access$202(this.this$1, null);
                                                        }
                                                        continue;
                                                    }
                                                }
                                            }
                                            var8_10 = null;
                                        }
                                        catch (Throwable var7_15) {
                                            var8_10 = null;
                                            var9_11 = threadPoolWorker.access$800(this.this$1);
                                            synchronized (var9_11) {
                                                elapsed = SystemTime.getCurrentTime() - threadPoolWorker.access$000(this.this$1);
                                                if (elapsed > 10000L) {
                                                    // empty if block
                                                }
                                                ThreadPool.access$1000(threadPoolWorker.access$800(this.this$1)).remove(this.this$1);
                                                if (ThreadPool.access$1000(threadPoolWorker.access$800(this.this$1)).size() == 0) {
                                                    var12_13 = ThreadPool.busy_pools;
                                                    synchronized (var12_13) {
                                                        ThreadPool.busy_pools.remove(threadPoolWorker.access$800(this.this$1));
                                                    }
                                                }
                                                if (ThreadPool.access$1200(threadPoolWorker.access$800(this.this$1)).size() > 0) {
                                                    threadPoolWorker.access$202(this.this$1, (AERunnable)ThreadPool.access$1200(threadPoolWorker.access$800(this.this$1)).remove(0));
                                                } else {
                                                    threadPoolWorker.access$202(this.this$1, null);
                                                }
                                                throw var7_15;
                                            }
                                        }
                                        var9_11 = threadPoolWorker.access$800(this.this$1);
                                        synchronized (var9_11) {
                                            elapsed = SystemTime.getCurrentTime() - threadPoolWorker.access$000(this.this$1);
                                            if (elapsed > 10000L) {
                                                // empty if block
                                            }
                                            ThreadPool.access$1000(threadPoolWorker.access$800(this.this$1)).remove(this.this$1);
                                            if (ThreadPool.access$1000(threadPoolWorker.access$800(this.this$1)).size() == 0) {
                                                var12_13 = ThreadPool.busy_pools;
                                                synchronized (var12_13) {
                                                    ThreadPool.busy_pools.remove(threadPoolWorker.access$800(this.this$1));
                                                }
                                            }
                                            if (ThreadPool.access$1200(threadPoolWorker.access$800(this.this$1)).size() > 0) {
                                                threadPoolWorker.access$202(this.this$1, (AERunnable)ThreadPool.access$1200(threadPoolWorker.access$800(this.this$1)).remove(0));
                                            } else {
                                                threadPoolWorker.access$202(this.this$1, null);
                                            }
                                        }
                                    }
                                    var16_2 = null;
                                    if (!time_to_die) ** break;
                                }
                            }
                            catch (Throwable e) {
                                DebugLight.printStackTrace(e);
                                var16_2 = null;
                                if (time_to_die) continue;
                                var17_4 = threadPoolWorker.access$800(this.this$1);
                                synchronized (var17_4) {
                                    ThreadPool.access$900(threadPoolWorker.access$800(this.this$1)).push(this.this$1);
                                }
                                ThreadPool.access$1300(threadPoolWorker.access$800(this.this$1)).release();
                                continue;
                            }
                            var17_4 = threadPoolWorker.access$800(this.this$1);
                            synchronized (var17_4) {
                                ThreadPool.access$900(threadPoolWorker.access$800(this.this$1)).push(this.this$1);
                            }
                            ThreadPool.access$1300(threadPoolWorker.access$800(this.this$1)).release();
                            continue;
                            break;
                        }
                    }
                    catch (Throwable var15_16) {
                        var16_3 = null;
                        if (time_to_die != false) throw var15_16;
                        var17_5 = threadPoolWorker.access$800(this.this$1);
                        synchronized (var17_5) {
                            ThreadPool.access$900(threadPoolWorker.access$800(this.this$1)).push(this.this$1);
                        }
                        ThreadPool.access$1300(threadPoolWorker.access$800(this.this$1)).release();
                        throw var15_16;
                    }
                }
            };
            this.worker_thread.setDaemon(true);
            this.worker_thread.start();
        }

        public void setState(String _state) {
            this.state = _state;
        }

        public String getState() {
            return this.state;
        }

        protected String getWorkerName() {
            return this.worker_name;
        }

        protected ThreadPool getOwner() {
            return this.owner;
        }

        protected void run(AERunnable _runnable) {
            this.runnable = _runnable;
            this.my_sem.release();
        }

        protected AERunnable getRunnable() {
            return this.runnable;
        }

        static /* synthetic */ AESemaphore access$700(threadPoolWorker x0) {
            return x0.my_sem;
        }

        static /* synthetic */ ThreadPool access$800(threadPoolWorker x0) {
            return x0.ThreadPool.this;
        }

        static /* synthetic */ long access$002(threadPoolWorker x0, long x1) {
            x0.run_start_time = x1;
            return x0.run_start_time;
        }

        static /* synthetic */ int access$102(threadPoolWorker x0, int x1) {
            x0.warn_count = x1;
            return x0.warn_count;
        }

        static /* synthetic */ String access$1100(threadPoolWorker x0) {
            return x0.state;
        }

        static /* synthetic */ AERunnable access$202(threadPoolWorker x0, AERunnable x1) {
            x0.runnable = x1;
            return x0.runnable;
        }
    }
}

