/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.platform.win32;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.gudy.azureus2.core3.logging.LogAlert;
import org.gudy.azureus2.core3.logging.LogEvent;
import org.gudy.azureus2.core3.logging.LogIDs;
import org.gudy.azureus2.core3.logging.Logger;
import org.gudy.azureus2.core3.util.AEMonitor;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.core3.util.SystemProperties;
import org.gudy.azureus2.platform.PlatformManager;
import org.gudy.azureus2.platform.PlatformManagerCapabilities;
import org.gudy.azureus2.platform.PlatformManagerListener;
import org.gudy.azureus2.platform.win32.access.AEWin32Access;
import org.gudy.azureus2.platform.win32.access.AEWin32AccessListener;
import org.gudy.azureus2.platform.win32.access.AEWin32Manager;
import org.gudy.azureus2.plugins.platform.PlatformManagerException;

public class PlatformManagerImpl
implements PlatformManager,
AEWin32AccessListener {
    private static final LogIDs LOGID = LogIDs.CORE;
    public static final int RT_NONE = 0;
    public static final int RT_AZ = 1;
    public static final int RT_OTHER = 2;
    public static final String DLL_NAME = "aereg";
    public static final String NEW_MAIN_ASSOC = "Azureus";
    public static final String OLD_MAIN_ASS0C = "BitTorrent";
    private static boolean init_tried;
    private static PlatformManagerImpl singleton;
    private static AEMonitor class_mon;
    private final Set capabilitySet = new HashSet();
    private List listeners = new ArrayList();
    protected AEWin32Access access;
    protected String app_exe_name;
    protected File az_exe;
    protected boolean az_exe_checked;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static PlatformManagerImpl getSingleton() throws PlatformManagerException {
        try {
            class_mon.enter();
            if (singleton == null && !init_tried) {
                init_tried = true;
                try {
                    singleton = new PlatformManagerImpl(AEWin32Manager.getAccessor());
                }
                catch (Throwable e) {
                    Logger.log(new LogEvent(LOGID, "Win32Platform: failed to initialise", e));
                    if (e instanceof PlatformManagerException) {
                        throw (PlatformManagerException)e;
                    }
                    throw new PlatformManagerException("Win32Platform: failed to initialise", e);
                }
            }
            PlatformManagerImpl platformManagerImpl = singleton;
            return platformManagerImpl;
        }
        finally {
            class_mon.exit();
        }
    }

    protected PlatformManagerImpl(AEWin32Access _access) throws PlatformManagerException {
        this.access = _access;
        this.access.addListener(this);
        this.app_exe_name = SystemProperties.getApplicationName() + ".exe";
        this.initializeCapabilities();
        this.applyPatches();
    }

    private void initializeCapabilities() {
        this.capabilitySet.add(PlatformManagerCapabilities.CreateCommandLineProcess);
        this.capabilitySet.add(PlatformManagerCapabilities.GetUserDataDirectory);
        this.capabilitySet.add(PlatformManagerCapabilities.RecoverableFileDelete);
        this.capabilitySet.add(PlatformManagerCapabilities.RegisterFileAssociations);
        this.capabilitySet.add(PlatformManagerCapabilities.ShowFileInBrowser);
        this.capabilitySet.add(PlatformManagerCapabilities.GetVersion);
        this.capabilitySet.add(PlatformManagerCapabilities.SetTCPTOSEnabled);
    }

    protected void applyPatches() {
        try {
            File exe_loc = this.getApplicationEXELocation();
            String az_exe_string = exe_loc.toString();
            String current = this.access.readStringValue(1, "Azureus\\DefaultIcon", "");
            String target = az_exe_string + "," + this.getIconIndex();
            if (current.indexOf(this.app_exe_name) != -1 && !current.equals(target)) {
                this.access.writeStringValue(1, "Azureus\\DefaultIcon", "", target);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    protected int getIconIndex() throws PlatformManagerException {
        return 0;
    }

    public String getVersion() {
        return this.access.getVersion();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected File getApplicationEXELocation() throws PlatformManagerException {
        if (this.az_exe == null) {
            try {
                String az_home;
                try {
                    az_home = this.access.getApplicationInstallDir(SystemProperties.getApplicationName());
                    this.az_exe = new File(az_home + File.separator + this.app_exe_name).getAbsoluteFile();
                    if (!this.az_exe.exists()) {
                        throw new PlatformManagerException(this.app_exe_name + " not found in " + az_home + ", please re-install");
                    }
                }
                catch (Throwable e) {
                    az_home = SystemProperties.getApplicationPath();
                    this.az_exe = new File(az_home + File.separator + this.app_exe_name).getAbsoluteFile();
                }
                if (!this.az_exe.exists()) {
                    String msg = this.app_exe_name + " not found in " + az_home + " - can't check file associations. Please re-install " + SystemProperties.getApplicationName();
                    this.az_exe = null;
                    if (!this.az_exe_checked) {
                        Logger.log(new LogAlert(false, 1, msg));
                    }
                    throw new PlatformManagerException(msg);
                }
            }
            finally {
                this.az_exe_checked = true;
            }
        }
        return this.az_exe;
    }

    public int getPlatformType() {
        return 1;
    }

    public String getUserDataDirectory() throws PlatformManagerException {
        try {
            return this.access.getUserAppData();
        }
        catch (Throwable e) {
            throw new PlatformManagerException("Failed to read registry details", e);
        }
    }

    public File getLocation(long location_id) throws PlatformManagerException {
        if (location_id == 1L) {
            return new File(this.getUserDataDirectory());
        }
        if (location_id == 2L) {
            try {
                return new File(this.access.readStringValue(4, "software\\microsoft\\windows\\currentversion\\explorer\\shell folders", "My Music"));
            }
            catch (Throwable e) {
                throw new PlatformManagerException("Failed to read registry details", e);
            }
        }
        return null;
    }

    public String getApplicationCommandLine() {
        try {
            return this.getApplicationEXELocation().toString();
        }
        catch (Throwable e) {
            return null;
        }
    }

    public boolean isApplicationRegistered() throws PlatformManagerException {
        try {
            if (this.getAdditionalFileTypeRegistrationDetails("Magnet", ".magnet") == 0) {
                this.registerMagnet();
            }
        }
        catch (Throwable e) {
            Debug.printStackTrace(e);
        }
        if (this.isAdditionalFileTypeRegistered(OLD_MAIN_ASS0C, ".torrent")) {
            this.registerAdditionalFileType(NEW_MAIN_ASSOC, "BitTorrent File", ".torrent", "application/x-bittorrent");
        }
        return this.isAdditionalFileTypeRegistered(NEW_MAIN_ASSOC, ".torrent");
    }

    public boolean isAdditionalFileTypeRegistered(String name, String type) throws PlatformManagerException {
        return this.getAdditionalFileTypeRegistrationDetails(name, type) == 1;
    }

    public int getAdditionalFileTypeRegistrationDetails(String name, String type) throws PlatformManagerException {
        String az_exe_str;
        try {
            az_exe_str = this.getApplicationEXELocation().toString();
        }
        catch (Throwable e) {
            return 0;
        }
        try {
            String test1 = this.access.readStringValue(1, name + "\\shell\\open\\command", "");
            if (!test1.equals("\"" + az_exe_str + "\" \"%1\"")) {
                return test1.length() == 0 ? 0 : 2;
            }
            try {
                String always_open_with = this.access.readStringValue(4, "Software\\Microsoft\\Windows\\CurrentVersion\\Explorer\\FileExts\\" + type, "Application");
                if (always_open_with.length() > 0) {
                    return 2;
                }
            }
            catch (Throwable e) {
                // empty catch block
            }
            return 1;
        }
        catch (Throwable e) {
            if (e.getMessage() == null || e.getMessage().indexOf("RegOpenKey failed") == -1) {
                Debug.printStackTrace(e);
            }
            return 0;
        }
    }

    public void registerApplication() throws PlatformManagerException {
        this.registerMagnet();
        this.registerAdditionalFileType(NEW_MAIN_ASSOC, "BitTorrent File", ".torrent", "application/x-bittorrent");
    }

    protected void registerMagnet() {
        try {
            this.registerAdditionalFileType("Magnet", "Magnet File", ".magnet", "application/x-magnet", true);
        }
        catch (Throwable e) {
            Debug.printStackTrace(e);
        }
    }

    public void registerAdditionalFileType(String name, String description, String type, String content_type) throws PlatformManagerException {
        this.registerAdditionalFileType(name, description, type, content_type, false);
    }

    public void registerAdditionalFileType(String name, String description, String type, String content_type, boolean url_protocol) throws PlatformManagerException {
        try {
            String az_exe_string = this.getApplicationEXELocation().toString();
            this.unregisterAdditionalFileType(name, type);
            this.access.writeStringValue(1, type, "", name);
            this.access.writeStringValue(1, name, "", description);
            this.access.writeStringValue(1, name + "\\shell", "", "open");
            this.access.writeStringValue(1, name + "\\DefaultIcon", "", az_exe_string + "," + this.getIconIndex());
            this.access.writeStringValue(1, name + "\\shell\\open\\command", "", "\"" + az_exe_string + "\" \"%1\"");
            this.access.writeStringValue(1, name + "\\Content Type", "", content_type);
            if (url_protocol) {
                this.access.writeStringValue(1, name, "URL Protocol", "");
            }
        }
        catch (PlatformManagerException e) {
            throw e;
        }
        catch (Throwable e) {
            throw new PlatformManagerException("Failed to write registry details", e);
        }
    }

    public void unregisterAdditionalFileType(String name, String type) throws PlatformManagerException {
        try {
            try {
                this.access.deleteValue(4, "Software\\Microsoft\\Windows\\CurrentVersion\\Explorer\\FileExts\\" + type, "Application");
            }
            catch (Throwable e) {
                // empty catch block
            }
            try {
                this.access.deleteKey(1, type);
            }
            catch (Throwable e) {
                // empty catch block
            }
            try {
                this.access.deleteKey(1, name, true);
            }
            catch (Throwable e) {}
        }
        catch (Throwable e) {
            throw new PlatformManagerException("Failed to delete registry details", e);
        }
    }

    public void createProcess(String command_line, boolean inherit_handles) throws PlatformManagerException {
        try {
            this.access.createProcess(command_line, inherit_handles);
        }
        catch (Throwable e) {
            throw new PlatformManagerException("Failed to create process", e);
        }
    }

    public void performRecoverableFileDelete(String file_name) throws PlatformManagerException {
        try {
            this.access.moveToRecycleBin(file_name);
        }
        catch (Throwable e) {
            throw new PlatformManagerException("Failed to move file", e);
        }
    }

    public void setTCPTOSEnabled(boolean enabled) throws PlatformManagerException {
        try {
            this.access.writeWordValue(3, "System\\CurrentControlSet\\Services\\Tcpip\\Parameters", "DisableUserTOSSetting", enabled ? 0 : 1);
        }
        catch (Throwable e) {
            throw new PlatformManagerException("Failed to write registry details", e);
        }
    }

    public void showFile(String file_name) throws PlatformManagerException {
        try {
            Runtime.getRuntime().exec(new String[]{"explorer.exe", "/e,/select,", "\"" + file_name + "\""});
        }
        catch (IOException e) {
            throw new PlatformManagerException("Failed to show file " + file_name, e);
        }
    }

    public boolean hasCapability(PlatformManagerCapabilities capability) {
        return this.capabilitySet.contains(capability);
    }

    public void dispose() {
    }

    public void eventOccurred(int type) {
        if (type != 22) {
            return;
        }
        int t_type = 1;
        if (t_type != -1) {
            for (int i = 0; i < this.listeners.size(); ++i) {
                try {
                    ((PlatformManagerListener)this.listeners.get(i)).eventOccurred(t_type);
                    continue;
                }
                catch (Throwable e) {
                    Debug.printStackTrace(e);
                }
            }
        }
    }

    public void addListener(PlatformManagerListener listener) {
        this.listeners.add(listener);
    }

    public void removeListener(PlatformManagerListener listener) {
        this.listeners.remove(listener);
    }

    static {
        class_mon = new AEMonitor("PlatformManager");
    }
}

