/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.pluginsimpl.local.ddb;

import com.aelitis.azureus.core.AzureusCore;
import com.aelitis.azureus.plugins.dht.DHTPluginProgressListener;
import javax.crypto.Cipher;
import javax.crypto.spec.SecretKeySpec;
import org.gudy.azureus2.core3.logging.LogAlert;
import org.gudy.azureus2.core3.logging.Logger;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.core3.util.SHA1Simple;
import org.gudy.azureus2.core3.util.SystemTime;
import org.gudy.azureus2.plugins.PluginInterface;
import org.gudy.azureus2.plugins.ddb.DistributedDatabaseContact;
import org.gudy.azureus2.plugins.ddb.DistributedDatabaseException;
import org.gudy.azureus2.plugins.ddb.DistributedDatabaseKey;
import org.gudy.azureus2.plugins.ddb.DistributedDatabaseProgressListener;
import org.gudy.azureus2.plugins.ddb.DistributedDatabaseTransferHandler;
import org.gudy.azureus2.plugins.ddb.DistributedDatabaseTransferType;
import org.gudy.azureus2.plugins.ddb.DistributedDatabaseValue;
import org.gudy.azureus2.plugins.download.Download;
import org.gudy.azureus2.plugins.download.DownloadException;
import org.gudy.azureus2.plugins.torrent.Torrent;
import org.gudy.azureus2.plugins.torrent.TorrentAttribute;
import org.gudy.azureus2.pluginsimpl.local.ddb.DDBaseContactImpl;
import org.gudy.azureus2.pluginsimpl.local.ddb.DDBaseHelpers;
import org.gudy.azureus2.pluginsimpl.local.ddb.DDBaseImpl;
import org.gudy.azureus2.pluginsimpl.local.ddb.DDBaseKeyImpl;
import org.gudy.azureus2.pluginsimpl.local.ddb.DDBaseValueImpl;

public class DDBaseTTTorrent
implements DistributedDatabaseTransferType,
DistributedDatabaseTransferHandler {
    public static final boolean TRACE = false;
    public static final byte CRYPTO_VERSION = 1;
    private AzureusCore azureus_core;
    private DDBaseImpl ddb;
    private TorrentAttribute ta_sha1;
    private boolean crypto_tested;
    private boolean crypto_available;

    protected DDBaseTTTorrent(AzureusCore _azureus_core, DDBaseImpl _ddb) {
        this.azureus_core = _azureus_core;
        this.ddb = _ddb;
    }

    public DistributedDatabaseValue read(DistributedDatabaseContact contact, DistributedDatabaseTransferType type, DistributedDatabaseKey key) throws DistributedDatabaseException {
        byte protocol_version = ((DDBaseContactImpl)contact).getContact().getProtocolVersion();
        try {
            byte[] search_key = ((DDBaseKeyImpl)key).getBytes();
            Download download = null;
            PluginInterface pi = this.azureus_core.getPluginManager().getDefaultPluginInterface();
            boolean encrypt = false;
            if (protocol_version >= 8) {
                String search_sha1 = pi.getUtilities().getFormatters().encodeBytesToString(search_key);
                if (this.ta_sha1 == null) {
                    this.ta_sha1 = pi.getTorrentManager().getPluginAttribute("DDBaseTTTorrent::sha1");
                }
                Download[] downloads = pi.getDownloadManager().getDownloads();
                for (int i = 0; i < downloads.length; ++i) {
                    Download dl = downloads[i];
                    if (dl.getTorrent() == null) continue;
                    String sha1 = dl.getAttribute(this.ta_sha1);
                    if (sha1 == null) {
                        sha1 = pi.getUtilities().getFormatters().encodeBytesToString(new SHA1Simple().calculateHash(dl.getTorrent().getHash()));
                        dl.setAttribute(this.ta_sha1, sha1);
                    }
                    if (!sha1.equals(search_sha1)) continue;
                    download = dl;
                    encrypt = true;
                    break;
                }
                if (download == null) {
                    download = pi.getShortCuts().getDownload(search_key);
                }
            } else {
                download = pi.getShortCuts().getDownload(search_key);
            }
            if (download == null) {
                String msg = "TorrentDownload: " + (encrypt ? "secure" : "insecure") + " request for '" + pi.getUtilities().getFormatters().encodeBytesToString(search_key) + "' not found";
                this.ddb.log(msg);
                return null;
            }
            Torrent torrent = download.getTorrent();
            String msg = "TorrentDownload: " + (encrypt ? "secure" : "insecure") + " request for '" + download.getName() + "' OK";
            this.ddb.log(msg);
            torrent = torrent.removeAdditionalProperties();
            torrent.setDecentralisedBackupRequested(true);
            byte[] data = torrent.writeToBEncodedData();
            if (encrypt && (data = this.encrypt(torrent.getHash(), data)) == null) {
                return null;
            }
            return this.ddb.createValue(data);
        }
        catch (DownloadException e) {
            return null;
        }
        catch (Throwable e) {
            throw new DistributedDatabaseException("Torrent write fails", e);
        }
    }

    public void write(DistributedDatabaseContact contact, DistributedDatabaseTransferType type, DistributedDatabaseKey key, DistributedDatabaseValue value) throws DistributedDatabaseException {
        throw new DistributedDatabaseException("not supported");
    }

    protected DistributedDatabaseValue read(DDBaseContactImpl contact, final DistributedDatabaseProgressListener listener, DistributedDatabaseTransferType type, DistributedDatabaseKey key, long timeout) throws DistributedDatabaseException {
        byte protocol_version = contact.getContact().getProtocolVersion();
        byte[] torrent_hash = ((DDBaseKeyImpl)key).getBytes();
        byte[] lookup_key = protocol_version >= 8 ? new SHA1Simple().calculateHash(torrent_hash) : torrent_hash;
        byte[] data = this.ddb.getDHT().read(new DHTPluginProgressListener(){

            public void reportSize(long size) {
                listener.reportSize(size);
            }

            public void reportActivity(String str) {
                listener.reportActivity(str);
            }

            public void reportCompleteness(int percent) {
                listener.reportCompleteness(percent);
            }
        }, contact.getContact(), DDBaseHelpers.getKey(type.getClass()).getHash(), lookup_key, timeout);
        if (data == null) {
            return null;
        }
        if (protocol_version >= 8 && (data = this.decrypt(torrent_hash, data)) == null) {
            return null;
        }
        return new DDBaseValueImpl(contact, data, SystemTime.getCurrentTime());
    }

    protected byte[] encrypt(byte[] hash, byte[] data) {
        if (!this.testCrypto()) {
            return null;
        }
        byte[] enc = this.doCrypt(1, hash, data, 0);
        if (enc == null) {
            byte[] res = new byte[data.length + 2];
            res[0] = 1;
            res[1] = 0;
            System.arraycopy(data, 0, res, 2, data.length);
            return res;
        }
        byte[] res = new byte[enc.length + 2];
        res[0] = 1;
        res[1] = 1;
        System.arraycopy(enc, 0, res, 2, enc.length);
        return res;
    }

    protected byte[] decrypt(byte[] hash, byte[] data) {
        if (!this.testCrypto()) {
            return null;
        }
        if (data[0] != 1) {
            Debug.out("Invalid crypto version received");
            return data;
        }
        if (data[1] == 0) {
            byte[] res = new byte[data.length - 2];
            System.arraycopy(data, 2, res, 0, res.length);
            return res;
        }
        byte[] res = this.doCrypt(2, hash, data, 2);
        return res;
    }

    protected byte[] doCrypt(int mode, byte[] hash, byte[] data, int data_offset) {
        try {
            byte[] key_data = new byte[24];
            System.arraycopy(hash, 0, key_data, 0, hash.length);
            SecretKeySpec tdes_key = new SecretKeySpec(key_data, "DESede");
            Cipher cipher = Cipher.getInstance("DESede");
            cipher.init(mode, tdes_key);
            return cipher.doFinal(data, data_offset, data.length - data_offset);
        }
        catch (Throwable e) {
            Debug.out(e);
            return null;
        }
    }

    protected boolean testCrypto() {
        if (!this.crypto_tested) {
            this.crypto_tested = true;
            try {
                Cipher.getInstance("DESede");
                this.crypto_available = true;
            }
            catch (Throwable e) {
                Logger.log(new LogAlert(false, "Unable to initialise cryptographic framework for magnet-based torrent downloads, please re-install Java", e));
            }
        }
        return this.crypto_available;
    }
}

