/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.ui.console.commands;

import java.io.PrintStream;
import java.util.Iterator;
import java.util.List;
import org.gudy.azureus2.core3.download.DownloadManager;
import org.gudy.azureus2.core3.util.ByteFormatter;
import org.gudy.azureus2.ui.console.ConsoleInput;
import org.gudy.azureus2.ui.console.commands.IConsoleCommand;

public abstract class TorrentCommand
extends IConsoleCommand {
    private final String primaryCommandName;
    private final String action;

    public TorrentCommand(String[] commandNames, String action) {
        super(commandNames);
        this.primaryCommandName = commandNames[0];
        this.action = action;
    }

    protected String getCommandName() {
        return this.primaryCommandName;
    }

    protected String getAction() {
        return this.action;
    }

    protected abstract boolean performCommand(ConsoleInput var1, DownloadManager var2, List var3);

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void execute(String commandName, ConsoleInput ci, List args) {
        if (!args.isEmpty()) {
            String subcommand = (String)args.remove(0);
            if (ci.torrents.isEmpty()) {
                ci.out.println("> Command '" + this.getCommandName() + "': No torrents in list (Maybe you forgot to 'show torrents' first).");
                return;
            }
            try {
                int number = Integer.parseInt(subcommand);
                if (number > 0 && number <= ci.torrents.size()) {
                    DownloadManager dm = (DownloadManager)ci.torrents.get(number - 1);
                    String name = dm.getDisplayName() == null ? "?" : dm.getDisplayName();
                    this.performCommandIfAllowed(ci, args, dm, "#" + subcommand, name);
                    return;
                }
                ci.out.println("> Command '" + this.getCommandName() + "': Torrent #" + subcommand + " unknown.");
                return;
            }
            catch (NumberFormatException e) {
                if ("all".equalsIgnoreCase(subcommand)) {
                    Iterator torrent = ci.torrents.iterator();
                    while (torrent.hasNext()) {
                        DownloadManager dm = (DownloadManager)torrent.next();
                        String name = dm.getDisplayName() == null ? "?" : dm.getDisplayName();
                        this.performCommandIfAllowed(ci, args, dm, subcommand, name);
                    }
                    return;
                }
                if ("hash".equalsIgnoreCase(subcommand)) {
                    String hash = (String)args.remove(0);
                    List torrents = ci.gm.getDownloadManagers();
                    boolean foundit = false;
                    if (torrents.isEmpty()) return;
                    Iterator torrent = torrents.iterator();
                    while (torrent.hasNext()) {
                        DownloadManager dm = (DownloadManager)torrent.next();
                        if (!hash.equals(ByteFormatter.nicePrintTorrentHash(dm.getTorrent(), true))) continue;
                        String name = dm.getDisplayName() == null ? "?" : dm.getDisplayName();
                        this.performCommandIfAllowed(ci, args, dm, hash, name);
                        return;
                    }
                    if (foundit) return;
                    ci.out.println("> Command '" + this.getCommandName() + "': Hash '" + hash + "' unknown.");
                    return;
                }
                ci.out.println("> Command '" + this.getCommandName() + "': Subcommand '" + subcommand + "' unknown.");
            }
            return;
        }
        ci.out.println("> Missing subcommand for '" + this.getCommandName() + "'");
        this.printHelp(ci.out, args);
    }

    private void performCommandIfAllowed(ConsoleInput ci, List args, DownloadManager dm, String desc, String name) {
        if (!"admin".equals(ci.getUserProfile().getUserType())) {
            if ("user".equals(ci.getUserProfile().getUserType())) {
                String owner = dm.getDownloadState().getAttribute("user");
                if (!ci.getUserProfile().getUsername().equals(owner)) {
                    ci.out.println("> " + this.getAction() + " torrent " + desc + " (" + name + ") failed: Permission Denied. Users can only modify their own torrents");
                    return;
                }
            } else {
                ci.out.println("> " + this.getAction() + " torrent " + desc + " (" + name + ") failed: Permission Denied. Guests cannot modify torrents");
                return;
            }
        }
        if (this.performCommand(ci, dm, args)) {
            ci.out.println("> " + this.getAction() + " Torrent " + desc + " (" + name + ") succeeded.");
        } else {
            ci.out.println("> " + this.getAction() + " Torrent " + desc + " (" + name + ") failed.");
        }
    }

    public void printHelp(PrintStream out, List args) {
        out.println("> " + this.getCommandName() + " syntax: " + this.getCommandName() + " (<#>|all|hash <hash>)");
    }
}

