/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.ui.swt.mainwindow;

import com.aelitis.azureus.core.AzureusCore;
import com.aelitis.azureus.core.AzureusCoreException;
import com.aelitis.azureus.core.AzureusCoreListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.swt.SWT;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabFolderAdapter;
import org.eclipse.swt.custom.CTabFolderEvent;
import org.eclipse.swt.custom.CTabFolderListener;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.custom.StackLayout;
import org.eclipse.swt.dnd.DropTarget;
import org.eclipse.swt.dnd.DropTargetAdapter;
import org.eclipse.swt.dnd.DropTargetEvent;
import org.eclipse.swt.dnd.DropTargetListener;
import org.eclipse.swt.dnd.FileTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.ShellAdapter;
import org.eclipse.swt.events.ShellEvent;
import org.eclipse.swt.events.ShellListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Decorations;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Item;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.ProgressBar;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;
import org.eclipse.swt.widgets.Widget;
import org.gudy.azureus2.core3.config.COConfigurationManager;
import org.gudy.azureus2.core3.config.ParameterListener;
import org.gudy.azureus2.core3.config.impl.TransferSpeedValidator;
import org.gudy.azureus2.core3.download.DownloadManager;
import org.gudy.azureus2.core3.download.DownloadManagerListener;
import org.gudy.azureus2.core3.global.GlobalManager;
import org.gudy.azureus2.core3.global.GlobalManagerListener;
import org.gudy.azureus2.core3.internat.MessageText;
import org.gudy.azureus2.core3.logging.LogEvent;
import org.gudy.azureus2.core3.logging.LogIDs;
import org.gudy.azureus2.core3.logging.Logger;
import org.gudy.azureus2.core3.security.SESecurityManager;
import org.gudy.azureus2.core3.stats.transfer.OverallStats;
import org.gudy.azureus2.core3.stats.transfer.StatsFactory;
import org.gudy.azureus2.core3.util.AEDiagnostics;
import org.gudy.azureus2.core3.util.AEDiagnosticsEvidenceGenerator;
import org.gudy.azureus2.core3.util.AEMonitor;
import org.gudy.azureus2.core3.util.AERunnable;
import org.gudy.azureus2.core3.util.AEThread;
import org.gudy.azureus2.core3.util.Constants;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.core3.util.DisplayFormatters;
import org.gudy.azureus2.core3.util.IndentWriter;
import org.gudy.azureus2.core3.util.SystemProperties;
import org.gudy.azureus2.plugins.PluginView;
import org.gudy.azureus2.plugins.update.UpdateCheckInstance;
import org.gudy.azureus2.plugins.update.UpdateCheckInstanceListener;
import org.gudy.azureus2.plugins.update.UpdateChecker;
import org.gudy.azureus2.plugins.update.UpdateCheckerListener;
import org.gudy.azureus2.plugins.update.UpdateManagerListener;
import org.gudy.azureus2.ui.swt.BlockedIpsWindow;
import org.gudy.azureus2.ui.swt.IconBar;
import org.gudy.azureus2.ui.swt.IconBarEnabler;
import org.gudy.azureus2.ui.swt.ImageRepository;
import org.gudy.azureus2.ui.swt.Messages;
import org.gudy.azureus2.ui.swt.MinimizedWindow;
import org.gudy.azureus2.ui.swt.OpenTorrentWindow;
import org.gudy.azureus2.ui.swt.PasswordWindow;
import org.gudy.azureus2.ui.swt.Tab;
import org.gudy.azureus2.ui.swt.TrayWindow;
import org.gudy.azureus2.ui.swt.URLTransfer;
import org.gudy.azureus2.ui.swt.Utils;
import org.gudy.azureus2.ui.swt.components.ColorUtils;
import org.gudy.azureus2.ui.swt.components.shell.ShellManager;
import org.gudy.azureus2.ui.swt.config.wizard.ConfigureWizard;
import org.gudy.azureus2.ui.swt.donations.DonationWindow2;
import org.gudy.azureus2.ui.swt.mainwindow.Colors;
import org.gudy.azureus2.ui.swt.mainwindow.Cursors;
import org.gudy.azureus2.ui.swt.mainwindow.GUIUpdater;
import org.gudy.azureus2.ui.swt.mainwindow.Initializer;
import org.gudy.azureus2.ui.swt.mainwindow.MainMenu;
import org.gudy.azureus2.ui.swt.mainwindow.SWTThread;
import org.gudy.azureus2.ui.swt.mainwindow.TorrentOpener;
import org.gudy.azureus2.ui.swt.maketorrent.NewTorrentWizard;
import org.gudy.azureus2.ui.swt.plugins.UISWTPluginView;
import org.gudy.azureus2.ui.swt.plugins.UISWTView;
import org.gudy.azureus2.ui.swt.plugins.UISWTViewEventListener;
import org.gudy.azureus2.ui.swt.pluginsimpl.UISWTInstanceImpl;
import org.gudy.azureus2.ui.swt.pluginsimpl.UISWTViewImpl;
import org.gudy.azureus2.ui.swt.sharing.progress.ProgressWindow;
import org.gudy.azureus2.ui.swt.update.UpdateProgressWindow;
import org.gudy.azureus2.ui.swt.update.UpdateWindow;
import org.gudy.azureus2.ui.swt.views.AbstractIView;
import org.gudy.azureus2.ui.swt.views.ConfigView;
import org.gudy.azureus2.ui.swt.views.IView;
import org.gudy.azureus2.ui.swt.views.LoggerView;
import org.gudy.azureus2.ui.swt.views.ManagerView;
import org.gudy.azureus2.ui.swt.views.MySharesView;
import org.gudy.azureus2.ui.swt.views.MyTorrentsSuperView;
import org.gudy.azureus2.ui.swt.views.MyTrackerView;
import org.gudy.azureus2.ui.swt.views.stats.StatsView;
import org.gudy.azureus2.ui.swt.welcome.WelcomeWindow;
import org.gudy.azureus2.ui.swt.wizard.WizardListener;
import org.gudy.azureus2.ui.systray.SystemTraySWT;

public class MainWindow
extends AERunnable
implements GlobalManagerListener,
DownloadManagerListener,
ParameterListener,
IconBarEnabler,
AzureusCoreListener,
AEDiagnosticsEvidenceGenerator {
    private static final LogIDs LOGID = LogIDs.GUI;
    private static MainWindow window;
    private Initializer initializer;
    private GUIUpdater updater;
    private AzureusCore azureus_core;
    GlobalManager globalManager;
    public static boolean isAlreadyDead;
    public static boolean isDisposeFromListener;
    private Display display;
    private Shell mainWindow;
    private MainMenu mainMenu;
    private IconBar iconBar;
    private boolean useCustomTab;
    private Composite folder;
    private UpdateWindow updateWindow;
    private Composite statusArea;
    Composite statusBar;
    StackLayout layoutStatusArea;
    CLabel statusText;
    private String statusTextKey = "";
    private String statusImageKey = null;
    private Composite statusUpdate;
    private Label statusUpdateLabel;
    private ProgressBar statusUpdateProgressBar;
    CLabel ipBlocked;
    CLabel srStatus;
    CLabel natStatus;
    CLabel dhtStatus;
    CLabel statusDown;
    CLabel statusUp;
    private TrayWindow tray;
    SystemTraySWT systemTraySWT;
    private HashMap downloadViews;
    private AEMonitor downloadViews_mon = new AEMonitor("MainWindow:dlviews");
    HashMap downloadBars;
    AEMonitor downloadBars_mon = new AEMonitor("MainWindow:dlbars");
    private Tab mytorrents;
    private Tab my_tracker_tab;
    private Tab my_shares_tab;
    private Tab stats_tab;
    private Tab console;
    private Tab config;
    private ConfigView config_view;
    private ArrayList update_stack = new ArrayList();
    protected AEMonitor this_mon = new AEMonitor("MainWindow");
    public static final String STATUS_ICON_WARN = "sb_warning";
    private UISWTInstanceImpl uiSWTInstanceImpl;
    private ArrayList events;
    Map pluginTabs = new HashMap();
    static /* synthetic */ Class class$org$gudy$azureus2$ui$swt$views$configsections$ConfigSectionConnection;

    public MainWindow(AzureusCore _azureus_core, Initializer _initializer, ArrayList events) {
        try {
            if (Logger.isEnabled()) {
                Logger.log(new LogEvent(LOGID, "MainWindow start"));
            }
            AEDiagnostics.addEvidenceGenerator(this);
            this.azureus_core = _azureus_core;
            this.globalManager = this.azureus_core.getGlobalManager();
            this.initializer = _initializer;
            this.display = SWTThread.getInstance().getDisplay();
            window = this;
            this.initializer.addListener(this);
            this.events = events;
            this.display.syncExec((Runnable)this);
        }
        catch (AzureusCoreException e) {
            Debug.printStackTrace(e);
        }
    }

    public void runSupport() {
        try {
            this.useCustomTab = COConfigurationManager.getBooleanParameter("useCustomTab");
            COConfigurationManager.addParameterListener("config.style.useSIUnits", this);
            this.mytorrents = null;
            this.my_tracker_tab = null;
            this.console = null;
            this.config = null;
            this.config_view = null;
            this.downloadViews = new HashMap();
            this.downloadBars = new HashMap();
            this.mainWindow = new Shell(this.display, 3280);
            this.mainWindow.setText("Azureus");
            Utils.setShellIcon(this.mainWindow);
            ShellManager.sharedManager().addWindow(this.mainWindow);
            this.mainMenu = new MainMenu(this);
            try {
                this.createDropTarget((Control)this.mainWindow);
            }
            catch (Throwable e) {
                Logger.log(new LogEvent(LOGID, "Drag and Drop not available", e));
            }
            FormLayout mainLayout = new FormLayout();
            mainLayout.marginHeight = 0;
            mainLayout.marginWidth = 0;
            try {
                mainLayout.spacing = 0;
            }
            catch (NoSuchFieldError e) {
                // empty catch block
            }
            this.mainWindow.setLayout((Layout)mainLayout);
            Label separator = new Label((Composite)this.mainWindow, 258);
            FormData formData = new FormData();
            formData.top = new FormAttachment(0, 0);
            formData.left = new FormAttachment(0, 0);
            formData.right = new FormAttachment(100, 0);
            separator.setLayoutData((Object)formData);
            this.iconBar = new IconBar((Composite)this.mainWindow);
            this.iconBar.setCurrentEnabler(this);
            formData = new FormData();
            formData.top = new FormAttachment((Control)separator);
            formData.left = new FormAttachment(0, 0);
            formData.right = new FormAttachment(100, 0);
            this.iconBar.setLayoutData(formData);
            separator = new Label((Composite)this.mainWindow, 258);
            formData = new FormData();
            formData.top = new FormAttachment((Control)this.iconBar.getCoolBar());
            formData.left = new FormAttachment(0, 0);
            formData.right = new FormAttachment(100, 0);
            separator.setLayoutData((Object)formData);
            if (!this.useCustomTab) {
                this.folder = new TabFolder((Composite)this.mainWindow, 512);
            } else {
                this.folder = new CTabFolder((Composite)this.mainWindow, 0x800040);
                final Color bg = ColorUtils.getShade(this.folder.getBackground(), Constants.isOSX ? -25 : -6);
                final Color fg = ColorUtils.getShade(this.folder.getForeground(), Constants.isOSX ? 25 : 6);
                this.folder.setBackground(bg);
                this.folder.setForeground(fg);
                ((CTabFolder)this.folder).setBorderVisible(false);
                this.folder.addDisposeListener(new DisposeListener(){

                    public void widgetDisposed(DisposeEvent event) {
                        bg.dispose();
                        fg.dispose();
                    }
                });
            }
            Tab.setFolder(this.folder);
            this.folder.getDisplay().addFilter(1, new Listener(){

                public void handleEvent(Event event) {
                    Control focus_control = MainWindow.this.display.getFocusControl();
                    if (focus_control != null && focus_control.getShell() != MainWindow.this.mainWindow) {
                        return;
                    }
                    int key = event.character;
                    if ((event.stateMask & SWT.MOD1) != 0 && event.character <= '\u001a' && event.character > '\u0000') {
                        key += 96;
                    }
                    if (key == 27 || event.keyCode == 0x100000D && event.stateMask == 262144) {
                        Tab.closeCurrent();
                        event.doit = false;
                    } else if (event.keyCode == 0x100000F || event.character == '\t' && (event.stateMask & 0x40000) != 0) {
                        if ((event.stateMask & 0x20000) == 0) {
                            event.doit = false;
                            Tab.selectNextTab(true);
                        } else if (event.stateMask == 131072) {
                            Tab.selectNextTab(false);
                            event.doit = false;
                        }
                    } else if (key == 108 && (event.stateMask & SWT.MOD1) != 0) {
                        OpenTorrentWindow.invokeURLPopup(MainWindow.this.mainWindow, MainWindow.this.globalManager);
                        event.doit = false;
                    }
                }
            });
            SelectionAdapter selectionAdapter = new SelectionAdapter(){

                public void widgetSelected(SelectionEvent event) {
                    if (MainWindow.this.display != null && !MainWindow.this.display.isDisposed()) {
                        Utils.execSWTThread(new AERunnable(this, event){
                            private final /* synthetic */ SelectionEvent val$event;
                            private final /* synthetic */ 3 this$1;
                            {
                                this.this$1 = this$1;
                                this.val$event = val$event;
                            }

                            public void runSupport() {
                                CTabItem item;
                                if (MainWindow.access$300(3.access$200(this.this$1)) && (item = (CTabItem)this.val$event.item) != null && !item.isDisposed() && !MainWindow.access$400(3.access$200(this.this$1)).isDisposed()) {
                                    try {
                                        ((CTabFolder)MainWindow.access$400(3.access$200(this.this$1))).setSelection(item);
                                        Control control = item.getControl();
                                        if (control != null) {
                                            control.setVisible(true);
                                            control.setFocus();
                                        }
                                    }
                                    catch (Throwable e) {
                                        Debug.printStackTrace(e);
                                    }
                                }
                                MainWindow.access$500(3.access$200(this.this$1)).setCurrentEnabler(3.access$200(this.this$1));
                            }
                        });
                    }
                }

                static /* synthetic */ MainWindow access$200(3 x0) {
                    return x0.MainWindow.this;
                }
            };
            if (!this.useCustomTab) {
                ((TabFolder)this.folder).addSelectionListener((SelectionListener)selectionAdapter);
            } else {
                try {
                    ((CTabFolder)this.folder).setMinimumCharacters(75);
                }
                catch (Exception e) {
                    Logger.log(new LogEvent(LOGID, "Can't set MIN_TAB_WIDTH", e));
                }
                ((CTabFolder)this.folder).addCTabFolderListener((CTabFolderListener)new CTabFolderAdapter(){

                    public void itemClosed(CTabFolderEvent event) {
                        Tab.closed((Item)((CTabItem)event.item));
                        event.doit = true;
                        ((CTabItem)event.item).dispose();
                    }
                });
                ((CTabFolder)this.folder).addSelectionListener((SelectionListener)selectionAdapter);
                try {
                    ((CTabFolder)this.folder).setSelectionBackground(new Color[]{this.display.getSystemColor(25), this.display.getSystemColor(25), this.display.getSystemColor(22)}, new int[]{10, 90}, true);
                }
                catch (NoSuchMethodError e) {
                    ((CTabFolder)this.folder).setSelectionBackground(new Color[]{this.display.getSystemColor(25)}, new int[0]);
                }
                ((CTabFolder)this.folder).setSelectionForeground(this.display.getSystemColor(24));
                try {
                    ((CTabFolder)this.folder).setSimple(!COConfigurationManager.getBooleanParameter("GUI_SWT_bFancyTab"));
                }
                catch (NoSuchMethodError e) {
                    // empty catch block
                }
            }
            int borderFlag = Constants.isOSX ? 0 : 4;
            this.statusBar = new Composite((Composite)this.mainWindow, 0);
            formData = new FormData();
            formData.top = new FormAttachment((Control)separator);
            formData.bottom = new FormAttachment((Control)this.statusBar);
            formData.left = new FormAttachment(0, 0);
            formData.right = new FormAttachment(100, 0);
            this.folder.setLayoutData((Object)formData);
            GridLayout layout_status = new GridLayout();
            layout_status.numColumns = 7;
            layout_status.horizontalSpacing = 0;
            layout_status.verticalSpacing = 0;
            layout_status.marginHeight = 0;
            if (Constants.isOSX) {
                try {
                    layout_status.marginRight = 15;
                }
                catch (NoSuchFieldError e) {
                    layout_status.marginWidth = 15;
                }
            } else {
                layout_status.marginWidth = 0;
            }
            this.statusBar.setLayout((Layout)layout_status);
            this.statusArea = new Composite(this.statusBar, 0);
            GridData gridData = new GridData(1808);
            this.statusArea.setLayoutData((Object)gridData);
            this.layoutStatusArea = new StackLayout();
            this.statusArea.setLayout((Layout)this.layoutStatusArea);
            this.statusText = new CLabel(this.statusArea, borderFlag);
            gridData = new GridData(784);
            this.statusText.setLayoutData((Object)gridData);
            int imageHeight = ImageRepository.getImage((String)STATUS_ICON_WARN).getBounds().height;
            GC gc = new GC((Drawable)this.statusText);
            int height = Math.max(imageHeight, gc.getFontMetrics().getHeight()) + 6;
            gc.dispose();
            formData = new FormData();
            formData.height = height;
            formData.bottom = new FormAttachment(100, 0);
            formData.left = new FormAttachment(0, 0);
            formData.right = new FormAttachment(100, 0);
            this.statusBar.setLayoutData((Object)formData);
            Listener listener = new Listener(){

                public void handleEvent(Event e) {
                    if (MainWindow.this.updateWindow != null) {
                        MainWindow.this.updateWindow.show();
                    }
                }
            };
            this.statusText.addListener(4, listener);
            this.statusText.addListener(8, listener);
            this.statusUpdate = new Composite(this.statusArea, 0);
            gridData = new GridData(784);
            this.statusUpdate.setLayoutData((Object)gridData);
            GridLayout layoutStatusUpdate = new GridLayout(2, false);
            layoutStatusUpdate.marginHeight = 0;
            layoutStatusUpdate.marginWidth = 0;
            this.statusUpdate.setLayout((Layout)layoutStatusUpdate);
            this.statusUpdateLabel = new Label(this.statusUpdate, 0);
            gridData = new GridData(256);
            this.statusUpdateLabel.setLayoutData((Object)gridData);
            Messages.setLanguageText((Widget)this.statusUpdateLabel, "MainWindow.statusText.checking");
            Messages.setLanguageText((Widget)this.statusUpdateLabel, "MainWindow.status.update.tooltip");
            this.statusUpdateLabel.addMouseListener((MouseListener)new MouseAdapter(){

                public void mouseDoubleClick(MouseEvent arg0) {
                    MainWindow.this.showUpdateProgressWindow();
                }
            });
            int progressFlag = Constants.isOSX ? 2 : 256;
            this.statusUpdateProgressBar = new ProgressBar(this.statusUpdate, progressFlag);
            gridData = new GridData(1808);
            this.statusUpdateProgressBar.setLayoutData((Object)gridData);
            Messages.setLanguageText((Widget)this.statusUpdateProgressBar, "MainWindow.status.update.tooltip");
            this.statusUpdateProgressBar.addMouseListener((MouseListener)new MouseAdapter(){

                public void mouseDoubleClick(MouseEvent arg0) {
                    MainWindow.this.showUpdateProgressWindow();
                }
            });
            this.layoutStatusArea.topControl = this.statusText;
            this.statusBar.layout();
            this.srStatus = new CLabelPadding(this.statusBar, borderFlag);
            this.srStatus.setText(MessageText.getString("SpeedView.stats.ratio"));
            COConfigurationManager.addAndFireParameterListener("Status Area Show SR", new ParameterListener(){

                public void parameterChanged(String parameterName) {
                    MainWindow.this.srStatus.setVisible(COConfigurationManager.getBooleanParameter(parameterName, true));
                    MainWindow.this.statusBar.layout();
                }
            });
            this.natStatus = new CLabelPadding(this.statusBar, borderFlag);
            this.natStatus.setText("");
            COConfigurationManager.addAndFireParameterListener("Status Area Show NAT", new ParameterListener(){

                public void parameterChanged(String parameterName) {
                    MainWindow.this.natStatus.setVisible(COConfigurationManager.getBooleanParameter(parameterName, true));
                    MainWindow.this.statusBar.layout();
                }
            });
            this.dhtStatus = new CLabelPadding(this.statusBar, borderFlag);
            this.dhtStatus.setText("");
            this.dhtStatus.setToolTipText(MessageText.getString("MainWindow.dht.status.tooltip"));
            COConfigurationManager.addAndFireParameterListener("Status Area Show DDB", new ParameterListener(){

                public void parameterChanged(String parameterName) {
                    MainWindow.this.dhtStatus.setVisible(COConfigurationManager.getBooleanParameter(parameterName, true));
                    MainWindow.this.statusBar.layout();
                }
            });
            this.ipBlocked = new CLabelPadding(this.statusBar, borderFlag);
            this.ipBlocked.setText("{} IPs:");
            Messages.setLanguageText((Widget)this.ipBlocked, "MainWindow.IPs.tooltip");
            this.ipBlocked.addMouseListener((MouseListener)new MouseAdapter(){

                public void mouseDoubleClick(MouseEvent arg0) {
                    BlockedIpsWindow.showBlockedIps(MainWindow.this.azureus_core, MainWindow.this.mainWindow);
                }
            });
            this.statusDown = new CLabelPadding(this.statusBar, borderFlag);
            this.statusDown.setImage(ImageRepository.getImage("down"));
            this.statusDown.setText("n/a");
            Messages.setLanguageText((Widget)this.statusDown, "MainWindow.status.updowndetails.tooltip");
            Listener lStats = new Listener(){

                public void handleEvent(Event e) {
                    MainWindow.this.showStats();
                }
            };
            this.statusUp = new CLabelPadding(this.statusBar, borderFlag);
            this.statusUp.setImage(ImageRepository.getImage("up"));
            this.statusUp.setText("n/a");
            Messages.setLanguageText((Widget)this.statusUp, "MainWindow.status.updowndetails.tooltip");
            this.statusDown.addListener(8, lStats);
            this.statusUp.addListener(8, lStats);
            Listener lDHT = new Listener(){

                public void handleEvent(Event e) {
                    MainWindow.this.showStats();
                    ((StatsView)MainWindow.this.stats_tab.getView()).showDHT();
                }
            };
            this.dhtStatus.addListener(8, lDHT);
            Listener lSR = new Listener(){

                public void handleEvent(Event e) {
                    MainWindow.this.showStats();
                    ((StatsView)MainWindow.this.stats_tab.getView()).showTransfers();
                    OverallStats stats = StatsFactory.getStats();
                    long ratio = 1000L * stats.getUploadedBytes() / (stats.getDownloadedBytes() + 1L);
                    if (ratio < 900L) {
                        Utils.openURL("http://azureus.aelitis.com/wiki/index.php/Share_Ratio");
                    }
                }
            };
            this.srStatus.addListener(8, lSR);
            Listener lNAT = new Listener(){

                public void handleEvent(Event e) {
                    MainWindow.this.showConfig();
                    MainWindow.this.config_view.selectSection(class$org$gudy$azureus2$ui$swt$views$configsections$ConfigSectionConnection == null ? (class$org$gudy$azureus2$ui$swt$views$configsections$ConfigSectionConnection = MainWindow.class$("org.gudy.azureus2.ui.swt.views.configsections.ConfigSectionConnection")) : class$org$gudy$azureus2$ui$swt$views$configsections$ConfigSectionConnection);
                    if (MainWindow.this.azureus_core.getPluginManager().getDefaultPluginInterface().getConnectionManager().getNATStatus() != 1) {
                        Utils.openURL("http://azureus.aelitis.com/wiki/index.php/NAT_problem");
                    }
                }
            };
            this.natStatus.addListener(8, lNAT);
            final Menu menuUpSpeed = new Menu((Decorations)this.mainWindow, 8);
            menuUpSpeed.addListener(22, new Listener(){

                public void handleEvent(Event e) {
                    MenuItem[] items = menuUpSpeed.getItems();
                    for (int i = 0; i < items.length; ++i) {
                        items[i].dispose();
                    }
                    String config_param = TransferSpeedValidator.getActiveUploadParameter(MainWindow.this.globalManager);
                    int upLimit = COConfigurationManager.getIntParameter(config_param, 0);
                    MenuItem item = new MenuItem(menuUpSpeed, 16);
                    item.setText(MessageText.getString("ConfigView.unlimited"));
                    item.addListener(13, new Listener(this, config_param){
                        private final /* synthetic */ String val$config_param;
                        private final /* synthetic */ 17 this$1;
                        {
                            this.this$1 = this$1;
                            this.val$config_param = val$config_param;
                        }

                        public void handleEvent(Event e) {
                            COConfigurationManager.setParameter(this.val$config_param, 0);
                            COConfigurationManager.save();
                        }
                    });
                    if (upLimit == 0) {
                        item.setSelection(true);
                    }
                    Listener speedChangeListener = new Listener(this, config_param){
                        private final /* synthetic */ String val$config_param;
                        private final /* synthetic */ 17 this$1;
                        {
                            this.this$1 = this$1;
                            this.val$config_param = val$config_param;
                        }

                        public void handleEvent(Event e) {
                            int iSpeed = (Integer)new TransferSpeedValidator(this.val$config_param, ((MenuItem)e.widget).getData("speed")).getValue();
                            COConfigurationManager.setParameter(this.val$config_param, iSpeed);
                            COConfigurationManager.save();
                        }
                    };
                    int iRel = 0;
                    for (int i = 0; i < 12; ++i) {
                        int[] iAboveBelow = iRel == 0 ? new int[]{upLimit} : new int[]{upLimit - iRel, upLimit + iRel};
                        for (int j = 0; j < iAboveBelow.length; ++j) {
                            if (iAboveBelow[j] < 5) continue;
                            item = new MenuItem(menuUpSpeed, 16, j == 0 ? 1 : menuUpSpeed.getItemCount());
                            item.setText(DisplayFormatters.formatByteCountToKiBEtcPerSec(iAboveBelow[j] * 1024, true));
                            item.setData("speed", (Object)new Long(iAboveBelow[j]));
                            item.addListener(13, speedChangeListener);
                            if (upLimit != iAboveBelow[j]) continue;
                            item.setSelection(true);
                        }
                        iRel += iRel >= 50 ? 50 : (iRel >= 10 ? 10 : (iRel >= 5 ? 5 : (iRel >= 2 ? 3 : 1)));
                    }
                }
            });
            this.statusUp.setMenu(menuUpSpeed);
            final Menu menuDownSpeed = new Menu((Decorations)this.mainWindow, 8);
            menuDownSpeed.addListener(22, new Listener(){

                public void handleEvent(Event e) {
                    boolean unlim;
                    MenuItem[] items = menuDownSpeed.getItems();
                    for (int i = 0; i < items.length; ++i) {
                        items[i].dispose();
                    }
                    int downLimit = COConfigurationManager.getIntParameter("Max Download Speed KBs", 0);
                    boolean bl = unlim = downLimit == 0;
                    if (downLimit == 0) {
                        downLimit = 275;
                    }
                    MenuItem item = new MenuItem(menuDownSpeed, 16);
                    item.setText(MessageText.getString("ConfigView.unlimited"));
                    item.addListener(13, new Listener(this){
                        private final /* synthetic */ 20 this$1;
                        {
                            this.this$1 = this$1;
                        }

                        public void handleEvent(Event e) {
                            COConfigurationManager.setParameter("Max Download Speed KBs", (Integer)new TransferSpeedValidator("Max Download Speed KBs", new Integer(0)).getValue());
                            COConfigurationManager.save();
                        }
                    });
                    if (unlim) {
                        item.setSelection(true);
                    }
                    Listener speedChangeListener = new Listener(this){
                        private final /* synthetic */ 20 this$1;
                        {
                            this.this$1 = this$1;
                        }

                        public void handleEvent(Event e) {
                            int iSpeed = (Integer)new TransferSpeedValidator("Max Download Speed KBs", ((MenuItem)e.widget).getData("speed")).getValue();
                            COConfigurationManager.setParameter("Max Download Speed KBs", iSpeed);
                            COConfigurationManager.save();
                        }
                    };
                    int iRel = 0;
                    for (int i = 0; i < 12; ++i) {
                        int[] iAboveBelow = iRel == 0 ? new int[]{downLimit} : new int[]{downLimit - iRel, downLimit + iRel};
                        for (int j = 0; j < iAboveBelow.length; ++j) {
                            if (iAboveBelow[j] < 5) continue;
                            item = new MenuItem(menuDownSpeed, 16, j == 0 ? 1 : menuDownSpeed.getItemCount());
                            item.setText(DisplayFormatters.formatByteCountToKiBEtcPerSec(iAboveBelow[j] * 1024, true));
                            item.setData("speed", (Object)new Long(iAboveBelow[j]));
                            item.addListener(13, speedChangeListener);
                            item.setSelection(!unlim && downLimit == iAboveBelow[j]);
                        }
                        iRel += iRel >= 50 ? 50 : (iRel >= 10 ? 10 : (iRel >= 5 ? 5 : (iRel >= 2 ? 3 : 1)));
                    }
                }
            });
            this.statusDown.setMenu(menuDownSpeed);
            if (Logger.isEnabled()) {
                Logger.log(new LogEvent(LOGID, "Initializing GUI complete"));
            }
            this.globalManager.addListener(this);
            Utils.linkShellMetricsToConfig(this.mainWindow, "window");
            this.mainWindow.addDisposeListener(new DisposeListener(){

                public void widgetDisposed(DisposeEvent event) {
                    if (!isAlreadyDead) {
                        isDisposeFromListener = true;
                        if (MainWindow.this.mainWindow != null) {
                            MainWindow.this.mainWindow.removeDisposeListener((DisposeListener)this);
                            MainWindow.this.dispose(false, false);
                        }
                        isAlreadyDead = true;
                    }
                }
            });
            this.mainWindow.layout();
            this.mainWindow.addShellListener((ShellListener)new ShellAdapter(){

                public void shellClosed(ShellEvent event) {
                    if (MainWindow.this.systemTraySWT != null && COConfigurationManager.getBooleanParameter("Enable System Tray") && COConfigurationManager.getBooleanParameter("Close To Tray", true)) {
                        MainWindow.this.minimizeToTray(event);
                    } else {
                        event.doit = MainWindow.this.dispose(false, false);
                    }
                }

                public void shellIconified(ShellEvent event) {
                    if (MainWindow.this.systemTraySWT != null && COConfigurationManager.getBooleanParameter("Enable System Tray") && COConfigurationManager.getBooleanParameter("Minimize To Tray", false)) {
                        MainWindow.this.minimizeToTray(event);
                    }
                }
            });
            this.mainWindow.addListener(20, new Listener(){

                public void handleEvent(Event e) {
                    if (Constants.isOSX && COConfigurationManager.getBooleanParameter("Password enabled", false)) {
                        e.doit = false;
                        MainWindow.this.mainWindow.setVisible(false);
                        PasswordWindow.showPasswordWindow(MainWindow.this.display);
                    }
                }
            });
        }
        catch (Throwable e) {
            System.out.println("Initialize Error");
            Debug.printStackTrace(e);
        }
    }

    private void openMainWindow() {
        this.uiSWTInstanceImpl = new UISWTInstanceImpl(this.azureus_core);
        new ProgressWindow();
        this.addUpdateListener();
        if (this.azureus_core.getTrackerHost().getTorrents().length > 0) {
            this.showMyTracker();
        }
        this.showMyTorrents();
        if (COConfigurationManager.getBooleanParameter("Open Console", false)) {
            this.showConsole();
        }
        this.events = null;
        if (COConfigurationManager.getBooleanParameter("Open Config", false)) {
            this.showConfig();
        }
        if (COConfigurationManager.getBooleanParameter("Open Stats On Start", false)) {
            this.showStats();
        }
        this.mainWindow.open();
        if (!Constants.isOSX) {
            this.mainWindow.forceActive();
        }
        this.updater = new GUIUpdater(this.azureus_core, this);
        this.updater.start();
        if (COConfigurationManager.getBooleanParameter("Enable System Tray")) {
            try {
                this.systemTraySWT = new SystemTraySWT(this);
            }
            catch (Throwable e) {
                Logger.log(new LogEvent(LOGID, 3, "Upgrade to SWT3.0M8 or later for system tray support."));
            }
            if (COConfigurationManager.getBooleanParameter("Start Minimized", false)) {
                this.minimizeToTray(null);
            } else if (COConfigurationManager.getBooleanParameter("Password enabled", false)) {
                this.minimizeToTray(null);
                PasswordWindow.showPasswordWindow(this.display);
            }
        }
        this.azureus_core.getPluginManager().firePluginEvent(1);
        if (!COConfigurationManager.getBooleanParameter("Wizard Completed", false)) {
            ConfigureWizard wizard = new ConfigureWizard(this.getAzureusCore(), this.display);
            wizard.addListener(new WizardListener(){

                public void closed() {
                    MainWindow.this.azureus_core.getPluginManager().firePluginEvent(2);
                }
            });
        } else {
            this.azureus_core.getPluginManager().firePluginEvent(2);
        }
        if (COConfigurationManager.getBooleanParameter("Show Download Basket", false)) {
            if (this.tray == null) {
                this.tray = new TrayWindow(this);
            }
            this.tray.setVisible(true);
        }
        COConfigurationManager.addParameterListener("Show Download Basket", this);
        COConfigurationManager.addParameterListener("GUI_SWT_bFancyTab", this);
        this.checkForWhatsNewWindow();
        DonationWindow2.checkForDonationPopup();
    }

    public void showMyTracker() {
        if (this.my_tracker_tab == null) {
            this.my_tracker_tab = new Tab(new MyTrackerView(this.azureus_core));
        } else {
            this.my_tracker_tab.setFocus();
            this.refreshIconBar();
        }
    }

    public void showMyShares() {
        if (this.my_shares_tab == null) {
            this.my_shares_tab = new Tab(new MySharesView(this.azureus_core));
        } else {
            this.my_shares_tab.setFocus();
            this.refreshIconBar();
        }
    }

    public void showMyTorrents() {
        if (this.mytorrents == null) {
            this.mytorrents = new Tab(new MyTorrentsSuperView(this.azureus_core));
        } else {
            this.mytorrents.setFocus();
        }
        this.refreshIconBar();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void minimizeToTray(ShellEvent event) {
        if (event != null) {
            event.doit = false;
        }
        if (Constants.isOSX) {
            this.mainWindow.setMinimized(true);
        } else {
            this.mainWindow.setVisible(false);
        }
        if (this.tray != null) {
            this.tray.setVisible(true);
        }
        try {
            this.downloadBars_mon.enter();
            Iterator iter = this.downloadBars.values().iterator();
            while (iter.hasNext()) {
                MinimizedWindow mw = (MinimizedWindow)iter.next();
                mw.setVisible(true);
            }
        }
        finally {
            this.downloadBars_mon.exit();
        }
    }

    public void setStatusText(String keyedSentence) {
        this.statusTextKey = keyedSentence == null ? "" : keyedSentence;
        this.statusImageKey = null;
        if (this.statusTextKey.length() == 0) {
            if (Constants.isCVSVersion()) {
                this.statusTextKey = "MainWindow.status.unofficialversion (2.3.0.7_B51)";
                this.statusImageKey = STATUS_ICON_WARN;
            } else if (!Constants.isOSX) {
                this.statusTextKey = "Azureus 2.3.0.7_B51";
            }
        }
        this.updateStatusText();
    }

    private void updateStatusText() {
        if (this.display == null || this.display.isDisposed()) {
            return;
        }
        final String text = this.updateWindow != null ? "MainWindow.updateavail" : this.statusTextKey;
        Utils.execSWTThread(new AERunnable(){

            public void runSupport() {
                if (MainWindow.this.statusText != null && !MainWindow.this.statusText.isDisposed()) {
                    MainWindow.this.statusText.setText(MessageText.getStringForSentence(text));
                    MainWindow.this.statusText.setImage(MainWindow.this.statusImageKey == null ? null : ImageRepository.getImage(MainWindow.this.statusImageKey));
                }
            }
        });
    }

    private void updateComponents() {
        if (this.statusText != null) {
            this.statusText.update();
        }
        if (this.folder != null) {
            if (this.useCustomTab) {
                ((CTabFolder)this.folder).update();
            } else {
                ((TabFolder)this.folder).update();
            }
        }
    }

    public void closeDownloadBars() {
        Utils.execSWTThread(new AERunnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void runSupport() {
                if (MainWindow.this.display == null || MainWindow.this.display.isDisposed()) {
                    return;
                }
                try {
                    MainWindow.this.downloadBars_mon.enter();
                    Iterator iter = MainWindow.this.downloadBars.keySet().iterator();
                    while (iter.hasNext()) {
                        DownloadManager dm = (DownloadManager)iter.next();
                        MinimizedWindow mw = (MinimizedWindow)MainWindow.this.downloadBars.get(dm);
                        mw.close();
                        iter.remove();
                    }
                }
                finally {
                    MainWindow.this.downloadBars_mon.exit();
                }
            }
        });
    }

    private void createDropTarget(Control control) {
        DropTarget dropTarget = new DropTarget(control, 23);
        dropTarget.setTransfer(new Transfer[]{URLTransfer.getInstance(), FileTransfer.getInstance()});
        dropTarget.addDropListener((DropTargetListener)new DropTargetAdapter(){

            public void dragOver(DropTargetEvent event) {
                if (URLTransfer.getInstance().isSupportedType(event.currentDataType)) {
                    event.detail = 4;
                }
            }

            public void drop(DropTargetEvent event) {
                TorrentOpener.openDroppedTorrents(MainWindow.this.azureus_core, event);
            }
        });
    }

    public void destroyRequest() {
        Logger.log(new LogEvent(LOGID, "MainWindow::destroyRequest"));
        if (COConfigurationManager.getBooleanParameter("Password enabled", false)) {
            Logger.log(new LogEvent(LOGID, "    denied - password is enabled"));
            return;
        }
        Utils.execSWTThread(new Runnable(){

            public void run() {
                MainWindow.this.dispose(false, false);
            }
        });
    }

    public void destroyed() {
    }

    public void destroyInitiated() {
    }

    public void seedingStatusChanged(boolean seeding_only_mode) {
    }

    public void downloadManagerAdded(DownloadManager created) {
        DonationWindow2.checkForDonationPopup();
        created.addListener(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void openManagerView(DownloadManager downloadManager) {
        try {
            this.downloadViews_mon.enter();
            if (this.downloadViews.containsKey(downloadManager)) {
                Tab tab = (Tab)this.downloadViews.get(downloadManager);
                tab.setFocus();
                this.refreshIconBar();
            } else {
                Tab tab = new Tab(new ManagerView(this.azureus_core, downloadManager));
                this.downloadViews.put(downloadManager, tab);
            }
        }
        finally {
            this.downloadViews_mon.exit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeManagerView(DownloadManager downloadManager) {
        try {
            this.downloadViews_mon.enter();
            this.downloadViews.remove(downloadManager);
        }
        finally {
            this.downloadViews_mon.exit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void downloadManagerRemoved(DownloadManager removed) {
        try {
            this.downloadViews_mon.enter();
            if (this.downloadViews.containsKey(removed)) {
                final Tab tab = (Tab)this.downloadViews.get(removed);
                Utils.execSWTThread(new AERunnable(){

                    public void runSupport() {
                        if (MainWindow.this.display == null || MainWindow.this.display.isDisposed()) {
                            return;
                        }
                        tab.dispose();
                    }
                });
            }
        }
        finally {
            this.downloadViews_mon.exit();
        }
    }

    public Display getDisplay() {
        return this.display;
    }

    public Shell getShell() {
        return this.mainWindow;
    }

    public void setVisible(boolean visible) {
        this.mainWindow.setVisible(visible);
        if (visible) {
            if (this.tray != null) {
                this.tray.setVisible(false);
            }
            this.mainWindow.forceActive();
            this.mainWindow.setMinimized(false);
        }
    }

    public boolean isVisible() {
        return this.mainWindow.isVisible();
    }

    public boolean dispose(boolean for_restart, boolean close_already_in_progress) {
        if (COConfigurationManager.getBooleanParameter("confirmationOnExit", false) && !this.getExitConfirmation(for_restart)) {
            return false;
        }
        if (this.systemTraySWT != null) {
            this.systemTraySWT.dispose();
        }
        Tab.closeAllTabs();
        isAlreadyDead = true;
        if (this.updater != null) {
            this.updater.stopIt();
        }
        this.initializer.stopIt(for_restart, close_already_in_progress);
        if (!this.mainWindow.isDisposed() && !isDisposeFromListener) {
            this.mainWindow.dispose();
        }
        COConfigurationManager.removeParameterListener("config.style.useSIUnits", this);
        COConfigurationManager.removeParameterListener("Show Download Basket", this);
        COConfigurationManager.removeParameterListener("GUI_SWT_bFancyTab", this);
        if (SystemProperties.isJavaWebStartInstance()) {
            AEThread close = new AEThread("JWS Force Terminate"){

                public void runSupport() {
                    try {
                        Thread.sleep(2500L);
                    }
                    catch (Throwable e) {
                        Debug.printStackTrace(e);
                    }
                    SESecurityManager.exitVM(1);
                }
            };
            close.setDaemon(true);
            close.start();
        }
        return true;
    }

    private boolean getExitConfirmation(boolean for_restart) {
        MessageBox mb = new MessageBox(this.mainWindow, 200);
        mb.setText(MessageText.getString(for_restart ? "MainWindow.dialog.restartconfirmation.title" : "MainWindow.dialog.exitconfirmation.title"));
        mb.setMessage(MessageText.getString(for_restart ? "MainWindow.dialog.restartconfirmation.text" : "MainWindow.dialog.exitconfirmation.text"));
        return mb.open() == 64;
    }

    public GlobalManager getGlobalManager() {
        return this.globalManager;
    }

    public Tab getConsole() {
        return this.console;
    }

    public Tab getMytorrents() {
        return this.mytorrents;
    }

    public Tab getMyTracker() {
        return this.my_tracker_tab;
    }

    public void setConsole(Tab tab) {
        this.console = tab;
    }

    public void setMytorrents(Tab tab) {
        this.mytorrents = tab;
    }

    public void setMyTracker(Tab tab) {
        this.my_tracker_tab = tab;
    }

    public void setMyShares(Tab tab) {
        this.my_shares_tab = tab;
    }

    public static MainWindow getWindow() {
        return window;
    }

    public HashMap getDownloadBars() {
        return this.downloadBars;
    }

    public void clearConfig() {
        this.config = null;
        this.config_view = null;
    }

    public void clearStats() {
        this.stats_tab = null;
    }

    public TrayWindow getTray() {
        return this.tray;
    }

    public boolean isUseCustomTab() {
        return this.useCustomTab;
    }

    public void openPluginView(PluginView view) {
        this.openPluginView(view, view.getPluginViewName());
    }

    public void openPluginView(UISWTPluginView view) {
        this.openPluginView(view, view.getPluginViewName());
    }

    public void openPluginView(String sParentID, String sViewID, UISWTViewEventListener l, Object dataSource, boolean bSetFocus) {
        UISWTViewImpl view = null;
        try {
            view = new UISWTViewImpl(sParentID, sViewID, l);
        }
        catch (Exception e) {
            Tab tab = (Tab)this.pluginTabs.get(sViewID);
            if (tab != null) {
                tab.setFocus();
            }
            return;
        }
        view.dataSourceChanged(dataSource);
        Tab tab = new Tab(view, bSetFocus);
        this.pluginTabs.put(sViewID, tab);
    }

    /*
     * WARNING - void declaration
     */
    public void closePluginViews(String sViewID) {
        void var2_2;
        CTabItem[] items;
        if (this.folder instanceof CTabFolder) {
            items = ((CTabFolder)this.folder).getItems();
        } else if (this.folder instanceof TabFolder) {
            items = ((TabFolder)this.folder).getItems();
        } else {
            return;
        }
        for (int i = 0; i < ((void)var2_2).length; ++i) {
            String sID;
            IView view = Tab.getView((Item)var2_2[i]);
            if (!(view instanceof UISWTViewImpl) || (sID = ((UISWTViewImpl)view).getViewID()) == null || !sID.equals(sViewID)) continue;
            try {
                this.closePluginView(view);
                continue;
            }
            catch (Exception e) {
                Debug.printStackTrace(e);
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    public UISWTView[] getPluginViews() {
        void var1_1;
        CTabItem[] items;
        if (this.folder instanceof CTabFolder) {
            items = ((CTabFolder)this.folder).getItems();
        } else if (this.folder instanceof TabFolder) {
            items = ((TabFolder)this.folder).getItems();
        } else {
            return new UISWTView[0];
        }
        ArrayList<IView> views = new ArrayList<IView>();
        for (int i = 0; i < ((void)var1_1).length; ++i) {
            IView view = Tab.getView((Item)var1_1[i]);
            if (!(view instanceof UISWTViewImpl)) continue;
            views.add(view);
        }
        return views.toArray(new UISWTView[0]);
    }

    protected void openPluginView(AbstractIView view, String name) {
        Tab tab = (Tab)this.pluginTabs.get(name);
        if (tab != null) {
            tab.setFocus();
        } else {
            tab = new Tab(view);
            this.pluginTabs.put(name, tab);
        }
    }

    public void closePluginView(IView view) {
        Item tab = Tab.getTab(view);
        if (tab != null) {
            Tab.closed(tab);
        }
    }

    public void removeActivePluginView(String view_name) {
        this.pluginTabs.remove(view_name);
    }

    public void parameterChanged(String parameterName) {
        if (parameterName.equals("Show Download Basket")) {
            if (COConfigurationManager.getBooleanParameter("Show Download Basket")) {
                if (this.tray == null) {
                    this.tray = new TrayWindow(this);
                    this.tray.setVisible(true);
                }
            } else if (this.tray != null) {
                this.tray.setVisible(false);
                this.tray = null;
            }
        }
        if (parameterName.equals("GUI_SWT_bFancyTab") && this.folder instanceof CTabFolder && this.folder != null && !this.folder.isDisposed()) {
            try {
                ((CTabFolder)this.folder).setSimple(!COConfigurationManager.getBooleanParameter("GUI_SWT_bFancyTab"));
            }
            catch (NoSuchMethodError noSuchMethodError) {
                // empty catch block
            }
        }
        if (parameterName.equals("config.style.useSIUnits")) {
            this.updateComponents();
        }
    }

    public boolean isEnabled(String itemKey) {
        if (itemKey.equals("open")) {
            return true;
        }
        if (itemKey.equals("new")) {
            return true;
        }
        IView currentView = this.getCurrentView();
        if (currentView != null) {
            return currentView.isEnabled(itemKey);
        }
        return false;
    }

    public boolean isSelected(String itemKey) {
        return false;
    }

    public void itemActivated(String itemKey) {
        if (itemKey.equals("open")) {
            TorrentOpener.openTorrentWindow();
            return;
        }
        if (itemKey.equals("new")) {
            new NewTorrentWizard(this.getAzureusCore(), this.display);
            return;
        }
        IView currentView = this.getCurrentView();
        if (currentView != null) {
            currentView.itemActivated(itemKey);
        }
    }

    IView getCurrentView() {
        try {
            if (!this.useCustomTab) {
                TabItem[] selection = ((TabFolder)this.folder).getSelection();
                if (selection.length > 0) {
                    return Tab.getView((Item)selection[0]);
                }
                return null;
            }
            return Tab.getView((Item)((CTabFolder)this.folder).getSelection());
        }
        catch (Exception e) {
            return null;
        }
    }

    public void refreshIconBar() {
        this.iconBar.setCurrentEnabler(this);
    }

    public void close() {
        this.getShell().close();
    }

    public void closeViewOrWindow() {
        if (this.getCurrentView() != null) {
            Tab.closeCurrent();
        } else {
            this.close();
        }
    }

    public void showConfig() {
        if (this.config == null) {
            this.config_view = new ConfigView(this.azureus_core);
            this.config = new Tab(this.config_view);
        } else {
            this.config.setFocus();
        }
    }

    public boolean showConfig(String id) {
        if (this.config == null) {
            this.config_view = new ConfigView(this.azureus_core);
            this.config = new Tab(this.config_view);
        } else {
            this.config.setFocus();
        }
        return this.config_view.selectSection(id);
    }

    public void showConsole() {
        if (this.console == null) {
            this.console = new Tab(new LoggerView(this.events));
        } else {
            this.console.setFocus();
        }
    }

    public void showStats() {
        if (this.stats_tab == null) {
            this.stats_tab = new Tab(new StatsView(this.globalManager));
        } else {
            this.stats_tab.setFocus();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setSelectedLanguageItem() {
        try {
            this.this_mon.enter();
            Messages.updateLanguageForControl((Widget)this.mainWindow.getShell());
            if (this.systemTraySWT != null) {
                Messages.updateLanguageForControl((Widget)this.systemTraySWT.getMenu());
            }
            if (this.statusText != null) {
                this.statusText.update();
            }
            if (this.folder != null) {
                if (this.useCustomTab) {
                    ((CTabFolder)this.folder).update();
                } else {
                    ((TabFolder)this.folder).update();
                }
            }
            if (this.tray != null) {
                this.tray.updateLanguage();
            }
            Tab.updateLanguage();
            this.setStatusText(this.statusTextKey);
        }
        finally {
            this.this_mon.exit();
        }
    }

    public MainMenu getMenu() {
        return this.mainMenu;
    }

    public void reportCurrentTask(String task2) {
    }

    public void reportPercent(int percent) {
        if (percent > 100) {
            Utils.execSWTThread(new AERunnable(){

                public void runSupport() {
                    if (MainWindow.this.display == null || MainWindow.this.display.isDisposed()) {
                        return;
                    }
                    MainWindow.this.openMainWindow();
                }
            });
        }
    }

    public void setUpdateNeeded(UpdateWindow updateWindow) {
        this.updateWindow = updateWindow;
        if (updateWindow != null) {
            this.statusText.setCursor(Cursors.handCursor);
            this.statusText.setForeground(Colors.colorWarning);
            this.updateStatusText();
        } else {
            this.statusText.setCursor(null);
            this.statusText.setForeground(null);
            this.updateStatusText();
        }
    }

    public void completionChanged(DownloadManager manager, boolean bCompleted) {
    }

    public void downloadComplete(DownloadManager manager) {
    }

    public void positionChanged(DownloadManager download, int oldPosition, int newPosition) {
    }

    public void stateChanged(final DownloadManager manager, int state) {
        if (!(state != 50 && state != 60 || this.display == null || this.display.isDisposed())) {
            Utils.execSWTThread(new AERunnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void runSupport() {
                    if (MainWindow.this.display == null || MainWindow.this.display.isDisposed()) {
                        return;
                    }
                    if (COConfigurationManager.getBooleanParameter("Open Details", false)) {
                        MainWindow.this.openManagerView(manager);
                    }
                    if (COConfigurationManager.getBooleanParameter("Open Bar", false)) {
                        try {
                            MainWindow.this.downloadBars_mon.enter();
                            if (MainWindow.this.downloadBars.get(manager) == null) {
                                MinimizedWindow mw = new MinimizedWindow(manager, MainWindow.this.mainWindow);
                                MainWindow.this.downloadBars.put(manager, mw);
                            }
                        }
                        finally {
                            MainWindow.this.downloadBars_mon.exit();
                        }
                    }
                }
            });
        }
    }

    public AzureusCore getAzureusCore() {
        return this.azureus_core;
    }

    private void addUpdateListener() {
        this.azureus_core.getPluginManager().getDefaultPluginInterface().getUpdateManager().addListener(new UpdateManagerListener(){

            public void checkInstanceCreated(UpdateCheckInstance instance) {
                new updateStatusChanger(instance);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void showUpdateProgressWindow() {
        try {
            this.this_mon.enter();
            UpdateCheckInstance[] instances = new UpdateCheckInstance[this.update_stack.size()];
            for (int i = 0; i < instances.length; ++i) {
                instances[i] = ((updateStatusChanger)this.update_stack.get(i)).getInstance();
            }
            UpdateProgressWindow.show(instances, this.getShell());
        }
        finally {
            this.this_mon.exit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void generate(IndentWriter writer) {
        writer.println("SWT UI");
        try {
            Tab t;
            writer.indent();
            writer.println("SWT Version:" + SWT.getVersion() + "/" + SWT.getPlatform());
            writer.println("MyTorrents");
            try {
                writer.indent();
                t = this.mytorrents;
                if (t != null) {
                    t.generateDiagnostics(writer);
                }
            }
            finally {
                writer.exdent();
            }
            writer.println("MyTracker");
            try {
                writer.indent();
                t = this.my_tracker_tab;
                if (t != null) {
                    t.generateDiagnostics(writer);
                }
            }
            finally {
                writer.exdent();
            }
            writer.println("MyShares");
            try {
                writer.indent();
                t = this.my_shares_tab;
                if (t != null) {
                    t.generateDiagnostics(writer);
                }
            }
            finally {
                writer.exdent();
            }
        }
        finally {
            writer.exdent();
        }
    }

    private void checkForWhatsNewWindow() {
        try {
            int version = 2400;
            int latestDisplayed = COConfigurationManager.getIntParameter("welcome.version.lastshown", 0);
            if (latestDisplayed < version) {
                new WelcomeWindow();
                COConfigurationManager.setParameter("welcome.version.lastshown", version);
                COConfigurationManager.save();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public UISWTInstanceImpl getUISWTInstanceImpl() {
        return this.uiSWTInstanceImpl;
    }

    static /* synthetic */ boolean access$300(MainWindow x0) {
        return x0.useCustomTab;
    }

    static /* synthetic */ Composite access$400(MainWindow x0) {
        return x0.folder;
    }

    static /* synthetic */ IconBar access$500(MainWindow x0) {
        return x0.iconBar;
    }

    static /* synthetic */ ProgressBar access$1700(MainWindow x0) {
        return x0.statusUpdateProgressBar;
    }

    static /* synthetic */ Composite access$1800(MainWindow x0) {
        return x0.statusArea;
    }

    static /* synthetic */ Label access$1900(MainWindow x0) {
        return x0.statusUpdateLabel;
    }

    static /* synthetic */ Composite access$2000(MainWindow x0) {
        return x0.statusUpdate;
    }

    static {
        isAlreadyDead = false;
        isDisposeFromListener = false;
    }

    private class CLabelPadding
    extends CLabel {
        private int lastWidth;
        private long widthSetOn;
        private final int KEEPWIDTHFOR_MS = 30000;

        public CLabelPadding(Composite parent, int style) {
            super(parent, style | 0x1000000);
            this.lastWidth = 0;
            this.widthSetOn = 0L;
            this.KEEPWIDTHFOR_MS = 30000;
            GridData gridData = new GridData(80);
            this.setLayoutData(gridData);
        }

        public Point computeSize(int wHint, int hHint, boolean changed) {
            if (!this.isVisible()) {
                return new Point(0, 0);
            }
            Point pt = super.computeSize(wHint, hHint, changed);
            pt.x += 4;
            long now = System.currentTimeMillis();
            if (this.lastWidth > pt.x && now - this.widthSetOn < 30000L) {
                pt.x = this.lastWidth;
            } else {
                if (this.lastWidth != pt.x) {
                    this.lastWidth = pt.x;
                }
                this.widthSetOn = now;
            }
            return pt;
        }
    }

    protected class updateStatusChanger {
        UpdateCheckInstance instance;
        int check_num = 0;
        boolean active;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected updateStatusChanger(UpdateCheckInstance _instance) {
            this.instance = _instance;
            try {
                MainWindow.this.this_mon.enter();
                MainWindow.this.update_stack.add(this);
                this.instance.addListener(new UpdateCheckInstanceListener(this){
                    private final /* synthetic */ updateStatusChanger this$1;
                    {
                        this.this$1 = this$1;
                    }

                    public void cancelled(UpdateCheckInstance instance) {
                        updateStatusChanger.access$1400(this.this$1);
                    }

                    public void complete(UpdateCheckInstance instance) {
                        updateStatusChanger.access$1400(this.this$1);
                    }
                });
                UpdateChecker[] checkers = this.instance.getCheckers();
                UpdateCheckerListener listener = new UpdateCheckerListener(this){
                    private final /* synthetic */ updateStatusChanger this$1;
                    {
                        this.this$1 = this$1;
                    }

                    public void cancelled(UpdateChecker checker) {
                    }

                    public void completed(UpdateChecker checker) {
                        updateStatusChanger.access$1500(this.this$1);
                    }

                    public void failed(UpdateChecker checker) {
                        updateStatusChanger.access$1500(this.this$1);
                    }
                };
                for (int i = 0; i < checkers.length; ++i) {
                    checkers[i].addListener(listener);
                }
                this.activate();
            }
            finally {
                MainWindow.this.this_mon.exit();
            }
        }

        protected UpdateCheckInstance getInstance() {
            return this.instance;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void activate() {
            try {
                MainWindow.this.this_mon.enter();
                this.active = true;
                this.switchStatusToUpdate();
                this.setNbChecks(this.instance.getCheckers().length);
            }
            finally {
                MainWindow.this.this_mon.exit();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void deactivate() {
            try {
                MainWindow.this.this_mon.enter();
                this.active = false;
                for (int i = 0; i < MainWindow.this.update_stack.size(); ++i) {
                    if (MainWindow.this.update_stack.get(i) != this) continue;
                    MainWindow.this.update_stack.remove(i);
                    break;
                }
                if (MainWindow.this.update_stack.size() == 0) {
                    this.switchStatusToText();
                } else {
                    ((updateStatusChanger)MainWindow.this.update_stack.get(MainWindow.this.update_stack.size() - 1)).activate();
                }
            }
            finally {
                MainWindow.this.this_mon.exit();
            }
        }

        private void setNbChecks(int nbChecks) {
            if (MainWindow.this.display != null && !MainWindow.this.display.isDisposed()) {
                Utils.execSWTThread(new AERunnable(this, nbChecks){
                    private final /* synthetic */ int val$nbChecks;
                    private final /* synthetic */ updateStatusChanger this$1;
                    {
                        this.this$1 = this$1;
                        this.val$nbChecks = val$nbChecks;
                    }

                    public void runSupport() {
                        if (MainWindow.access$1700(updateStatusChanger.access$1600(this.this$1)) == null || MainWindow.access$1700(updateStatusChanger.access$1600(this.this$1)).isDisposed()) {
                            return;
                        }
                        MainWindow.access$1700(updateStatusChanger.access$1600(this.this$1)).setMinimum(0);
                        MainWindow.access$1700(updateStatusChanger.access$1600(this.this$1)).setMaximum(this.val$nbChecks);
                        MainWindow.access$1700(updateStatusChanger.access$1600(this.this$1)).setSelection(this.this$1.check_num);
                    }
                });
            }
        }

        private void setNextCheck() {
            if (MainWindow.this.display != null && !MainWindow.this.display.isDisposed()) {
                Utils.execSWTThread(new AERunnable(this){
                    private final /* synthetic */ updateStatusChanger this$1;
                    {
                        this.this$1 = this$1;
                    }

                    public void runSupport() {
                        if (MainWindow.access$1700(updateStatusChanger.access$1600(this.this$1)) == null || MainWindow.access$1700(updateStatusChanger.access$1600(this.this$1)).isDisposed()) {
                            return;
                        }
                        ++this.this$1.check_num;
                        if (this.this$1.active) {
                            MainWindow.access$1700(updateStatusChanger.access$1600(this.this$1)).setSelection(this.this$1.check_num);
                        }
                    }
                });
            }
        }

        private void switchStatusToUpdate() {
            if (MainWindow.this.display != null && !MainWindow.this.display.isDisposed()) {
                Utils.execSWTThread(new AERunnable(this){
                    private final /* synthetic */ updateStatusChanger this$1;
                    {
                        this.this$1 = this$1;
                    }

                    public void runSupport() {
                        if (MainWindow.access$1800(updateStatusChanger.access$1600(this.this$1)) == null || MainWindow.access$1800(updateStatusChanger.access$1600(this.this$1)).isDisposed()) {
                            return;
                        }
                        String name = this.this$1.instance.getName();
                        if (MessageText.keyExists(name)) {
                            name = MessageText.getString(name);
                        }
                        MainWindow.access$1900(updateStatusChanger.access$1600(this.this$1)).setText(name);
                        updateStatusChanger.access$1600((updateStatusChanger)this.this$1).layoutStatusArea.topControl = MainWindow.access$2000(updateStatusChanger.access$1600(this.this$1));
                        MainWindow.access$1800(updateStatusChanger.access$1600(this.this$1)).layout();
                    }
                });
            }
        }

        private void switchStatusToText() {
            if (MainWindow.this.display != null && !MainWindow.this.display.isDisposed()) {
                Utils.execSWTThread(new AERunnable(this){
                    private final /* synthetic */ updateStatusChanger this$1;
                    {
                        this.this$1 = this$1;
                    }

                    public void runSupport() {
                        if (MainWindow.access$1800(updateStatusChanger.access$1600(this.this$1)) == null || MainWindow.access$1800(updateStatusChanger.access$1600(this.this$1)).isDisposed()) {
                            return;
                        }
                        updateStatusChanger.access$1600((updateStatusChanger)this.this$1).layoutStatusArea.topControl = updateStatusChanger.access$1600((updateStatusChanger)this.this$1).statusText;
                        MainWindow.access$1800(updateStatusChanger.access$1600(this.this$1)).layout();
                    }
                });
            }
        }

        static /* synthetic */ void access$1400(updateStatusChanger x0) {
            x0.deactivate();
        }

        static /* synthetic */ void access$1500(updateStatusChanger x0) {
            x0.setNextCheck();
        }

        static /* synthetic */ MainWindow access$1600(updateStatusChanger x0) {
            return x0.MainWindow.this;
        }
    }
}

