/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.ui.swt.views.table.utils;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.MouseMoveListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.RowData;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.gudy.azureus2.core3.internat.MessageText;
import org.gudy.azureus2.ui.swt.Utils;
import org.gudy.azureus2.ui.swt.components.shell.ShellFactory;
import org.gudy.azureus2.ui.swt.views.table.ITableStructureModificationListener;
import org.gudy.azureus2.ui.swt.views.table.TableColumnCore;
import org.gudy.azureus2.ui.swt.views.utils.VerticalAligner;

public class TableColumnEditorWindow {
    private Display display;
    private Shell shell;
    private Color blue;
    private Table table;
    private ArrayList tableColumns;
    private Map newEnabledState;
    private ITableStructureModificationListener listener;
    private boolean mousePressed;
    private TableItem selectedItem;
    private Point oldPoint;
    private Image oldImage;

    public TableColumnEditorWindow(Shell parent, TableColumnCore[] _tableColumns, ITableStructureModificationListener _listener) {
        this.display = parent.getDisplay();
        this.listener = _listener;
        this.tableColumns = new ArrayList<TableColumnCore>(Arrays.asList(_tableColumns));
        Collections.sort(this.tableColumns, new Comparator(){

            public final int compare(Object a, Object b) {
                int iPositionB;
                int iPositionA = ((TableColumnCore)a).getPosition();
                if (iPositionA == -1) {
                    iPositionA = 65535;
                }
                if ((iPositionB = ((TableColumnCore)b).getPosition()) == -1) {
                    iPositionB = 65535;
                }
                return iPositionA - iPositionB;
            }
        });
        this.newEnabledState = new HashMap();
        Iterator iter = this.tableColumns.iterator();
        while (iter.hasNext()) {
            TableColumnCore item = (TableColumnCore)iter.next();
            Boolean value = new Boolean(item.getPosition() != -1);
            this.newEnabledState.put(item, value);
        }
        this.blue = new Color((Device)this.display, 0, 0, 128);
        this.shell = ShellFactory.createShell(parent, 2160);
        Utils.setShellIcon(this.shell);
        this.shell.setText(MessageText.getString("columnChooser.title"));
        GridLayout layout = new GridLayout();
        this.shell.setLayout((Layout)layout);
        Label label = new Label((Composite)this.shell, 0);
        label.setText(MessageText.getString("columnChooser.move"));
        GridData gridData = new GridData(768);
        label.setLayoutData((Object)gridData);
        this.table = new Table((Composite)this.shell, 268503076);
        gridData = new GridData(1808);
        this.table.setLayoutData((Object)gridData);
        this.table.setHeaderVisible(true);
        Composite cButtonArea = new Composite((Composite)this.shell, 0);
        gridData = new GridData(128);
        cButtonArea.setLayoutData((Object)gridData);
        RowLayout rLayout = new RowLayout(256);
        rLayout.marginLeft = 0;
        rLayout.marginTop = 0;
        rLayout.marginRight = 0;
        rLayout.marginBottom = 0;
        rLayout.spacing = 5;
        cButtonArea.setLayout((Layout)rLayout);
        Button bOk = new Button(cButtonArea, 8);
        bOk.setText(MessageText.getString("Button.ok"));
        RowData rd = new RowData();
        rd.width = 70;
        bOk.setLayoutData((Object)rd);
        bOk.addListener(13, new Listener(){

            public void handleEvent(Event e) {
                TableColumnEditorWindow.this.saveAndApply();
                TableColumnEditorWindow.this.close();
            }
        });
        Button bCancel = new Button(cButtonArea, 8);
        bCancel.setText(MessageText.getString("Button.cancel"));
        rd = new RowData();
        rd.width = 70;
        bCancel.setLayoutData((Object)rd);
        bCancel.addListener(13, new Listener(){

            public void handleEvent(Event e) {
                TableColumnEditorWindow.this.close();
            }
        });
        Button bApply = new Button(cButtonArea, 8);
        bApply.setText(MessageText.getString("columnChooser.apply"));
        rd = new RowData();
        rd.width = 70;
        bApply.setLayoutData((Object)rd);
        bApply.addListener(13, new Listener(){

            public void handleEvent(Event e) {
                TableColumnEditorWindow.this.saveAndApply();
            }
        });
        String[] columnsHeader = new String[]{"columnname", "columndescription"};
        for (int i = 0; i < columnsHeader.length; ++i) {
            TableColumn column = new TableColumn(this.table, 0);
            if (columnsHeader[i] == "") continue;
            column.setText(MessageText.getString("columnChooser." + columnsHeader[i]));
        }
        this.table.getColumn(0).setWidth(160);
        this.table.getColumn(1).setWidth(1000);
        this.table.addListener(13, new Listener(){

            public void handleEvent(Event e) {
                if (e.detail != 32) {
                    return;
                }
                TableItem item = (TableItem)e.item;
                int index = item.getParent().indexOf(item);
                TableColumnCore tableColumn = (TableColumnCore)TableColumnEditorWindow.this.tableColumns.get(index);
                TableColumnEditorWindow.this.newEnabledState.put(tableColumn, new Boolean(item.getChecked()));
            }
        });
        this.table.addListener(36, new Listener(){

            public void handleEvent(Event event) {
                TableItem item = (TableItem)event.item;
                if (item == null) {
                    return;
                }
                Table table = item.getParent();
                int index = table.indexOf(item);
                if (index < 0) {
                    Rectangle r = item.getBounds(0);
                    table.getItem(new Point(r.x, r.y));
                    index = table.indexOf(item);
                    if (index < 0) {
                        return;
                    }
                }
                TableColumnCore tableColumn = (TableColumnCore)TableColumnEditorWindow.this.tableColumns.get(index);
                String sTitleLanguageKey = tableColumn.getTitleLanguageKey();
                item.setText(0, MessageText.getString(sTitleLanguageKey));
                item.setText(1, MessageText.getString(sTitleLanguageKey + ".info", ""));
                boolean bChecked = (Boolean)TableColumnEditorWindow.this.newEnabledState.get(tableColumn);
                Utils.setCheckedInSetData(item, bChecked);
                Utils.alternateRowBackground(item);
            }
        });
        this.table.setItemCount(this.tableColumns.size());
        this.table.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDown(MouseEvent arg0) {
                TableColumnEditorWindow.this.mousePressed = true;
                TableColumnEditorWindow.this.selectedItem = TableColumnEditorWindow.this.table.getItem(new Point(arg0.x, arg0.y));
            }

            public void mouseUp(MouseEvent e) {
                TableColumnEditorWindow.this.mousePressed = false;
                if (TableColumnEditorWindow.this.oldPoint != null && TableColumnEditorWindow.this.oldImage != null) {
                    GC gc = new GC((Drawable)TableColumnEditorWindow.this.table);
                    gc.drawImage(TableColumnEditorWindow.this.oldImage, ((TableColumnEditorWindow)TableColumnEditorWindow.this).oldPoint.x, ((TableColumnEditorWindow)TableColumnEditorWindow.this).oldPoint.y);
                    TableColumnEditorWindow.this.oldImage.dispose();
                    TableColumnEditorWindow.this.oldImage = null;
                    TableColumnEditorWindow.this.oldPoint = null;
                }
                Point p = new Point(e.x, e.y);
                TableItem item = TableColumnEditorWindow.this.table.getItem(p);
                if (item != null && TableColumnEditorWindow.this.selectedItem != null) {
                    int oldIndex;
                    int index = TableColumnEditorWindow.this.table.indexOf(item);
                    if (index == (oldIndex = TableColumnEditorWindow.this.table.indexOf(TableColumnEditorWindow.this.selectedItem))) {
                        return;
                    }
                    TableColumnCore tableColumn = (TableColumnCore)TableColumnEditorWindow.this.tableColumns.get(oldIndex);
                    TableColumnEditorWindow.this.tableColumns.remove(tableColumn);
                    TableColumnEditorWindow.this.tableColumns.add(index, tableColumn);
                    TableColumnEditorWindow.this.table.clearAll();
                }
            }
        });
        this.table.addMouseMoveListener(new MouseMoveListener(){

            public void mouseMove(MouseEvent e) {
                if (!TableColumnEditorWindow.this.mousePressed || TableColumnEditorWindow.this.selectedItem == null) {
                    return;
                }
                Point p = new Point(e.x, e.y);
                TableItem item = TableColumnEditorWindow.this.table.getItem(p);
                if (item == null) {
                    return;
                }
                GC gc = new GC((Drawable)TableColumnEditorWindow.this.table);
                Rectangle bounds = item.getBounds(0);
                int selectedPosition = TableColumnEditorWindow.this.table.indexOf(TableColumnEditorWindow.this.selectedItem);
                int newPosition = TableColumnEditorWindow.this.table.indexOf(item);
                if (TableColumnEditorWindow.this.oldPoint != null && TableColumnEditorWindow.this.oldImage != null) {
                    gc.drawImage(TableColumnEditorWindow.this.oldImage, ((TableColumnEditorWindow)TableColumnEditorWindow.this).oldPoint.x, ((TableColumnEditorWindow)TableColumnEditorWindow.this).oldPoint.y);
                    TableColumnEditorWindow.this.oldImage.dispose();
                    TableColumnEditorWindow.this.oldImage = null;
                    TableColumnEditorWindow.this.oldPoint = null;
                }
                bounds.y += VerticalAligner.getTableAdjustVerticalBy(TableColumnEditorWindow.this.table);
                if (newPosition <= selectedPosition) {
                    TableColumnEditorWindow.this.oldPoint = new Point(bounds.x, bounds.y);
                } else {
                    TableColumnEditorWindow.this.oldPoint = new Point(bounds.x, bounds.y + bounds.height);
                }
                TableColumnEditorWindow.this.oldImage = new Image((Device)TableColumnEditorWindow.this.display, bounds.width, 2);
                gc.copyArea(TableColumnEditorWindow.this.oldImage, ((TableColumnEditorWindow)TableColumnEditorWindow.this).oldPoint.x, ((TableColumnEditorWindow)TableColumnEditorWindow.this).oldPoint.y);
                gc.setBackground(TableColumnEditorWindow.this.blue);
                gc.fillRectangle(((TableColumnEditorWindow)TableColumnEditorWindow.this).oldPoint.x, ((TableColumnEditorWindow)TableColumnEditorWindow.this).oldPoint.y, bounds.width, 2);
            }
        });
        this.shell.pack();
        Point p = this.shell.getSize();
        p.x = 550;
        p.y += 2;
        if (p.y + 64 > this.display.getClientArea().height) {
            p.y = this.display.getBounds().height - 64;
        }
        this.shell.setSize(p);
        Utils.centreWindow(this.shell);
        this.shell.open();
    }

    private void close() {
        if (this.blue != null && !this.blue.isDisposed()) {
            this.blue.dispose();
        }
        if (!this.shell.isDisposed()) {
            this.shell.dispose();
        }
    }

    private void saveAndApply() {
        TableItem[] items = this.table.getItems();
        int position = 0;
        for (int i = 0; i < items.length; ++i) {
            TableColumnCore tableColumn;
            boolean bChecked = (Boolean)this.newEnabledState.get(tableColumn = (TableColumnCore)this.tableColumns.get(i));
            tableColumn.setPositionNoShift(bChecked ? position++ : -1);
            tableColumn.saveSettings();
        }
        this.listener.tableStructureChanged();
    }
}

