/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.plugins.rating;

import com.aelitis.azureus.plugins.rating.ui.RatingColumn;
import com.aelitis.azureus.plugins.rating.ui.RatingWindow;
import com.aelitis.azureus.plugins.rating.updater.RatingsUpdater;
import java.io.InputStream;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.gudy.azureus2.plugins.Plugin;
import org.gudy.azureus2.plugins.PluginInterface;
import org.gudy.azureus2.plugins.PluginListener;
import org.gudy.azureus2.plugins.config.ConfigParameter;
import org.gudy.azureus2.plugins.config.ConfigParameterListener;
import org.gudy.azureus2.plugins.download.Download;
import org.gudy.azureus2.plugins.logging.LoggerChannel;
import org.gudy.azureus2.plugins.ui.SWT.SWTManager;
import org.gudy.azureus2.plugins.ui.UIManager;
import org.gudy.azureus2.plugins.ui.config.Parameter;
import org.gudy.azureus2.plugins.ui.config.PluginConfigUIFactory;
import org.gudy.azureus2.plugins.ui.menus.MenuItem;
import org.gudy.azureus2.plugins.ui.menus.MenuItemListener;
import org.gudy.azureus2.plugins.ui.tables.TableCellRefreshListener;
import org.gudy.azureus2.plugins.ui.tables.TableColumn;
import org.gudy.azureus2.plugins.ui.tables.TableContextMenuItem;
import org.gudy.azureus2.plugins.ui.tables.TableManager;
import org.gudy.azureus2.plugins.ui.tables.TableRow;

public class RatingPlugin
implements Plugin,
ConfigParameterListener,
PluginListener {
    private static final String COLUMN_ID_RATING = "RatingColumn";
    private PluginInterface pluginInterface;
    LoggerChannel log;
    private String nick;
    private RatingsUpdater updater;
    private static final String resPath = "com/aelitis/azureus/plugins/rating/ui/icons/";
    public Image imgNoRating;
    public Image[] imgRated;

    public void initialize(PluginInterface pluginInterface) {
        this.pluginInterface = pluginInterface;
        this.log = pluginInterface.getLogger().getChannel("Rating Plugin");
        this.imgNoRating = this.loadImage("com/aelitis/azureus/plugins/rating/ui/icons/unrated.png");
        this.imgRated = new Image[5];
        int i = 0;
        while (i < 5) {
            this.imgRated[i] = this.loadImage("com/aelitis/azureus/plugins/rating/ui/icons/rated" + (i + 1) + ".png");
            ++i;
        }
        this.nick = pluginInterface.getPluginconfig().getPluginStringParameter("nick", "Anonymous");
        this.addPluginConfig();
        this.updater = new RatingsUpdater(this);
        pluginInterface.addListener((PluginListener)this);
        this.addMyTorrentsColumn();
        this.addMyTorrentsMenu();
    }

    public void closedownComplete() {
    }

    public void closedownInitiated() {
    }

    public void initializationComplete() {
        this.updater.initialize();
    }

    private void addPluginConfig() {
        PluginConfigUIFactory factory = this.pluginInterface.getPluginConfigUIFactory();
        Parameter[] parameters = new Parameter[]{factory.createStringParameter("nick", "rating.config.nick", "")};
        parameters[0].addConfigParameterListener((ConfigParameterListener)this);
        this.pluginInterface.addConfigUIParameters(parameters, "rating.config.title");
    }

    private Image loadImage(String res) {
        InputStream is = this.getClass().getClassLoader().getResourceAsStream(res);
        if (is != null) {
            ImageData imageData = new ImageData(is);
            return new Image((Device)this.pluginInterface.getUIManager().getSWTManager().getDisplay(), imageData);
        }
        return null;
    }

    private void addMyTorrentsColumn() {
        RatingColumn ratingColumn = new RatingColumn(this);
        this.addRatingColumnToTable("MyTorrents", ratingColumn);
        this.addRatingColumnToTable("MySeeders", ratingColumn);
    }

    private void addRatingColumnToTable(String tableID, RatingColumn ratingColumn) {
        UIManager uiManager = this.pluginInterface.getUIManager();
        SWTManager swtManager = uiManager.getSWTManager();
        TableManager tableManager = uiManager.getTableManager();
        TableColumn activityColumn = tableManager.createColumn(tableID, COLUMN_ID_RATING);
        activityColumn.setAlignment(1);
        activityColumn.setPosition(5);
        activityColumn.setRefreshInterval(-1);
        activityColumn.setType(2);
        activityColumn.addCellRefreshListener((TableCellRefreshListener)ratingColumn);
        tableManager.addColumn(activityColumn);
    }

    private void addMyTorrentsMenu() {
        MenuItemListener listener = new MenuItemListener(){

            public void selected(MenuItem _menu, Object _target) {
                Download download = (Download)((TableRow)_target).getDataSource();
                if (download == null || download.getTorrent() == null) {
                    return;
                }
                new RatingWindow(RatingPlugin.this, download);
            }
        };
        TableContextMenuItem menu1 = this.pluginInterface.getUIManager().getTableManager().addContextMenuItem("MyTorrents", "RatingPlugin.contextmenu.manageRating");
        TableContextMenuItem menu2 = this.pluginInterface.getUIManager().getTableManager().addContextMenuItem("MySeeders", "RatingPlugin.contextmenu.manageRating");
        menu1.addListener(listener);
        menu2.addListener(listener);
    }

    public void configParameterChanged(ConfigParameter param) {
        this.nick = this.pluginInterface.getPluginconfig().getPluginStringParameter("nick", "Anonymous");
    }

    public PluginInterface getPluginInterface() {
        return this.pluginInterface;
    }

    public String getNick() {
        return this.nick;
    }

    public void logInfo(String text) {
        this.log.log(1, text);
    }

    public void logError(String text) {
        this.log.log(3, text);
    }

    public RatingsUpdater getUpdater() {
        return this.updater;
    }
}

