/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.core.dht.transport.udp.impl;

import com.aelitis.azureus.core.dht.transport.DHTTransportException;
import com.aelitis.azureus.core.dht.transport.DHTTransportValue;
import com.aelitis.azureus.core.dht.transport.udp.impl.DHTTransportUDPContactImpl;
import com.aelitis.azureus.core.dht.transport.udp.impl.DHTTransportUDPImpl;
import com.aelitis.azureus.core.dht.transport.udp.impl.DHTUDPPacketRequest;
import com.aelitis.azureus.core.dht.transport.udp.impl.DHTUDPUtils;
import com.aelitis.azureus.core.dht.transport.udp.impl.packethandler.DHTUDPPacketNetworkHandler;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;

public class DHTUDPPacketRequestStore
extends DHTUDPPacketRequest {
    public static final int MAX_KEYS_PER_PACKET = 255;
    public static final int MAX_VALUES_PER_KEY = 255;
    private int random_id;
    private byte[][] keys;
    private DHTTransportValue[][] value_sets;

    public DHTUDPPacketRequestStore(DHTTransportUDPImpl _transport, long _connection_id, DHTTransportUDPContactImpl _local_contact, DHTTransportUDPContactImpl _remote_contact) {
        super(_transport, 1026, _connection_id, _local_contact, _remote_contact);
    }

    protected DHTUDPPacketRequestStore(DHTUDPPacketNetworkHandler network_handler, DataInputStream is, long con_id, int trans_id) throws IOException {
        super(network_handler, is, 1026, con_id, trans_id);
        if (this.getProtocolVersion() >= 7) {
            this.random_id = is.readInt();
        }
        this.keys = DHTUDPUtils.deserialiseByteArrayArray(is, 255);
        this.value_sets = DHTUDPUtils.deserialiseTransportValuesArray(this, is, this.getClockSkew(), 255);
        super.postDeserialise(is);
    }

    public void serialise(DataOutputStream os) throws IOException {
        super.serialise(os);
        if (this.getProtocolVersion() >= 7) {
            os.writeInt(this.random_id);
        }
        DHTUDPUtils.serialiseByteArrayArray(os, this.keys, 255);
        try {
            DHTUDPUtils.serialiseTransportValuesArray(this, os, this.value_sets, 0L, 255);
        }
        catch (DHTTransportException e) {
            throw new IOException(e.getMessage());
        }
        super.postSerialise(os);
    }

    protected void setRandomID(int _random_id) {
        this.random_id = _random_id;
    }

    protected int getRandomID() {
        return this.random_id;
    }

    protected void setValueSets(DHTTransportValue[][] _values) {
        this.value_sets = _values;
    }

    protected DHTTransportValue[][] getValueSets() {
        return this.value_sets;
    }

    protected void setKeys(byte[][] _key) {
        this.keys = _key;
    }

    protected byte[][] getKeys() {
        return this.keys;
    }

    public String getString() {
        return super.getString();
    }
}

