/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.core.peermanager.download.session.impl;

import com.aelitis.azureus.core.networkmanager.IncomingMessageQueue;
import com.aelitis.azureus.core.networkmanager.OutgoingMessageQueue;
import com.aelitis.azureus.core.peermanager.connection.AZPeerConnection;
import com.aelitis.azureus.core.peermanager.download.session.TorrentSession;
import com.aelitis.azureus.core.peermanager.download.session.TorrentSessionListener;
import com.aelitis.azureus.core.peermanager.messaging.Message;
import com.aelitis.azureus.core.peermanager.messaging.bittorrent.BTBitfield;
import com.aelitis.azureus.core.peermanager.messaging.bittorrent.BTCancel;
import com.aelitis.azureus.core.peermanager.messaging.bittorrent.BTHave;
import com.aelitis.azureus.core.peermanager.messaging.bittorrent.BTPiece;
import com.aelitis.azureus.core.peermanager.messaging.bittorrent.BTRequest;
import org.gudy.azureus2.core3.util.DirectByteBuffer;

public class BTTorrentSession
implements TorrentSession {
    private final TorrentSessionListener listener;
    private final AZPeerConnection peer;
    private final IncomingMessageQueue.MessageQueueListener incoming_q_listener = new IncomingMessageQueue.MessageQueueListener(){

        public boolean messageReceived(Message message) {
            if (message.getID().equals("BT_BITFIELD")) {
                BTBitfield bitf = (BTBitfield)message;
                BTTorrentSession.this.listener.receivedSessionBitfield(bitf.getBitfield());
                return true;
            }
            if (message.getID().equals("BT_HAVE")) {
                BTHave have = (BTHave)message;
                BTTorrentSession.this.listener.receivedSessionHave(have.getPieceNumber());
                return true;
            }
            if (message.getID().equals("BT_REQUEST")) {
                BTRequest req = (BTRequest)message;
                BTTorrentSession.this.listener.receivedSessionRequest((byte)-1, req.getPieceNumber(), req.getPieceOffset(), req.getLength());
                return true;
            }
            if (message.getID().equals("BT_CANCEL")) {
                BTCancel can = (BTCancel)message;
                BTTorrentSession.this.listener.receivedSessionCancel(can.getPieceNumber(), can.getPieceOffset(), can.getLength());
                return true;
            }
            if (message.getID().equals("BT_PIECE")) {
                BTPiece piece = (BTPiece)message;
                BTTorrentSession.this.listener.receivedSessionPiece(piece.getPieceNumber(), piece.getPieceOffset(), piece.getPieceData());
                return true;
            }
            return false;
        }

        public void protocolBytesReceived(int byte_count) {
        }

        public void dataBytesReceived(int byte_count) {
        }
    };
    private final OutgoingMessageQueue.MessageQueueListener sent_message_listener = new OutgoingMessageQueue.MessageQueueListener(){

        public boolean messageAdded(Message message) {
            return true;
        }

        public void messageSent(Message message) {
            if (message.getID().equals("BT_PIECE")) {
                BTTorrentSession.this.listener.sentSessionPiece(message);
            }
        }

        public void messageQueued(Message message) {
        }

        public void messageRemoved(Message message) {
        }

        public void protocolBytesSent(int byte_count) {
        }

        public void dataBytesSent(int byte_count) {
        }
    };

    public BTTorrentSession(AZPeerConnection peer, TorrentSessionListener listener) {
        this.peer = peer;
        this.listener = listener;
        peer.getNetworkConnection().getIncomingMessageQueue().registerQueueListener(this.incoming_q_listener);
        peer.getNetworkConnection().getOutgoingMessageQueue().registerQueueListener(this.sent_message_listener);
        listener.sessionIsEstablished();
    }

    public void sendSessionBitfield(DirectByteBuffer bitfield) {
        this.peer.getNetworkConnection().getOutgoingMessageQueue().addMessage(new BTBitfield(bitfield), false);
    }

    public void sendSessionRequest(byte unchoke_id, int piece_number, int piece_offset, int length) {
        this.peer.getNetworkConnection().getOutgoingMessageQueue().addMessage(new BTRequest(piece_number, piece_offset, length), false);
    }

    public void sendSessionCancel(int piece_number, int piece_offset, int length) {
        this.peer.getNetworkConnection().getOutgoingMessageQueue().addMessage(new BTCancel(piece_number, piece_offset, length), false);
    }

    public void sendSessionHave(int[] piece_numbers) {
        for (int i = 0; i < piece_numbers.length; ++i) {
            this.peer.getNetworkConnection().getOutgoingMessageQueue().addMessage(new BTHave(piece_numbers[i]), false);
        }
    }

    public Object sendSessionPiece(int piece_number, int piece_offset, DirectByteBuffer data) {
        BTPiece piece = new BTPiece(piece_number, piece_offset, data);
        this.peer.getNetworkConnection().getOutgoingMessageQueue().addMessage(piece, false);
        return piece;
    }

    public void endSession(String reason) {
        this.peer.getNetworkConnection().getIncomingMessageQueue().cancelQueueListener(this.incoming_q_listener);
        this.peer.getNetworkConnection().getOutgoingMessageQueue().cancelQueueListener(this.sent_message_listener);
    }
}

