/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.core.peermanager.nat;

import com.aelitis.azureus.core.AzureusCore;
import com.aelitis.azureus.core.nat.NATTraversal;
import com.aelitis.azureus.core.nat.NATTraversalHandler;
import com.aelitis.azureus.core.nat.NATTraversalObserver;
import com.aelitis.azureus.core.nat.NATTraverser;
import com.aelitis.azureus.core.peermanager.nat.PeerNATInitiator;
import com.aelitis.azureus.core.peermanager.nat.PeerNATTraversalAdapter;
import com.aelitis.azureus.core.util.bloom.BloomFilter;
import com.aelitis.azureus.core.util.bloom.BloomFilterFactory;
import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.gudy.azureus2.core3.logging.LogEvent;
import org.gudy.azureus2.core3.logging.LogIDs;
import org.gudy.azureus2.core3.logging.Logger;
import org.gudy.azureus2.core3.util.Average;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.core3.util.SimpleTimer;
import org.gudy.azureus2.core3.util.SystemTime;
import org.gudy.azureus2.core3.util.TimerEvent;
import org.gudy.azureus2.core3.util.TimerEventPerformer;

public class PeerNATTraverser
implements NATTraversalHandler {
    private static final LogIDs LOGID = LogIDs.PEER;
    private static final int OUTCOME_SUCCESS = 0;
    private static final int OUTCOME_FAILED_NO_REND = 1;
    private static final int OUTCOME_FAILED_OTHER = 2;
    private static PeerNATTraverser singleton;
    private static final int MAX_ACTIVE_REQUESTS = 3;
    private static final int TIMER_PERIOD = 10000;
    private static final int USAGE_PERIOD = 10000;
    private static final int USAGE_DURATION_SECS = 60;
    private static final int MAX_USAGE_PER_MIN = 15000;
    private static final int STATS_TICK_COUNT = 12;
    private NATTraverser nat_traverser;
    private Map initiators = new HashMap();
    private LinkedList pending_requests = new LinkedList();
    private List active_requests = new ArrayList();
    private Average usage_average = Average.getInstance(10000, 60);
    private int attempted_count = 0;
    private int success_count = 0;
    private int failed_no_rendezvous = 0;
    private int failed_negative_bloom = 0;
    private BloomFilter negative_result_bloom = BloomFilterFactory.createAddOnly(4096);
    private static final int BLOOM_SIZE = 4096;
    private static final int BLOOM_REBUILD_PERIOD = 300000;
    private static final int BLOOM_REBUILD_TICKS = 30;

    public static void initialise(AzureusCore core) {
        singleton = new PeerNATTraverser(core);
    }

    public static PeerNATTraverser getSingleton() {
        return singleton;
    }

    public PeerNATTraverser(AzureusCore core) {
        this.nat_traverser = core.getNATTraverser();
        this.nat_traverser.registerHandler(this);
        SimpleTimer.addPeriodicEvent("PeerNAT:stats", 10000L, new TimerEventPerformer(){
            private int ticks;

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void perform(TimerEvent event2) {
                ++this.ticks;
                ArrayList<PeerNATTraversal> to_run = null;
                Map map = PeerNATTraverser.this.initiators;
                synchronized (map) {
                    if (this.ticks % 30 == 0) {
                        int size = PeerNATTraverser.this.negative_result_bloom.getEntryCount();
                        if (Logger.isEnabled() && size > 0) {
                            Logger.log(new LogEvent(LOGID, "PeerNATTraverser: negative bloom size = " + size));
                        }
                        PeerNATTraverser.this.negative_result_bloom = BloomFilterFactory.createAddOnly(4096);
                    }
                    if (this.ticks % 12 == 0) {
                        String msg = "NAT traversal stats: active=" + PeerNATTraverser.this.active_requests.size() + ",pending=" + PeerNATTraverser.this.pending_requests.size() + ",attempted=" + PeerNATTraverser.this.attempted_count + ",no rendezvous=" + PeerNATTraverser.this.failed_no_rendezvous + ",negative bloom=" + PeerNATTraverser.this.failed_negative_bloom + ",successful=" + PeerNATTraverser.this.success_count;
                        if (Logger.isEnabled()) {
                            Logger.log(new LogEvent(LOGID, msg));
                        }
                    }
                    int used = 0;
                    for (int i = 0; i < PeerNATTraverser.this.active_requests.size(); ++i) {
                        used = (int)((long)used + ((PeerNATTraversal)PeerNATTraverser.this.active_requests.get(i)).getTimeUsed());
                    }
                    PeerNATTraverser.this.usage_average.addValue(used);
                    int usage = (int)PeerNATTraverser.this.usage_average.getAverage();
                    if (usage > 15000) {
                        return;
                    }
                    while (PeerNATTraverser.this.pending_requests.size() != 0 && PeerNATTraverser.this.active_requests.size() < 3) {
                        PeerNATTraversal traversal = (PeerNATTraversal)PeerNATTraverser.this.pending_requests.removeFirst();
                        PeerNATTraverser.this.active_requests.add(traversal);
                        if (to_run == null) {
                            to_run = new ArrayList<PeerNATTraversal>();
                        }
                        to_run.add(traversal);
                        PeerNATTraverser.this.attempted_count++;
                    }
                }
                if (to_run != null) {
                    for (int i = 0; i < to_run.size(); ++i) {
                        PeerNATTraversal traversal = (PeerNATTraversal)to_run.get(i);
                        boolean bad = false;
                        Map map2 = PeerNATTraverser.this.initiators;
                        synchronized (map2) {
                            if (PeerNATTraverser.this.negative_result_bloom.contains(traversal.getTarget().toString().getBytes())) {
                                bad = true;
                                PeerNATTraverser.this.failed_negative_bloom++;
                            }
                        }
                        if (bad) {
                            PeerNATTraverser.this.removeRequest(traversal, 2);
                            traversal.getAdapter().failed();
                            continue;
                        }
                        traversal.run();
                    }
                }
            }
        });
    }

    public int getType() {
        return 1;
    }

    public String getName() {
        return "Peer Traversal";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void register(PeerNATInitiator initiator) {
        Map map = this.initiators;
        synchronized (map) {
            if (this.initiators.put(initiator, new LinkedList()) != null) {
                Debug.out("initiator already present");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unregister(PeerNATInitiator initiator) {
        Map map = this.initiators;
        synchronized (map) {
            LinkedList requests = (LinkedList)this.initiators.remove(initiator);
            if (requests == null) {
                Debug.out("initiator not present");
            } else {
                for (PeerNATTraversal traversal : requests) {
                    traversal.cancel();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void create(PeerNATInitiator initiator, InetSocketAddress target, PeerNATTraversalAdapter adapter) {
        boolean bad = false;
        Map map = this.initiators;
        synchronized (map) {
            if (this.negative_result_bloom.contains(target.toString().getBytes())) {
                bad = true;
                ++this.failed_negative_bloom;
            }
        }
        if (bad) {
            adapter.failed();
        } else {
            map = this.initiators;
            synchronized (map) {
                LinkedList requests = (LinkedList)this.initiators.get(initiator);
                if (requests == null) {
                    Debug.out("initiator not found");
                    adapter.failed();
                    return;
                }
                PeerNATTraversal traversal = new PeerNATTraversal(initiator, target, adapter);
                requests.addLast(traversal);
                this.pending_requests.addLast(traversal);
                if (Logger.isEnabled()) {
                    Logger.log(new LogEvent(LOGID, "created NAT traversal for " + initiator.getDisplayName() + "/" + target));
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void removeRequest(PeerNATTraversal request2, int outcome) {
        Map map = this.initiators;
        synchronized (map) {
            LinkedList requests = (LinkedList)this.initiators.get(request2.getInitiator());
            if (requests != null) {
                requests.remove(request2);
            }
            this.pending_requests.remove(request2);
            if (this.active_requests.remove(request2)) {
                this.usage_average.addValue(request2.getTimeUsed());
                if (outcome == 0) {
                    ++this.success_count;
                } else {
                    InetSocketAddress target = request2.getTarget();
                    this.negative_result_bloom.add(target.toString().getBytes());
                    if (outcome == 1) {
                        ++this.failed_no_rendezvous;
                    }
                }
            }
        }
    }

    public Map process(InetSocketAddress originator, Map data) {
        return null;
    }

    protected class PeerNATTraversal
    implements NATTraversalObserver {
        private PeerNATInitiator initiator;
        private InetSocketAddress target;
        private PeerNATTraversalAdapter adapter;
        private NATTraversal traversal;
        private boolean cancelled;
        private long time;

        protected PeerNATTraversal(PeerNATInitiator _initiator, InetSocketAddress _target, PeerNATTraversalAdapter _adapter) {
            this.initiator = _initiator;
            this.target = _target;
            this.adapter = _adapter;
        }

        protected PeerNATInitiator getInitiator() {
            return this.initiator;
        }

        protected InetSocketAddress getTarget() {
            return this.target;
        }

        protected PeerNATTraversalAdapter getAdapter() {
            return this.adapter;
        }

        protected long getTimeUsed() {
            long now = SystemTime.getCurrentTime();
            long elapsed = now - this.time;
            this.time = now;
            elapsed = elapsed < 0L ? 0L : Math.min(elapsed, 10000L);
            return elapsed;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void run() {
            PeerNATTraversal peerNATTraversal = this;
            synchronized (peerNATTraversal) {
                if (!this.cancelled) {
                    this.time = SystemTime.getCurrentTime();
                    this.traversal = PeerNATTraverser.this.nat_traverser.attemptTraversal(PeerNATTraverser.this, this.target, null, false, this);
                }
            }
        }

        public void succeeded(InetSocketAddress rendezvous, InetSocketAddress target, Map reply) {
            PeerNATTraverser.this.removeRequest(this, 0);
            if (Logger.isEnabled()) {
                Logger.log(new LogEvent(LOGID, "NAT traversal for " + this.initiator.getDisplayName() + "/" + target + " succeeded"));
            }
            this.adapter.success(target);
        }

        public void failed(int reason) {
            PeerNATTraverser.this.removeRequest(this, reason == 1 ? 1 : 2);
            this.adapter.failed();
        }

        public void failed(Throwable cause) {
            PeerNATTraverser.this.removeRequest(this, 2);
            this.adapter.failed();
        }

        public void disabled() {
            PeerNATTraverser.this.removeRequest(this, 2);
            this.adapter.failed();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void cancel() {
            boolean complete = false;
            PeerNATTraversal peerNATTraversal = this;
            synchronized (peerNATTraversal) {
                this.cancelled = true;
                if (this.traversal == null) {
                    complete = true;
                }
            }
            if (complete) {
                PeerNATTraverser.this.removeRequest(this, 2);
            } else {
                this.traversal.cancel();
            }
            this.adapter.failed();
        }
    }
}

