/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.core.peermanager.uploadslots;

import com.aelitis.azureus.core.peermanager.unchoker.UnchokerUtil;
import org.gudy.azureus2.core3.peer.impl.PEPeerTransport;
import org.gudy.azureus2.core3.util.DisplayFormatters;

public class UploadSession {
    protected static final int TYPE_DOWNLOAD = 0;
    protected static final int TYPE_SEED = 1;
    private final PEPeerTransport peer;
    private final int session_type;

    protected UploadSession(PEPeerTransport _peer, int _session_type) {
        this.peer = _peer;
        this.session_type = _session_type;
    }

    protected int getSessionType() {
        return this.session_type;
    }

    protected void start() {
        UnchokerUtil.performChokeUnchoke(null, this.peer);
    }

    protected void stop() {
        UnchokerUtil.performChokeUnchoke(this.peer, null);
    }

    protected boolean isSameSession(UploadSession session) {
        if (session == null) {
            return false;
        }
        return this.peer == session.peer;
    }

    protected String getStatsTrace() {
        String n = this.peer.getManager().getDisplayName();
        String t = this.session_type == 0 ? "DOWNLOADING" : "SEEDING";
        String p = " : [" + this.peer.getClient() + "] " + this.peer.getIp() + " :" + this.peer.getPort();
        String s = " || (D: " + DisplayFormatters.formatByteCountToKiBEtcPerSec(this.peer.getStats().getDataReceiveRate()) + ") (U: " + DisplayFormatters.formatByteCountToKiBEtcPerSec(this.peer.getStats().getDataSendRate()) + ")";
        return "[" + n + "] " + t + p + s;
    }
}

