/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.net.magneturi.impl;

import com.aelitis.net.magneturi.MagnetURIHandler;
import com.aelitis.net.magneturi.MagnetURIHandlerListener;
import com.aelitis.net.magneturi.MagnetURIHandlerProgressListener;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketException;
import java.net.URL;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.StringTokenizer;
import org.gudy.azureus2.core3.internat.MessageText;
import org.gudy.azureus2.core3.logging.LogEvent;
import org.gudy.azureus2.core3.logging.LogIDs;
import org.gudy.azureus2.core3.logging.Logger;
import org.gudy.azureus2.core3.util.AEMonitor;
import org.gudy.azureus2.core3.util.AEThread;
import org.gudy.azureus2.core3.util.Base32;
import org.gudy.azureus2.core3.util.Debug;

public class MagnetURIHandlerImpl
extends MagnetURIHandler {
    private static final LogIDs LOGID = LogIDs.NET;
    private static MagnetURIHandlerImpl singleton;
    private static AEMonitor class_mon;
    private static final int DOWNLOAD_TIMEOUT = 180000;
    protected static final String NL = "\r\n";
    private int port;
    private List listeners = new ArrayList();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static MagnetURIHandler getSingleton() {
        try {
            class_mon.enter();
            if (singleton == null) {
                singleton = new MagnetURIHandlerImpl();
            }
            MagnetURIHandlerImpl magnetURIHandlerImpl = singleton;
            return magnetURIHandlerImpl;
        }
        finally {
            class_mon.exit();
        }
    }

    protected MagnetURIHandlerImpl() {
        ServerSocket socket = null;
        for (int i = 45100; i <= 45199; ++i) {
            try {
                socket = new ServerSocket(i, 50, InetAddress.getByName("127.0.0.1"));
                this.port = i;
                break;
            }
            catch (Throwable e) {
                continue;
            }
        }
        if (socket == null) {
            if (Logger.isEnabled()) {
                Logger.log(new LogEvent(LOGID, 3, "MagnetURI: no free sockets, giving up"));
            }
        } else {
            if (Logger.isEnabled()) {
                Logger.log(new LogEvent(LOGID, "MagnetURI: bound on " + socket.getLocalPort()));
            }
            final ServerSocket f_socket = socket;
            AEThread t = new AEThread("MagnetURIHandler"){

                public void runSupport() {
                    int errors = 0;
                    int ok = 0;
                    while (true) {
                        try {
                            while (true) {
                                final Socket sck = f_socket.accept();
                                ++ok;
                                errors = 0;
                                AEThread t = new AEThread("MagnetURIHandler:processor"){

                                    /*
                                     * WARNING - Removed try catching itself - possible behaviour change.
                                     */
                                    public void runSupport() {
                                        boolean close_socket = true;
                                        try {
                                            String address = sck.getInetAddress().getHostAddress();
                                            if (address.equals("localhost") || address.equals("127.0.0.1")) {
                                                BufferedReader br = new BufferedReader(new InputStreamReader(sck.getInputStream(), "UTF8"));
                                                String line = br.readLine();
                                                if (line != null) {
                                                    if (line.toUpperCase().startsWith("GET ")) {
                                                        Logger.log(new LogEvent(LOGID, "MagnetURIHandler: processing '" + line + "'"));
                                                        line = line.substring(4);
                                                        int pos = line.lastIndexOf(32);
                                                        line = line.substring(0, pos);
                                                        close_socket = MagnetURIHandlerImpl.this.process(line, sck.getOutputStream());
                                                    } else {
                                                        Logger.log(new LogEvent(LOGID, 1, "MagnetURIHandler: invalid command - '" + line + "'"));
                                                    }
                                                } else {
                                                    Logger.log(new LogEvent(LOGID, 1, "MagnetURIHandler: connect from '" + address + "': no data read"));
                                                }
                                            } else {
                                                Logger.log(new LogEvent(LOGID, 1, "MagnetURIHandler: connect from invalid address '" + address + "'"));
                                            }
                                        }
                                        catch (Throwable e) {
                                            if (!(e instanceof IOException) && !(e instanceof SocketException)) {
                                                Debug.printStackTrace(e);
                                            }
                                        }
                                        finally {
                                            try {
                                                if (close_socket) {
                                                    sck.close();
                                                }
                                            }
                                            catch (Throwable e) {}
                                        }
                                    }
                                };
                                t.setDaemon(true);
                                t.start();
                            }
                        }
                        catch (Throwable e) {
                            Debug.printStackTrace(e);
                            if (++errors <= 100 || !Logger.isEnabled()) continue;
                            Logger.log(new LogEvent(LOGID, "MagnetURIHandler: bailing out, too many socket errors"));
                            continue;
                        }
                        break;
                    }
                }
            };
            t.setDaemon(true);
            t.start();
        }
    }

    protected boolean process(String get, OutputStream os) throws IOException {
        String urn;
        HashMap<String, String> params = new HashMap<String, String>();
        ArrayList<String> source_params = new ArrayList<String>();
        int pos = get.indexOf(63);
        if (pos != -1) {
            StringTokenizer tok = new StringTokenizer(get.substring(pos + 1), "&");
            while (tok.hasMoreTokens()) {
                String arg = tok.nextToken();
                pos = arg.indexOf(61);
                if (pos == -1) {
                    params.put(arg.trim(), "");
                    continue;
                }
                try {
                    String lhs = arg.substring(0, pos).trim();
                    String rhs = URLDecoder.decode(arg.substring(pos + 1).trim(), "UTF8");
                    params.put(lhs, rhs);
                    if (!lhs.equalsIgnoreCase("xsource")) continue;
                    source_params.add(rhs);
                }
                catch (UnsupportedEncodingException e) {
                    Debug.printStackTrace(e);
                }
            }
        }
        if (get.startsWith("/magnet10/badge.img")) {
            for (int i = 0; i < this.listeners.size(); ++i) {
                byte[] data = ((MagnetURIHandlerListener)this.listeners.get(i)).badge();
                if (data == null) continue;
                this.writeReply(os, "image/gif", data);
                return true;
            }
            this.writeNotFound(os);
            return true;
        }
        if (get.startsWith("/magnet10/canHandle.img?")) {
            urn = (String)params.get("xt");
            if (urn != null && urn.startsWith("urn:btih:")) {
                for (int i = 0; i < this.listeners.size(); ++i) {
                    byte[] data = ((MagnetURIHandlerListener)this.listeners.get(i)).badge();
                    if (data == null) continue;
                    this.writeReply(os, "image/gif", data);
                    return true;
                }
            }
            this.writeNotFound(os);
            return true;
        }
        if (get.startsWith("/magnet10/options.js?") || get.startsWith("/magnet10/default.js?")) {
            String resp = "";
            resp = resp + this.getJS("magnetOptionsPreamble");
            resp = resp + this.getJSS("<a href=\\\"http://127.0.0.1:\"+(45100+magnetCurrentSlot)+\"/select/?\"+magnetQueryString+\"\\\" target=\\\"_blank\\\">");
            resp = resp + this.getJSS("<img src=\\\"http://127.0.0.1:\"+(45100+magnetCurrentSlot)+\"/magnet10/badge.img\\\">");
            resp = resp + this.getJSS("Download with Azureus");
            resp = resp + this.getJSS("</a>");
            resp = resp + this.getJS("magnetOptionsPostamble");
            resp = resp + "magnetOptionsPollSuccesses++";
            this.writeReply(os, "application/x-javascript", resp);
            return true;
        }
        if (get.startsWith("/magnet10/pause")) {
            try {
                Thread.sleep(250L);
            }
            catch (Throwable e) {
                // empty catch block
            }
            this.writeNotFound(os);
            return true;
        }
        if (get.startsWith("/select/")) {
            String fail_reason = "";
            boolean ok = false;
            String urn2 = (String)params.get("xt");
            if (urn2 == null) {
                fail_reason = "xt missing";
            } else {
                try {
                    URL magnet = new URL("magnet:?xt=" + urn2);
                    for (int i = 0; i < this.listeners.size(); ++i) {
                        if (!((MagnetURIHandlerListener)this.listeners.get(i)).download(magnet)) continue;
                        ok = true;
                        break;
                    }
                    if (!ok) {
                        fail_reason = "No listeners accepted the operation";
                    }
                }
                catch (Throwable e) {
                    Debug.printStackTrace(e);
                    fail_reason = Debug.getNestedExceptionMessage(e);
                }
            }
            if (ok) {
                if ("image".equalsIgnoreCase((String)params.get("result"))) {
                    for (int i = 0; i < this.listeners.size(); ++i) {
                        byte[] data = ((MagnetURIHandlerListener)this.listeners.get(i)).badge();
                        if (data == null) continue;
                        this.writeReply(os, "image/gif", data);
                        return true;
                    }
                }
                this.writeReply(os, "text/plain", "Download initiated");
            } else {
                this.writeReply(os, "text/plain", "Download initiation failed: " + fail_reason);
            }
        } else if (get.startsWith("/download/")) {
            urn = (String)params.get("xt");
            if (urn == null || !urn.startsWith("urn:sha1:") && !urn.startsWith("urn:btih:")) {
                if (Logger.isEnabled()) {
                    Logger.log(new LogEvent(LOGID, 1, "MagnetURIHandler: invalid command - '" + get + "'"));
                }
                return true;
            }
            final PrintWriter pw = new PrintWriter(new OutputStreamWriter(os, "UTF-8"));
            try {
                pw.print("HTTP/1.0 200 OK\r\n");
                pw.flush();
                String base_32 = urn.substring(9);
                ArrayList<InetSocketAddress> sources = new ArrayList<InetSocketAddress>();
                for (int i = 0; i < source_params.size(); ++i) {
                    String source = (String)source_params.get(i);
                    int p = source.indexOf(58);
                    if (p == -1) continue;
                    try {
                        InetSocketAddress sa = new InetSocketAddress(source.substring(0, p), Integer.parseInt(source.substring(p + 1)));
                        sources.add(sa);
                        continue;
                    }
                    catch (Throwable e) {
                        Debug.printStackTrace(e);
                    }
                }
                InetSocketAddress[] s = new InetSocketAddress[sources.size()];
                sources.toArray(s);
                if (Logger.isEnabled()) {
                    Logger.log(new LogEvent(LOGID, "MagnetURIHandler: download of '" + base_32 + "' starts (initial sources=" + s.length + ")"));
                }
                byte[] sha1 = Base32.decode(base_32);
                byte[] data = null;
                for (int i = 0; i < this.listeners.size() && (data = ((MagnetURIHandlerListener)this.listeners.get(i)).download(new MagnetURIHandlerProgressListener(){

                    public void reportSize(long size) {
                        pw.print("X-Report: " + MagnetURIHandlerImpl.this.getMessageText("torrent_size", String.valueOf(size)) + MagnetURIHandlerImpl.NL);
                        pw.flush();
                    }

                    public void reportActivity(String str) {
                        pw.print("X-Report: " + str + MagnetURIHandlerImpl.NL);
                        pw.flush();
                    }

                    public void reportCompleteness(int percent) {
                        pw.print("X-Report: " + MagnetURIHandlerImpl.this.getMessageText("percent", String.valueOf(percent)) + MagnetURIHandlerImpl.NL);
                        pw.flush();
                    }
                }, sha1, s, 180000L)) == null; ++i) {
                }
                if (Logger.isEnabled()) {
                    Logger.log(new LogEvent(LOGID, "MagnetURIHandler: download of '" + base_32 + "' completes, data " + (data == null ? "not found" : "found, length = " + data.length)));
                }
                if (data == null) {
                    pw.print("X-Report: error: " + this.getMessageText("no_sources") + NL);
                    pw.flush();
                    return !params.containsKey("pause_on_error");
                }
                pw.print("Content-Length: " + data.length + NL + NL);
                pw.flush();
                os.write(data);
                os.flush();
            }
            catch (Throwable e) {
                pw.print("X-Report: error: " + this.getMessageText("error", Debug.getNestedExceptionMessage(e)) + NL);
                pw.flush();
                return !params.containsKey("pause_on_error");
            }
        }
        return true;
    }

    protected String getMessageText(String resource) {
        return MessageText.getString("MagnetURLHandler.report." + resource);
    }

    protected String getMessageText(String resource, String param) {
        return MessageText.getString("MagnetURLHandler.report." + resource, new String[]{param});
    }

    protected String getJS(String s) {
        return "document.write(" + s + ");" + NL;
    }

    protected String getJSS(String s) {
        return "document.write(\"" + s + "\");" + NL;
    }

    protected void writeReply(OutputStream os, String content_type, String content) throws IOException {
        this.writeReply(os, content_type, content.getBytes());
    }

    protected void writeReply(OutputStream os, String content_type, byte[] content) throws IOException {
        PrintWriter pw = new PrintWriter(new OutputStreamWriter(os));
        pw.print("HTTP/1.1 200 OK\r\n");
        pw.print("Cache-Control: no-cache\r\n");
        pw.print("Pragma: no-cache\r\n");
        pw.print("Content-Type: " + content_type + NL);
        pw.print("Content-Length: " + content.length + NL + NL);
        pw.flush();
        os.write(content);
    }

    protected void writeNotFound(OutputStream os) throws IOException {
        PrintWriter pw = new PrintWriter(new OutputStreamWriter(os));
        pw.print("HTTP/1.0 404 Not Found\r\n\r\n");
        pw.flush();
    }

    public int getPort() {
        return this.port;
    }

    public void addListener(MagnetURIHandlerListener l) {
        this.listeners.add(l);
    }

    public void removeListener(MagnetURIHandlerListener l) {
        this.listeners.remove(l);
    }

    public static void main(String[] args) {
        new MagnetURIHandlerImpl();
        try {
            Thread.sleep(1000000L);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    static {
        class_mon = new AEMonitor("MagnetURLHandler:class");
    }
}

