/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.core3.internat;

import java.util.Enumeration;
import java.util.Hashtable;
import java.util.ListResourceBundle;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import org.gudy.azureus2.core3.internat.MessageText;

public class IntegratedResourceBundle
extends ListResourceBundle {
    private Locale locale;
    private Object[][] contents;

    public IntegratedResourceBundle(ResourceBundle main, Map localizationPaths) {
        this.locale = main.getLocale();
        Hashtable messages = new Hashtable();
        this.addResourceMessages(main, messages);
        for (String localizationPath : localizationPaths.keySet()) {
            ClassLoader classLoader = (ClassLoader)localizationPaths.get(localizationPath);
            ResourceBundle newResourceBundle = null;
            try {
                newResourceBundle = classLoader != null ? ResourceBundle.getBundle(localizationPath, this.locale, classLoader) : ResourceBundle.getBundle(localizationPath, this.locale, IntegratedResourceBundle.class.getClassLoader());
            }
            catch (Exception e) {
                try {
                    newResourceBundle = classLoader != null ? ResourceBundle.getBundle(localizationPath, MessageText.LOCALE_DEFAULT, classLoader) : ResourceBundle.getBundle(localizationPath, MessageText.LOCALE_DEFAULT, IntegratedResourceBundle.class.getClassLoader());
                }
                catch (Exception e2) {
                    System.out.println(localizationPath + ": no default resource bundle");
                    continue;
                }
            }
            this.addResourceMessages(newResourceBundle, messages);
        }
        this.contents = new Object[messages.size()][2];
        int i = 0;
        Enumeration enumeration = messages.keys();
        while (enumeration.hasMoreElements()) {
            String key = (String)enumeration.nextElement();
            this.contents[i][0] = key;
            this.contents[i++][1] = messages.get(key);
        }
    }

    public Locale getLocale() {
        return this.locale;
    }

    public Object[][] getContents() {
        return this.contents;
    }

    private void addResourceMessages(ResourceBundle bundle, Hashtable messages) {
        if (bundle != null) {
            Enumeration<String> enumeration = bundle.getKeys();
            while (enumeration.hasMoreElements()) {
                String key = enumeration.nextElement();
                messages.put(key, bundle.getObject(key));
            }
        }
    }
}

