/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.core3.torrent.impl;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import org.gudy.azureus2.core3.html.HTMLUtils;
import org.gudy.azureus2.core3.torrent.TOTorrent;
import org.gudy.azureus2.core3.torrent.TOTorrentAnnounceURLSet;
import org.gudy.azureus2.core3.torrent.TOTorrentException;
import org.gudy.azureus2.core3.torrent.impl.TOTorrentFileImpl;
import org.gudy.azureus2.core3.torrent.impl.TOTorrentImpl;
import org.gudy.azureus2.core3.util.BDecoder;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.core3.util.TorrentUtils;

public class TOTorrentDeserialiseImpl
extends TOTorrentImpl {
    public TOTorrentDeserialiseImpl(File file) throws TOTorrentException {
        if (!file.isFile()) {
            throw new TOTorrentException("TOTorrentDeserialise: Torrent must be a file ('" + file.getName() + "')", 1);
        }
        if (file.length() == 0L) {
            throw new TOTorrentException("TOTorrentDeserialise: Torrent is zero length ('" + file.getName() + "')", 2);
        }
        FileInputStream fis = null;
        try {
            fis = new FileInputStream(file);
            this.construct(fis);
        }
        catch (IOException e) {
            throw new TOTorrentException("TOTorrentDeserialise: IO exception reading torrent '" + e.toString() + "'", 4);
        }
        finally {
            if (fis != null) {
                try {
                    fis.close();
                }
                catch (IOException e) {
                    Debug.printStackTrace(e);
                }
            }
        }
    }

    public TOTorrentDeserialiseImpl(InputStream is) throws TOTorrentException {
        this.construct(is);
    }

    public TOTorrentDeserialiseImpl(byte[] bytes) throws TOTorrentException {
        this.construct(bytes);
    }

    public TOTorrentDeserialiseImpl(Map map) throws TOTorrentException {
        this.construct(map);
    }

    protected void construct(InputStream is) throws TOTorrentException {
        ByteArrayOutputStream metaInfo = new ByteArrayOutputStream();
        try {
            int nbRead;
            byte[] buf = new byte[32768];
            int iFirstByte = is.read();
            if (iFirstByte != 100 && iFirstByte != 101 && iFirstByte != 105 && (iFirstByte < 48 || iFirstByte > 57)) {
                block9: {
                    try {
                        int nbRead2;
                        metaInfo.write(iFirstByte);
                        while ((nbRead2 = is.read(buf)) > 0 && metaInfo.size() < 32000) {
                            metaInfo.write(buf, 0, nbRead2);
                        }
                        String char_data = new String(metaInfo.toByteArray());
                        if (char_data.toLowerCase().indexOf("html") != -1) {
                            char_data = HTMLUtils.convertHTMLToText2(char_data);
                            if ((char_data = HTMLUtils.splitWithLineLength(char_data, 80)).length() > 400) {
                                char_data = char_data.substring(0, 400) + "...";
                            }
                            throw new TOTorrentException("Contents maybe HTML:\n" + char_data, 6);
                        }
                    }
                    catch (Throwable e) {
                        if (!(e instanceof TOTorrentException)) break block9;
                        throw (TOTorrentException)e;
                    }
                }
                throw new TOTorrentException("Contents invalid - bad header", 6);
            }
            metaInfo.write(iFirstByte);
            while ((nbRead = is.read(buf)) > 0) {
                metaInfo.write(buf, 0, nbRead);
            }
        }
        catch (IOException e) {
            throw new TOTorrentException("TOTorrentDeserialise: IO exception reading torrent '" + e.toString() + "'", 4);
        }
        this.construct(metaInfo.toByteArray());
    }

    protected void construct(byte[] bytes) throws TOTorrentException {
        try {
            Map meta_data = BDecoder.decode(bytes);
            this.construct(meta_data);
        }
        catch (IOException e) {
            throw new TOTorrentException("IO Error: " + e.getMessage(), 6);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void construct(Map meta_data) throws TOTorrentException {
        try {
            Map info;
            int i;
            String announce_url = null;
            boolean got_announce = false;
            boolean got_announce_list = false;
            boolean bad_announce = false;
            for (String key : meta_data.keySet()) {
                if (key.equalsIgnoreCase("announce")) {
                    got_announce = true;
                    announce_url = this.readStringFromMetaData(meta_data, "announce");
                    if (announce_url == null) {
                        bad_announce = true;
                        continue;
                    }
                    announce_url = announce_url.replaceAll(" ", "");
                    try {
                        this.setAnnounceURL(new URL(announce_url));
                    }
                    catch (MalformedURLException e) {
                        if (announce_url.indexOf("://") == -1) {
                            announce_url = "http:/" + (announce_url.startsWith("/") ? "" : "/") + announce_url;
                        }
                        try {
                            this.setAnnounceURL(new URL(announce_url));
                        }
                        catch (MalformedURLException f) {
                            bad_announce = true;
                        }
                    }
                    continue;
                }
                if (key.equalsIgnoreCase("announce-list")) {
                    got_announce_list = true;
                    List announce_list = null;
                    Object ann_list = meta_data.get("announce-list");
                    if (ann_list instanceof List) {
                        announce_list = (List)ann_list;
                    }
                    if (announce_list == null || announce_list.size() <= 0) continue;
                    announce_url = this.readStringFromMetaData(meta_data, "announce");
                    if (announce_url != null) {
                        announce_url = announce_url.replaceAll(" ", "");
                    }
                    boolean announce_url_found = false;
                    for (i = 0; i < announce_list.size(); ++i) {
                        List set = (List)announce_list.get(i);
                        Vector<URL> urls = new Vector<URL>();
                        for (int j = 0; j < set.size(); ++j) {
                            String url_str = this.readStringFromMetaData((byte[])set.get(j));
                            url_str = url_str.replaceAll(" ", "");
                            try {
                                urls.add(new URL(url_str));
                                if (!url_str.equalsIgnoreCase(announce_url)) continue;
                                announce_url_found = true;
                                continue;
                            }
                            catch (MalformedURLException e) {
                                if (url_str.indexOf("://") == -1) {
                                    url_str = "http:/" + (url_str.startsWith("/") ? "" : "/") + url_str;
                                }
                                try {
                                    urls.add(new URL(url_str));
                                    if (!url_str.equalsIgnoreCase(announce_url)) continue;
                                    announce_url_found = true;
                                    continue;
                                }
                                catch (MalformedURLException f) {
                                    Debug.printStackTrace(f);
                                }
                            }
                        }
                        if (urls.size() <= 0) continue;
                        Object[] url_array = new URL[urls.size()];
                        urls.copyInto(url_array);
                        this.addTorrentAnnounceURLSet((URL[])url_array);
                    }
                    if (announce_url_found || announce_url == null || announce_url.length() <= 0) continue;
                    try {
                        Vector<URL> urls = new Vector<URL>();
                        urls.add(new URL(announce_url));
                        Object[] url_array = new URL[urls.size()];
                        urls.copyInto(url_array);
                        this.addTorrentAnnounceURLSet((URL[])url_array);
                    }
                    catch (Exception e) {
                        Debug.printStackTrace(e);
                    }
                    continue;
                }
                if (key.equalsIgnoreCase("comment")) {
                    this.setComment((byte[])meta_data.get("comment"));
                    continue;
                }
                if (key.equalsIgnoreCase("created by")) {
                    this.setCreatedBy((byte[])meta_data.get("created by"));
                    continue;
                }
                if (key.equalsIgnoreCase("creation date")) {
                    try {
                        Long creation_date = (Long)meta_data.get("creation date");
                        if (creation_date == null) continue;
                        this.setCreationDate(creation_date);
                    }
                    catch (Exception e) {
                        System.out.println("TOTorrentDeserialise: creation_date extraction fails, ignoring");
                    }
                    continue;
                }
                if (key.equalsIgnoreCase("info")) continue;
                Object prop = meta_data.get(key);
                if (prop instanceof byte[]) {
                    this.setAdditionalByteArrayProperty(key, (byte[])prop);
                    continue;
                }
                if (prop instanceof Long) {
                    this.setAdditionalLongProperty(key, (Long)prop);
                    continue;
                }
                if (prop instanceof List) {
                    this.setAdditionalListProperty(key, (List)prop);
                    continue;
                }
                this.setAdditionalMapProperty(key, (Map)prop);
            }
            if (bad_announce) {
                if (!got_announce_list) throw new TOTorrentException("ANNOUNCE_URL malformed ('" + announce_url + "'", 6);
                TOTorrentAnnounceURLSet[] sets = this.getAnnounceURLGroup().getAnnounceURLSets();
                if (sets.length <= 0) throw new TOTorrentException("ANNOUNCE_URL malformed ('" + announce_url + "' and no usable announce list)", 6);
                this.setAnnounceURL(sets[0].getAnnounceURLs()[0]);
            }
            if (!got_announce_list && !got_announce) {
                this.setAnnounceURL(TorrentUtils.getDecentralisedEmptyURL());
            }
            if ((info = (Map)meta_data.get("info")) == null) {
                throw new TOTorrentException("Decode fails, 'info' element not found'", 6);
            }
            this.setName((byte[])info.get("name"));
            this.setHashFromInfo(info);
            Long simple_file_length = (Long)info.get("length");
            if (simple_file_length != null) {
                this.setSimpleTorrent(true);
                this.setFiles(new TOTorrentFileImpl[]{new TOTorrentFileImpl((TOTorrent)this, (long)simple_file_length, new byte[][]{this.getName()})});
            } else {
                this.setSimpleTorrent(false);
                List meta_files = (List)info.get("files");
                TOTorrentFileImpl[] files = new TOTorrentFileImpl[meta_files.size()];
                for (i = 0; i < files.length; ++i) {
                    Map file_map = (Map)meta_files.get(i);
                    long len = (Long)file_map.get("length");
                    List paths = (List)file_map.get("path");
                    byte[][] path_comps = new byte[paths.size()][];
                    for (int j = 0; j < paths.size(); ++j) {
                        path_comps[j] = (byte[])paths.get(j);
                    }
                    TOTorrentFileImpl file = files[i] = new TOTorrentFileImpl((TOTorrent)this, len, path_comps);
                    for (String key : file_map.keySet()) {
                        if (key.equals("length") || key.equals("path")) continue;
                        file.setAdditionalProperty(key, file_map.get(key));
                    }
                }
                this.setFiles(files);
            }
            this.setPieceLength((Long)info.get("piece length"));
            byte[] flat_pieces = (byte[])info.get("pieces");
            byte[][] pieces = new byte[flat_pieces.length / 20][20];
            for (i = 0; i < pieces.length; ++i) {
                System.arraycopy(flat_pieces, i * 20, pieces[i], 0, 20);
            }
            this.setPieces(pieces);
            for (String key : info.keySet()) {
                if (key.equals("name") || key.equals("length") || key.equals("files") || key.equals("piece length") || key.equals("pieces")) continue;
                this.addAdditionalInfoProperty(key, info.get(key));
            }
            return;
        }
        catch (Throwable e) {
            if (!(e instanceof TOTorrentException)) throw new TOTorrentException("Decode fails '" + e.toString() + "'", 6, e);
            throw (TOTorrentException)e;
        }
    }

    public void printMap() {
        try {
            this.print("", "root", this.serialiseToMap());
        }
        catch (TOTorrentException e) {
            Debug.printStackTrace(e);
        }
    }

    protected void print(String indent, String name, Map map) {
        System.out.println(indent + name + "{map}");
        Set keys = map.keySet();
        for (String key : keys) {
            Object value = map.get(key);
            if (value instanceof Map) {
                this.print(indent + "  ", key, (Map)value);
                continue;
            }
            if (value instanceof List) {
                this.print(indent + "  ", key, (List)value);
                continue;
            }
            if (value instanceof Long) {
                this.print(indent + "  ", key, (Long)value);
                continue;
            }
            this.print(indent + "  ", key, (byte[])value);
        }
    }

    protected void print(String indent, String name, List list) {
        System.out.println(indent + name + "{list}");
        Iterator it = list.iterator();
        int index = 0;
        while (it.hasNext()) {
            Object value = it.next();
            if (value instanceof Map) {
                this.print(indent + "  ", "[" + index + "]", (Map)value);
            } else if (value instanceof List) {
                this.print(indent + "  ", "[" + index + "]", (List)value);
            } else if (value instanceof Long) {
                this.print(indent + "  ", "[" + index + "]", (Long)value);
            } else {
                this.print(indent + "  ", "[" + index + "]", (byte[])value);
            }
            ++index;
        }
    }

    protected void print(String indent, String name, Long value) {
        System.out.println(indent + name + "{long} = " + value);
    }

    protected void print(String indent, String name, byte[] value) {
        String x = new String(value);
        boolean print = true;
        for (int i = 0; i < x.length(); ++i) {
            char c = x.charAt(i);
            if (c < '\u0080') continue;
            print = false;
            break;
        }
        if (print) {
            System.out.println(indent + name + "{byte[]} = " + x);
        } else {
            System.out.println(indent + name + "{byte[], length " + value.length + "}");
        }
    }
}

