/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.core3.tracker.server.impl;

import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.TreeMap;
import org.gudy.azureus2.core3.logging.LogEvent;
import org.gudy.azureus2.core3.logging.LogIDs;
import org.gudy.azureus2.core3.logging.Logger;
import org.gudy.azureus2.core3.tracker.server.TRTrackerServerException;
import org.gudy.azureus2.core3.tracker.server.TRTrackerServerPeer;
import org.gudy.azureus2.core3.tracker.server.TRTrackerServerTorrent;
import org.gudy.azureus2.core3.tracker.server.TRTrackerServerTorrentListener;
import org.gudy.azureus2.core3.tracker.server.TRTrackerServerTorrentPeerListener;
import org.gudy.azureus2.core3.tracker.server.TRTrackerServerTorrentStats;
import org.gudy.azureus2.core3.tracker.server.impl.TRTrackerServerImpl;
import org.gudy.azureus2.core3.tracker.server.impl.TRTrackerServerNATChecker;
import org.gudy.azureus2.core3.tracker.server.impl.TRTrackerServerPeerImpl;
import org.gudy.azureus2.core3.tracker.server.impl.TRTrackerServerTorrentStatsImpl;
import org.gudy.azureus2.core3.util.AEMonitor;
import org.gudy.azureus2.core3.util.ByteFormatter;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.core3.util.HashWrapper;
import org.gudy.azureus2.core3.util.HostNameToIPResolver;
import org.gudy.azureus2.core3.util.SystemTime;

public class TRTrackerServerTorrentImpl
implements TRTrackerServerTorrent {
    private static final LogIDs LOGID = LogIDs.TRACKER;
    public static final int MIN_CACHE_ENTRY_SIZE = 10;
    public static final int MAX_UPLOAD_BYTES_PER_SEC = 0x300000;
    public static final int MAX_DOWNLOAD_BYTES_PER_SEC = 0x300000;
    public static final boolean USE_LIGHTWEIGHT_SEEDS = true;
    public static final int MAX_IP_OVERRIDE_PEERS = 64;
    public static final byte COMPACT_MODE_NONE = 0;
    public static final byte COMPACT_MODE_NORMAL = 1;
    public static final byte COMPACT_MODE_AZ = 2;
    private static final int QUEUED_PEERS_MAX_SWARM_SIZE = 32;
    private static final int QUEUED_PEERS_MAX = 32;
    private static final int QUEUED_PEERS_ADD_MAX = 3;
    private HashWrapper hash;
    private Map peer_map = new HashMap();
    private Map peer_reuse_map = new HashMap();
    private List peer_list = new ArrayList();
    private int peer_list_hole_count;
    private boolean peer_list_compaction_suspended;
    private Map lightweight_seed_map = new HashMap();
    private int seed_count;
    private int removed_count;
    private int ip_override_count;
    private int bad_NAT_count;
    private Random random = new Random(SystemTime.getCurrentTime());
    private long last_scrape_calc_time;
    private Map last_scrape;
    private LinkedHashMap announce_cache = new LinkedHashMap();
    private TRTrackerServerTorrentStatsImpl stats;
    private List listeners = new ArrayList();
    private List peer_listeners;
    private boolean deleted;
    private boolean enabled;
    private boolean map_size_diff_reported;
    private boolean ip_override_limit_exceeded_reported;
    private byte duplicate_peer_checker_index = 0;
    private byte[] duplicate_peer_checker = new byte[0];
    private URL[] redirects;
    private boolean caching_enabled = true;
    private LinkedList queued_peers;
    protected AEMonitor this_mon = new AEMonitor("TRTrackerServerTorrent");

    public TRTrackerServerTorrentImpl(HashWrapper _hash, boolean _enabled) {
        this.hash = _hash;
        this.enabled = _enabled;
        this.stats = new TRTrackerServerTorrentStatsImpl(this);
    }

    public void setEnabled(boolean _enabled) {
        this.enabled = _enabled;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TRTrackerServerPeerImpl peerContact(String url_parameters, String event2, HashWrapper peer_id, int tcp_port, int udp_port, byte crypto_level, String ip_address, boolean ip_override, boolean loopback, String tracker_key, long uploaded, long downloaded, long left, long interval_requested) throws TRTrackerServerException {
        if (!this.enabled) {
            throw new TRTrackerServerException("Torrent temporarily disabled");
        }
        if (!HostNameToIPResolver.isNonDNSName(ip_address)) {
            try {
                ip_address = HostNameToIPResolver.syncResolve(ip_address).getHostAddress();
            }
            catch (UnknownHostException e) {
                Debug.printStackTrace(e);
            }
        }
        TRTrackerServerException deferred_failure = null;
        try {
            this.this_mon.enter();
            this.handleRedirects(url_parameters, ip_address, false);
            int event_type = 2;
            if (event2 != null && event2.length() > 2) {
                char c = event2.charAt(2);
                event_type = c == 'm' ? 3 : (c == 'o' ? 4 : 1);
            }
            long now = SystemTime.getCurrentTime();
            int tracker_key_hash_code = tracker_key == null ? 0 : tracker_key.hashCode();
            TRTrackerServerPeerImpl peer = (TRTrackerServerPeerImpl)this.peer_map.get(peer_id);
            boolean new_peer = false;
            boolean peer_already_removed = false;
            boolean already_completed = false;
            long last_contact_time = 0L;
            long ul_diff = 0L;
            long dl_diff = 0L;
            long le_diff = 0L;
            byte[] ip_address_bytes = ip_address.getBytes("ISO-8859-1");
            if (peer == null) {
                lightweightSeed lws;
                String reuse_key = new String(ip_address_bytes, "ISO-8859-1") + ":" + tcp_port;
                byte last_NAT_status = loopback ? (byte)3 : 0;
                new_peer = true;
                TRTrackerServerPeerImpl old_peer = (TRTrackerServerPeerImpl)this.peer_reuse_map.get(reuse_key);
                if (old_peer != null) {
                    if (ip_override && !old_peer.isIPOverride()) {
                        throw new TRTrackerServerException("IP Override denied");
                    }
                    last_contact_time = old_peer.getLastContactTime();
                    already_completed = old_peer.getDownloadCompleted();
                    this.removePeer(old_peer, 5);
                    this.lightweight_seed_map.remove(old_peer.getPeerId());
                } else {
                    lws = (lightweightSeed)this.lightweight_seed_map.remove(peer_id);
                    if (lws != null) {
                        last_contact_time = lws.getLastContactTime();
                        ul_diff = uploaded - lws.getUploaded();
                        if (ul_diff < 0L) {
                            ul_diff = 0L;
                        }
                        last_NAT_status = lws.getNATStatus();
                    } else {
                        last_contact_time = now;
                    }
                }
                if (event_type != 4) {
                    if (ip_override && this.ip_override_count >= 64 && !loopback) {
                        if (!this.ip_override_limit_exceeded_reported) {
                            this.ip_override_limit_exceeded_reported = true;
                            Debug.out("Too many ip-override peers for " + ByteFormatter.encodeString(this.hash.getBytes()));
                        }
                        lws = null;
                        return lws;
                    }
                    peer = new TRTrackerServerPeerImpl(peer_id, tracker_key_hash_code, ip_address_bytes, ip_override, tcp_port, udp_port, crypto_level, last_contact_time, already_completed, last_NAT_status);
                    if (ip_override) {
                        ++this.ip_override_count;
                    }
                    this.peer_map.put(peer_id, peer);
                    this.peer_list.add(peer);
                    this.peer_reuse_map.put(reuse_key, peer);
                    if (this.queued_peers != null) {
                        if (this.peer_map.size() > 32) {
                            this.queued_peers = null;
                        } else {
                            Iterator it = this.queued_peers.iterator();
                            while (it.hasNext()) {
                                QueuedPeer qp = (QueuedPeer)it.next();
                                if (!qp.sameAs(peer)) continue;
                                it.remove();
                                break;
                            }
                        }
                    }
                }
            } else {
                int existing_tracker_key_hash_code = peer.getKeyHashCode();
                if (existing_tracker_key_hash_code != tracker_key_hash_code) {
                    throw new TRTrackerServerException("Unauthorised: key mismatch ");
                }
                if (ip_override && !peer.isIPOverride()) {
                    throw new TRTrackerServerException("IP Override denied");
                }
                already_completed = peer.getDownloadCompleted();
                last_contact_time = peer.getLastContactTime();
                if (event_type == 4) {
                    this.removePeer(peer, event_type);
                    peer_already_removed = true;
                } else {
                    byte[] old_ip = peer.getIPAsRead();
                    int old_port = peer.getTCPPort();
                    if (peer.checkForIPOrPortChange(ip_address_bytes, tcp_port, udp_port, crypto_level)) {
                        String old_key = new String(old_ip, "ISO-8859-1") + ":" + old_port;
                        String new_key = new String(ip_address_bytes, "ISO-8859-1") + ":" + tcp_port;
                        TRTrackerServerPeerImpl old_peer = (TRTrackerServerPeerImpl)this.peer_reuse_map.get(new_key);
                        if (old_peer != null) {
                            this.removePeer(old_peer, 5);
                        }
                        if (this.peer_reuse_map.remove(old_key) == null) {
                            Debug.out("TRTrackerServerTorrent: IP address change: '" + old_key + "' -> '" + new_key + "': old key not found");
                        }
                        this.peer_reuse_map.put(new_key, peer);
                    }
                }
            }
            long new_timeout = now + interval_requested * 1000L * (long)TRTrackerServerImpl.CLIENT_TIMEOUT_MULTIPLIER;
            if (peer != null) {
                long elapsed_time;
                if (!peer_already_removed) {
                    try {
                        this.peerEvent(peer, event_type);
                    }
                    catch (TRTrackerServerException e) {
                        deferred_failure = e;
                    }
                }
                peer.setTimeout(now, new_timeout);
                if (!new_peer) {
                    ul_diff = uploaded - peer.getUploaded();
                    dl_diff = downloaded - peer.getDownloaded();
                }
                if ((elapsed_time = now - last_contact_time) == 0L) {
                    elapsed_time = 25L;
                }
                long ul_rate = ul_diff * 1000L / elapsed_time;
                long dl_rate = dl_diff * 1000L / elapsed_time;
                if (ul_rate > 0x300000L) {
                    if (Logger.isEnabled()) {
                        Logger.log(new LogEvent(LOGID, "TRTrackerPeer: peer " + peer.getIPRaw() + "/" + new String(peer.getPeerId().getHash()) + " reported an upload rate of " + ul_rate / 1024L + " KiB/s per second"));
                    }
                    ul_diff = 0L;
                }
                if (dl_rate > 0x300000L) {
                    if (Logger.isEnabled()) {
                        Logger.log(new LogEvent(LOGID, "TRTrackerPeer: peer " + peer.getIPRaw() + "/" + new String(peer.getPeerId().getHash()) + " reported a download rate of " + dl_rate / 1024L + " KiB/s per second"));
                    }
                    dl_diff = 0L;
                }
                le_diff = event_type == 4 ? 0L : left - peer.getAmountLeft();
                boolean was_seed = new_peer ? false : peer.isSeed();
                peer.setStats(uploaded, downloaded, left);
                boolean is_seed = peer.isSeed();
                if (event_type != 4 && !was_seed && is_seed) {
                    ++this.seed_count;
                }
            }
            this.stats.addAnnounce(ul_diff, dl_diff, le_diff);
            if (event_type == 3 && !already_completed) {
                peer.setDownloadCompleted();
                this.stats.addCompleted();
            }
            if (peer != null && peer.isSeed()) {
                int seed_limit = TRTrackerServerImpl.getSeedLimit();
                if (seed_limit != 0 && this.seed_count > seed_limit && !loopback) {
                    if (!peer_already_removed) {
                        this.removePeer(peer, 6);
                    }
                    throw new TRTrackerServerException("too many seeds");
                }
                int seed_retention = TRTrackerServerImpl.getMaxSeedRetention();
                if (seed_retention != 0 && this.seed_count > seed_retention) {
                    int to_remove = seed_retention / 20 + 1;
                    try {
                        int bad_nat_loop;
                        this.peer_list_compaction_suspended = true;
                        int n = bad_nat_loop = TRTrackerServerNATChecker.getSingleton().isEnabled() ? 0 : 1;
                        while (bad_nat_loop < 2) {
                            for (int i = 0; i < this.peer_list.size(); ++i) {
                                TRTrackerServerPeerImpl this_peer = (TRTrackerServerPeerImpl)this.peer_list.get(i);
                                if (this_peer == null || !this_peer.isSeed()) continue;
                                boolean bad_nat = this_peer.isNATStatusBad();
                                if ((bad_nat_loop != 0 || !bad_nat) && bad_nat_loop != 1) continue;
                                this.lightweight_seed_map.put(this_peer.getPeerId(), new lightweightSeed(now, new_timeout, this_peer.getUploaded(), this_peer.getNATStatus()));
                                this.removePeer(this_peer, i, 6);
                                if (--to_remove == 0) break;
                            }
                            if (to_remove == 0) {
                                break;
                            }
                            ++bad_nat_loop;
                        }
                    }
                    finally {
                        this.peer_list_compaction_suspended = false;
                    }
                    this.checkForPeerListCompaction(false);
                }
            }
            if (deferred_failure != null) {
                if (peer != null && !peer_already_removed) {
                    this.removePeer(peer, 7);
                }
                throw deferred_failure;
            }
            TRTrackerServerPeerImpl tRTrackerServerPeerImpl = peer;
            return tRTrackerServerPeerImpl;
        }
        catch (UnsupportedEncodingException e) {
            throw new TRTrackerServerException("Encoding fails", e);
        }
        finally {
            this.this_mon.exit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void peerQueued(String ip, int tcp_port, int udp_port, byte crypto_level, int timeout_secs) {
        if (this.peer_map.size() >= 32 || tcp_port == 0) {
            return;
        }
        try {
            this.this_mon.enter();
            QueuedPeer new_qp = new QueuedPeer(ip, tcp_port, udp_port, crypto_level, timeout_secs);
            String reuse_key = new String(new_qp.getIP(), "ISO-8859-1") + ":" + tcp_port;
            if (this.peer_reuse_map.containsKey(reuse_key)) {
                return;
            }
            if (this.queued_peers != null) {
                Iterator it = this.queued_peers.iterator();
                while (it.hasNext()) {
                    QueuedPeer qp = (QueuedPeer)it.next();
                    if (!qp.sameAs(new_qp)) continue;
                    it.remove();
                    this.queued_peers.add(new_qp);
                    return;
                }
                if (this.queued_peers.size() >= 32) {
                    QueuedPeer oldest = null;
                    for (QueuedPeer qp : this.queued_peers) {
                        if (oldest == null) {
                            oldest = qp;
                            continue;
                        }
                        if (qp.getCreateTime() >= oldest.getCreateTime()) continue;
                        oldest = qp;
                    }
                    this.queued_peers.remove(oldest);
                }
            } else {
                this.queued_peers = new LinkedList();
            }
            this.queued_peers.addFirst(new_qp);
        }
        catch (UnsupportedEncodingException e) {
            Debug.printStackTrace(e);
        }
        finally {
            this.this_mon.exit();
        }
    }

    protected void removePeer(TRTrackerServerPeerImpl peer, int reason) {
        this.removePeer(peer, -1, reason);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void removePeer(TRTrackerServerPeerImpl peer, int peer_list_index, int reason) {
        try {
            Object o;
            this.this_mon.enter();
            if (peer.isIPOverride()) {
                --this.ip_override_count;
            }
            this.stats.removeLeft(peer.getAmountLeft());
            if (this.peer_map.size() != this.peer_reuse_map.size() && !this.map_size_diff_reported) {
                this.map_size_diff_reported = true;
                Debug.out("TRTrackerServerTorrent::removePeer: maps size different ( " + this.peer_map.size() + "/" + this.peer_reuse_map.size() + ")");
            }
            if ((o = this.peer_map.remove(peer.getPeerId())) == null) {
                Debug.out(" TRTrackerServerTorrent::removePeer: peer_map doesn't contain peer");
            } else {
                try {
                    this.peerEvent(peer, reason);
                }
                catch (TRTrackerServerException e) {
                    // empty catch block
                }
            }
            if (peer_list_index == -1) {
                int peer_index = this.peer_list.indexOf(peer);
                if (peer_index == -1) {
                    Debug.out(" TRTrackerServerTorrent::removePeer: peer_list doesn't contain peer");
                } else {
                    this.peer_list.set(peer_index, null);
                }
            } else if (this.peer_list.get(peer_list_index) == peer) {
                this.peer_list.set(peer_list_index, null);
            } else {
                Debug.out(" TRTrackerServerTorrent::removePeer: peer_list doesn't contain peer at index");
            }
            ++this.peer_list_hole_count;
            this.checkForPeerListCompaction(false);
            try {
                o = this.peer_reuse_map.remove(new String(peer.getIPAsRead(), "ISO-8859-1") + ":" + peer.getTCPPort());
                if (o == null) {
                    Debug.out(" TRTrackerServerTorrent::removePeer: peer_reuse_map doesn't contain peer");
                }
            }
            catch (UnsupportedEncodingException e) {
                // empty catch block
            }
            if (peer.isSeed()) {
                --this.seed_count;
            }
            ++this.removed_count;
        }
        finally {
            this.this_mon.exit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map exportAnnounceToMap(HashMap preprocess_map, TRTrackerServerPeerImpl requesting_peer, boolean include_seeds, int num_want, long interval, long min_interval, boolean no_peer_id, byte compact_mode, byte crypto_level) {
        try {
            int i;
            this.this_mon.enter();
            long now = SystemTime.getCurrentTime();
            boolean nat_warning = requesting_peer != null && requesting_peer.getNATStatus() == 4;
            int total_peers = this.peer_map.size();
            int cache_millis = TRTrackerServerImpl.getAnnounceCachePeriod();
            boolean send_peer_ids = TRTrackerServerImpl.getSendPeerIds();
            if (no_peer_id || compact_mode != 0) {
                send_peer_ids = false;
            }
            boolean add_to_cache = false;
            int max_peers = TRTrackerServerImpl.getMaxPeersToSend();
            if (num_want < 0) {
                num_want = total_peers;
            }
            if (max_peers > 0 && num_want > max_peers) {
                num_want = max_peers;
            }
            if (this.caching_enabled && !nat_warning && preprocess_map.size() == 0 && cache_millis > 0 && num_want >= 10 && total_peers >= TRTrackerServerImpl.getAnnounceCachePeerThreshold() && crypto_level != 2) {
                announceCacheEntry entry;
                Iterator it = this.announce_cache.keySet().iterator();
                while (it.hasNext()) {
                    Integer key = (Integer)it.next();
                    entry = (announceCacheEntry)this.announce_cache.get(key);
                    if (now - entry.getTime() <= (long)cache_millis) continue;
                    it.remove();
                }
                for (i = num_want / 10; i > num_want / 20; --i) {
                    entry = (announceCacheEntry)this.announce_cache.get(new Integer(i));
                    if (entry == null) continue;
                    if (now - entry.getTime() > (long)cache_millis) {
                        this.announce_cache.remove(new Integer(i));
                        continue;
                    }
                    if (entry.getSendPeerIds() != send_peer_ids || entry.getCompactMode() != compact_mode) continue;
                    Map map = entry.getData();
                    return map;
                }
                add_to_cache = true;
            }
            ArrayList rep_peers = new ArrayList();
            if (num_want > 0) {
                if (num_want >= total_peers) {
                    for (i = 0; i < this.peer_list.size(); ++i) {
                        TRTrackerServerPeerImpl peer = (TRTrackerServerPeerImpl)this.peer_list.get(i);
                        if (peer == null) continue;
                        if (now > peer.getTimeout()) {
                            this.removePeer(peer, i, 5);
                            continue;
                        }
                        if (peer.getTCPPort() == 0 || crypto_level == 0 && peer.getCryptoLevel() == 2 || !include_seeds && peer.isSeed()) continue;
                        HashMap<String, Object> rep_peer = new HashMap<String, Object>(3);
                        if (send_peer_ids) {
                            rep_peer.put("peer id", peer.getPeerId().getHash());
                        }
                        if (compact_mode != 0) {
                            byte[] peer_bytes = peer.getIPBytes();
                            if (peer_bytes == null) continue;
                            rep_peer.put("ip", peer_bytes);
                            if (compact_mode == 2) {
                                rep_peer.put("azudp", new Long(peer.getUDPPort()));
                            }
                        } else {
                            rep_peer.put("ip", peer.getIPAsRead());
                        }
                        rep_peer.put("port", new Long(peer.getTCPPort()));
                        if (crypto_level != 0) {
                            rep_peer.put("crypto_flag", new Long(peer.getCryptoLevel() == 2 ? 1L : 0L));
                        }
                        rep_peers.add(rep_peer);
                    }
                } else if (num_want < total_peers * 3) {
                    int peer_list_size = this.peer_list.size();
                    if (this.duplicate_peer_checker.length < peer_list_size) {
                        this.duplicate_peer_checker = new byte[peer_list_size * 2];
                        this.duplicate_peer_checker_index = 1;
                    } else if (this.duplicate_peer_checker.length > peer_list_size * 2) {
                        this.duplicate_peer_checker = new byte[3 * peer_list_size / 2];
                        this.duplicate_peer_checker_index = 1;
                    } else {
                        this.duplicate_peer_checker_index = (byte)(this.duplicate_peer_checker_index + 1);
                        if (this.duplicate_peer_checker_index == 0) {
                            Arrays.fill(this.duplicate_peer_checker, (byte)0);
                            this.duplicate_peer_checker_index = 1;
                        }
                    }
                    boolean peer_removed = false;
                    try {
                        int bad_nat_loop;
                        this.peer_list_compaction_suspended = true;
                        int added = 0;
                        int n = bad_nat_loop = TRTrackerServerNATChecker.getSingleton().isEnabled() ? 0 : 1;
                        while (bad_nat_loop < 2) {
                            int limit = num_want * 2;
                            for (int i2 = 0; i2 < limit && added < num_want; ++i2) {
                                int index = this.random.nextInt(peer_list_size);
                                TRTrackerServerPeerImpl peer = (TRTrackerServerPeerImpl)this.peer_list.get(index);
                                if (peer == null) continue;
                                if (now > peer.getTimeout()) {
                                    this.removePeer(peer, 5);
                                    peer_removed = true;
                                    continue;
                                }
                                if (peer.getTCPPort() == 0 || crypto_level == 0 && peer.getCryptoLevel() == 2 || !include_seeds && peer.isSeed()) continue;
                                boolean bad_nat = peer.isNATStatusBad();
                                if ((bad_nat_loop != 0 || bad_nat) && bad_nat_loop != 1 || this.duplicate_peer_checker[index] == this.duplicate_peer_checker_index) continue;
                                this.duplicate_peer_checker[index] = this.duplicate_peer_checker_index;
                                ++added;
                                HashMap<String, Object> rep_peer = new HashMap<String, Object>(3);
                                if (send_peer_ids) {
                                    rep_peer.put("peer id", peer.getPeerId().getHash());
                                }
                                if (compact_mode != 0) {
                                    byte[] peer_bytes = peer.getIPBytes();
                                    if (peer_bytes == null) continue;
                                    rep_peer.put("ip", peer_bytes);
                                    if (compact_mode == 2) {
                                        rep_peer.put("azudp", new Long(peer.getUDPPort()));
                                    }
                                } else {
                                    rep_peer.put("ip", peer.getIPAsRead());
                                }
                                rep_peer.put("port", new Long(peer.getTCPPort()));
                                if (crypto_level != 0) {
                                    rep_peer.put("crypto_flag", new Long(peer.getCryptoLevel() == 2 ? 1L : 0L));
                                }
                                rep_peers.add(rep_peer);
                            }
                            ++bad_nat_loop;
                        }
                    }
                    finally {
                        this.peer_list_compaction_suspended = false;
                        if (peer_removed) {
                            this.checkForPeerListCompaction(false);
                        }
                    }
                } else {
                    LinkedList peers = new LinkedList(this.peer_map.keySet());
                    int added = 0;
                    while (added < num_want && peers.size() > 0) {
                        String key = (String)peers.remove(this.random.nextInt(peers.size()));
                        TRTrackerServerPeerImpl peer = (TRTrackerServerPeerImpl)this.peer_map.get(key);
                        if (now > peer.getTimeout()) {
                            this.removePeer(peer, 5);
                            continue;
                        }
                        if (peer.getTCPPort() == 0 || crypto_level == 0 && peer.getCryptoLevel() == 2 || !include_seeds && peer.isSeed()) continue;
                        ++added;
                        HashMap<String, Object> rep_peer = new HashMap<String, Object>(3);
                        if (send_peer_ids) {
                            rep_peer.put("peer id", peer.getPeerId().getHash());
                        }
                        if (compact_mode != 0) {
                            byte[] peer_bytes = peer.getIPBytes();
                            if (peer_bytes == null) continue;
                            rep_peer.put("ip", peer_bytes);
                            if (compact_mode == 2) {
                                rep_peer.put("azudp", new Long(peer.getUDPPort()));
                            }
                        } else {
                            rep_peer.put("ip", peer.getIPAsRead());
                        }
                        rep_peer.put("port", new Long(peer.getTCPPort()));
                        if (crypto_level != 0) {
                            rep_peer.put("crypto_flag", new Long(peer.getCryptoLevel() == 2 ? 1L : 0L));
                        }
                        rep_peers.add(rep_peer);
                    }
                }
            }
            if (include_seeds && !send_peer_ids && this.seed_count < 3 && this.queued_peers != null) {
                Iterator it = this.queued_peers.iterator();
                ArrayList<QueuedPeer> added = new ArrayList<QueuedPeer>(3);
                while (it.hasNext() && num_want > rep_peers.size() && added.size() < 3) {
                    QueuedPeer peer = (QueuedPeer)it.next();
                    if (peer.isTimedOut(now)) {
                        it.remove();
                        continue;
                    }
                    if (crypto_level == 0 && peer.getCryptoLevel() == 2) continue;
                    HashMap<String, Object> rep_peer = new HashMap<String, Object>(3);
                    if (compact_mode != 0) {
                        byte[] peer_bytes = peer.getIPBytes();
                        if (peer_bytes == null) continue;
                        rep_peer.put("ip", peer_bytes);
                        if (compact_mode == 2) {
                            rep_peer.put("azudp", new Long(peer.getUDPPort()));
                        }
                    } else {
                        rep_peer.put("ip", peer.getIP());
                    }
                    rep_peer.put("port", new Long(peer.getTCPPort()));
                    if (crypto_level != 0) {
                        rep_peer.put("crypto_flag", new Long(peer.getCryptoLevel() == 2 ? 1L : 0L));
                    }
                    rep_peers.add(rep_peer);
                    added.add(peer);
                    it.remove();
                }
                for (int i3 = 0; i3 < added.size(); ++i3) {
                    this.queued_peers.add(added.get(i3));
                }
            }
            TreeMap<String, Object> root = new TreeMap<String, Object>();
            if (preprocess_map.size() > 0) {
                root.putAll(preprocess_map);
            }
            int num_peers_returned = rep_peers.size();
            if (compact_mode == 2) {
                byte[] compact_peers = new byte[num_peers_returned * 9];
                for (int i4 = 0; i4 < num_peers_returned; ++i4) {
                    Map rep_peer = (Map)rep_peers.get(i4);
                    byte[] ip = (byte[])rep_peer.get("ip");
                    int tcp_port = ((Long)rep_peer.get("port")).intValue();
                    int udp_port = ((Long)rep_peer.get("azudp")).intValue();
                    Long crypto_flag_l = (Long)rep_peer.get("crypto_flag");
                    byte crypto_flag = crypto_flag_l == null ? (byte)0 : crypto_flag_l.byteValue();
                    int pos = i4 * 9;
                    System.arraycopy(ip, 0, compact_peers, pos, 4);
                    pos += 4;
                    compact_peers[pos++] = (byte)(tcp_port >> 8);
                    compact_peers[pos++] = (byte)(tcp_port & 0xFF);
                    compact_peers[pos++] = (byte)(udp_port >> 8);
                    compact_peers[pos++] = (byte)(udp_port & 0xFF);
                    compact_peers[pos++] = crypto_flag;
                }
                root.put("peers", compact_peers);
                root.put("azcompact", new Long(1L));
            } else {
                byte[] crypto_flags = null;
                if (crypto_level != 0) {
                    crypto_flags = new byte[num_peers_returned];
                }
                if (compact_mode == 1) {
                    byte[] compact_peers = new byte[num_peers_returned * 6];
                    for (int i5 = 0; i5 < num_peers_returned; ++i5) {
                        Map rep_peer = (Map)rep_peers.get(i5);
                        byte[] ip = (byte[])rep_peer.get("ip");
                        int port = ((Long)rep_peer.get("port")).intValue();
                        int pos = i5 * 6;
                        System.arraycopy(ip, 0, compact_peers, pos, 4);
                        pos += 4;
                        compact_peers[pos++] = (byte)(port >> 8);
                        compact_peers[pos++] = (byte)(port & 0xFF);
                        if (crypto_flags == null) continue;
                        Long crypto_flag = (Long)rep_peer.remove("crypto_flag");
                        crypto_flags[i5] = crypto_flag.byteValue();
                    }
                    root.put("peers", compact_peers);
                } else {
                    for (int i6 = 0; i6 < num_peers_returned; ++i6) {
                        Map rep_peer = (Map)rep_peers.get(i6);
                        if (crypto_flags == null) continue;
                        Long crypto_flag = (Long)rep_peer.remove("crypto_flag");
                        crypto_flags[i6] = crypto_flag.byteValue();
                    }
                    root.put("peers", rep_peers);
                }
                if (crypto_flags != null) {
                    root.put("crypto_flags", crypto_flags);
                }
            }
            root.put("interval", new Long(interval));
            root.put("min interval", new Long(min_interval));
            if (nat_warning) {
                requesting_peer.setNATStatus((byte)5);
                root.put("warning message", ("Unable to connect to your incoming data port (" + requesting_peer.getIP() + ":" + requesting_peer.getTCPPort() + "). " + "This will result in slow downloads. Please check your firewall/router settings").getBytes());
            }
            root.put("complete", new Long(this.getSeedCount()));
            root.put("incomplete", new Long(this.getLeecherCount()));
            root.put("downloaded", new Long(this.stats.getCompletedCount()));
            if (add_to_cache) {
                this.announce_cache.put(new Integer((num_peers_returned + 9) / 10), new announceCacheEntry(root, send_peer_ids, compact_mode));
            }
            TreeMap<String, Object> treeMap = root;
            return treeMap;
        }
        finally {
            this.this_mon.exit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map exportScrapeToMap(String url_parameters, String ip_address, boolean allow_cache) throws TRTrackerServerException {
        try {
            this.this_mon.enter();
            this.handleRedirects(url_parameters, ip_address, true);
            this.stats.addScrape();
            long now = SystemTime.getCurrentTime();
            long diff = now - this.last_scrape_calc_time;
            if (allow_cache && this.last_scrape != null && diff < (long)TRTrackerServerImpl.getScrapeCachePeriod() && diff >= 0L) {
                Map map = this.last_scrape;
                return map;
            }
            this.last_scrape = new TreeMap();
            this.last_scrape_calc_time = now;
            this.last_scrape.put("complete", new Long(this.getSeedCount()));
            this.last_scrape.put("incomplete", new Long(this.getLeecherCount()));
            this.last_scrape.put("downloaded", new Long(this.stats.getCompletedCount()));
            Map map = this.last_scrape;
            return map;
        }
        finally {
            this.this_mon.exit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void checkTimeouts() {
        try {
            this.this_mon.enter();
            long now = SystemTime.getCurrentTime();
            int new_bad_NAT_count = 0;
            try {
                this.peer_list_compaction_suspended = true;
                for (int i = 0; i < this.peer_list.size(); ++i) {
                    TRTrackerServerPeerImpl peer = (TRTrackerServerPeerImpl)this.peer_list.get(i);
                    if (peer == null) continue;
                    if (now > peer.getTimeout()) {
                        this.removePeer(peer, i, 5);
                        continue;
                    }
                    if (!peer.isNATStatusBad()) continue;
                    ++new_bad_NAT_count;
                }
            }
            finally {
                this.peer_list_compaction_suspended = false;
            }
            this.bad_NAT_count = new_bad_NAT_count;
            if (this.removed_count > 1000) {
                this.removed_count = 0;
                this.checkForPeerListCompaction(true);
                HashMap new_peer_map = new HashMap(this.peer_map);
                HashMap new_peer_reuse_map = new HashMap(this.peer_reuse_map);
                this.peer_map = new_peer_map;
                this.peer_reuse_map = new_peer_reuse_map;
            } else {
                this.checkForPeerListCompaction(false);
            }
            Iterator it = this.lightweight_seed_map.values().iterator();
            while (it.hasNext()) {
                lightweightSeed lws = (lightweightSeed)it.next();
                if (now <= lws.getTimeout()) continue;
                it.remove();
            }
        }
        finally {
            this.this_mon.exit();
        }
    }

    protected void checkForPeerListCompaction(boolean force) {
        if (this.peer_list_hole_count > 0 && !this.peer_list_compaction_suspended && (force || this.peer_list_hole_count > this.peer_map.size() / 10)) {
            ArrayList new_peer_list = new ArrayList(this.peer_list.size() - this.peer_list_hole_count / 2);
            int holes_found = 0;
            for (int i = 0; i < this.peer_list.size(); ++i) {
                Object obj = this.peer_list.get(i);
                if (obj == null) {
                    ++holes_found;
                    continue;
                }
                new_peer_list.add(obj);
            }
            if (holes_found != this.peer_list_hole_count) {
                Debug.out("TRTrackerTorrent:compactHoles: count mismatch");
            }
            this.peer_list = new_peer_list;
            this.peer_list_hole_count = 0;
        }
    }

    protected void updateXferStats(int bytes_in, int bytes_out) {
        this.stats.addXferStats(bytes_in, bytes_out);
    }

    public TRTrackerServerTorrentStats getStats() {
        return this.stats;
    }

    public int getPeerCount() {
        return this.peer_map.size() + this.lightweight_seed_map.size();
    }

    public int getSeedCount() {
        if (this.seed_count < 0) {
            Debug.out("seed count negative");
        }
        return this.seed_count + this.lightweight_seed_map.size();
    }

    public int getLeecherCount() {
        int res = this.peer_map.size() - this.seed_count;
        return res < 0 ? 0 : res;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TRTrackerServerPeer[] getPeers() {
        try {
            this.this_mon.enter();
            TRTrackerServerPeer[] res = new TRTrackerServerPeer[this.peer_map.size()];
            this.peer_map.values().toArray(res);
            TRTrackerServerPeer[] tRTrackerServerPeerArray = res;
            return tRTrackerServerPeerArray;
        }
        finally {
            this.this_mon.exit();
        }
    }

    public HashWrapper getHash() {
        return this.hash;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setRedirects(URL[] urls) {
        try {
            this.this_mon.enter();
            this.redirects = urls;
        }
        finally {
            this.this_mon.exit();
        }
    }

    public URL[] getRedirects() {
        return this.redirects;
    }

    protected void handleRedirects(String url_parameters, String real_ip_address, boolean scrape) throws TRTrackerServerException {
        if (this.redirects != null) {
            if (url_parameters.indexOf("permredirect") != -1) {
                Debug.out("redirect recursion");
                throw new TRTrackerServerException("redirection recursion not supported");
            }
            URL redirect = this.redirects[real_ip_address.hashCode() % this.redirects.length];
            HashMap<String, String> headers = new HashMap<String, String>();
            String redirect_str = redirect.toString();
            if (scrape) {
                int pos = redirect_str.indexOf("/announce");
                if (pos == -1) {
                    return;
                }
                redirect_str = redirect_str.substring(0, pos) + "/scrape" + redirect_str.substring(pos + 9);
            }
            redirect_str = redirect_str.indexOf(63) == -1 ? redirect_str + "?" : redirect_str + "&";
            redirect_str = redirect_str + "permredirect=1";
            if (url_parameters.length() > 0) {
                redirect_str = redirect_str + "&" + url_parameters;
            }
            System.out.println("redirect -> " + redirect_str);
            headers.put("Location", redirect_str);
            throw new TRTrackerServerException(301, "Moved Permanently", headers);
        }
    }

    public void addListener(TRTrackerServerTorrentListener l) {
        this.listeners.add(l);
        if (this.deleted) {
            l.deleted(this);
        }
    }

    public void removeListener(TRTrackerServerTorrentListener l) {
        this.listeners.remove(l);
    }

    protected void peerEvent(TRTrackerServerPeer peer, int event2) throws TRTrackerServerException {
        if (this.peer_listeners != null) {
            for (int i = 0; i < this.peer_listeners.size(); ++i) {
                try {
                    ((TRTrackerServerTorrentPeerListener)this.peer_listeners.get(i)).eventOccurred(this, peer, event2);
                    continue;
                }
                catch (TRTrackerServerException e) {
                    throw e;
                }
                catch (Throwable e) {
                    Debug.printStackTrace(e);
                }
            }
        }
    }

    public void addPeerListener(TRTrackerServerTorrentPeerListener l) {
        if (this.peer_listeners == null) {
            this.peer_listeners = new ArrayList();
        }
        this.peer_listeners.add(l);
    }

    public void removePeerListener(TRTrackerServerTorrentPeerListener l) {
        if (this.peer_listeners != null) {
            this.peer_listeners.remove(l);
        }
    }

    public void disableCaching() {
        this.caching_enabled = false;
    }

    public boolean isCachingEnabled() {
        return this.caching_enabled;
    }

    public int getBadNATPeerCount() {
        return this.bad_NAT_count;
    }

    protected void delete() {
        this.deleted = true;
        for (int i = 0; i < this.listeners.size(); ++i) {
            ((TRTrackerServerTorrentListener)this.listeners.get(i)).deleted(this);
        }
    }

    public String getString() {
        String redirect;
        if (this.redirects == null) {
            redirect = "none";
        } else {
            redirect = "";
            for (int i = 0; i < this.redirects.length; ++i) {
                redirect = redirect + (i == 0 ? "" : ",") + this.redirects[i];
            }
        }
        return "seeds=" + this.getSeedCount() + ",leechers=" + this.getLeecherCount() + ", redirect=" + redirect;
    }

    protected static class QueuedPeer {
        private short tcp_port;
        private short udp_port;
        private byte[] ip;
        private byte crypto_level;
        private int create_time_secs;
        private int timeout_secs;

        protected QueuedPeer(String ip_str, int _tcp_port, int _udp_port, byte _crypto_level, int _timeout_secs) {
            try {
                this.ip = ip_str.getBytes("ISO-8859-1");
            }
            catch (UnsupportedEncodingException e) {
                Debug.printStackTrace(e);
            }
            this.tcp_port = (short)_tcp_port;
            this.udp_port = (short)_udp_port;
            this.crypto_level = _crypto_level;
            this.create_time_secs = (int)SystemTime.getCurrentTime() / 1000;
            this.timeout_secs = _timeout_secs * TRTrackerServerImpl.CLIENT_TIMEOUT_MULTIPLIER;
        }

        protected boolean sameAs(TRTrackerServerPeerImpl peer) {
            return this.tcp_port == peer.getTCPPort() && Arrays.equals(this.ip, peer.getIPAsRead());
        }

        protected boolean sameAs(QueuedPeer other) {
            return this.tcp_port == other.tcp_port && Arrays.equals(this.ip, other.ip);
        }

        protected byte[] getIP() {
            return this.ip;
        }

        protected byte[] getIPBytes() {
            try {
                return HostNameToIPResolver.hostAddressToBytes(new String(this.ip, "ISO-8859-1"));
            }
            catch (UnsupportedEncodingException e) {
                Debug.printStackTrace(e);
                return null;
            }
        }

        protected int getTCPPort() {
            return this.tcp_port & 0xFFFF;
        }

        protected int getUDPPort() {
            return this.udp_port & 0xFFFF;
        }

        protected byte getCryptoLevel() {
            return this.crypto_level;
        }

        protected int getCreateTime() {
            return this.create_time_secs;
        }

        protected boolean isTimedOut(long now_millis) {
            int now_secs = (int)(now_millis / 1000L);
            if (now_secs < this.create_time_secs) {
                this.create_time_secs = now_secs;
            }
            return this.create_time_secs + this.timeout_secs > now_secs;
        }

        protected String getString() {
            return new String(this.ip) + ":" + this.getTCPPort() + "/" + this.getUDPPort() + "/" + this.getCryptoLevel();
        }
    }

    protected static class lightweightSeed {
        long timeout;
        long last_contact_time;
        long uploaded;
        byte nat_status;

        protected lightweightSeed(long _now, long _timeout, long _uploaded, byte _nat_status) {
            this.last_contact_time = _now;
            this.timeout = _timeout;
            this.uploaded = _uploaded;
            this.nat_status = _nat_status;
        }

        protected long getTimeout() {
            return this.timeout;
        }

        protected long getLastContactTime() {
            return this.last_contact_time;
        }

        protected long getUploaded() {
            return this.uploaded;
        }

        protected byte getNATStatus() {
            return this.nat_status;
        }
    }

    static class announceCacheEntry {
        protected Map data;
        protected boolean send_peer_ids;
        protected byte compact_mode;
        protected long time;

        protected announceCacheEntry(Map _data, boolean _send_peer_ids, byte _compact_mode) {
            this.data = _data;
            this.send_peer_ids = _send_peer_ids;
            this.compact_mode = _compact_mode;
            this.time = SystemTime.getCurrentTime();
        }

        protected boolean getSendPeerIds() {
            return this.send_peer_ids;
        }

        protected byte getCompactMode() {
            return this.compact_mode;
        }

        protected long getTime() {
            return this.time;
        }

        protected Map getData() {
            return this.data;
        }
    }
}

