/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.core3.util;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.gudy.azureus2.core3.util.Average;
import org.gudy.azureus2.core3.util.Debug;

public class SystemTime {
    public static final long TIME_GRANULARITY_MILLIS = 25L;
    private static final int STEPS_PER_SECOND = 40;
    private static final SystemTime instance = new SystemTime();
    private final Thread updater;
    private volatile long stepped_time;
    private volatile long last_approximate_time;
    private volatile int access_count;
    private volatile int slice_access_count;
    private volatile int access_average_per_slice;
    private volatile int drift_adjusted_granularity;
    private volatile List consumer_list = new ArrayList();
    private volatile List clock_change_list = new ArrayList();

    private SystemTime() {
        this.stepped_time = System.currentTimeMillis();
        this.updater = new Thread("SystemTime"){

            public void run() {
                Average access_average = null;
                Average drift_average = null;
                long last_second = 0L;
                int tick_count = 0;
                while (true) {
                    SystemTime.this.stepped_time = System.currentTimeMillis();
                    List consumer_list_ref = SystemTime.this.consumer_list;
                    if (last_second == 0L) {
                        last_second = SystemTime.this.stepped_time - 1000L;
                    } else {
                        long offset = SystemTime.this.stepped_time - last_second;
                        if (offset < 0L || offset > 5000L) {
                            SystemTime.this.last_approximate_time = 0L;
                            last_second = SystemTime.this.stepped_time - 1000L;
                            access_average = null;
                            drift_average = null;
                            Iterator it = SystemTime.this.clock_change_list.iterator();
                            while (it.hasNext()) {
                                ((consumer)it.next()).consume(offset);
                            }
                        }
                    }
                    if (++tick_count == 40) {
                        if (access_average == null) {
                            access_average = Average.getInstance(1000, 10);
                            drift_average = Average.getInstance(1000, 10);
                        }
                        long drift = SystemTime.this.stepped_time - last_second - 1000L;
                        last_second = SystemTime.this.stepped_time;
                        drift_average.addValue(drift);
                        SystemTime.this.drift_adjusted_granularity = (int)(25L + drift_average.getAverage() / 40L);
                        access_average.addValue(SystemTime.this.access_count);
                        SystemTime.this.access_average_per_slice = (int)(access_average.getAverage() / 40L);
                        SystemTime.this.access_count = 0;
                        tick_count = 0;
                    }
                    SystemTime.this.slice_access_count = 0;
                    for (int i = 0; i < consumer_list_ref.size(); ++i) {
                        consumer cons = (consumer)consumer_list_ref.get(i);
                        try {
                            cons.consume(SystemTime.this.stepped_time);
                            continue;
                        }
                        catch (Throwable e) {
                            Debug.printStackTrace(e);
                        }
                    }
                    try {
                        Thread.sleep(25L);
                        continue;
                    }
                    catch (Exception e) {
                        Debug.printStackTrace(e);
                        continue;
                    }
                    break;
                }
            }
        };
        this.updater.setDaemon(true);
        this.updater.setPriority(10);
        this.updater.start();
    }

    private long getApproximateTime() {
        long adjusted_time = this.stepped_time;
        long temp = this.access_average_per_slice;
        if (temp > 0L) {
            long x = (long)(this.drift_adjusted_granularity * this.slice_access_count) / temp;
            if (x >= (long)this.drift_adjusted_granularity) {
                x = this.drift_adjusted_granularity - 1;
            }
            adjusted_time += x;
        }
        ++this.access_count;
        ++this.slice_access_count;
        if (adjusted_time < this.last_approximate_time) {
            adjusted_time = this.last_approximate_time;
        } else {
            this.last_approximate_time = adjusted_time;
        }
        return adjusted_time;
    }

    public static long getCurrentTime() {
        return instance.getApproximateTime();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void registerConsumer(consumer c) {
        SystemTime systemTime = instance;
        synchronized (systemTime) {
            ArrayList<consumer> new_list = new ArrayList<consumer>(SystemTime.instance.consumer_list);
            new_list.add(c);
            SystemTime.instance.consumer_list = new_list;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void unregisterConsumer(consumer c) {
        SystemTime systemTime = instance;
        synchronized (systemTime) {
            ArrayList new_list = new ArrayList(SystemTime.instance.consumer_list);
            new_list.remove(c);
            SystemTime.instance.consumer_list = new_list;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void registerClockChangeListener(consumer c) {
        SystemTime systemTime = instance;
        synchronized (systemTime) {
            ArrayList<consumer> new_list = new ArrayList<consumer>(SystemTime.instance.clock_change_list);
            new_list.add(c);
            SystemTime.instance.clock_change_list = new_list;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void unregisterClockChangeListener(consumer c) {
        SystemTime systemTime = instance;
        synchronized (systemTime) {
            ArrayList new_list = new ArrayList(SystemTime.instance.clock_change_list);
            new_list.remove(c);
            SystemTime.instance.clock_change_list = new_list;
        }
    }

    public static void main(String[] args) {
        int i = 0;
        while (i < 1) {
            int f_i = i++;
            new Thread(){

                public void run() {
                    long start = SystemTime.getCurrentTime();
                    while (true) {
                        long now = SystemTime.getCurrentTime();
                        System.out.println(now - start);
                        try {
                            Thread.sleep(1000L);
                        }
                        catch (Throwable e) {
                        }
                    }
                }
            }.start();
        }
    }

    public static interface consumer {
        public void consume(long var1);
    }
}

