/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.ui.swt;

import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.RowData;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;
import org.gudy.azureus2.core3.internat.MessageText;
import org.gudy.azureus2.core3.util.Constants;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.ui.swt.ImageRepository;
import org.gudy.azureus2.ui.swt.Messages;
import org.gudy.azureus2.ui.swt.Utils;
import org.gudy.azureus2.ui.swt.components.ControlUtils;
import org.gudy.azureus2.ui.swt.components.shell.ShellFactory;

public class SimpleTextEntryWindow {
    private Object parsed_data = null;
    private boolean data_entered = false;

    public SimpleTextEntryWindow(Display display, String title_key, String message_key, String default_value, final TextEntrySubmissionListener handler) {
        final Shell shell = ShellFactory.createShell(display, 67680);
        if (title_key != null) {
            shell.setText(MessageText.getString(title_key));
        }
        if (!Constants.isOSX) {
            shell.setImage(ImageRepository.getImage("azureus"));
        }
        GridLayout layout = new GridLayout();
        shell.setLayout((Layout)layout);
        Label label = new Label((Composite)shell, 0);
        if (message_key != null) {
            Messages.setLanguageText((Widget)label, message_key);
        }
        GridData gridData = new GridData();
        gridData.widthHint = 330;
        label.setLayoutData((Object)gridData);
        if (message_key != null && MessageText.keyExists(message_key + ".2")) {
            label = new Label((Composite)shell, 0);
            Messages.setLanguageText((Widget)label, message_key + ".2");
            gridData = new GridData();
            gridData.widthHint = 330;
            label.setLayoutData((Object)gridData);
        }
        final Text text_entry = new Text((Composite)shell, 2048);
        if (default_value != null) {
            text_entry.setText(default_value);
            text_entry.selectAll();
        }
        gridData = new GridData();
        gridData.widthHint = 330;
        text_entry.setLayoutData((Object)gridData);
        Composite panel = new Composite((Composite)shell, 0);
        RowLayout rLayout = new RowLayout();
        rLayout.marginTop = 0;
        rLayout.marginLeft = 0;
        rLayout.marginBottom = 0;
        rLayout.marginRight = 0;
        try {
            rLayout.fill = true;
        }
        catch (NoSuchFieldError e) {
            // empty catch block
        }
        rLayout.spacing = ControlUtils.getButtonMargin();
        panel.setLayout((Layout)rLayout);
        gridData = new GridData();
        gridData.horizontalAlignment = Constants.isOSX ? 0x1000008 : 0x1000000;
        panel.setLayoutData((Object)gridData);
        Button ok = SimpleTextEntryWindow.createAlertButton(panel, "Button.ok");
        Button cancel = SimpleTextEntryWindow.createAlertButton(panel, "Button.cancel");
        ok.addListener(13, new Listener(){

            public void handleEvent(Event event2) {
                try {
                    String entered_data = text_entry.getText().trim();
                    Object result = entered_data;
                    if (handler != null) {
                        result = handler.dataEntered(entered_data);
                    }
                    SimpleTextEntryWindow.this.parsed_data = result;
                    SimpleTextEntryWindow.this.data_entered = true;
                }
                catch (Exception e) {
                    Debug.printStackTrace(e);
                }
                shell.dispose();
            }
        });
        cancel.addListener(13, new Listener(){

            public void handleEvent(Event event2) {
                shell.dispose();
            }
        });
        shell.setDefaultButton(ok);
        shell.addListener(31, new Listener(){

            public void handleEvent(Event e) {
                if (e.character == '\u001b') {
                    shell.dispose();
                }
            }
        });
        shell.pack();
        Utils.createURLDropTarget((Composite)shell, text_entry);
        Utils.centreWindow(shell);
        shell.open();
        while (!shell.isDisposed()) {
            if (display.readAndDispatch()) continue;
            display.sleep();
        }
    }

    private static Button createAlertButton(Composite panel, String localizationKey) {
        Button button = new Button(panel, 8);
        button.setText(MessageText.getString(localizationKey));
        RowData rData = new RowData();
        rData.width = Math.max(ControlUtils.getDialogButtonMinWidth(), button.computeSize((int)-1, (int)-1).x);
        button.setLayoutData((Object)rData);
        return button;
    }

    public Object getStoredValue() {
        return this.parsed_data;
    }

    public String getStoredString() {
        return (String)this.parsed_data;
    }

    public boolean wasDataSubmitted() {
        return this.data_entered;
    }

    public static interface TextEntrySubmissionListener {
        public Object dataEntered(String var1);
    }
}

