/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.ui.swt.config.wizard;

import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Widget;
import org.gudy.azureus2.core3.internat.MessageText;
import org.gudy.azureus2.ui.swt.Messages;
import org.gudy.azureus2.ui.swt.config.wizard.ConfigureWizard;
import org.gudy.azureus2.ui.swt.config.wizard.NatPanel;
import org.gudy.azureus2.ui.swt.wizard.AbstractWizardPanel;
import org.gudy.azureus2.ui.swt.wizard.IWizardPanel;

public class TransferPanel
extends AbstractWizardPanel {
    Label nbMaxActive;
    Label nbMaxDownloads;
    Label nbMaxUploadsPerTorrent;
    private static final int[] upRates = new int[]{0, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 20, 25, 30, 35, 40, 45, 50, 55, 60, 70, 80, 85, 90, 100, 110, 150, 200, 250, 300, 350, 400, 450, 500, 600, 700, 800, 900, 1000};

    public TransferPanel(ConfigureWizard wizard, IWizardPanel previous) {
        super(wizard, previous);
    }

    public void show() {
        this.wizard.setTitle(MessageText.getString("configureWizard.transfer.title"));
        this.wizard.setCurrentInfo(MessageText.getString("configureWizard.transfer.hint"));
        Composite rootPanel = this.wizard.getPanel();
        GridLayout layout = new GridLayout();
        layout.numColumns = 1;
        rootPanel.setLayout((Layout)layout);
        Composite panel = new Composite(rootPanel, 0);
        GridData gridData = new GridData(1808);
        panel.setLayoutData((Object)gridData);
        layout = new GridLayout();
        layout.numColumns = 2;
        panel.setLayout((Layout)layout);
        Label label = new Label(panel, 64);
        gridData = new GridData(768);
        gridData.horizontalSpan = 2;
        label.setLayoutData((Object)gridData);
        Messages.setLanguageText((Widget)label, "configureWizard.transfer.message");
        label = new Label(panel, 0);
        Messages.setLanguageText((Widget)label, "configureWizard.transfer.connection");
        final Combo connections = new Combo(panel, 12);
        for (int i = 0; i < 8; ++i) {
            connections.add(MessageText.getString("configureWizard.transfer.connection." + i));
        }
        label = new Label(panel, 0);
        Messages.setLanguageText((Widget)label, "configureWizard.transfer.maxUpSpeed");
        String[] upsLabels = new String[upRates.length];
        int[] upsValues = new int[upRates.length];
        upsLabels[0] = MessageText.getString("ConfigView.unlimited");
        upsValues[0] = 0;
        for (int i = 1; i < upRates.length; ++i) {
            upsLabels[i] = " " + upRates[i] + " KB/s";
            upsValues[i] = 1024 * upRates[i];
        }
        final Combo cMaxUpSpeed = new Combo(panel, 12);
        for (int i = 0; i < upRates.length; ++i) {
            cMaxUpSpeed.add(upsLabels[i]);
        }
        gridData = new GridData();
        gridData.widthHint = 100;
        cMaxUpSpeed.setLayoutData((Object)gridData);
        label = new Label(panel, 0);
        Messages.setLanguageText((Widget)label, "configureWizard.transfer.maxActiveTorrents");
        this.nbMaxActive = new Label(panel, 0);
        gridData = new GridData();
        gridData.widthHint = 100;
        this.nbMaxActive.setLayoutData((Object)gridData);
        label = new Label(panel, 0);
        Messages.setLanguageText((Widget)label, "configureWizard.transfer.maxDownloads");
        this.nbMaxDownloads = new Label(panel, 0);
        gridData = new GridData();
        gridData.widthHint = 100;
        this.nbMaxDownloads.setLayoutData((Object)gridData);
        label = new Label(panel, 0);
        Messages.setLanguageText((Widget)label, "configureWizard.transfer.maxUploadsPerTorrent");
        this.nbMaxUploadsPerTorrent = new Label(panel, 0);
        gridData = new GridData();
        gridData.widthHint = 100;
        this.nbMaxUploadsPerTorrent.setLayoutData((Object)gridData);
        connections.addListener(13, new Listener(){

            public void handleEvent(Event event2) {
                int index;
                ((ConfigureWizard)((TransferPanel)TransferPanel.this).wizard).upSpeed = index = connections.getSelectionIndex();
                if (index == 0) {
                    cMaxUpSpeed.setEnabled(true);
                } else {
                    int maxUp;
                    cMaxUpSpeed.setEnabled(false);
                    int[] upSpeeds = new int[]{0, 5, 13, 25, 40, 55, 85, 110};
                    cMaxUpSpeed.select(TransferPanel.this.findIndex(upSpeeds[index], upRates));
                    ((ConfigureWizard)((TransferPanel)TransferPanel.this).wizard).maxUpSpeed = maxUp = upRates[cMaxUpSpeed.getSelectionIndex()];
                    TransferPanel.this.computeAll(maxUp);
                }
            }
        });
        cMaxUpSpeed.addListener(13, new Listener(){

            public void handleEvent(Event event2) {
                int maxUp;
                ((ConfigureWizard)((TransferPanel)TransferPanel.this).wizard).maxUpSpeed = maxUp = upRates[cMaxUpSpeed.getSelectionIndex()];
                TransferPanel.this.computeAll(maxUp);
            }
        });
        connections.select(((ConfigureWizard)this.wizard).upSpeed);
        cMaxUpSpeed.select(this.findIndex(((ConfigureWizard)this.wizard).maxUpSpeed, upRates));
        cMaxUpSpeed.setEnabled(((ConfigureWizard)this.wizard).upSpeed == 0);
        this.computeAll(((ConfigureWizard)this.wizard).maxUpSpeed);
    }

    public void computeAll(int maxUploadSpeed) {
        if (maxUploadSpeed != 0) {
            int nbMaxActive = (int)(Math.pow(maxUploadSpeed, 0.34) * 0.92);
            int nbMaxUploads = (int)(Math.pow(maxUploadSpeed, 0.25) * 1.68);
            int nbMaxDownloads = nbMaxActive * 4 / 5;
            if (nbMaxDownloads == 0) {
                nbMaxDownloads = 1;
            }
            if (nbMaxUploads > 50) {
                nbMaxUploads = 50;
            }
            ((ConfigureWizard)this.wizard).maxActiveTorrents = nbMaxActive;
            ((ConfigureWizard)this.wizard).maxDownloads = nbMaxDownloads;
            ((ConfigureWizard)this.wizard).nbUploadsPerTorrent = nbMaxUploads;
        } else {
            ((ConfigureWizard)this.wizard).maxActiveTorrents = 0;
            ((ConfigureWizard)this.wizard).maxDownloads = 0;
            ((ConfigureWizard)this.wizard).nbUploadsPerTorrent = 4;
        }
        this.refresh();
    }

    public void refresh() {
        this.nbMaxActive.setText("" + ((ConfigureWizard)this.wizard).maxActiveTorrents);
        this.nbMaxDownloads.setText("" + ((ConfigureWizard)this.wizard).maxDownloads);
        this.nbMaxUploadsPerTorrent.setText("" + ((ConfigureWizard)this.wizard).nbUploadsPerTorrent);
    }

    private int findIndex(int value, int[] values) {
        for (int i = 0; i < values.length; ++i) {
            if (values[i] != value) continue;
            return i;
        }
        return 0;
    }

    public boolean isNextEnabled() {
        return true;
    }

    public IWizardPanel getNextPanel() {
        return new NatPanel((ConfigureWizard)this.wizard, (IWizardPanel)this);
    }
}

