/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.plugins.extseed.util;

import com.aelitis.azureus.plugins.extseed.ExternalSeedException;
import com.aelitis.azureus.plugins.extseed.util.ExternalSeedHTTPDownloaderListener;
import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.net.HttpURLConnection;
import java.net.Socket;
import java.net.URL;
import java.util.StringTokenizer;

public class ExternalSeedHTTPDownloader {
    public static final String NL = "\r\n";
    private URL url;
    private String user_agent;
    private int last_response;
    private byte[] last_response_data;

    public ExternalSeedHTTPDownloader(URL _url, String _user_agent) {
        this.url = _url;
        this.user_agent = _user_agent;
    }

    public void download(int length, ExternalSeedHTTPDownloaderListener listener) throws ExternalSeedException {
        this.download(new String[0], new String[0], length, listener);
    }

    public void downloadRange(long offset, int length, ExternalSeedHTTPDownloaderListener listener) throws ExternalSeedException {
        this.download(new String[]{"Range"}, new String[]{"bytes=" + offset + "-" + (offset + (long)length - 1L)}, length, listener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void download(String[] prop_names, String[] prop_values, int length, ExternalSeedHTTPDownloaderListener listener) throws ExternalSeedException {
        block14: {
            try {
                int response;
                HttpURLConnection connection = (HttpURLConnection)this.url.openConnection();
                connection.setRequestProperty("Connection", "Keep-Alive");
                connection.setRequestProperty("User-Agent", this.user_agent);
                for (int i = 0; i < prop_names.length; ++i) {
                    connection.setRequestProperty(prop_names[i], prop_values[i]);
                }
                this.last_response = response = connection.getResponseCode();
                if (response == 202 || response == 200 || response == 206) {
                    InputStream is = connection.getInputStream();
                    try {
                        int pos;
                        int len;
                        byte[] buffer = null;
                        int buffer_pos = 0;
                        for (pos = 0; pos < length; pos += len) {
                            if (buffer == null) {
                                buffer = listener.getBuffer();
                            }
                            if ((len = is.read(buffer, buffer_pos, buffer.length - buffer_pos)) < 0) break;
                            if ((buffer_pos += len) != buffer.length) continue;
                            listener.done();
                            buffer = null;
                            buffer_pos = 0;
                        }
                        if (pos != length) {
                            String log_str;
                            if (buffer == null) {
                                log_str = "No buffer assigned";
                            } else {
                                log_str = new String(buffer, 0, length);
                                if (log_str.length() > 64) {
                                    log_str = log_str.substring(0, 64);
                                }
                            }
                            throw new ExternalSeedException("Connection failed: data too short - " + length + "/" + pos + " [" + log_str + "]");
                        }
                        break block14;
                    }
                    finally {
                        is.close();
                    }
                }
                ExternalSeedException error = new ExternalSeedException("Connection failed: " + connection.getResponseMessage());
                error.setPermanentFailure(true);
                throw error;
            }
            catch (Throwable e) {
                if (e instanceof ExternalSeedException) {
                    throw (ExternalSeedException)e;
                }
                throw new ExternalSeedException("Connection failed", e);
            }
        }
    }

    public void downloadSocket(int length, ExternalSeedHTTPDownloaderListener listener) throws ExternalSeedException {
        this.downloadSocket(new String[0], new String[0], length, listener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void downloadSocket(String[] prop_names, String[] prop_values, int length, ExternalSeedHTTPDownloaderListener listener) throws ExternalSeedException {
        block26: {
            Socket socket = null;
            try {
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                PrintWriter pw = new PrintWriter(baos);
                pw.print("GET " + this.url.getPath() + "?" + this.url.getQuery() + " HTTP/1.0" + NL);
                pw.print("Host: " + this.url.getHost() + (this.url.getPort() == -1 ? "" : ":" + this.url.getPort()) + NL);
                pw.print("Accept: */*\r\n");
                pw.print("Connection: Keep-Alive\r\n");
                pw.print("User-Agent: " + this.user_agent + NL);
                for (int i = 0; i < prop_names.length; ++i) {
                    pw.print(prop_names[i] + ":" + prop_values[i] + NL);
                }
                pw.print(NL);
                pw.flush();
                socket = new Socket(this.url.getHost(), this.url.getPort() == -1 ? this.url.getDefaultPort() : this.url.getPort());
                OutputStream os = socket.getOutputStream();
                os.write(baos.toByteArray());
                os.flush();
                BufferedInputStream is = new BufferedInputStream(socket.getInputStream());
                try {
                    int response;
                    byte[] buffer;
                    String header = "";
                    do {
                        int len;
                        if ((len = ((InputStream)is).read(buffer = new byte[1])) >= 0) continue;
                        throw new IOException("input too short reading header");
                    } while (!(header = header + (char)buffer[0]).endsWith("\r\n\r\n"));
                    int line_end = header.indexOf(NL);
                    if (line_end == -1) {
                        throw new IOException("header too short");
                    }
                    String first_line = header.substring(0, line_end);
                    StringTokenizer tok = new StringTokenizer(first_line, " ");
                    tok.nextToken();
                    this.last_response = response = Integer.parseInt(tok.nextToken());
                    String response_str = tok.nextToken();
                    if (response == 202 || response == 200 || response == 206) {
                        int pos;
                        int len;
                        byte[] buffer2 = null;
                        int buffer_pos = 0;
                        for (pos = 0; pos < length; pos += len) {
                            if (buffer2 == null) {
                                buffer2 = listener.getBuffer();
                            }
                            if ((len = ((InputStream)is).read(buffer2, buffer_pos, buffer2.length - buffer_pos)) < 0) break;
                            if ((buffer_pos += len) != buffer2.length) continue;
                            listener.done();
                            buffer2 = null;
                            buffer_pos = 0;
                        }
                        if (pos != length) {
                            String log_str;
                            if (buffer2 == null) {
                                log_str = "No buffer assigned";
                            } else {
                                log_str = new String(buffer2, 0, length);
                                if (log_str.length() > 64) {
                                    log_str = log_str.substring(0, 64);
                                }
                            }
                            throw new ExternalSeedException("Connection failed: data too short - " + length + "/" + pos + " [" + log_str + "]");
                        }
                        break block26;
                    }
                    if (response == 503) {
                        byte[] buffer3;
                        int len;
                        String data_str = "";
                        while ((len = ((InputStream)is).read(buffer3 = new byte[1])) >= 0) {
                            data_str = data_str + (char)buffer3[0];
                        }
                        this.last_response_data = data_str.getBytes();
                        break block26;
                    }
                    ExternalSeedException error = new ExternalSeedException("Connection failed: " + response_str);
                    error.setPermanentFailure(true);
                    throw error;
                }
                finally {
                    ((InputStream)is).close();
                }
            }
            catch (Throwable e) {
                if (e instanceof ExternalSeedException) {
                    throw (ExternalSeedException)e;
                }
                throw new ExternalSeedException("Connection failed", e);
            }
            finally {
                if (socket != null) {
                    try {
                        socket.close();
                    }
                    catch (Throwable e) {}
                }
            }
        }
    }

    public int getLastResponse() {
        return this.last_response;
    }

    public byte[] getLast503ResponseData() {
        return this.last_response_data;
    }
}

