/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.core3.util;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.List;
import org.gudy.azureus2.core3.util.AEMonitor;
import org.gudy.azureus2.core3.util.AENetworkClassifier;
import org.gudy.azureus2.core3.util.AESemaphore;
import org.gudy.azureus2.core3.util.AEThread;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.core3.util.HostNameToIPResolverException;
import org.gudy.azureus2.core3.util.HostNameToIPResolverListener;

public class HostNameToIPResolver {
    protected static Thread resolver_thread;
    protected static List request_queue;
    protected static AEMonitor request_queue_mon;
    protected static AESemaphore request_semaphore;
    static final int INADDRSZ = 4;

    public static boolean isNonDNSName(String host) {
        return AENetworkClassifier.categoriseAddress(host) != "Public";
    }

    public static InetAddress syncResolve(String host) throws UnknownHostException {
        if (HostNameToIPResolver.isNonDNSName(host)) {
            throw new HostNameToIPResolverException("non-DNS name '" + host + "'", true);
        }
        byte[] bytes = HostNameToIPResolver.textToNumericFormat(host);
        if (bytes != null) {
            return InetAddress.getByAddress(bytes);
        }
        char[] chars = host.toCharArray();
        boolean resolve = false;
        for (int i = 0; i < chars.length; ++i) {
            if (chars[i] == '.' || Character.isDigit(chars[i])) continue;
            resolve = true;
            break;
        }
        if (resolve) {
            return InetAddress.getByName(host);
        }
        throw new UnknownHostException("Host '" + host + "' doesn't obey minimal validation rules");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addResolverRequest(String host, HostNameToIPResolverListener l) {
        byte[] bytes = HostNameToIPResolver.textToNumericFormat(host);
        if (bytes != null) {
            try {
                l.hostNameResolutionComplete(InetAddress.getByAddress(host, bytes));
                return;
            }
            catch (UnknownHostException unknownHostException) {
                // empty catch block
            }
        }
        try {
            request_queue_mon.enter();
            request_queue.add(new request(host, l));
            request_semaphore.release();
            if (resolver_thread == null) {
                resolver_thread = new AEThread("HostNameToIPResolver"){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public void runSupport() {
                        block7: while (true) {
                            try {
                                while (true) {
                                    request req;
                                    request_semaphore.reserve();
                                    try {
                                        request_queue_mon.enter();
                                        req = (request)request_queue.remove(0);
                                    }
                                    finally {
                                        request_queue_mon.exit();
                                    }
                                    try {
                                        InetAddress addr = HostNameToIPResolver.syncResolve(req.getHost());
                                        req.getListener().hostNameResolutionComplete(addr);
                                        continue block7;
                                    }
                                    catch (Throwable e) {
                                        req.getListener().hostNameResolutionComplete(null);
                                        continue;
                                    }
                                    break;
                                }
                            }
                            catch (Throwable e) {
                                Debug.printStackTrace(e);
                                continue;
                            }
                            break;
                        }
                    }
                };
                resolver_thread.setDaemon(true);
                resolver_thread.start();
            }
        }
        finally {
            request_queue_mon.exit();
        }
    }

    public static byte[] hostAddressToBytes(String host) {
        return HostNameToIPResolver.textToNumericFormat(host);
    }

    static byte[] textToNumericFormat(String src) {
        if (src.length() == 0) {
            return null;
        }
        byte[] dst = new byte[4];
        char[] srcb = src.toCharArray();
        boolean saw_digit = false;
        int octets = 0;
        int i = 0;
        int cur = 0;
        while (i < srcb.length) {
            char ch;
            if (Character.isDigit(ch = srcb[i++])) {
                int sum = (dst[cur] & 0xFF) * 10 + (Character.digit(ch, 10) & 0xFF);
                if (sum > 255) {
                    return null;
                }
                dst[cur] = (byte)(sum & 0xFF);
                if (saw_digit) continue;
                if (++octets > 4) {
                    return null;
                }
                saw_digit = true;
                continue;
            }
            if (ch == '.' && saw_digit) {
                if (octets == 4) {
                    return null;
                }
                dst[++cur] = 0;
                saw_digit = false;
                continue;
            }
            return null;
        }
        if (octets < 4) {
            return null;
        }
        return dst;
    }

    static {
        request_queue = new ArrayList();
        request_queue_mon = new AEMonitor("HostNameToIPResolver");
        request_semaphore = new AESemaphore("HostNameToIPResolver");
    }

    protected static class request {
        protected String host;
        protected HostNameToIPResolverListener listener;

        protected request(String _host, HostNameToIPResolverListener _listener) {
            this.host = _host;
            this.listener = _listener;
        }

        protected String getHost() {
            return this.host;
        }

        protected HostNameToIPResolverListener getListener() {
            return this.listener;
        }
    }
}

