/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.pluginsimpl.local.messaging;

import com.aelitis.azureus.core.nat.NATTraverser;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Random;
import org.gudy.azureus2.core3.logging.LogEvent;
import org.gudy.azureus2.core3.logging.LogIDs;
import org.gudy.azureus2.core3.logging.Logger;
import org.gudy.azureus2.core3.util.AERunnable;
import org.gudy.azureus2.core3.util.AESemaphore;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.core3.util.DelayedEvent;
import org.gudy.azureus2.core3.util.DirectByteBuffer;
import org.gudy.azureus2.core3.util.SimpleTimer;
import org.gudy.azureus2.core3.util.SystemTime;
import org.gudy.azureus2.core3.util.ThreadPool;
import org.gudy.azureus2.core3.util.TimerEvent;
import org.gudy.azureus2.core3.util.TimerEventPerformer;
import org.gudy.azureus2.plugins.messaging.MessageException;
import org.gudy.azureus2.plugins.messaging.generic.GenericMessageEndpoint;
import org.gudy.azureus2.plugins.messaging.generic.GenericMessageHandler;
import org.gudy.azureus2.plugins.utils.PooledByteBuffer;
import org.gudy.azureus2.pluginsimpl.local.messaging.GenericMessage;
import org.gudy.azureus2.pluginsimpl.local.messaging.GenericMessageConnectionAdapter;
import org.gudy.azureus2.pluginsimpl.local.messaging.GenericMessageConnectionImpl;
import org.gudy.azureus2.pluginsimpl.local.messaging.GenericMessageEndpointImpl;
import org.gudy.azureus2.pluginsimpl.local.messaging.MessageManagerImpl;

public class GenericMessageConnectionIndirect
implements GenericMessageConnectionAdapter {
    private static final LogIDs LOGID = LogIDs.NET;
    private static final boolean TRACE = false;
    public static final int MAX_MESSAGE_SIZE = 32768;
    private static final int MESSAGE_TYPE_CONNECT = 1;
    private static final int MESSAGE_TYPE_ERROR = 2;
    private static final int MESSAGE_TYPE_DATA = 3;
    private static final int MESSAGE_TYPE_DISCONNECT = 4;
    private static final int TICK_PERIOD = 5000;
    private static final int KEEP_ALIVE_CHECK_PERIOD = 5000;
    private static final int KEEP_ALIVE_MIN = 10000;
    private static final int STATS_PERIOD = 60000;
    private static final int KEEP_ALIVE_CHECK_TICKS = 1;
    private static final int STATS_TICKS = 12;
    private static final int MAX_REMOTE_CONNECTIONS = 1024;
    private static final int MAX_REMOTE_CONNECTIONS_PER_IP = 32;
    private static long connection_id_next = new Random().nextLong();
    private static Map local_connections = new HashMap();
    private static Map remote_connections = new HashMap();
    private static ThreadPool keep_alive_pool = new ThreadPool("GenericMessageConnectionIndirect:keepAlive", 8, true);
    private MessageManagerImpl message_manager;
    private String msg_id;
    private String msg_desc;
    private GenericMessageEndpoint endpoint;
    private NATTraverser nat_traverser;
    private GenericMessageConnectionImpl owner;
    private InetSocketAddress rendezvous;
    private InetSocketAddress target;
    private long connection_id;
    private boolean incoming;
    private boolean closed;
    private LinkedList send_queue = new LinkedList();
    private AESemaphore send_queue_sem = new AESemaphore("GenericMessageConnectionIndirect:sendq");
    private volatile long last_message_sent;
    private volatile long last_message_received;
    private volatile boolean keep_alive_in_progress;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static Map receive(MessageManagerImpl message_manager, InetSocketAddress originator, Map message) {
        GenericMessageConnectionIndirect indirect_connection;
        if (!message.containsKey("type")) {
            return null;
        }
        int type = ((Long)message.get("type")).intValue();
        if (type == 1) {
            String msg_id = new String((byte[])message.get("msg_id"));
            String msg_desc = new String((byte[])message.get("msg_desc"));
            GenericMessageEndpointImpl endpoint = new GenericMessageEndpointImpl(originator);
            endpoint.addUDP(originator);
            GenericMessageHandler handler = message_manager.getHandler(msg_id);
            if (handler == null) {
                Debug.out("No message handler registered for '" + msg_id + "'");
                return null;
            }
            try {
                Long con_id;
                Map map = remote_connections;
                synchronized (map) {
                    if (remote_connections.size() >= 1024) {
                        Debug.out("Maximum remote connections exceeded - request from " + originator + " denied [" + GenericMessageConnectionIndirect.getRemoteConnectionStatus() + "]");
                        return null;
                    }
                    int num_from_this_ip = 0;
                    for (GenericMessageConnectionIndirect con : remote_connections.values()) {
                        if (!con.getEndpoint().getNotionalAddress().getAddress().equals(originator.getAddress())) continue;
                        ++num_from_this_ip;
                    }
                    if (num_from_this_ip >= 32) {
                        Debug.out("Maximum remote connections per-ip exceeded - request from " + originator + " denied [" + GenericMessageConnectionIndirect.getRemoteConnectionStatus() + "]");
                        return null;
                    }
                    con_id = new Long(connection_id_next++);
                }
                GenericMessageConnectionIndirect indirect_connection2 = new GenericMessageConnectionIndirect(message_manager, msg_id, msg_desc, endpoint, con_id);
                GenericMessageConnectionImpl new_connection = new GenericMessageConnectionImpl(message_manager, indirect_connection2);
                if (handler.accept(new_connection)) {
                    new_connection.accepted();
                    Map it = remote_connections;
                    synchronized (it) {
                        remote_connections.put(con_id, indirect_connection2);
                    }
                    List replies = indirect_connection2.receive((List)message.get("data"));
                    HashMap<String, Object> reply = new HashMap<String, Object>();
                    reply.put("type", new Long(1L));
                    reply.put("con_id", con_id);
                    reply.put("data", replies);
                    return reply;
                }
                return null;
            }
            catch (MessageException e) {
                Debug.out("Error accepting message", e);
                return null;
            }
        }
        if (type == 3) {
            GenericMessageConnectionIndirect indirect_connection3;
            Long con_id = (Long)message.get("con_id");
            Map endpoint = remote_connections;
            synchronized (endpoint) {
                indirect_connection3 = (GenericMessageConnectionIndirect)remote_connections.get(con_id);
            }
            if (indirect_connection3 == null) {
                return null;
            }
            HashMap<String, Object> reply = new HashMap<String, Object>();
            if (indirect_connection3.isClosed()) {
                reply.put("type", new Long(4L));
            } else {
                List replies = indirect_connection3.receive((List)message.get("data"));
                reply.put("type", new Long(3L));
                reply.put("data", replies);
                if (indirect_connection3.receiveIncomplete()) {
                    reply.put("more_data", new Long(1L));
                }
            }
            return reply;
        }
        Long con_id = (Long)message.get("con_id");
        Map reply = remote_connections;
        synchronized (reply) {
            indirect_connection = (GenericMessageConnectionIndirect)remote_connections.get(con_id);
        }
        if (indirect_connection != null) {
            try {
                indirect_connection.close(new Throwable("Remote closed connection"));
            }
            catch (Throwable e) {
                Debug.printStackTrace(e);
            }
        }
        return null;
    }

    protected static String getRemoteConnectionStatus() {
        return GenericMessageConnectionIndirect.getConnectionStatus(remote_connections);
    }

    protected static String getLocalConnectionStatus() {
        return GenericMessageConnectionIndirect.getConnectionStatus(local_connections);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static String getConnectionStatus(Map connections) {
        HashMap<InetAddress, Integer> totals = new HashMap<InetAddress, Integer>();
        Map map = connections;
        synchronized (map) {
            for (GenericMessageConnectionIndirect genericMessageConnectionIndirect : connections.values()) {
                InetAddress originator = genericMessageConnectionIndirect.getEndpoint().getNotionalAddress().getAddress();
                Integer i = (Integer)totals.get(originator);
                i = i == null ? new Integer(1) : new Integer(i + 1);
                totals.put(originator, i);
            }
        }
        String str = "";
        for (Map.Entry entry : totals.entrySet()) {
            str = str + (str.length() == 0 ? "" : ",") + entry.getKey() + ":" + entry.getValue();
        }
        return str;
    }

    protected GenericMessageConnectionIndirect(MessageManagerImpl _message_manager, String _msg_id, String _msg_desc, GenericMessageEndpoint _endpoint, InetSocketAddress _rendezvous, InetSocketAddress _target) {
        this.message_manager = _message_manager;
        this.msg_id = _msg_id;
        this.msg_desc = _msg_desc;
        this.endpoint = _endpoint;
        this.rendezvous = _rendezvous;
        this.target = _target;
        this.nat_traverser = this.message_manager.getNATTraverser();
        GenericMessageConnectionIndirect.log("outgoing connection to " + this.endpoint.getNotionalAddress());
    }

    protected GenericMessageConnectionIndirect(MessageManagerImpl _message_manager, String _msg_id, String _msg_desc, GenericMessageEndpoint _endpoint, long _connection_id) {
        this.message_manager = _message_manager;
        this.msg_id = _msg_id;
        this.msg_desc = _msg_desc;
        this.endpoint = _endpoint;
        this.connection_id = _connection_id;
        this.incoming = true;
        this.last_message_received = SystemTime.getCurrentTime();
        GenericMessageConnectionIndirect.log("incoming connection from " + this.endpoint.getNotionalAddress());
    }

    public void setOwner(GenericMessageConnectionImpl _owner) {
        this.owner = _owner;
    }

    public int getMaximumMessageSize() {
        return 32768;
    }

    public long getLastMessageReceivedTime() {
        long now = SystemTime.getCurrentTime();
        if (now < this.last_message_received) {
            this.last_message_received = now;
        }
        return this.last_message_received;
    }

    public GenericMessageEndpoint getEndpoint() {
        return this.endpoint;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void connect(ByteBuffer initial_data, GenericMessageConnectionAdapter.ConnectionListener listener) {
        block10: {
            try {
                HashMap<String, Object> message = new HashMap<String, Object>();
                byte[] initial_data_bytes = new byte[initial_data.remaining()];
                initial_data.get(initial_data_bytes);
                ArrayList<byte[]> initial_messages = new ArrayList<byte[]>();
                initial_messages.add(initial_data_bytes);
                message.put("type", new Long(1L));
                message.put("msg_id", this.msg_id);
                message.put("msg_desc", this.msg_desc);
                message.put("data", initial_messages);
                Map reply = this.nat_traverser.sendMessage(this.message_manager, this.rendezvous, this.target, message);
                this.last_message_sent = SystemTime.getCurrentTime();
                if (reply == null || !reply.containsKey("type")) {
                    listener.connectFailure(new Throwable("Indirect connect failed (response=" + reply + ")"));
                    break block10;
                }
                int reply_type = ((Long)reply.get("type")).intValue();
                if (reply_type == 2) {
                    listener.connectFailure(new Throwable(new String((byte[])reply.get("error"))));
                    break block10;
                }
                if (reply_type == 4) {
                    listener.connectFailure(new Throwable("Disconnected"));
                    break block10;
                }
                if (reply_type == 1) {
                    this.connection_id = (Long)reply.get("con_id");
                    Map map = local_connections;
                    synchronized (map) {
                        local_connections.put(new Long(this.connection_id), this);
                    }
                    listener.connectSuccess();
                    List replies = (List)reply.get("data");
                    for (int i = 0; i < replies.size(); ++i) {
                        this.owner.receive(new GenericMessage(this.msg_id, this.msg_desc, new DirectByteBuffer(ByteBuffer.wrap((byte[])replies.get(i))), false));
                    }
                    break block10;
                }
                Debug.out("Unexpected reply type - " + reply_type);
                listener.connectFailure(new Throwable("Unexpected reply type - " + reply_type));
            }
            catch (Throwable e) {
                listener.connectFailure(e);
            }
        }
    }

    public void accepted() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void send(PooledByteBuffer pbb) throws MessageException {
        byte[] bytes = pbb.toByteArray();
        if (this.incoming) {
            LinkedList linkedList = this.send_queue;
            synchronized (linkedList) {
                if (this.send_queue.size() > 64) {
                    throw new MessageException("Send queue limit exceeded");
                }
                this.send_queue.add(bytes);
            }
            this.send_queue_sem.release();
        } else {
            ArrayList<byte[]> messages = new ArrayList<byte[]>();
            messages.add(bytes);
            this.send(messages);
        }
    }

    protected void send(List messages) {
        try {
            HashMap<String, Object> message = new HashMap<String, Object>();
            message.put("con_id", new Long(this.connection_id));
            message.put("type", new Long(3L));
            message.put("data", messages);
            Map reply = this.nat_traverser.sendMessage(this.message_manager, this.rendezvous, this.target, message);
            this.last_message_sent = SystemTime.getCurrentTime();
            if (reply == null || !reply.containsKey("type")) {
                this.owner.reportFailed(new Throwable("Indirect message send failed (response=" + reply + ")"));
            } else {
                int reply_type = ((Long)reply.get("type")).intValue();
                if (reply_type == 2) {
                    this.owner.reportFailed(new Throwable(new String((byte[])reply.get("error"))));
                } else if (reply_type == 3) {
                    List replies = (List)reply.get("data");
                    for (int i = 0; i < replies.size(); ++i) {
                        this.owner.receive(new GenericMessage(this.msg_id, this.msg_desc, new DirectByteBuffer(ByteBuffer.wrap((byte[])replies.get(i))), false));
                    }
                    if (reply.get("more_data") != null) {
                        new DelayedEvent("GenMsg:kap", 500L, new AERunnable(){

                            public void runSupport() {
                                if (GenericMessageConnectionIndirect.this.prepareForKeepAlive(true)) {
                                    keep_alive_pool.run(new AERunnable(){

                                        public void runSupport() {
                                            GenericMessageConnectionIndirect.this.keepAlive();
                                        }
                                    });
                                }
                            }
                        });
                    }
                } else if (reply_type == 4) {
                    this.owner.reportFailed(new Throwable("Disconnected"));
                }
            }
        }
        catch (Throwable e) {
            this.owner.reportFailed(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected List receive(List messages) {
        this.last_message_received = SystemTime.getCurrentTime();
        for (int i = 0; i < messages.size(); ++i) {
            this.owner.receive(new GenericMessage(this.msg_id, this.msg_desc, new DirectByteBuffer(ByteBuffer.wrap((byte[])messages.get(i))), false));
        }
        ArrayList reply = new ArrayList();
        if (this.send_queue_sem.reserve(2500L)) {
            try {
                Thread.sleep(250L);
            }
            catch (Throwable e) {
                // empty catch block
            }
            int max = this.getMaximumMessageSize();
            int total = 0;
            LinkedList linkedList = this.send_queue;
            synchronized (linkedList) {
                while (this.send_queue.size() > 0) {
                    byte[] data = (byte[])this.send_queue.getFirst();
                    if (total > 0 && total + data.length > max) break;
                    reply.add(this.send_queue.removeFirst());
                    total += data.length;
                }
            }
            for (int i = 1; i < reply.size(); ++i) {
                this.send_queue_sem.reserve();
            }
        }
        return reply;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean receiveIncomplete() {
        LinkedList linkedList = this.send_queue;
        synchronized (linkedList) {
            return this.send_queue.size() > 0;
        }
    }

    public void close() throws MessageException {
        this.close(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void close(Throwable close_cause) throws MessageException {
        block14: {
            if (this.closed) {
                return;
            }
            GenericMessageConnectionIndirect.log("connection to " + this.endpoint.getNotionalAddress() + " closed" + (close_cause == null ? "" : " (" + close_cause + ")"));
            try {
                this.closed = true;
                if (this.incoming) {
                    Map map = remote_connections;
                    synchronized (map) {
                        remote_connections.remove(new Long(this.connection_id));
                        break block14;
                    }
                }
                Map map = local_connections;
                synchronized (map) {
                    local_connections.remove(new Long(this.connection_id));
                }
                HashMap<String, Long> message = new HashMap<String, Long>();
                message.put("con_id", new Long(this.connection_id));
                message.put("type", new Long(4L));
                try {
                    this.nat_traverser.sendMessage(this.message_manager, this.rendezvous, this.target, message);
                    this.last_message_sent = SystemTime.getCurrentTime();
                }
                catch (Throwable e) {
                    throw new MessageException("Close operation failed", e);
                }
            }
            finally {
                if (close_cause != null) {
                    this.owner.reportFailed(close_cause);
                }
            }
        }
    }

    protected boolean isClosed() {
        return this.closed;
    }

    protected boolean prepareForKeepAlive(boolean force) {
        if (this.keep_alive_in_progress) {
            return false;
        }
        long now = SystemTime.getCurrentTime();
        if (force || now < this.last_message_sent || now - this.last_message_sent > 10000L) {
            this.keep_alive_in_progress = true;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void keepAlive() {
        try {
            this.send(new ArrayList());
        }
        finally {
            this.keep_alive_in_progress = false;
        }
    }

    protected static void log(String str) {
        if (Logger.isEnabled()) {
            Logger.log(new LogEvent(LOGID, "GenericMessaging (indirect):" + str));
        }
    }

    protected void trace(String str) {
    }

    static {
        SimpleTimer.addPeriodicEvent("DDBTorrent:timeout2", 5000L, new TimerEventPerformer(){
            private int tick_count = 0;

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void perform(TimerEvent event2) {
                Map map;
                ++this.tick_count;
                if (this.tick_count % 12 == 0 && Logger.isEnabled()) {
                    int remote_total;
                    int local_total;
                    map = local_connections;
                    synchronized (map) {
                        local_total = local_connections.size();
                    }
                    map = remote_connections;
                    synchronized (map) {
                        remote_total = remote_connections.size();
                    }
                    if (local_total + remote_total > 0) {
                        GenericMessageConnectionIndirect.log("local=" + local_total + " [" + GenericMessageConnectionIndirect.getLocalConnectionStatus() + "], remote=" + remote_total + " [" + GenericMessageConnectionIndirect.getRemoteConnectionStatus() + "]");
                    }
                }
                if (this.tick_count % 1 == 0) {
                    Map local_total = local_connections;
                    synchronized (local_total) {
                        for (final GenericMessageConnectionIndirect con : local_connections.values()) {
                            if (!con.prepareForKeepAlive(false)) continue;
                            keep_alive_pool.run(new AERunnable(){

                                public void runSupport() {
                                    con.keepAlive();
                                }
                            });
                        }
                    }
                    long now = SystemTime.getCurrentTime();
                    map = remote_connections;
                    synchronized (map) {
                        for (GenericMessageConnectionIndirect con : remote_connections.values()) {
                            long last_receive = con.getLastMessageReceivedTime();
                            if (now - last_receive <= 30000L) continue;
                            try {
                                con.close(new Throwable("Timeout"));
                            }
                            catch (Throwable e) {
                                Debug.printStackTrace(e);
                            }
                        }
                    }
                }
            }
        });
    }
}

