/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.ui.swt.components;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.text.MessageFormat;
import java.util.LinkedList;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.gudy.azureus2.core3.util.Debug;

public class FlatImageButton
extends Canvas {
    public static final URL PLUS_BUTTON = FlatImageButton.class.getClassLoader().getResource("org/gudy/azureus2/ui/icons/imagebutton/plus.png");
    public static final URL MINUS_BUTTON = FlatImageButton.class.getClassLoader().getResource("org/gudy/azureus2/ui/icons/imagebutton/minus.png");
    private static final String RES_PREFIX = "org/gudy/azureus2/ui/icons/imagebutton/";
    private Image[] imageStates = new Image[3];
    private static final int NORMAL = 0;
    private static final int PRESSED = 1;
    private static final int DISABLED = 2;
    private int currentState = 0;
    private LinkedList selectionListeners = new LinkedList();

    public FlatImageButton(Composite parent, int style) {
        super(parent, 0x200000);
        this.setBackground(parent.getDisplay().getSystemColor(22));
        this.setForeground(parent.getDisplay().getSystemColor(21));
        ButtonEventHandler handler = new ButtonEventHandler();
        this.addPaintListener(handler);
        this.addDisposeListener(handler);
        this.addMouseListener((MouseListener)handler);
        super.setSize(16, 16);
    }

    public FlatImageButton(Composite parent, String filename) {
        this(parent, 0);
        if (new File(filename).exists()) {
            this.setImage(new Image((Device)parent.getDisplay(), filename));
        } else {
            Debug.out(MessageFormat.format("Image file {0} for FlatImageButton not found. ", filename));
        }
    }

    public FlatImageButton(Composite parent, URL resource) {
        this(parent, 0);
        if (resource != null) {
            this.setImage(parent.getDisplay(), resource);
        } else {
            Debug.out(MessageFormat.format("Image resource for FlatImageButton {0} not found. ", this.toString()));
        }
    }

    public void addSelectionListener(SelectionListener listener) {
        this.selectionListeners.add(listener);
    }

    public void removeSelectionListener(SelectionListener listener) {
        this.selectionListeners.remove(listener);
    }

    public void setEnabled(boolean enable) {
        if (this.currentState == 2 && enable) {
            this.currentState = 0;
            this.redraw();
        } else if (this.currentState != 1 || !enable) {
            this.currentState = 2;
            this.redraw();
        }
        super.setEnabled(enable);
    }

    public void setImage(Image img) {
        this.disposePreviousImages();
        this.imageStates[0] = img;
        this.imageStates[1] = new Image((Device)Display.getCurrent(), img, 2);
        this.imageStates[2] = new Image((Device)Display.getCurrent(), img, 1);
        super.setSize(img.getBounds().width, img.getBounds().height);
    }

    private void setImage(Display context, URL resource) {
        this.disposePreviousImages();
        try {
            this.imageStates[0] = new Image((Device)context, resource.openStream());
            this.imageStates[1] = new Image((Device)context, new URL(String.valueOf(resource) + ".pressed.png").openStream());
            this.imageStates[2] = new Image((Device)context, new URL(String.valueOf(resource) + ".disabled.png").openStream());
            super.setSize(this.imageStates[0].getBounds().width, this.imageStates[0].getBounds().height);
        }
        catch (IOException e) {
            Debug.printStackTrace(e);
        }
    }

    private void disposePreviousImages() {
        for (int i = 0; i < this.imageStates.length; ++i) {
            Image imageState = this.imageStates[i];
            if (imageState == null) continue;
            imageState.dispose();
        }
    }

    private void executeCallback() {
        Event ev = new Event();
        ev.type = 13;
        ev.item = this;
        ev.widget = this;
        SelectionEvent selev = new SelectionEvent(ev);
        for (SelectionListener listener : this.selectionListeners) {
            listener.widgetSelected(selev);
        }
    }

    private class ButtonEventHandler
    extends MouseAdapter
    implements DisposeListener,
    PaintListener,
    KeyListener {
        private ButtonEventHandler() {
        }

        public void widgetDisposed(DisposeEvent disposeEvent) {
            FlatImageButton.this.disposePreviousImages();
        }

        public void paintControl(PaintEvent e) {
            Image img = FlatImageButton.this.imageStates[FlatImageButton.this.currentState];
            if (img == null) {
                e.gc.setBackground(e.display.getSystemColor(13));
                e.gc.fillRectangle(FlatImageButton.this.getBounds());
                return;
            }
            int x = Math.max(0, 0 + (FlatImageButton.this.getSize().x - ((FlatImageButton)FlatImageButton.this).imageStates[((FlatImageButton)FlatImageButton.this).currentState].getBounds().width) / 2);
            int y = Math.max(0, 0 + (FlatImageButton.this.getSize().y - ((FlatImageButton)FlatImageButton.this).imageStates[((FlatImageButton)FlatImageButton.this).currentState].getBounds().height) / 2);
            e.gc.drawImage(img, x, y);
            if (FlatImageButton.this.isFocusControl()) {
                e.gc.drawFocus(x, y, ((FlatImageButton)FlatImageButton.this).imageStates[((FlatImageButton)FlatImageButton.this).currentState].getBounds().width, ((FlatImageButton)FlatImageButton.this).imageStates[((FlatImageButton)FlatImageButton.this).currentState].getBounds().height);
            }
        }

        public void mouseDown(MouseEvent mouseEvent) {
            FlatImageButton.this.currentState = FlatImageButton.this.isEnabled() ? 1 : 2;
            FlatImageButton.this.redraw();
            if (FlatImageButton.this.isEnabled() && mouseEvent.button == 1) {
                FlatImageButton.this.executeCallback();
                this.mouseUp(mouseEvent);
                FlatImageButton.this.redraw();
            }
        }

        public void mouseUp(MouseEvent mouseEvent) {
            FlatImageButton.this.currentState = FlatImageButton.this.isEnabled() ? 0 : 2;
            FlatImageButton.this.redraw();
        }

        public void keyPressed(KeyEvent event2) {
            if (event2.character != '\r') {
                return;
            }
            FlatImageButton.this.currentState = FlatImageButton.this.isEnabled() ? 1 : 2;
            FlatImageButton.this.redraw();
            if (FlatImageButton.this.isEnabled()) {
                FlatImageButton.this.executeCallback();
                this.keyReleased(event2);
                FlatImageButton.this.redraw();
            }
        }

        public void keyReleased(KeyEvent event2) {
            if (event2.character != '\r') {
                return;
            }
            FlatImageButton.this.currentState = FlatImageButton.this.isEnabled() ? 0 : 2;
            FlatImageButton.this.redraw();
        }
    }
}

