/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.ui.swt.maketorrent;

import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.swt.custom.TreeEditor;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Decorations;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.swt.widgets.Widget;
import org.gudy.azureus2.core3.util.Constants;
import org.gudy.azureus2.ui.swt.ImageRepository;
import org.gudy.azureus2.ui.swt.Messages;
import org.gudy.azureus2.ui.swt.Utils;
import org.gudy.azureus2.ui.swt.components.shell.ShellFactory;
import org.gudy.azureus2.ui.swt.mainwindow.Colors;
import org.gudy.azureus2.ui.swt.maketorrent.TrackerEditorListener;

public class MultiTrackerEditor {
    TrackerEditorListener listener;
    String oldName;
    String currentName;
    boolean anonymous;
    List trackers;
    Display display;
    Shell shell;
    Text textName;
    Tree treeGroups;
    TreeEditor editor;
    TreeItem itemEdited;
    Button btnSave;
    Button btnCancel;
    Menu menu;

    public MultiTrackerEditor(String name, List trackers, TrackerEditorListener listener) {
        this(name, trackers, listener, false);
    }

    public MultiTrackerEditor(String name, List trackers, TrackerEditorListener listener, boolean _anonymous) {
        this.oldName = name;
        this.currentName = name != null ? name : "";
        this.listener = listener;
        this.anonymous = _anonymous;
        this.trackers = new ArrayList(trackers);
        this.createWindow();
    }

    private void createWindow() {
        GridData gridData;
        this.display = Display.getCurrent();
        this.shell = ShellFactory.createShell(67680);
        Messages.setLanguageText((Widget)this.shell, "wizard.multitracker.edit.title");
        if (!Constants.isOSX) {
            this.shell.setImage(ImageRepository.getImage("azureus"));
        }
        GridLayout layout = new GridLayout();
        layout.numColumns = 3;
        this.shell.setLayout((Layout)layout);
        if (!this.anonymous) {
            Label labelName = new Label((Composite)this.shell, 0);
            Messages.setLanguageText((Widget)labelName, "wizard.multitracker.edit.name");
            this.textName = new Text((Composite)this.shell, 2048);
            this.textName.setText(this.currentName);
            gridData = new GridData(768);
            gridData.horizontalSpan = 2;
            this.textName.setLayoutData((Object)gridData);
            this.textName.addModifyListener(new ModifyListener(){

                public void modifyText(ModifyEvent arg0) {
                    MultiTrackerEditor.this.currentName = MultiTrackerEditor.this.textName.getText();
                    MultiTrackerEditor.this.computeSaveEnable();
                }
            });
        }
        this.treeGroups = new Tree((Composite)this.shell, 2048);
        gridData = new GridData(1808);
        gridData.horizontalSpan = 3;
        gridData.heightHint = 150;
        this.treeGroups.setLayoutData((Object)gridData);
        this.treeGroups.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDoubleClick(MouseEvent arg0) {
                TreeItem treeItem;
                String type;
                if (MultiTrackerEditor.this.treeGroups.getSelectionCount() == 1 && (type = (String)(treeItem = MultiTrackerEditor.this.treeGroups.getSelection()[0]).getData("type")).equals("tracker")) {
                    MultiTrackerEditor.this.editTreeItem(treeItem);
                }
            }
        });
        Label labelSeparator = new Label((Composite)this.shell, 258);
        gridData = new GridData(768);
        gridData.horizontalSpan = 3;
        labelSeparator.setLayoutData((Object)gridData);
        Label label = new Label((Composite)this.shell, 0);
        gridData = new GridData(768);
        label.setLayoutData((Object)gridData);
        Composite cButtons = new Composite((Composite)this.shell, 0);
        gridData = new GridData(768);
        gridData.horizontalSpan = 2;
        cButtons.setLayoutData((Object)gridData);
        GridLayout layoutButtons = new GridLayout();
        layoutButtons.numColumns = 3;
        cButtons.setLayout((Layout)layoutButtons);
        label = new Label(cButtons, 0);
        gridData = new GridData(768);
        label.setLayoutData((Object)gridData);
        this.btnSave = new Button(cButtons, 8);
        gridData = new GridData();
        gridData.widthHint = 70;
        gridData.horizontalAlignment = 3;
        this.btnSave.setLayoutData((Object)gridData);
        Messages.setLanguageText((Widget)this.btnSave, "wizard.multitracker.edit.save");
        this.btnSave.addListener(13, new Listener(){

            public void handleEvent(Event e) {
                MultiTrackerEditor.this.update();
                MultiTrackerEditor.this.shell.dispose();
            }
        });
        this.btnCancel = new Button(cButtons, 8);
        gridData = new GridData();
        gridData.horizontalAlignment = 3;
        gridData.widthHint = 70;
        this.btnCancel.setLayoutData((Object)gridData);
        Messages.setLanguageText((Widget)this.btnCancel, "Button.cancel");
        this.btnCancel.addListener(13, new Listener(){

            public void handleEvent(Event e) {
                MultiTrackerEditor.this.shell.dispose();
            }
        });
        this.shell.setDefaultButton(this.btnSave);
        this.shell.addListener(31, new Listener(){

            public void handleEvent(Event e) {
                if (e.character == '\u001b') {
                    MultiTrackerEditor.this.shell.dispose();
                }
            }
        });
        this.computeSaveEnable();
        this.refresh();
        this.constructMenu();
        this.editor = new TreeEditor(this.treeGroups);
        this.treeGroups.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent arg0) {
                if (MultiTrackerEditor.this.itemEdited != null && !MultiTrackerEditor.this.editor.getEditor().isDisposed()) {
                    MultiTrackerEditor.this.itemEdited.setText(((Text)MultiTrackerEditor.this.editor.getEditor()).getText());
                }
                MultiTrackerEditor.this.removeEditor();
            }
        });
        Point size = this.shell.computeSize(400, -1);
        this.shell.setSize(size);
        Utils.centreWindow(this.shell);
        this.shell.open();
    }

    private void update() {
        this.trackers = new ArrayList();
        TreeItem[] groupItems = this.treeGroups.getItems();
        for (int i = 0; i < groupItems.length; ++i) {
            TreeItem group = groupItems[i];
            TreeItem[] trackerItems = group.getItems();
            ArrayList<String> groupList = new ArrayList<String>(group.getItemCount());
            for (int j = 0; j < trackerItems.length; ++j) {
                groupList.add(trackerItems[j].getText());
            }
            this.trackers.add(groupList);
        }
        this.listener.trackersChanged(this.oldName, this.currentName, this.trackers);
        this.oldName = this.currentName;
    }

    private void computeSaveEnable() {
        boolean enabled;
        boolean bl = enabled = this.anonymous || !"".equals(this.currentName);
        if (enabled) {
            TreeItem[] groupItems = this.treeGroups.getItems();
            block0: for (int i = 0; i < groupItems.length; ++i) {
                TreeItem group = groupItems[i];
                TreeItem[] trackerItems = group.getItems();
                for (int j = 0; j < trackerItems.length; ++j) {
                    if (this.validURL(trackerItems[j].getText())) continue;
                    enabled = false;
                    break block0;
                }
            }
        }
        if (enabled != this.btnSave.getEnabled()) {
            this.btnSave.setEnabled(enabled);
        }
    }

    private void refresh() {
        this.treeGroups.removeAll();
        for (List trackerGroup : this.trackers) {
            TreeItem itemRoot = this.newGroup();
            for (String url : trackerGroup) {
                this.newTracker(itemRoot, url);
            }
        }
    }

    private void constructMenu() {
        this.menu = new Menu((Decorations)this.shell, 0);
        this.menu.addListener(22, new Listener(){

            public void handleEvent(Event e) {
                MenuItem[] items = MultiTrackerEditor.this.menu.getItems();
                for (int i = 0; i < items.length; ++i) {
                    items[i].dispose();
                }
                if (MultiTrackerEditor.this.treeGroups.getSelectionCount() != 1) {
                    MenuItem item = new MenuItem(MultiTrackerEditor.this.menu, 0);
                    Messages.setLanguageText((Widget)item, "wizard.multitracker.edit.newgroup");
                    item.addListener(13, new Listener(){

                        public void handleEvent(Event arg0) {
                            TreeItem group = MultiTrackerEditor.this.newGroup();
                            TreeItem itemTracker = MultiTrackerEditor.this.newTracker(group, "http://");
                            MultiTrackerEditor.this.editTreeItem(itemTracker);
                        }
                    });
                    return;
                }
                final TreeItem treeItem = MultiTrackerEditor.this.treeGroups.getSelection()[0];
                String type = (String)treeItem.getData("type");
                if (type.equals("tracker")) {
                    MenuItem item = new MenuItem(MultiTrackerEditor.this.menu, 0);
                    Messages.setLanguageText((Widget)item, "wizard.multitracker.edit.deletetracker");
                    item.addListener(13, new Listener(){

                        public void handleEvent(Event arg0) {
                            treeItem.dispose();
                        }
                    });
                    item = new MenuItem(MultiTrackerEditor.this.menu, 0);
                    Messages.setLanguageText((Widget)item, "wizard.multitracker.edit.edit");
                    item.addListener(13, new Listener(){

                        public void handleEvent(Event arg0) {
                            MultiTrackerEditor.this.editTreeItem(treeItem);
                        }
                    });
                } else if (type.equals("group")) {
                    MenuItem item = new MenuItem(MultiTrackerEditor.this.menu, 0);
                    Messages.setLanguageText((Widget)item, "wizard.multitracker.edit.newgroup");
                    item.addListener(13, new Listener(){

                        public void handleEvent(Event arg0) {
                            TreeItem group = MultiTrackerEditor.this.newGroup();
                            TreeItem itemTracker = MultiTrackerEditor.this.newTracker(group, "http://");
                            MultiTrackerEditor.this.editTreeItem(itemTracker);
                        }
                    });
                    item = new MenuItem(MultiTrackerEditor.this.menu, 0);
                    Messages.setLanguageText((Widget)item, "wizard.multitracker.edit.deletegroup");
                    item.addListener(13, new Listener(){

                        public void handleEvent(Event arg0) {
                            TreeItem[] subItems = treeItem.getItems();
                            for (int i = 0; i < subItems.length; ++i) {
                                subItems[i].dispose();
                            }
                            treeItem.dispose();
                        }
                    });
                    new MenuItem(MultiTrackerEditor.this.menu, 2);
                    item = new MenuItem(MultiTrackerEditor.this.menu, 0);
                    Messages.setLanguageText((Widget)item, "wizard.multitracker.edit.newtracker");
                    item.addListener(13, new Listener(){

                        public void handleEvent(Event arg0) {
                            TreeItem itemTracker = MultiTrackerEditor.this.newTracker(treeItem, "http://");
                            MultiTrackerEditor.this.editTreeItem(itemTracker);
                        }
                    });
                }
            }
        });
        this.treeGroups.setMenu(this.menu);
    }

    private void editTreeItem(final TreeItem item) {
        Control oldEditor = this.editor.getEditor();
        if (oldEditor != null) {
            oldEditor.dispose();
        }
        this.itemEdited = item;
        final Text text = new Text((Composite)this.treeGroups, 2048);
        text.setText(item.getText());
        text.setForeground(item.getForeground());
        text.setSelection(item.getText().length());
        text.addListener(14, new Listener(){

            public void handleEvent(Event e) {
                String url = text.getText();
                if (MultiTrackerEditor.this.validURL(url)) {
                    text.setForeground(null);
                    item.setForeground(null);
                } else {
                    text.setForeground(Colors.colorError);
                    item.setForeground(Colors.colorError);
                }
                item.setText(url);
                MultiTrackerEditor.this.computeSaveEnable();
                MultiTrackerEditor.this.removeEditor();
            }
        });
        text.addListener(24, new Listener(){

            public void handleEvent(Event e) {
                String url = text.getText();
                if (MultiTrackerEditor.this.validURL(url)) {
                    text.setForeground(null);
                    item.setForeground(null);
                } else {
                    text.setForeground(Colors.colorError);
                    item.setForeground(Colors.colorError);
                }
                item.setText(url);
                MultiTrackerEditor.this.computeSaveEnable();
            }
        });
        text.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyReleased(KeyEvent keyEvent) {
                if (keyEvent.character == '\u001b') {
                    MultiTrackerEditor.this.removeEditor();
                }
            }
        });
        this.editor.horizontalAlignment = 16384;
        this.editor.grabHorizontal = true;
        this.editor.minimumWidth = 50;
        Rectangle r = text.computeTrim(0, 0, 100, text.getLineHeight());
        this.editor.minimumHeight = r.height;
        this.editor.setEditor((Control)text, item);
        text.setFocus();
    }

    private boolean validURL(String str) {
        try {
            URL url = new URL(str);
            String prot = url.getProtocol().toLowerCase();
            return prot.equals("http") || prot.equals("https") || prot.equals("udp");
        }
        catch (Throwable e) {
            return false;
        }
    }

    private void removeEditor() {
        Control oldEditor = this.editor.getEditor();
        if (oldEditor != null) {
            oldEditor.dispose();
        }
    }

    private TreeItem newGroup() {
        TreeItem item = new TreeItem(this.treeGroups, 0);
        item.setData("type", (Object)"group");
        Messages.setLanguageText((Widget)item, "wizard.multitracker.group");
        return item;
    }

    private TreeItem newTracker(TreeItem root, String url) {
        TreeItem item = new TreeItem(root, 0);
        item.setText(url);
        item.setData("type", (Object)"tracker");
        root.setExpanded(true);
        return item;
    }
}

