/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.ui.swt.views.configsections;

import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.program.Program;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Widget;
import org.gudy.azureus2.core3.config.COConfigurationManager;
import org.gudy.azureus2.core3.internat.MessageText;
import org.gudy.azureus2.core3.peer.PEPeerSource;
import org.gudy.azureus2.core3.util.AENetworkClassifier;
import org.gudy.azureus2.ui.swt.Messages;
import org.gudy.azureus2.ui.swt.config.BooleanParameter;
import org.gudy.azureus2.ui.swt.config.IntParameter;
import org.gudy.azureus2.ui.swt.config.Parameter;
import org.gudy.azureus2.ui.swt.config.ParameterChangeListener;
import org.gudy.azureus2.ui.swt.mainwindow.Colors;
import org.gudy.azureus2.ui.swt.mainwindow.Cursors;
import org.gudy.azureus2.ui.swt.plugins.UISWTConfigSection;

public class ConfigSectionConnection
implements UISWTConfigSection {
    private static final String CFG_PREFIX = "ConfigView.section.connection.";
    private static final boolean ENABLE_TCP_UDP_EXPERIMENTAL = false;

    public String configSectionGetParentSection() {
        return "root";
    }

    public String configSectionGetName() {
        return "server";
    }

    public void configSectionSave() {
    }

    public void configSectionDelete() {
    }

    public Composite configSectionCreate(Composite parent) {
        int userMode = COConfigurationManager.getIntParameter("User Mode");
        Composite cSection = new Composite(parent, 0);
        GridData gridData = new GridData(272);
        cSection.setLayoutData((Object)gridData);
        GridLayout layout = new GridLayout();
        cSection.setLayout((Layout)layout);
        Composite cMiniArea = new Composite(cSection, 0);
        layout = new GridLayout();
        layout.numColumns = 2;
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        cMiniArea.setLayout((Layout)layout);
        gridData = new GridData(768);
        cMiniArea.setLayoutData((Object)gridData);
        final boolean separate_ports = userMode > 1 || COConfigurationManager.getIntParameter("TCP.Listen.Port") != COConfigurationManager.getIntParameter("UDP.Listen.Port");
        Label label = new Label(cMiniArea, 0);
        Messages.setLanguageText((Widget)label, separate_ports ? "ConfigView.label.tcplistenport" : "ConfigView.label.serverport");
        gridData = new GridData();
        label.setLayoutData((Object)gridData);
        final IntParameter tcplisten = new IntParameter(cMiniArea, "TCP.Listen.Port", 1, 65535, false, false);
        gridData = new GridData();
        gridData.widthHint = 40;
        tcplisten.setLayoutData(gridData);
        tcplisten.addChangeListener(new ParameterChangeListener(){

            public void parameterChanged(Parameter p, boolean caused_internally) {
                int val = tcplisten.getValue();
                if (val == 6880 || val == 6881) {
                    val = 6881;
                    tcplisten.setValue(val);
                }
                if (!separate_ports) {
                    COConfigurationManager.setParameter("UDP.Listen.Port", val);
                }
            }
        });
        if (separate_ports) {
            label = new Label(cMiniArea, 0);
            Messages.setLanguageText((Widget)label, "ConfigView.label.udplistenport");
            gridData = new GridData(128);
            label.setLayoutData((Object)gridData);
            final IntParameter udp_listen = new IntParameter(cMiniArea, "UDP.Listen.Port", 1, 65535, false, false);
            gridData = new GridData();
            gridData.widthHint = 40;
            udp_listen.setLayoutData(gridData);
            udp_listen.addChangeListener(new ParameterChangeListener(){

                public void parameterChanged(Parameter p, boolean caused_internally) {
                    int val = udp_listen.getValue();
                    if (val == 6880 || val == 6881) {
                        val = 6881;
                        udp_listen.setValue(val);
                    }
                }
            });
        }
        if (userMode < 2) {
            label = new Label(cSection, 0);
            gridData = new GridData();
            label.setLayoutData((Object)gridData);
            label.setText(MessageText.getString("Utils.link.visit") + ":");
            Label linkLabel = new Label(cSection, 0);
            linkLabel.setText(MessageText.getString("ConfigView.section.connection.serverport.wiki"));
            linkLabel.setData((Object)"http://azureus.aelitis.com/wiki/index.php?title=Why_ports_like_6881_are_no_good_choice");
            linkLabel.setCursor(Cursors.handCursor);
            linkLabel.setForeground(Colors.blue);
            gridData = new GridData();
            linkLabel.setLayoutData((Object)gridData);
            linkLabel.addMouseListener((MouseListener)new MouseAdapter(){

                public void mouseDoubleClick(MouseEvent arg0) {
                    Program.launch((String)((String)((Label)arg0.widget).getData()));
                }

                public void mouseDown(MouseEvent arg0) {
                    Program.launch((String)((String)((Label)arg0.widget).getData()));
                }
            });
        }
        if (userMode > 0) {
            Group peer_sources_group = new Group(cSection, 0);
            Messages.setLanguageText((Widget)peer_sources_group, "ConfigView.section.connection.group.peersources");
            GridLayout peer_sources_layout = new GridLayout();
            peer_sources_group.setLayout((Layout)peer_sources_layout);
            gridData = new GridData();
            peer_sources_group.setLayoutData((Object)gridData);
            label = new Label((Composite)peer_sources_group, 64);
            Messages.setLanguageText((Widget)label, "ConfigView.section.connection.group.peersources.info");
            gridData = new GridData();
            label.setLayoutData((Object)gridData);
            for (int i = 0; i < PEPeerSource.PS_SOURCES.length; ++i) {
                String p = PEPeerSource.PS_SOURCES[i];
                String config_name = "Peer Source Selection Default." + p;
                String msg_text = "ConfigView.section.connection.peersource." + p;
                BooleanParameter peer_source = new BooleanParameter((Composite)peer_sources_group, config_name, msg_text);
                gridData = new GridData();
                peer_source.setLayoutData(gridData);
            }
            if (userMode > 1) {
                Group networks_group = new Group(cSection, 0);
                Messages.setLanguageText((Widget)networks_group, "ConfigView.section.connection.group.networks");
                GridLayout networks_layout = new GridLayout();
                networks_group.setLayout((Layout)networks_layout);
                gridData = new GridData();
                networks_group.setLayoutData((Object)gridData);
                label = new Label((Composite)networks_group, 0);
                Messages.setLanguageText((Widget)label, "ConfigView.section.connection.group.networks.info");
                gridData = new GridData();
                label.setLayoutData((Object)gridData);
                for (int i = 0; i < AENetworkClassifier.AT_NETWORKS.length; ++i) {
                    String nn = AENetworkClassifier.AT_NETWORKS[i];
                    String config_name = "Network Selection Default." + nn;
                    String msg_text = "ConfigView.section.connection.networks." + nn;
                    BooleanParameter network = new BooleanParameter((Composite)networks_group, config_name, msg_text);
                    gridData = new GridData();
                    network.setLayoutData(gridData);
                }
                label = new Label((Composite)networks_group, 0);
                gridData = new GridData();
                label.setLayoutData((Object)gridData);
                BooleanParameter network_prompt = new BooleanParameter((Composite)networks_group, "Network Selection Prompt", "ConfigView.section.connection.networks.prompt");
                gridData = new GridData();
                network_prompt.setLayoutData(gridData);
            }
        }
        return cSection;
    }
}

