/* "CodeWorker":	a scripting language for parsing and generating text.

Copyright (C) 1996-1997, 1999-2005 Cdric Lemaire

This library is free software; you can redistribute it and/or
modify it under the terms of the GNU Lesser General Public
License as published by the Free Software Foundation; either
version 2.1 of the License, or (at your option) any later version.

This library is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
Lesser General Public License for more details.

You should have received a copy of the GNU Lesser General Public
License along with this library; if not, write to the Free Software
Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

To contact the author: codeworker@free.fr
*/

package org.codeworker.jni;

public class Runtime {
    public static native void registerScript(java.lang.String pKey, org.codeworker.IEXECUTE_FUNCTION pScript);
    public static native int entryPoint(java.lang.String[] tsArgs, org.codeworker.IEXECUTE_FUNCTION pScript);
    public static native org.codeworker.IParseTree getThisTree();
    public static native void throwBNFExecutionError(java.lang.String sMessage);
    public static native void parseAsBNF(org.codeworker.IEXECUTE_FUNCTION pScript, org.codeworker.IParseTree pContext, java.lang.String sInputFile);
//##markup##"functions"
//##begin##"functions"
	public static native void appendFile(java.lang.String sFilename, java.lang.String sContent);
	public static native void clearVariable(org.codeworker.IParseTree pNode);
	public static native void compileToCpp(java.lang.String sScriptFileName, java.lang.String sProjectDirectory, java.lang.String sCodeWorkerDirectory);
	public static native void copyFile(java.lang.String sSourceFileName, java.lang.String sDestinationFileName);
	public static native void copyGenerableFile(java.lang.String sSourceFileName, java.lang.String sDestinationFileName);
	public static native void copySmartDirectory(java.lang.String sSourceDirectory, java.lang.String sDestinationPath);
	public static native void cutString(java.lang.String sText, java.lang.String sSeparator, org.codeworker.IParseTree slList);
	public static native void environTable(org.codeworker.IParseTree pTable);
	public static native void extendExecutedScript(java.lang.String sScriptContent);
	public static native void insertElementAt(org.codeworker.IParseTree pList, java.lang.String sKey, int iPosition);
	public static native void invertArray(org.codeworker.IParseTree pArray);
	public static native void listAllGeneratedFiles(org.codeworker.IParseTree pFiles);
	public static native void openLogFile(java.lang.String sFilename);
	public static native void produceHTML(java.lang.String sScriptFileName, java.lang.String sHTMLFileName);
	public static native void putEnv(java.lang.String sName, java.lang.String sValue);
	public static native void randomSeed(int iSeed);
	public static native void removeAllElements(org.codeworker.IParseTree pVariable);
	public static native void removeElement(org.codeworker.IParseTree pVariable, java.lang.String sKey);
	public static native void removeFirstElement(org.codeworker.IParseTree pList);
	public static native void removeLastElement(org.codeworker.IParseTree pList);
	public static native void removeRecursive(org.codeworker.IParseTree pVariable, java.lang.String sAttribute);
	public static native void removeVariable(org.codeworker.IParseTree pNode);
	public static native void saveBinaryToFile(java.lang.String sFilename, java.lang.String sContent);
	public static native void saveProject(java.lang.String sXMLFileName, org.codeworker.IParseTree pNodeToSave);
	public static native void saveProjectTypes(java.lang.String sXMLFileName);
	public static native void saveToFile(java.lang.String sFilename, java.lang.String sContent);
	public static native void setCommentBegin(java.lang.String sCommentBegin);
	public static native void setCommentEnd(java.lang.String sCommentEnd);
	public static native void setGenerationHeader(java.lang.String sComment);
	public static native void setIncludePath(java.lang.String sPath);
	public static native void setNow(java.lang.String sConstantDateTime);
	public static native void setProperty(java.lang.String sDefine, java.lang.String sValue);
	public static native void setTextMode(java.lang.String sTextMode);
	public static native void setVersion(java.lang.String sVersion);
	public static native void setWriteMode(java.lang.String sMode);
	public static native void setWorkingPath(java.lang.String sPath);
	public static native void sleep(int iMillis);
	public static native void slideNodeContent(org.codeworker.IParseTree pOrgNode, java.lang.String xDestNode);
	public static native void sortArray(org.codeworker.IParseTree pArray);
	public static native void traceEngine();
	public static native void traceLine(java.lang.String sLine);
	public static native void traceObject(org.codeworker.IParseTree pObject, int iDepth);
	public static native void traceText(java.lang.String sText);
	public static native void attachInputToSocket(int iSocket);
	public static native void detachInputFromSocket(int iSocket);
	public static native void goBack();
	public static native void setInputLocation(int iLocation);
	public static native void allFloatingLocations(org.codeworker.IParseTree pList);
	public static native void attachOutputToSocket(int iSocket);
	public static native void detachOutputFromSocket(int iSocket);
	public static native void incrementIndentLevel(int iLevel);
	public static native void insertText(int iLocation, java.lang.String sText);
	public static native void insertTextOnce(int iLocation, java.lang.String sText);
	public static native void insertTextToFloatingLocation(java.lang.String sLocation, java.lang.String sText);
	public static native void insertTextOnceToFloatingLocation(java.lang.String sLocation, java.lang.String sText);
	public static native void overwritePortion(int iLocation, java.lang.String sText, int iSize);
	public static native void populateProtectedArea(java.lang.String sProtectedAreaName, java.lang.String sContent);
	public static native void resizeOutputStream(int iNewSize);
	public static native void setFloatingLocation(java.lang.String sKey, int iLocation);
	public static native void setOutputLocation(int iLocation);
	public static native void setProtectedArea(java.lang.String sProtectedAreaName);
	public static native void writeBytes(java.lang.String sBytes);
	public static native void writeText(java.lang.String sText);
	public static native void writeTextOnce(java.lang.String sText);
	public static native void closeSocket(int iSocket);
	public static native boolean flushOutputToSocket(int iSocket);
	public static native int acceptSocket(int iServerSocket);
	public static native double add(double dLeft, double dRight);
	public static native java.lang.String addToDate(java.lang.String sDate, java.lang.String sFormat, java.lang.String sShifting);
	public static native java.lang.String byteToChar(java.lang.String sByte);
	public static native long bytesToLong(java.lang.String sBytes);
	public static native short bytesToShort(java.lang.String sBytes);
	public static native java.lang.String canonizePath(java.lang.String sPath);
	public static native boolean changeDirectory(java.lang.String sPath);
	public static native int changeFileTime(java.lang.String sFilename, java.lang.String sAccessTime, java.lang.String sModificationTime);
	public static native java.lang.String charAt(java.lang.String sText, int iIndex);
	public static native java.lang.String charToByte(java.lang.String sChar);
	public static native int charToInt(java.lang.String sChar);
	public static native boolean chmod(java.lang.String sFilename, java.lang.String sMode);
	public static native int ceil(double dNumber);
	public static native int compareDate(java.lang.String sDate1, java.lang.String sDate2);
	public static native java.lang.String completeDate(java.lang.String sDate, java.lang.String sFormat);
	public static native java.lang.String completeLeftSpaces(java.lang.String sText, int iLength);
	public static native java.lang.String completeRightSpaces(java.lang.String sText, int iLength);
	public static native java.lang.String composeAdaLikeString(java.lang.String sText);
	public static native java.lang.String composeCLikeString(java.lang.String sText);
	public static native java.lang.String composeHTMLLikeString(java.lang.String sText);
	public static native java.lang.String composeSQLLikeString(java.lang.String sText);
	public static native java.lang.String computeMD5(java.lang.String sText);
	public static native boolean copySmartFile(java.lang.String sSourceFileName, java.lang.String sDestinationFileName);
	public static native java.lang.String coreString(java.lang.String sText, int iPos, int iLastRemoved);
	public static native int countStringOccurences(java.lang.String sString, java.lang.String sText);
	public static native boolean createDirectory(java.lang.String sPath);
	public static native int createINETClientSocket(java.lang.String sRemoteAddress, int iPort);
	public static native int createINETServerSocket(int iPort, int iBackLog);
	public static native boolean createIterator(org.codeworker.IParseTree pI, org.codeworker.IParseTree pList);
	public static native boolean createReverseIterator(org.codeworker.IParseTree pI, org.codeworker.IParseTree pList);
	public static native boolean createVirtualFile(java.lang.String sHandle, java.lang.String sContent);
	public static native java.lang.String createVirtualTemporaryFile(java.lang.String sContent);
	public static native java.lang.String decodeURL(java.lang.String sURL);
	public static native double decrement(org.codeworker.DoubleRef dNumber);
	public static native boolean deleteFile(java.lang.String sFilename);
	public static native boolean deleteVirtualFile(java.lang.String sHandle);
	public static native double div(double dDividend, double dDivisor);
	public static native boolean duplicateIterator(org.codeworker.IParseTree pOldIt, org.codeworker.IParseTree pNewIt);
	public static native java.lang.String encodeURL(java.lang.String sURL);
	public static native java.lang.String endl();
	public static native boolean endString(java.lang.String sText, java.lang.String sEnd);
	public static native boolean equal(double dLeft, double dRight);
	public static native boolean equalsIgnoreCase(java.lang.String sLeft, java.lang.String sRight);
	public static native boolean equalTrees(org.codeworker.IParseTree pFirstTree, org.codeworker.IParseTree pSecondTree);
	public static native java.lang.String executeStringQuiet(org.codeworker.IParseTree pThis, java.lang.String sCommand);
	public static native boolean existEnv(java.lang.String sVariable);
	public static native boolean existFile(java.lang.String sFileName);
	public static native boolean existVirtualFile(java.lang.String sHandle);
	public static native boolean existVariable(org.codeworker.IParseTree pVariable);
	public static native double exp(double dX);
	public static native boolean exploreDirectory(org.codeworker.IParseTree pDirectory, java.lang.String sPath, boolean bSubfolders);
	public static native java.lang.String extractGenerationHeader(java.lang.String sFilename, org.codeworker.StringRef sGenerator, org.codeworker.StringRef sVersion, org.codeworker.StringRef sDate);
	public static native java.lang.String fileCreation(java.lang.String sFilename);
	public static native java.lang.String fileLastAccess(java.lang.String sFilename);
	public static native java.lang.String fileLastModification(java.lang.String sFilename);
	public static native int fileLines(java.lang.String sFilename);
	public static native java.lang.String fileMode(java.lang.String sFilename);
	public static native int fileSize(java.lang.String sFilename);
	public static native boolean findElement(java.lang.String sValue, org.codeworker.IParseTree pVariable);
	public static native int findFirstChar(java.lang.String sText, java.lang.String sSomeChars);
	public static native int findFirstSubstringIntoKeys(java.lang.String sSubstring, org.codeworker.IParseTree pArray);
	public static native int findLastString(java.lang.String sText, java.lang.String sFind);
	public static native int findNextString(java.lang.String sText, java.lang.String sFind, int iPosition);
	public static native int findNextSubstringIntoKeys(java.lang.String sSubstring, org.codeworker.IParseTree pArray, int iNext);
	public static native int findString(java.lang.String sText, java.lang.String sFind);
	public static native int floor(double dNumber);
	public static native java.lang.String formatDate(java.lang.String sDate, java.lang.String sFormat);
	public static native int getArraySize(org.codeworker.IParseTree pVariable);
	public static native java.lang.String getCommentBegin();
	public static native java.lang.String getCommentEnd();
	public static native java.lang.String getCurrentDirectory();
	public static native java.lang.String getEnv(java.lang.String sVariable);
	public static native java.lang.String getGenerationHeader();
	public static native java.lang.String getHTTPRequest(java.lang.String sURL, org.codeworker.IParseTree pHTTPSession, org.codeworker.IParseTree pArguments);
	public static native java.lang.String getIncludePath();
	public static native double getLastDelay();
	public static native java.lang.String getNow();
	public static native java.lang.String getProperty(java.lang.String sDefine);
	public static native java.lang.String getShortFilename(java.lang.String sPathFilename);
	public static native java.lang.String getTextMode();
	public static native int getVariableAttributes(org.codeworker.IParseTree pVariable, org.codeworker.IParseTree pList);
	public static native java.lang.String getVersion();
	public static native java.lang.String getWorkingPath();
	public static native java.lang.String getWriteMode();
	public static native int hexaToDecimal(java.lang.String sHexaNumber);
	public static native java.lang.String hostToNetworkLong(java.lang.String sBytes);
	public static native java.lang.String hostToNetworkShort(java.lang.String sBytes);
	public static native double increment(org.codeworker.DoubleRef dNumber);
	public static native boolean indentFile(java.lang.String sFile, java.lang.String sMode);
	public static native boolean inf(double dLeft, double dRight);
	public static native java.lang.String inputKey(boolean bEcho);
	public static native java.lang.String inputLine(boolean bEcho, java.lang.String sPrompt);
	public static native boolean isEmpty(org.codeworker.IParseTree pArray);
	public static native boolean isIdentifier(java.lang.String sIdentifier);
	public static native boolean isNegative(double dNumber);
	public static native boolean isNumeric(java.lang.String sNumber);
	public static native boolean isPositive(double dNumber);
	public static native java.lang.String joinStrings(org.codeworker.IParseTree pList, java.lang.String sSeparator);
	public static native java.lang.String leftString(java.lang.String sText, int iLength);
	public static native int lengthString(java.lang.String sText);
	public static native java.lang.String loadBinaryFile(java.lang.String sFile, int iLength);
	public static native java.lang.String loadFile(java.lang.String sFile, int iLength);
	public static native java.lang.String loadVirtualFile(java.lang.String sHandle);
	public static native double log(double dX);
	public static native java.lang.String longToBytes(long ulLong);
	public static native java.lang.String midString(java.lang.String sText, int iPos, int iLength);
	public static native int mod(int iDividend, int iDivisor);
	public static native double mult(double dLeft, double dRight);
	public static native java.lang.String networkLongToHost(java.lang.String sBytes);
	public static native java.lang.String networkShortToHost(java.lang.String sBytes);
	public static native int octalToDecimal(java.lang.String sOctalNumber);
	public static native java.lang.String pathFromPackage(java.lang.String sPackage);
	public static native java.lang.String postHTTPRequest(java.lang.String sURL, org.codeworker.IParseTree pHTTPSession, org.codeworker.IParseTree pArguments);
	public static native double pow(double dX, double dY);
	public static native int randomInteger();
	public static native java.lang.String receiveBinaryFromSocket(int iSocket, int iLength);
	public static native java.lang.String receiveFromSocket(int iSocket, org.codeworker.BooleanRef bIsText);
	public static native java.lang.String receiveTextFromSocket(int iSocket, int iLength);
	public static native java.lang.String relativePath(java.lang.String sPath, java.lang.String sReference);
	public static native boolean removeDirectory(java.lang.String sPath);
	public static native boolean removeGenerationTagsHandler(java.lang.String sKey);
	public static native java.lang.String repeatString(java.lang.String sText, int iOccurrences);
	public static native java.lang.String replaceString(java.lang.String sOld, java.lang.String sNew, java.lang.String sText);
	public static native java.lang.String replaceTabulations(java.lang.String sText, int iTab);
	public static native java.lang.String resolveFilePath(java.lang.String sFilename);
	public static native java.lang.String rightString(java.lang.String sText, int iLength);
	public static native java.lang.String rsubString(java.lang.String sText, int iPos);
	public static native boolean scanDirectories(org.codeworker.IParseTree pDirectory, java.lang.String sPath, java.lang.String sPattern);
	public static native boolean scanFiles(org.codeworker.IParseTree pFiles, java.lang.String sPath, java.lang.String sPattern, boolean bSubfolders);
	public static native boolean sendBinaryToSocket(int iSocket, java.lang.String sBytes);
	public static native java.lang.String sendHTTPRequest(java.lang.String sURL, org.codeworker.IParseTree pHTTPSession);
	public static native boolean sendTextToSocket(int iSocket, java.lang.String sText);
	public static native boolean selectGenerationTagsHandler(java.lang.String sKey);
	public static native java.lang.String shortToBytes(short ulShort);
	public static native double sqrt(double dX);
	public static native boolean startString(java.lang.String sText, java.lang.String sStart);
	public static native double sub(double dLeft, double dRight);
	public static native java.lang.String subString(java.lang.String sText, int iPos);
	public static native boolean sup(double dLeft, double dRight);
	public static native java.lang.String system(java.lang.String sCommand);
	public static native java.lang.String toLowerString(java.lang.String sText);
	public static native java.lang.String toUpperString(java.lang.String sText);
	public static native int trimLeft(org.codeworker.StringRef sString);
	public static native int trimRight(org.codeworker.StringRef sString);
	public static native int trim(org.codeworker.StringRef sString);
	public static native java.lang.String truncateAfterString(org.codeworker.IParseTree pVariable, java.lang.String sText);
	public static native java.lang.String truncateBeforeString(org.codeworker.IParseTree pVariable, java.lang.String sText);
	public static native java.lang.String UUID();
	public static native int countInputCols();
	public static native int countInputLines();
	public static native java.lang.String getInputFilename();
	public static native java.lang.String getLastReadChars(int iLength);
	public static native int getInputLocation();
	public static native boolean lookAhead(java.lang.String sText);
	public static native java.lang.String peekChar();
	public static native boolean readAdaString(org.codeworker.StringRef sText);
	public static native java.lang.String readByte();
	public static native java.lang.String readBytes(int iLength);
	public static native java.lang.String readCChar();
	public static native java.lang.String readChar();
	public static native int readCharAsInt();
	public static native java.lang.String readChars(int iLength);
	public static native java.lang.String readIdentifier();
	public static native boolean readIfEqualTo(java.lang.String sText);
	public static native boolean readIfEqualToIgnoreCase(java.lang.String sText);
	public static native boolean readIfEqualToIdentifier(java.lang.String sIdentifier);
	public static native boolean readLine(org.codeworker.StringRef sText);
	public static native boolean readNextText(java.lang.String sText);
	public static native boolean readNumber(org.codeworker.DoubleRef dNumber);
	public static native boolean readPythonString(org.codeworker.StringRef sText);
	public static native boolean readString(org.codeworker.StringRef sText);
	public static native java.lang.String readUptoJustOneChar(java.lang.String sOneAmongChars);
	public static native java.lang.String readWord();
	public static native boolean skipBlanks();
	public static native boolean skipEmptyCpp();
	public static native boolean skipEmptyCppExceptDoxygen();
	public static native boolean skipEmptyHTML();
	public static native boolean skipEmptyLaTeX();
	public static native int countOutputCols();
	public static native int countOutputLines();
	public static native boolean decrementIndentLevel(int iLevel);
	public static native boolean equalLastWrittenChars(java.lang.String sText);
	public static native boolean existFloatingLocation(java.lang.String sKey, boolean bParent);
	public static native int getFloatingLocation(java.lang.String sKey);
	public static native java.lang.String getLastWrittenChars(int iNbChars);
	public static native java.lang.String getMarkupKey();
	public static native java.lang.String getMarkupValue();
	public static native java.lang.String getOutputFilename();
	public static native int getOutputLocation();
	public static native java.lang.String getProtectedArea(java.lang.String sProtection);
	public static native int getProtectedAreaKeys(org.codeworker.IParseTree pKeys);
	public static native boolean indentText(java.lang.String sMode);
	public static native boolean newFloatingLocation(java.lang.String sKey);
	public static native int remainingProtectedAreas(org.codeworker.IParseTree pKeys);
	public static native int removeFloatingLocation(java.lang.String sKey);
	public static native boolean removeProtectedArea(java.lang.String sProtectedAreaName);
//##end##"functions"
}
