<?php


// Determine what locale to use
switch (PHP_OS)
{
	case 'WINNT':
	case 'WIN32':
		$locale = 'czech';
		break;

	case 'FreeBSD':
	case 'NetBSD':
	case 'OpenBSD':
		$locale = 'cz_CZ.cp-1250';
		break;

	default:
		$locale = 'cz_CZ';
		break;
}

// Attempt to set the locale
setlocale(LC_CTYPE, $locale);


// Language definitions for frequently used strings
$lang_common = array(

// Text orientation and encoding
'lang_direction'		=>	'ltr',	// ltr (Left-To-Right) or rtl (Right-To-Left)
'lang_encoding'			=>	'windows-1250',
'lang_multibyte'		=>	false,

// Notices
'Bad request'			=>	'patn poadavek. Objekt, kter jste poadovali, je nesprvn nebo star.',
'No view'				=>	'Nemte oprvnn prohlet toto frum.',
'No permission'			=>	'Nemte oprvnn pstupu na strnku.',
'Bad referrer'			=>	'patn HTTP_REFERER. Byli jste pesmrovni na tuto strnku z neautorizovanho zdroje. Pokud problm petrvv, prosm ovte, zda \'Base URL\' je nastaven v Administrace/Options and a e jste navtvili frum pes tuto adresu URL. Tak ovte, zda V prohle nebo proxy server tyto hlaviky posl sprvn. Vce informac o kontrole HTTP_REFERER naleznete v dokumentaci k PunBB.',

// Topic/forum indicators
'New icon'				=>	'V tmatu jsou nov pspvky',
'Normal icon'			=>	'<!-- -->',
'Closed icon'			=>	'Tma je zaveno.',
'Redirect icon'			=>	'Pesmrovan frum',

// Miscellaneous
'Announcement'			=>	'Oznmen',
'Options'				=>	'Nastaven',
'Actions'				=>	'innosti',
'Submit'				=>	'Odeslat',	// "name" of submit buttons
'Ban message'			=>	'Mte ban (zkaz) pro toto frum.',
'Ban message 2'			=>	'Ban (zkaz) vypr:',
'Ban message 3'			=>	'Administrtor nebo modertor, kter Vs zabanoval zanechal nsledujc zprvu:',
'Ban message 4'			=>	'Jakkoliv dotazy smujte na administrtora',
'Never'					=>	'Nikdy',
'Today'					=>	'Dnes',
'Yesterday'				=>	'Vera',
'Info'					=>	'Info',		// a common table header
'Go back'				=>	'Zpt',
'Maintenance'			=>	'drba',
'Redirecting'			=>	'Pesmrovn',
'Click redirect'		=>	'Kliknte sem pro rychl pesmrovn (nebo pokud vs prohle automaticky nepesmroval)',
'on'					=>	'on',		// as in "BBCode is on"
'off'					=>	'off',
'Invalid e-mail'		=>	'Zadan e-mailov adresa nen platn.',
'required field'		=>	'je nutn vyplnit v tomto formuli',	// for javascript form validation
'Last post'				=>	'Posledn pspvek',
'by'					=>	'od',	// as in last post by someuser
'New posts'				=>	'Nov&nbsp;pspvek',	// the link that leads to the first new post (use &nbsp; for spaces)
'New posts info'		=>	'Zobrazit nejnovj pspvek v tmatu.',	// the popup text for new posts links
'Username'				=>	'Uivatelsk jmno',
'Password'				=>	'Vae heslo',
'E-mail'				=>	'E-mail',
'Send e-mail'			=>	'Poslat e-mail',
'Moderated by'			=>	'Moderuje',
'Registered'			=>	'Registrovan',
'Subject'				=>	'Pedmt',
'Message'				=>	'Zprva',
'Topic'					=>	'Tma',
'Forum'					=>	'Frum',
'Posts'					=>	'Pspvky',
'Replies'				=>	'Odpovdi',
'Author'				=>	'Autor',
'Pages'					=>	'Strnky',
'BBCode'				=>	'BBCode',	// You probably shouldn't change this
'img tag'				=>	'[img] tag',
'Smilies'				=>	'Smajlky',
'and'					=>	'a',
'Image link'			=>	'obrzek',	// This is displayed (i.e. <image>) instead of images when "Show images" is disabled in the profile
'wrote'					=>	'napsal(a)',	// For [quote]'s
'Code'					=>	'Code',		// For [code]'s
'Mailer'				=>	'Mailer',	// As in "MyForums Mailer" in the signature of outgoing e-mails
'Important information'	=>	'Dleit informace',
'Write message legend'	=>	'Napi zprvu a odeli',

// Title
'Title'					=>	'Titulek',
'Member'				=>	'len',	// Default title
'Moderator'				=>	'Modertor',
'Administrator'			=>	'Administrtor',
'Banned'				=>	'Zablokovan',
'Guest'					=>	'Host',

// Stuff for include/parser.php
'BBCode error'			=>	'Syntaxe BBCode ve zprv je patn.',
'BBCode error 1'		=>	'Chyb vodn tag pro [/quote].',
'BBCode error 2'		=>	'Chyb ukonovac tag pro [code].',
'BBCode error 3'		=>	'Chyb vodn tag pro [/code].',
'BBCode error 4'		=>	'Chyb jeden i vce ukonovacch tag pro [quote].',
'BBCode error 5'		=>	'Chyb jeden i vce potench tag pro [/quote].',

// Stuff for the navigator (top of every page)
'Index'					=>	'Index',
'User list'				=>	'Seznam uivatel',
'Rules'					=>  'Pravidla',
'Search'				=>  'Hledat',
'Register'				=>  'Registrace',
'Login'					=>  'Pihlsit',
'Not logged in'			=>  'Nejste pihlen(a)',
'Profile'				=>	'Profil',
'Logout'				=>	'Odhlsit',
'Logged in as'			=>	'Pihlen jako',
'Admin'					=>	'Administrace',
'Last visit'			=>	'Posledn nvtva',
'Show new posts'		=>	'Zobrazit nov pspvky od posledn nvtvy',
'Mark all as read'		=>	'Oznait vechna tmata jako peten',
'Mark forum as read'	=>	'Oznait toto frum za peten', // MOD: MARK TOPICS AS READ
'Link separator'		=>	'',	// The text that separates links in the navigator

// Stuff for the page footer
'Board footer'			=>	'Zpat',
'Search links'			=>	'Hledan odkazy',
'Show recent posts'		=>	'Zobrazit posledn pspvky',
'Show unanswered posts'	=>	'Zobrazit pspvky bez odpovd',
'Show your posts'		=>	'Zobrazit m pspvky',
'Show subscriptions'	=>	'Zobrazit tmata s oznamovnm',
'Jump to'				=>	'Pejt na',
'Go'					=>	'Pejt',		// submit button in forum jump
'Move topic'			=>  'Pesunout tma',
'Open topic'			=>  'Otevt tma',
'Close topic'			=>  'Zavt tma',
'Unstick topic'			=>  'Zruit zvraznn',
'Stick topic'			=>  'Zvraznit tma',
'Moderate forum'		=>	'Moderovat frum',
'Delete posts'			=>	'Smazat vce pspvk',
'Debug table'			=>	'Ladc informace',

// For extern.php RSS feed
'RSS Desc Active	'	=>	'Nejaktivnj tmata',	// board_title will be appended to this string
'RSS Desc New'			=>	'Nejnovj tmata',					// board_title will be appended to this string
'Posted'				=>	'Zaslan'	// The date/time a topic was started

);

$czech_days=array(
	'Nedle',
	'Pondl',
	'ter',
	'Steda',
	'tvrtek',
	'Ptek',
	'Sobota'
);

$v_czech_days=array(
	'v nedli',
	'v pondl',
	'v ter',
	've stedu',
	've tvrtek',
	'v ptek',
	'v sobotu'
);

function new_msg_cz($num)
{
	switch($num)
	{
		case 0:return 'dn nov';
		case 1:return '1 nov';
		case 2:
		case 3:
		case 4:return $num.' nov';
		default:return $num.' novch';
	}
}
