/*
 * Decompiled with CFR 0.152.
 */
package com.horobi.relax;

import com.horobi.relax.ConverterPanel;
import com.horobi.relax.DTD2RELAX;
import com.horobi.relax.FileConverter;
import java.awt.Component;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import javax.swing.JFrame;
import org.xml.sax.SAXException;

public class DTDtoRELAXConverterGUI
implements FileConverter {
    static final int TOP_LEVEL_ELEMENT = 0;
    static final int OUTPUT_ENCODING = 1;

    public boolean accept(File file) {
        if (file.isFile()) {
            String name = file.getName();
            return name.endsWith(".dtd") || name.endsWith(".DTD");
        }
        return false;
    }

    public void convert(File input, File output, String[] options) throws IOException, FileNotFoundException {
        OutputStreamWriter osw;
        FileInputStream is = new FileInputStream(input);
        FileOutputStream fos = new FileOutputStream(output);
        String mimeCharsetName = options[1];
        if (mimeCharsetName == null || mimeCharsetName.length() == 0) {
            osw = new OutputStreamWriter(fos);
        } else {
            String encoding = DTD2RELAX.convertEncoding(mimeCharsetName);
            if (encoding == null) {
                throw new IOException("unsupported encoding: '" + mimeCharsetName + "'");
            }
            osw = new OutputStreamWriter((OutputStream)fos, encoding);
        }
        try {
            DTD2RELAX.printSchema(input.getAbsolutePath(), options[0], new PrintWriter(osw), mimeCharsetName);
        }
        catch (SAXException e) {
            throw new IOException(e.getMessage());
        }
        catch (RuntimeException e) {
            throw new IOException(e.getMessage());
        }
    }

    public String getInputFileDescription() {
        return "*.dtd (DTD Files)";
    }

    public String getName() {
        return "DTD to RELAX Converter version " + DTD2RELAX.getVersion();
    }

    public Object[] getOptionDefaults() {
        String[] encDefaults = new String[]{"UTF-16", "UTF-8"};
        return new Object[]{"", encDefaults};
    }

    public String[] getOptionNames() {
        return new String[]{"Top level element", "Output encoding"};
    }

    public String getOutputFileName(File input) {
        if (!input.isFile()) {
            return null;
        }
        String name = input.getName();
        int i = name.lastIndexOf(".");
        if (i > 0 && !name.startsWith(".")) {
            name = name.substring(0, i);
        }
        return String.valueOf(name) + ".rlx";
    }

    public static void main(String[] args) {
        DTDtoRELAXConverterGUI converter = new DTDtoRELAXConverterGUI();
        ConverterPanel app = new ConverterPanel(converter);
        JFrame f = new JFrame(converter.getName());
        f.addWindowListener(new WindowAdapter(){

            public void windowClosed(WindowEvent we) {
                System.exit(0);
            }

            public void windowClosing(WindowEvent we) {
                System.exit(0);
            }
        });
        f.getContentPane().add(app);
        f.pack();
        ((Component)f).setVisible(true);
        app.revalidate();
    }
}

