/*
 * Decompiled with CFR 0.152.
 */
package com.horobi.relax;

import com.horobi.relax.SAXPrinter;
import java.io.PrintWriter;
import java.util.Hashtable;
import java.util.Vector;
import org.xml.sax.AttributeList;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;

public class EasyRELAXPrinter
implements SAXPrinter {
    PrintWriter writer;
    Vector elementRules;
    Hashtable tags;
    Vector hedgeRules;
    String current;
    String currentRole;
    String indent;
    boolean start;
    String step = "  ";

    public EasyRELAXPrinter(PrintWriter writer) {
        this.setWriter(writer);
    }

    protected String attsToString(AttributeList atts, String space) {
        String str = "";
        int n = atts.getLength();
        int i = 0;
        while (i < n) {
            str = String.valueOf(str) + space + atts.getName(i) + "=" + "\"" + atts.getValue(i) + "\"";
            ++i;
        }
        return str;
    }

    public void characters(char[] ch, int st, int len) throws SAXException {
        if (this.start && this.current != null) {
            this.current = String.valueOf(this.current) + ">\n";
        }
        this.start = false;
    }

    public void endDocument() throws SAXException {
    }

    public void endElement(String name) throws SAXException {
        this.indent = this.indent.substring(this.step.length());
        if (name.equals("module")) {
            this.printModuleContent();
            this.writer.println(String.valueOf(this.indent) + "</module>");
            this.elementRules = null;
            this.tags = null;
            this.hedgeRules = null;
        } else if (this.current != null) {
            this.current = this.start ? String.valueOf(this.current) + "/>\n" : String.valueOf(this.current) + this.indent + "</" + name + ">\n";
            if (name.equals("interface")) {
                this.writer.println(this.current);
                this.current = null;
            } else if (name.equals("elementRule")) {
                Rule rule = new Rule(this.currentRole);
                rule.content = this.current;
                this.elementRules.addElement(rule);
                this.current = null;
                this.currentRole = null;
            } else if (name.equals("tag")) {
                this.tags.put(this.currentRole, this.current);
                this.current = null;
                this.currentRole = null;
            } else if (name.equals("hedgeRule")) {
                this.hedgeRules.addElement(this.current);
                this.current = null;
            }
        }
        this.start = false;
    }

    public void ignorableWhitespace(char[] ch, int st, int len) throws SAXException {
        if (this.start && this.current != null) {
            this.current = String.valueOf(this.current) + ">\n";
        }
        this.start = false;
    }

    protected void printModuleContent() {
        int i = 0;
        while (i < this.elementRules.size()) {
            Rule elementRule = (Rule)this.elementRules.elementAt(i);
            this.writer.print((String)this.tags.get(elementRule.role));
            this.writer.println(elementRule);
            ++i;
        }
        int i2 = 0;
        while (i2 < this.hedgeRules.size()) {
            this.writer.print((String)this.hedgeRules.elementAt(i2));
            ++i2;
        }
        this.elementRules = null;
        this.tags = null;
        this.hedgeRules = null;
    }

    public void processingInstruction(String target, String data) throws SAXException {
        if (this.start && this.current != null) {
            this.current = String.valueOf(this.current) + ">\n";
        }
        this.start = false;
    }

    public void setDocumentLocator(Locator locator) {
    }

    public void setWriter(PrintWriter writer) {
        this.writer = writer;
    }

    public void startDocument() throws SAXException {
        this.indent = "";
        this.start = false;
    }

    public void startElement(String name, AttributeList atts) throws SAXException {
        if (this.start && this.current != null) {
            this.current = String.valueOf(this.current) + ">\n";
        }
        if (name.equals("module")) {
            this.elementRules = new Vector();
            this.tags = new Hashtable();
            this.hedgeRules = new Vector();
            this.writer.println("<" + name + this.attsToString(atts, "\n        ") + ">");
        } else if (name.equals("interface") || name.equals("elementRule") || name.equals("tag") || name.equals("hedgeRule")) {
            this.current = String.valueOf(this.indent) + "<" + name + this.attsToString(atts, " ");
            if (name.equals("tag")) {
                this.currentRole = atts.getValue("name");
            } else if (name.equals("elementRule")) {
                this.currentRole = atts.getValue("role");
            }
        } else if (this.current != null) {
            this.current = String.valueOf(this.current) + this.indent + "<" + name + this.attsToString(atts, " ");
        }
        this.indent = String.valueOf(this.indent) + this.step;
        this.start = true;
    }

    class Rule {
        String role;
        String content;

        Rule(String roleValue) {
            this.role = roleValue;
        }

        public String toString() {
            return this.content;
        }
    }
}

