/*
 * Decompiled with CFR 0.152.
 */
package com.horobi.relax;

import com.horobi.relax.SAXPrinter;
import java.io.PrintWriter;
import org.xml.sax.AttributeList;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;

public class RELAXPrinter
implements SAXPrinter {
    PrintWriter writer;
    String tag;
    String indent;
    boolean inImplicitTagSection;
    String step = "  ";

    public RELAXPrinter() {
    }

    public RELAXPrinter(PrintWriter writer) {
        this.setWriter(writer);
    }

    public void characters(char[] ch, int start, int length) throws SAXException {
        if (this.tag != null) {
            this.flushATag();
        }
    }

    public void endDocument() throws SAXException {
    }

    public void endElement(String name) throws SAXException {
        this.indent = this.indent.substring(this.step.length());
        if (this.tag != null) {
            if (this.inImplicitTagSection) {
                this.tag = this.tag.substring(1);
            }
            this.flushEmptyTag();
            if (name.equals("tag")) {
                this.inImplicitTagSection = true;
            }
        } else {
            this.writer.println(String.valueOf(this.indent) + "</" + name + ">");
        }
    }

    protected void flushATag() {
        this.tag = String.valueOf(this.tag) + ">";
        this.writer.println(this.tag);
        this.tag = null;
    }

    protected void flushEmptyTag() {
        this.tag = String.valueOf(this.tag) + "/>";
        this.writer.println(this.tag);
        this.tag = null;
    }

    public void ignorableWhitespace(char[] ch, int start, int length) throws SAXException {
        if (this.tag != null) {
            this.flushATag();
        }
    }

    public void processingInstruction(String target, String data) throws SAXException {
        if (this.tag != null) {
            this.flushATag();
        }
    }

    public void setDocumentLocator(Locator locator) {
    }

    public void setWriter(PrintWriter writer) {
        this.writer = writer;
    }

    public void startDocument() throws SAXException {
        this.tag = null;
        this.indent = "";
        this.inImplicitTagSection = false;
    }

    public void startElement(String name, AttributeList atts) throws SAXException {
        String space = " ";
        if (this.tag != null) {
            this.flushATag();
        }
        this.tag = "";
        if (name.equals("module")) {
            space = "\n        ";
        }
        if (name.equals("tag") || name.equals("interface") || name.equals("elementRule") || name.equals("hedgeRule")) {
            this.tag = String.valueOf(this.tag) + "\n";
        }
        this.tag = String.valueOf(this.tag) + this.indent + "<" + name;
        int n = atts.getLength();
        int i = 0;
        while (i < n) {
            this.tag = String.valueOf(this.tag) + space + atts.getName(i) + "=" + "\"" + atts.getValue(i) + "\"";
            ++i;
        }
        this.indent = String.valueOf(this.indent) + this.step;
        if (this.inImplicitTagSection && !name.equals("tag")) {
            this.inImplicitTagSection = false;
        }
    }
}

