/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xml.omake;

import com.ibm.xml.omake.RegexpParseException;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.Vector;

public class Regexp
implements Serializable {
    String regexp;
    int nofparen;
    Token tokentree;
    transient NFANode nfastart;
    transient NFANode nfaterm;
    transient int[] positions;
    transient String target;

    void toNFA(Token token) {
        if (this.nfastart == null) {
            this.nfastart = new NFANode();
            this.nfaterm = new NFANode();
            this.toNFA(token, this.nfastart, this.nfaterm);
        }
    }

    void toNFA(Token token, NFANode nFANode, NFANode nFANode2) {
        switch (token.type) {
            case 0: {
                nFANode.addElement(new NFAArrow(0, token.chardata, nFANode2));
                return;
            }
            case 1: {
                NFANode nFANode3 = new NFANode();
                this.toNFA(token.child, nFANode, nFANode3);
                this.toNFA(token.child2, nFANode3, nFANode2);
                return;
            }
            case 2: {
                Enumeration enumeration = token.children.elements();
                while (enumeration.hasMoreElements()) {
                    NFANode nFANode4 = new NFANode();
                    nFANode.addElement(new NFAArrow(1, 0, nFANode4));
                    this.toNFA((Token)enumeration.nextElement(), nFANode4, nFANode2);
                }
                return;
            }
            case 3: {
                NFANode nFANode5 = new NFANode();
                NFANode nFANode6 = new NFANode();
                nFANode.addElement(new NFAArrow(1, 0, nFANode5));
                this.toNFA(token.child, nFANode5, nFANode6);
                nFANode6.addElement(new NFAArrow(1, 0, nFANode5));
                nFANode5.addElement(new NFAArrow(1, 0, nFANode2));
                return;
            }
            case 4: {
                nFANode.addElement(new NFAArrow(2, token.ranges, nFANode2));
                return;
            }
            case 5: {
                nFANode.addElement(new NFAArrow(3, token.ranges, nFANode2));
                return;
            }
            case 6: {
                NFANode nFANode7 = new NFANode();
                NFANode nFANode8 = new NFANode();
                nFANode.addElement(new NFAArrow(1, token.parennumber, nFANode7));
                this.toNFA(token.child, nFANode7, nFANode8);
                nFANode8.addElement(new NFAArrow(1, -token.parennumber, nFANode2));
                return;
            }
            case 7: {
                nFANode.addElement(new NFAArrow(1, 0, nFANode2));
                return;
            }
        }
    }

    int NFAmatch(String string, int n, int n2) {
        if (this.nfastart == null) {
            this.prepare();
        }
        return this.NFAmatch0(this.nfastart, string, n, n2, this.positions);
    }

    int NFAmatch0(NFANode nFANode, String string, int n, int n2, int[] nArray) {
        int n3 = -1;
        if (nFANode == this.nfaterm) {
            n3 = n;
        } else if (n > n2) {
            n3 = -1;
        } else {
            int[] nArray2 = (int[])nArray.clone();
            int[] nArray3 = new int[nArray.length];
            Enumeration enumeration = nFANode.elements();
            while (enumeration.hasMoreElements()) {
                NFAArrow nFAArrow = (NFAArrow)enumeration.nextElement();
                int n4 = -1;
                System.arraycopy(nArray, 0, nArray3, 0, nArray.length);
                switch (nFAArrow.type) {
                    case 0: 
                    case 2: 
                    case 3: {
                        if (n >= n2) {
                            n4 = -1;
                            break;
                        }
                        if (!nFAArrow.match(string.charAt(n))) break;
                        n4 = this.NFAmatch0(nFAArrow.to, string, n + 1, n2, nArray3);
                        break;
                    }
                    case 1: {
                        if (nFAArrow.regnumber > 0) {
                            nArray3[nFAArrow.regnumber * 2] = n;
                        } else if (nFAArrow.regnumber < 0) {
                            nArray3[-nFAArrow.regnumber * 2 + 1] = n;
                        }
                        n4 = this.NFAmatch0(nFAArrow.to, string, n, n2, nArray3);
                    }
                }
                if (n4 <= n3) continue;
                n3 = n4;
                System.arraycopy(nArray3, 0, nArray2, 0, nArray3.length);
            }
            if (n3 >= 0) {
                System.arraycopy(nArray2, 0, nArray, 0, nArray.length);
            }
        }
        return n3;
    }

    void prepare() {
        this.toNFA(this.tokentree);
        this.positions = new int[this.nofparen * 2];
        int n = 0;
        while (n < this.nofparen * 2) {
            this.positions[n] = -1;
            ++n;
        }
    }

    public Regexp(String string) throws RegexpParseException {
        this.regexp = string;
        RegexpParser regexpParser = new RegexpParser(string);
        this.tokentree = regexpParser.parse();
        this.nofparen = regexpParser.parennumber;
    }

    public String toString() {
        return this.tokentree.toString();
    }

    public int match(String string) {
        this.target = string;
        int n = string.length();
        int n2 = 0;
        while (n2 < n) {
            int n3 = this.NFAmatch(string, n2, n);
            if (n3 >= 0) {
                this.positions[0] = n2;
                this.positions[1] = n3;
                return n2;
            }
            ++n2;
        }
        return -1;
    }

    public boolean exactMatch(String string) {
        this.target = string;
        int n = string.length();
        if (n == this.NFAmatch(string, 0, n)) {
            this.positions[0] = 0;
            this.positions[1] = n;
            return true;
        }
        return false;
    }

    public int getMatchedBeginning(int n) {
        return this.positions[n * 2];
    }

    public int getMatchedEnd(int n) {
        return this.positions[n * 2 + 1];
    }

    public String getMatchedString(int n) {
        return this.target.substring(this.positions[n * 2], this.positions[n * 2 + 1]);
    }

    public int getNumberOfGroups() {
        return this.nofparen;
    }

    public static void main(String[] stringArray) {
        try {
            Regexp regexp = new Regexp(stringArray[0]);
            System.out.println("Regexp: " + regexp);
            System.out.println("Match position: " + regexp.match(stringArray[1]));
            int n = 0;
            while (n < regexp.getNumberOfGroups()) {
                if (n == 0) {
                    System.out.print("To whole pattern: ");
                } else {
                    System.out.print("[" + n + "]: ");
                }
                if (regexp.getMatchedBeginning(n) < 0) {
                    System.out.println("-1");
                } else {
                    System.out.print(String.valueOf(regexp.getMatchedBeginning(n)) + ", " + regexp.getMatchedEnd(n) + ", ");
                    System.out.println(regexp.getMatchedString(n));
                }
                ++n;
            }
            return;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return;
        }
    }

    static class Token
    implements Serializable {
        static final int CHAR = 0;
        static final int CONCAT = 1;
        static final int UNION = 2;
        static final int CLOSURE = 3;
        static final int RANGE = 4;
        static final int NRANGE = 5;
        static final int PAREN = 6;
        static final int EMPTY = 7;
        int type;
        int chardata;
        static final int PERIOD_START = 1;
        static final int PERIOD_END = 65534;
        int[] ranges;
        int parennumber;
        Token child;
        Token child2;
        Vector children;

        Token(int n) {
            this.type = n;
        }

        Token(int n, Token token) {
            this.type = n;
            this.child = token;
        }

        Token(int n, Token token, int n2) {
            this.type = n;
            this.child = token;
            this.parennumber = n2;
        }

        Token(Token token, Token token2) {
            this.type = 1;
            this.child = token;
            this.child2 = token2;
        }

        Token(int n, int n2) {
            this.type = n;
            this.chardata = n2;
        }

        void addElement(Token token) {
            if (this.children == null) {
                this.children = new Vector();
            }
            this.children.addElement(token);
        }

        void addRange(int n, int n2) {
            int n3 = 0;
            if (this.ranges == null) {
                this.ranges = new int[2];
            } else {
                n3 = this.ranges.length;
                int[] nArray = new int[n3 + 2];
                System.arraycopy(this.ranges, 0, nArray, 0, n3);
                this.ranges = nArray;
            }
            if (n <= n2) {
                this.ranges[n3++] = n;
                this.ranges[n3] = n2;
                return;
            }
            this.ranges[n3++] = n2;
            this.ranges[n3] = n;
        }

        public String toString() {
            String string = "";
            switch (this.type) {
                case 0: {
                    if ("|*+?().[\\".indexOf(this.chardata) >= 0) {
                        string = "\\" + (char)this.chardata;
                        break;
                    }
                    string = String.valueOf((char)this.chardata);
                    break;
                }
                case 1: {
                    if (this.child2.type == 3 && this.child2.child == this.child) {
                        string = String.valueOf(this.child.toString()) + "+";
                        break;
                    }
                    string = String.valueOf(this.child.toString()) + this.child2.toString();
                    break;
                }
                case 2: {
                    if (this.children.size() == 2 && ((Token)this.children.elementAt((int)0)).type == 7) {
                        string = String.valueOf(this.children.elementAt(1).toString()) + "?";
                        break;
                    }
                    Enumeration enumeration = this.children.elements();
                    StringBuffer stringBuffer = new StringBuffer();
                    stringBuffer.append(enumeration.nextElement().toString());
                    while (enumeration.hasMoreElements()) {
                        stringBuffer.append('|');
                        stringBuffer.append(enumeration.nextElement().toString());
                    }
                    string = stringBuffer.toString();
                    break;
                }
                case 3: {
                    string = String.valueOf(this.child.toString()) + "*";
                    break;
                }
                case 4: {
                    if (this.ranges.length == 2 && this.ranges[0] == 1 && this.ranges[1] == 65534) {
                        string = ".";
                        break;
                    }
                    StringBuffer stringBuffer = new StringBuffer();
                    stringBuffer.append("[");
                    int n = 0;
                    while (n < this.ranges.length) {
                        if (this.ranges[n] == this.ranges[n + 1]) {
                            stringBuffer.append((char)this.ranges[n]);
                        } else {
                            stringBuffer.append((char)this.ranges[n]);
                            stringBuffer.append('-');
                            stringBuffer.append((char)this.ranges[n + 1]);
                        }
                        n += 2;
                    }
                    stringBuffer.append("]");
                    string = stringBuffer.toString();
                    break;
                }
                case 5: {
                    StringBuffer stringBuffer = new StringBuffer();
                    stringBuffer.append("[^");
                    int n = 0;
                    while (n < this.ranges.length) {
                        if (this.ranges[n] == this.ranges[n + 1]) {
                            stringBuffer.append((char)this.ranges[n]);
                        } else {
                            stringBuffer.append((char)this.ranges[n]);
                            stringBuffer.append('-');
                            stringBuffer.append((char)this.ranges[n + 1]);
                        }
                        n += 2;
                    }
                    stringBuffer.append("]");
                    string = stringBuffer.toString();
                    break;
                }
                case 6: {
                    string = "(" + this.child.toString() + ")";
                }
            }
            return string;
        }
    }

    static class RegexpParser {
        private static final String className = "com.ibm.xml.omake.Regexp.RegexpParser";
        int offset;
        String regexp;
        static final int T_CHAR = 0;
        static final int T_EOF = 1;
        static final int T_OR = 2;
        static final int T_STAR = 3;
        static final int T_PLUS = 4;
        static final int T_QUESTION = 5;
        static final int T_LPAREN = 6;
        static final int T_RPAREN = 7;
        static final int T_DOT = 8;
        static final int T_LBRACKET = 9;
        int chardata;
        int nexttoken;
        static final int S_NORMAL = 0;
        static final int S_NONE = 1;
        int syntax = 0;
        int parennumber = 1;

        RegexpParser(String string) {
            this.regexp = string;
            this.offset = 0;
        }

        private String left() {
            return this.regexp.substring(this.offset);
        }

        Token parse() throws RegexpParseException {
            this.next();
            Token token = this.parseRegexp();
            if (this.offset != this.regexp.length()) {
                throw new RegexpParseException("com.ibm.xml.omake.Regexp.RegexpParser#parse(): Wrong character: " + this.regexp.substring(this.offset));
            }
            return token;
        }

        private void setSyntax(int n) {
            this.syntax = n;
        }

        int read() {
            return this.nexttoken;
        }

        void next() {
            int n;
            if (this.offset < this.regexp.length()) {
                char c = this.regexp.charAt(this.offset++);
                this.chardata = c;
                if (this.syntax == 0) {
                    switch (c) {
                        case '|': {
                            n = 2;
                            break;
                        }
                        case '*': {
                            n = 3;
                            break;
                        }
                        case '+': {
                            n = 4;
                            break;
                        }
                        case '?': {
                            n = 5;
                            break;
                        }
                        case '(': {
                            n = 6;
                            break;
                        }
                        case ')': {
                            n = 7;
                            break;
                        }
                        case '.': {
                            n = 8;
                            break;
                        }
                        case '[': {
                            n = 9;
                            break;
                        }
                        case '\\': {
                            if (this.offset < this.regexp.length()) {
                                n = 0;
                                this.chardata = this.regexp.charAt(this.offset++);
                            } else {
                                throw new RegexpParseException("com.ibm.xml.omake.Regexp.RegexpParser#next(): 1 character is required after \\.");
                            }
                        }
                        default: {
                            n = 0;
                            break;
                        }
                    }
                } else {
                    n = 0;
                }
            } else {
                n = 1;
                this.chardata = -1;
            }
            this.nexttoken = n;
        }

        Token parseRegexp() throws RegexpParseException {
            Token token = this.parseTerm();
            Token token2 = null;
            while (this.read() == 2) {
                this.next();
                if (token2 == null) {
                    token2 = new Token(2);
                    token2.addElement(token);
                    token = token2;
                }
                token.addElement(this.parseTerm());
            }
            return token;
        }

        Token parseTerm() throws RegexpParseException {
            int n = this.read();
            if (n == 2 || n == 7 || n == 1) {
                return new Token(7);
            }
            Token token = this.parseFactor();
            while ((n = this.read()) != 2 && n != 7 && n != 1) {
                token = new Token(token, this.parseFactor());
            }
            return token;
        }

        Token parseFactor() throws RegexpParseException {
            Token token = this.parseAtom();
            int n = this.read();
            switch (n) {
                case 3: {
                    this.next();
                    token = new Token(3, token);
                    break;
                }
                case 4: {
                    this.next();
                    token = new Token(token, new Token(3, token));
                    break;
                }
                case 5: {
                    this.next();
                    Token token2 = new Token(2);
                    token2.addElement(new Token(7));
                    token2.addElement(token);
                    token = token2;
                }
            }
            return token;
        }

        Token parseAtom() throws RegexpParseException {
            int n = this.read();
            Token token = null;
            switch (n) {
                case 6: {
                    this.next();
                    int n2 = this.parennumber++;
                    token = new Token(6, this.parseRegexp(), n2);
                    if (this.read() != 7) {
                        throw new RegexpParseException("com.ibm.xml.omake.Regexp.RegexpParser#parseAtom(): ')' is expected: " + this.regexp.substring(this.offset));
                    }
                    this.next();
                    break;
                }
                case 8: {
                    this.next();
                    token = new Token(4);
                    token.addRange(1, 65534);
                    break;
                }
                case 9: {
                    int n3;
                    this.syntax = 1;
                    this.next();
                    boolean bl = false;
                    if (this.chardata == 94) {
                        bl = true;
                        this.next();
                    }
                    token = new Token(bl ? 5 : 4);
                    boolean bl2 = true;
                    boolean bl3 = false;
                    int n4 = -1;
                    while (this.read() != 1 && ((n3 = this.chardata) != 93 || bl2)) {
                        this.next();
                        bl2 = false;
                        switch (n3) {
                            case 45: {
                                if (n4 < 0) {
                                    n4 = 45;
                                    break;
                                }
                                bl3 = true;
                                break;
                            }
                            default: {
                                if (n4 < 0) {
                                    n4 = n3;
                                    bl3 = false;
                                    break;
                                }
                                if (!bl3) {
                                    token.addRange(n4, n4);
                                    n4 = n3;
                                    break;
                                }
                                token.addRange(n4, n3);
                                n4 = -1;
                                bl3 = false;
                            }
                        }
                    }
                    if (n4 >= 0) {
                        token.addRange(n4, n4);
                    }
                    if (bl3) {
                        token.addRange(45, 45);
                    }
                    if (this.read() == 1) {
                        throw new RegexpParseException("com.ibm.xml.omake.Regexp.RegexpParser#parseAtom(): Unexpected end of expression in a range([...]).");
                    }
                    this.syntax = 0;
                    this.next();
                    break;
                }
                case 0: {
                    token = new Token(0, this.chardata);
                    this.next();
                    break;
                }
                default: {
                    throw new RegexpParseException("com.ibm.xml.omake.Regexp.RegexpParser#parseAtom(): Unexpected special character: code=" + n + ", " + (char)this.chardata);
                }
            }
            return token;
        }
    }

    static class NFAArrow {
        static final int CHAR = 0;
        static final int EPSILON = 1;
        static final int RANGE = 2;
        static final int NRANGE = 3;
        int type;
        int chardata;
        int regnumber;
        int[] ranges;
        NFANode to;

        NFAArrow(int n, int n2, NFANode nFANode) {
            this.type = n;
            this.to = nFANode;
            if (n == 0) {
                this.chardata = n2;
                return;
            }
            this.regnumber = n2;
        }

        NFAArrow(int n, int[] nArray, NFANode nFANode) {
            this.type = n;
            this.ranges = nArray;
            this.to = nFANode;
        }

        boolean match(int n) {
            boolean bl = false;
            if (this.type == 0) {
                bl = n == this.chardata;
            } else if (this.type == 2) {
                int n2 = 0;
                while (n2 < this.ranges.length) {
                    if (this.ranges[n2] <= n && n <= this.ranges[n2 + 1]) {
                        return true;
                    }
                    n2 += 2;
                }
            } else if (this.type == 3) {
                int n3 = 0;
                while (n3 < this.ranges.length) {
                    if (this.ranges[n3] <= n && n <= this.ranges[n3 + 1]) {
                        return false;
                    }
                    n3 += 2;
                }
                bl = true;
            } else {
                System.err.println("NFAArrow#match(): Internal error!");
            }
            return bl;
        }
    }

    static class NFANode
    extends Vector {
        NFANode() {
        }
    }
}

