/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xml.parser;

import com.ibm.xml.parser.AttDef;
import com.ibm.xml.parser.Attlist;
import com.ibm.xml.parser.Child;
import com.ibm.xml.parser.ContentModel;
import com.ibm.xml.parser.ElementDecl;
import com.ibm.xml.parser.EntityDecl;
import com.ibm.xml.parser.EntityPool;
import com.ibm.xml.parser.ExternalID;
import com.ibm.xml.parser.Parent;
import com.ibm.xml.parser.TXDOMException;
import com.ibm.xml.parser.TXElement;
import com.ibm.xml.parser.TXNodeList;
import com.ibm.xml.parser.TXNotation;
import com.ibm.xml.parser.Visitor;
import java.io.IOException;
import java.io.Writer;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import org.w3c.dom.DOMException;
import org.w3c.dom.DocumentType;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.Notation;

public class DTD
extends Parent
implements DocumentType {
    static final long serialVersionUID = 8746509003209143695L;
    public static final String CM_EOC = " *EOC* ";
    public static final String CM_ERROR = " *ERROR* ";
    public static final String CM_PCDATA = "#PCDATA";
    private String name;
    private String xmlEncoding;
    private TXNodeList internalChildren;
    private TXNodeList externalChildren = new TXNodeList();
    private ExternalID externalID;
    private Hashtable elementDecls = new Hashtable();
    private Hashtable attListDecls = new Hashtable();
    private Hashtable notationDecls = new Hashtable();
    private boolean parsingExternal = false;
    boolean isPrintInternalDTD = true;
    private Hashtable idHash;
    EntityPool entityPool;

    public DTD() {
        this.internalChildren = this.children;
    }

    public DTD(String string, ExternalID externalID) {
        this.name = string;
        this.externalID = externalID;
        this.internalChildren = this.children;
    }

    public Object clone() {
        return this.cloneNode(true);
    }

    public synchronized Node cloneNode(boolean bl) {
        this.checkFactory();
        DTD dTD = this.factory.createDTD(this.name, this.externalID);
        dTD.setFactory(this.getFactory());
        dTD.isPrintInternalDTD = this.isPrintInternalDTD;
        dTD.xmlEncoding = this.xmlEncoding;
        EntityPool entityPool = new EntityPool();
        entityPool.add(this.factory.createEntityDecl("lt", "&#60;", false));
        entityPool.add(this.factory.createEntityDecl("gt", "&#62;", false));
        entityPool.add(this.factory.createEntityDecl("amp", "&#38;", false));
        entityPool.add(this.factory.createEntityDecl("apos", "&#39;", false));
        entityPool.add(this.factory.createEntityDecl("quot", "&#34;", false));
        dTD.setEntityPool(entityPool);
        if (bl) {
            dTD.setParsingExternal(true);
            dTD.externalChildren.ensureCapacity(this.externalChildren.getLength());
            int n = 0;
            while (n < this.externalChildren.getLength()) {
                dTD.appendChild((Child)((Child)this.externalChildren.item(n)).clone());
                ++n;
            }
            dTD.setParsingExternal(false);
            dTD.internalChildren.ensureCapacity(this.internalChildren.getLength());
            int n2 = 0;
            while (n2 < this.internalChildren.getLength()) {
                dTD.appendChild((Child)((Child)this.internalChildren.item(n2)).clone());
                ++n2;
            }
        }
        dTD.setParsingExternal(this.parsingExternal);
        return dTD;
    }

    public synchronized boolean equals(Node node, boolean bl) {
        if (node == null) {
            return false;
        }
        if (!(node instanceof DTD)) {
            return false;
        }
        DTD dTD = (DTD)node;
        if (!(dTD.name == null && this.name == null || dTD.name != null && dTD.name.equals(this.name))) {
            return false;
        }
        if (!(dTD.externalID == null && this.externalID == null || dTD.externalID != null && dTD.externalID.equals(this.externalID))) {
            return false;
        }
        if (!(dTD.xmlEncoding == null && this.xmlEncoding == null || dTD.xmlEncoding != null && dTD.xmlEncoding.equalsIgnoreCase(this.xmlEncoding))) {
            return false;
        }
        if (bl) {
            if (!dTD.internalChildren.equals(this.internalChildren, bl)) {
                return false;
            }
            if (!dTD.externalChildren.equals(this.externalChildren, bl)) {
                return false;
            }
        }
        return true;
    }

    public short getNodeType() {
        return 10;
    }

    public String getNodeName() {
        return this.name;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String string) {
        this.name = string;
    }

    protected void realInsert(Node node, int n) throws DOMException {
        if (node == null) {
            return;
        }
        super.realInsert(node, n);
        if (node instanceof ElementDecl) {
            ElementDecl elementDecl = (ElementDecl)node;
            this.elementDecls.put(elementDecl.getName(), elementDecl);
            return;
        }
        if (node instanceof Attlist) {
            Attlist attlist = (Attlist)node;
            String string = attlist.getName();
            Hashtable<String, AttDef> hashtable = (Hashtable<String, AttDef>)this.attListDecls.get(string);
            if (hashtable == null) {
                hashtable = new Hashtable<String, AttDef>();
                this.attListDecls.put(string, hashtable);
            }
            int n2 = 0;
            while (n2 < attlist.size()) {
                AttDef attDef = attlist.elementAt(n2);
                if (hashtable.get(attDef.getName()) == null) {
                    hashtable.put(attDef.getName(), attDef);
                }
                ++n2;
            }
            return;
        }
        if (node instanceof TXNotation) {
            TXNotation tXNotation = (TXNotation)node;
            this.notationDecls.put(tXNotation.getNodeName(), tXNotation);
            return;
        }
        if (node instanceof EntityDecl) {
            EntityDecl entityDecl = (EntityDecl)node;
            this.entityPool.add(entityDecl);
        }
    }

    public void setParsingExternal(boolean bl) {
        this.parsingExternal = bl;
        this.children = bl ? this.externalChildren : this.internalChildren;
    }

    public boolean isParsingExternal() {
        return this.parsingExternal;
    }

    public Enumeration internalElements() {
        return this.internalChildren.elements();
    }

    public Enumeration externalElements() {
        return this.externalChildren.elements();
    }

    public ExternalID getExternalID() {
        return this.externalID;
    }

    public void setExternalID(ExternalID externalID) {
        this.externalID = externalID;
    }

    public Enumeration getAttributeDeclarations(String string) {
        Hashtable hashtable = (Hashtable)this.attListDecls.get(string);
        if (hashtable == null) {
            hashtable = new Hashtable();
        }
        return hashtable.elements();
    }

    public AttDef getAttributeDeclaration(String string, String string2) {
        Hashtable hashtable = (Hashtable)this.attListDecls.get(string);
        if (hashtable == null) {
            return null;
        }
        return (AttDef)hashtable.get(string2);
    }

    public boolean isAttributeDeclared(String string, String string2) {
        return this.getAttributeDeclaration(string, string2) != null;
    }

    public Enumeration getElementDeclarations() {
        return this.elementDecls.elements();
    }

    public ElementDecl getElementDeclaration(String string) {
        return (ElementDecl)this.elementDecls.get(string);
    }

    public boolean isElementDeclared(String string) {
        return this.elementDecls.containsKey(string);
    }

    public Vector makeContentElementList(String string) {
        ElementDecl elementDecl = (ElementDecl)this.elementDecls.get(string);
        if (elementDecl == null) {
            return null;
        }
        return elementDecl.getXML4JContentModel().getChildrenOrder();
    }

    public Enumeration getNotationEnumeration() {
        return this.notationDecls.elements();
    }

    public Notation getNotation(String string) {
        TXNotation tXNotation = (TXNotation)this.notationDecls.get(string);
        if (tXNotation == null) {
            return null;
        }
        return tXNotation.getNotationImpl();
    }

    public NamedNodeMap getNotations() {
        return new HashNamedNodeMap(this.notationDecls);
    }

    public void setEncoding(String string) {
        this.xmlEncoding = string;
    }

    public void printExternal(Writer writer, String string) throws IOException {
        if (this.xmlEncoding != null) {
            writer.write("<?xml encoding=\"" + this.xmlEncoding + "\"?>");
        }
        int n = 0;
        while (n < this.externalChildren.getLength()) {
            ((Child)this.externalChildren.item(n)).print(writer, string);
            ++n;
        }
        writer.flush();
    }

    public boolean checkContent(TXElement tXElement) {
        ElementDecl elementDecl = (ElementDecl)this.elementDecls.get(tXElement.getNodeName());
        if (elementDecl == null) {
            return false;
        }
        return elementDecl.getXML4JContentModel().check(tXElement);
    }

    public ContentModel getContentModel(String string) {
        ElementDecl elementDecl = (ElementDecl)this.elementDecls.get(string);
        if (elementDecl == null) {
            return null;
        }
        return elementDecl.getXML4JContentModel();
    }

    public int getContentType(String string) {
        ElementDecl elementDecl = (ElementDecl)this.elementDecls.get(string);
        if (elementDecl == null) {
            return -1;
        }
        return elementDecl.getXML4JContentModel().getType();
    }

    public Hashtable prepareTable(String string) {
        ElementDecl elementDecl = (ElementDecl)this.elementDecls.get(string);
        if (elementDecl == null) {
            return null;
        }
        return elementDecl.getXML4JContentModel().prepareTable();
    }

    public Hashtable getInsertableElements(Element element, int n, Hashtable hashtable) {
        ContentModel contentModel = this.getContentModel(element.getNodeName());
        if (contentModel == null) {
            return null;
        }
        return contentModel.getInsertableElements(element, n, hashtable, false);
    }

    public Hashtable getAppendableElements(Element element, Hashtable hashtable) {
        return this.getInsertableElements(element, element.getChildNodes().getLength(), hashtable);
    }

    public Hashtable getInsertableElementsForValidContent(Element element, int n, Hashtable hashtable) {
        ContentModel contentModel = this.getContentModel(element.getNodeName());
        if (contentModel == null) {
            return null;
        }
        return contentModel.getInsertableElements(element, n, hashtable, true);
    }

    public boolean registID(Element element, String string) {
        if (this.idHash == null) {
            this.idHash = new Hashtable();
        }
        if (this.idHash.containsKey(string)) {
            return false;
        }
        this.idHash.put(string, element);
        return true;
    }

    public boolean unregistID(String string) {
        if (this.idHash == null) {
            return false;
        }
        if (!this.idHash.containsKey(string)) {
            return false;
        }
        this.idHash.remove(string);
        return true;
    }

    public Element checkID(String string) {
        if (this.idHash == null) {
            return null;
        }
        return (Element)this.idHash.get(string);
    }

    public Enumeration IDs() {
        if (this.idHash == null) {
            return new Hashtable().keys();
        }
        return this.idHash.keys();
    }

    public Enumeration getEntityEnumeration() {
        return this.entityPool.elements();
    }

    public Enumeration getParameterEntityEnumeration() {
        return this.entityPool.parameterEntityElements();
    }

    public EntityDecl getEntityDecl(String string, boolean bl) {
        EntityDecl entityDecl = bl ? this.entityPool.referPara(string) : this.entityPool.refer(string);
        return entityDecl;
    }

    public NamedNodeMap getEntities() {
        return new HashNamedNodeMap(this.entityPool.getEntityHash());
    }

    public int getInternalSize() {
        return this.internalChildren.getLength();
    }

    public int getExternalSize() {
        return this.externalChildren.getLength();
    }

    public void setPrintInternalDTD(boolean bl) {
        this.isPrintInternalDTD = bl;
    }

    public boolean isPrintInternalDTD() {
        return this.isPrintInternalDTD;
    }

    public void acceptPre(Visitor visitor) throws Exception {
        visitor.visitDTDPre(this);
    }

    public void acceptPost(Visitor visitor) throws Exception {
        visitor.visitDTDPost(this);
    }

    void setEntityPool(EntityPool entityPool) {
        this.entityPool = entityPool;
    }

    protected void checkChildType(Node node) throws DOMException {
        switch (node.getNodeType()) {
            default: {
                throw new TXDOMException(3, "Specified node type (" + node.getNodeType() + ") can't be a child of DocumentType.");
            }
            case 3: 
            case 6: 
            case 7: 
            case 8: 
            case 12: 
            case 20: 
            case 21: 
            case 23: 
        }
    }

    static class HashNamedNodeMap
    implements NamedNodeMap {
        Hashtable hash;
        Node[] data;

        HashNamedNodeMap(Hashtable hashtable) {
            this.hash = hashtable;
            this.makeArray();
        }

        private void makeArray() {
            this.data = new Node[this.hash.size()];
            Enumeration enumeration = this.hash.elements();
            int n = 0;
            while (enumeration.hasMoreElements()) {
                this.data[n++] = (Node)enumeration.nextElement();
            }
        }

        public Node getNamedItem(String string) {
            Object v = this.hash.get(string);
            if (v == null) {
                return null;
            }
            if (v instanceof TXNotation) {
                return ((TXNotation)v).getNotationImpl();
            }
            if (v instanceof EntityDecl) {
                return ((EntityDecl)v).getEntityImpl();
            }
            throw new RuntimeException("XML4J internal error: non-supported hash.");
        }

        public Node setNamedItem(Node node) {
            throw new TXDOMException(7, "This NamedNodeMap is read-only.");
        }

        public Node removeNamedItem(String string) {
            throw new TXDOMException(7, "This NamedNodeMap is read-only.");
        }

        public Node item(int n) {
            return this.data[n];
        }

        public int getLength() {
            return this.data.length;
        }
    }
}

