// File: ConverterPanel.java - last edit: 
// ʥХ祦 2000-2-28

// Copyright (c) 2000 by NANBA Ryosuke.

package com.horobi.relax;

//// imports
import java.awt.Component;
import java.awt.BorderLayout;
import java.awt.GridBagLayout;
import java.awt.GridBagConstraints;
import java.awt.event.*;
import javax.swing.JFileChooser;
import javax.swing.JPanel;
import javax.swing.JLabel;
import javax.swing.JComboBox;
import javax.swing.JTextField;
import javax.swing.JButton;
import javax.swing.Timer;
import javax.swing.filechooser.FileFilter;
import java.io.*;

/* ConverterPanel: (?)С GUI Ǥ.
 * @author NANBA Ryosuke
 * @version $Id: ConverterPanel.java,v 1.4 2000/05/07 15:37:58 rnanba Exp $
 */
public class ConverterPanel extends JPanel {


	public ConverterPanel(FileConverter aConverter) {
		converter = aConverter;
		chooser = new JFileChooser(".");
		FileFilter filter = new FileFilter() {
			public boolean accept(File f) {
				if(f.isDirectory())
					return true;
				return converter.accept(f);
			}
			public String getDescription() {
				return converter.getInputFileDescription();
			}
		};
		chooser.addChoosableFileFilter(filter);
		chooser.setFileFilter(filter);

		GridBagLayout gb = new GridBagLayout();
		JPanel center = new JPanel(gb);
		GridBagConstraints c = new GridBagConstraints();

		open = new JButton("Open...");
		open.addActionListener(new ActionListener() {
			public void actionPerformed(ActionEvent ae) { open(); }
		});
		fromLabel = new JLabel("From: ");
		toLabel = new JLabel("To: ");
		toLabel2 = new JLabel("");
		convert = new JButton("Start");
		convert.addActionListener(new ActionListener() {
			public void actionPerformed(ActionEvent ae) { convert(); }
		});
		convert.setEnabled(false);
		message = new JLabel(converter.getName());

		c.fill = GridBagConstraints.HORIZONTAL;
		c.anchor = GridBagConstraints.WEST;
		c.gridwidth = GridBagConstraints.RELATIVE;
		add(center, fromLabel, gb, c);
		c.fill = GridBagConstraints.NONE;
		c.anchor = GridBagConstraints.EAST;
		c.gridwidth = GridBagConstraints.REMAINDER;
		add(center, open, gb, c);

		c.weightx = 1.0;
		c.fill = GridBagConstraints.NONE;
		c.anchor = GridBagConstraints.WEST;
		c.gridwidth = GridBagConstraints.RELATIVE;
		add(center, toLabel, gb, c);
		c.fill = GridBagConstraints.HORIZONTAL;
		c.anchor = GridBagConstraints.EAST;
		c.gridwidth = GridBagConstraints.REMAINDER;
		add(center, toLabel2, gb, c);
		//add(center, toField, gb, c);
		add(center, createOptionUI(), gb, c);
		c.anchor = GridBagConstraints.WEST;
		add(center, convert, gb, c);

		setLayout(new BorderLayout());
		add("Center", center);
		add("South", message);
	}
	static void add(JPanel panel, Component component,
					   GridBagLayout gb, GridBagConstraints c) {
		gb.setConstraints(component, c);
		panel.add(component);
	}
	protected JPanel createOptionUI() {
		GridBagLayout gb = new GridBagLayout();
		GridBagConstraints c = new GridBagConstraints();
		JPanel options = new JPanel(gb);
		
		String names[] = converter.getOptionNames();
		Object defaults[] = converter.getOptionDefaults();
		int n = names.length;
		optionValues = new OptionValue[n];
		for(int i=0; i<n; i++){
			c.weightx = 0.0;
			c.fill = GridBagConstraints.NONE;
			c.anchor = GridBagConstraints.WEST;
			c.gridwidth = GridBagConstraints.RELATIVE;
			JLabel label = new JLabel(names[i]+": ");
			add(options, label, gb, c);

			c.weightx = 1.0;
			c.fill = GridBagConstraints.HORIZONTAL;
			c.gridwidth = GridBagConstraints.REMAINDER;
			c.anchor = GridBagConstraints.EAST;
			if(defaults[i] instanceof String){
				JTextField text = new JTextField((String)defaults[i]);
				add(options, text, gb, c);
				optionValues[i] = new OptionValue(text) { 
					String getValue() {
						return ((JTextField)object).getText();
					}
				};
			}else if(defaults[i] instanceof String[]){
				JComboBox combo = new JComboBox((Object[])defaults[i]);
				combo.setEditable(true);
				add(options, combo, gb, c);
				optionValues[i] = new OptionValue(combo) {
					String getValue() {
						return (String)((JComboBox)object)
							.getEditor().getItem();
					}
				};
			}
		}
		return options;
	}
	protected void start() {
		open.setEnabled(false);
		convert.setEnabled(false);
		timer = new Timer(100, new ActionListener() {
			int t = 0;
			public void actionPerformed(ActionEvent ae) {
				message.setText("converting... "+ "-\\|/".charAt(t++ % 4));
				message.repaint();
			}
		});
		timer.setRepeats(true);
		timer.setInitialDelay(0);
		timer.start();
	}
	protected void stop(String msg) {
		timer.stop();
		timer = null;
		message.setText(msg);
		open.setEnabled(true);
		convert.setEnabled(true);
	}
	public void open() {
		int opt = chooser.showOpenDialog(this);
		if(opt == JFileChooser.APPROVE_OPTION){
			src = chooser.getSelectedFile();
			String output = converter.getOutputFileName(src);
			dst = new File(src.getParent() + File.separator + output);
			fromLabel.setText("From: "+src.getName());
			//toField.setText(output);
			toLabel2.setText(output);
			convert.setEnabled(true);
			repaint();
		}
	}
	public void convert() {
		start();
		new Thread(new Runner()).start();
	}
	class Runner implements Runnable {
		public void run() {
			String options[] = new String[optionValues.length];
			for(int i=0; i<optionValues.length; i++)
				options[i] = optionValues[i].getValue();
			try{
				converter.convert(src, dst, options);
				stop("done.");
			}catch(Exception e){
				stop(e.getMessage());
			}finally{
				repaint();
			}
		}
	}

	FileConverter converter;
	JButton open;
	JButton convert;
	JLabel fromLabel;
	JLabel toLabel;
	JLabel toLabel2;
	//JTextField toField;
	JLabel message;
	JFileChooser chooser;
	Timer timer;
	File src;
	File dst;
	abstract class OptionValue {
		Object object;
		OptionValue(Object obj){ object = obj; }
		abstract String getValue();
	};
	OptionValue optionValues[];
}
