/*
 * Decompiled with CFR 0.152.
 */
package com.sittinglittleduck.DirBuster.gui;

import com.sittinglittleduck.DirBuster.gui.JDialogViewReport;
import com.sittinglittleduck.DirBuster.gui.StartGUI;
import com.sittinglittleduck.DirBuster.report.ReportWriter;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import javax.swing.DefaultComboBoxModel;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.jdesktop.layout.GroupLayout;

public class JPanelReport
extends JPanel {
    private StartGUI parent;
    public static final String reportExt = ".txt";
    public static final String reportSimpleExt = "-simple.txt";
    public static final String reportXMLExt = ".xml";
    public static final String reportCSVExt = ".csv";
    private JButton jButtonBack;
    private JButton jButtonGenerate;
    private JButton jButtonReportBrowse;
    private JButton jButtonReportExit;
    private JButton jButtonReportNew;
    private JCheckBox jCheckBoxCSVReport;
    private JCheckBox jCheckBoxFullTextReport;
    private JCheckBox jCheckBoxReportXML;
    private JCheckBox jCheckBoxSimpleList;
    private JComboBox jComboBoxSimpleListType;
    private JLabel jLabel1;
    private JLabel jLabel2;
    public JTextField jTextFieldReportLocation;
    public JTextField jTextFieldReportName;

    public JPanelReport(StartGUI parent) {
        this.parent = parent;
        this.initComponents();
    }

    private void initComponents() {
        this.jLabel2 = new JLabel();
        this.jTextFieldReportLocation = new JTextField();
        this.jButtonReportBrowse = new JButton();
        this.jButtonGenerate = new JButton();
        this.jButtonReportExit = new JButton();
        this.jButtonReportNew = new JButton();
        this.jButtonBack = new JButton();
        this.jCheckBoxFullTextReport = new JCheckBox();
        this.jCheckBoxReportXML = new JCheckBox();
        this.jCheckBoxSimpleList = new JCheckBox();
        this.jComboBoxSimpleListType = new JComboBox();
        this.jCheckBoxCSVReport = new JCheckBox();
        this.jLabel1 = new JLabel();
        this.jTextFieldReportName = new JTextField();
        this.jLabel2.setText("Please select the location to write the report to");
        this.jButtonReportBrowse.setIcon(new ImageIcon(this.getClass().getResource("/com/sittinglittleduck/DirBuster/gui/icons/system-search.png")));
        this.jButtonReportBrowse.setText("Browse");
        this.jButtonReportBrowse.setToolTipText("Browse location to save reports to");
        this.jButtonReportBrowse.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                JPanelReport.this.jButtonReportBrowseActionPerformed(evt);
            }
        });
        this.jButtonGenerate.setIcon(new ImageIcon(this.getClass().getResource("/com/sittinglittleduck/DirBuster/gui/icons/txt.png")));
        this.jButtonGenerate.setText("Generate Report");
        this.jButtonGenerate.setToolTipText("Click to generate reports");
        this.jButtonGenerate.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                JPanelReport.this.jButtonGenerateActionPerformed(evt);
            }
        });
        this.jButtonReportExit.setIcon(new ImageIcon(this.getClass().getResource("/com/sittinglittleduck/DirBuster/gui/icons/door_out.png")));
        this.jButtonReportExit.setText("Exit");
        this.jButtonReportExit.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                JPanelReport.this.jButtonReportExitActionPerformed(evt);
            }
        });
        this.jButtonReportNew.setIcon(new ImageIcon(this.getClass().getResource("/com/sittinglittleduck/DirBuster/gui/icons/window-new.png")));
        this.jButtonReportNew.setText("New Test");
        this.jButtonReportNew.setMaximumSize(new Dimension(79, 25));
        this.jButtonReportNew.setMinimumSize(new Dimension(79, 25));
        this.jButtonReportNew.setPreferredSize(new Dimension(79, 25));
        this.jButtonReportNew.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                JPanelReport.this.jButtonReportNewActionPerformed(evt);
            }
        });
        this.jButtonBack.setIcon(new ImageIcon(this.getClass().getResource("/com/sittinglittleduck/DirBuster/gui/icons/go-previous.png")));
        this.jButtonBack.setText("Back");
        this.jButtonBack.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                JPanelReport.this.jButtonBackActionPerformed(evt);
            }
        });
        this.jCheckBoxFullTextReport.setSelected(true);
        this.jCheckBoxFullTextReport.setText("Full text report (.txt)");
        this.jCheckBoxReportXML.setText("XML report (.xml)");
        this.jCheckBoxSimpleList.setText("Simple text list (simple.txt)");
        this.jComboBoxSimpleListType.setModel(new DefaultComboBoxModel<String>(new String[]{"Found dirs and files", "Found dirs only", "Found files only"}));
        this.jCheckBoxCSVReport.setText("CSV report (.csv)");
        this.jLabel1.setText("Report name (file extension will be auto added)");
        this.jTextFieldReportName.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                JPanelReport.this.jTextFieldReportNameActionPerformed(evt);
            }
        });
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(1).add(layout.createSequentialGroup().addContainerGap().add(layout.createParallelGroup(1).add(layout.createSequentialGroup().add(this.jCheckBoxCSVReport).addContainerGap()).add(layout.createSequentialGroup().add(this.jCheckBoxSimpleList).addPreferredGap(0).add(this.jComboBoxSimpleListType, -2, -1, -2).addContainerGap()).add(layout.createSequentialGroup().add(this.jCheckBoxReportXML).addContainerGap()).add(layout.createSequentialGroup().add(layout.createParallelGroup(1).add(this.jCheckBoxFullTextReport).add(2, layout.createSequentialGroup().add(this.jButtonGenerate, -2, 150, -2).addPreferredGap(0, 351, Short.MAX_VALUE).add(this.jButtonBack).addPreferredGap(0).add(this.jButtonReportNew, -2, 98, -2).addPreferredGap(0).add(this.jButtonReportExit, -2, 70, -2))).addContainerGap()).add(layout.createSequentialGroup().add(layout.createParallelGroup(1).add(this.jLabel2, -2, 390, -2).add(2, layout.createSequentialGroup().add(this.jTextFieldReportLocation, -1, 550, Short.MAX_VALUE).addPreferredGap(1).add(this.jButtonReportBrowse))).add(113, 113, 113)).add(layout.createSequentialGroup().add(this.jLabel1).addContainerGap(450, Short.MAX_VALUE)).add(layout.createSequentialGroup().add(this.jTextFieldReportName, -2, 298, -2).addContainerGap(448, Short.MAX_VALUE)))));
        layout.setVerticalGroup(layout.createParallelGroup(1).add(layout.createSequentialGroup().add(17, 17, 17).add(this.jCheckBoxFullTextReport).addPreferredGap(1).add(layout.createParallelGroup(3).add(this.jCheckBoxSimpleList).add(this.jComboBoxSimpleListType, -2, -1, -2)).add(7, 7, 7).add(this.jCheckBoxReportXML).add(4, 4, 4).add(this.jCheckBoxCSVReport).add(18, 18, 18).add(this.jLabel2).add(6, 6, 6).add(layout.createParallelGroup(3).add(this.jTextFieldReportLocation, -2, -1, -2).add(this.jButtonReportBrowse)).addPreferredGap(0).add(this.jLabel1).addPreferredGap(0).add(this.jTextFieldReportName, -2, -1, -2).add(layout.createParallelGroup(1).add(layout.createSequentialGroup().addPreferredGap(0, 28, Short.MAX_VALUE).add(layout.createParallelGroup(3).add(this.jButtonReportExit).add(this.jButtonReportNew, -2, -1, -2).add(this.jButtonBack)).addContainerGap()).add(layout.createSequentialGroup().addPreferredGap(1).add(this.jButtonGenerate).addContainerGap()))));
    }

    private void jButtonReportNewActionPerformed(ActionEvent evt) {
        this.parent.jPanelRunning.resultsTableModel.clearData();
        this.parent.showSetup();
    }

    private void jButtonReportExitActionPerformed(ActionEvent evt) {
        System.exit(0);
    }

    private void jButtonReportBrowseActionPerformed(ActionEvent evt) {
        File dir = new File(System.getProperty("user.dir"));
        JFileChooser fc = new JFileChooser(dir);
        fc.setFileSelectionMode(1);
        fc.setDialogTitle("Please Select The Location To Save The Report To");
        int returnVal = fc.showDialog(fc, "Select Directory");
        if (returnVal == 0) {
            File file = fc.getSelectedFile();
            this.jTextFieldReportLocation.setText(file.getAbsolutePath());
        }
        if (!this.jTextFieldReportName.getText().equals("")) {
            this.jTextFieldReportName.setText("DirBusterReport-" + this.parent.manager.getHost() + "-" + this.parent.manager.getPort());
        }
    }

    private void jButtonGenerateActionPerformed(ActionEvent evt) {
        FileInputStream filein;
        int n;
        if (this.jTextFieldReportLocation.getText() == null) {
            JOptionPane.showMessageDialog(this, "Please enter the location of where you wish the report to be writen to.", "Error", 0);
            return;
        }
        if (this.jTextFieldReportLocation.getText().equalsIgnoreCase("")) {
            JOptionPane.showMessageDialog(this, "Please enter the location of where you wish the report to be writen to.", "Error", 0);
            return;
        }
        if (this.jTextFieldReportName.getText() == null) {
            JOptionPane.showMessageDialog(this, "Please enter the name of the report.", "Error", 0);
            return;
        }
        if (this.jTextFieldReportName.getText().equalsIgnoreCase("")) {
            JOptionPane.showMessageDialog(this, "Please enter the name of the report.", "Error", 0);
            return;
        }
        String filename = this.jTextFieldReportLocation.getText().trim() + File.separator + this.jTextFieldReportName.getText().trim();
        if (new File(filename).isDirectory()) {
            JOptionPane.showMessageDialog(this, "The given path is a directory. Please specify both path and file name.", "Error", 0);
            return;
        }
        ReportWriter report = new ReportWriter(filename);
        if (this.jCheckBoxFullTextReport.isSelected()) {
            n = 0;
            try {
                filein = new FileInputStream(filename);
                n = JOptionPane.showConfirmDialog(this, "Full text report file already there.", "Over write it?", 0);
            }
            catch (FileNotFoundException ex) {
                // empty catch block
            }
            if (n == 0) {
                report.writeReport();
            }
        }
        if (this.jCheckBoxSimpleList.isSelected()) {
            n = 0;
            try {
                filein = new FileInputStream(filename);
                n = JOptionPane.showConfirmDialog(this, "Simple text report file already there.", "Over write it?", 0);
            }
            catch (FileNotFoundException ex) {
                // empty catch block
            }
            if (n == 0) {
                if (this.jComboBoxSimpleListType.getSelectedIndex() == 0) {
                    report.writeSimpleListFilesAndDirs();
                } else if (this.jComboBoxSimpleListType.getSelectedIndex() == 1) {
                    report.writeSimpleListDirsOnly();
                } else if (this.jComboBoxSimpleListType.getSelectedIndex() == 2) {
                    report.writeSimpleListFilesOnly();
                }
                report.writeReport();
            }
        }
        if (this.jCheckBoxReportXML.isSelected()) {
            n = 0;
            try {
                filein = new FileInputStream(filename);
                n = JOptionPane.showConfirmDialog(this, "XML report file already there.", "Over write it?", 0);
            }
            catch (FileNotFoundException ex) {
                // empty catch block
            }
            if (n == 0) {
                report.writeXML();
            }
        }
        if (this.jCheckBoxCSVReport.isSelected()) {
            n = 0;
            try {
                filein = new FileInputStream(filename);
                n = JOptionPane.showConfirmDialog(this, "CSV report file already there.", "Over write it?", 0);
            }
            catch (FileNotFoundException ex) {
                // empty catch block
            }
            if (n == 0) {
                report.writeCSV();
            }
        }
        new JDialogViewReport((Frame)this.parent, true, filename).setVisible(true);
    }

    private void jButtonBackActionPerformed(ActionEvent evt) {
        this.parent.showRunning();
    }

    private void jTextFieldReportNameActionPerformed(ActionEvent evt) {
    }
}

