/*
 * Decompiled with CFR 0.152.
 */
package com.sittinglittleduck.DirBuster.workGenerators;

import com.sittinglittleduck.DirBuster.BaseCase;
import com.sittinglittleduck.DirBuster.GenBaseCase;
import com.sittinglittleduck.DirBuster.Manager;
import com.sittinglittleduck.DirBuster.WorkUnit;
import com.sittinglittleduck.DirBuster.bruteForceIterator.BruteForceIterator;
import com.sittinglittleduck.DirBuster.utils.HeadRequestCheck;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.concurrent.BlockingQueue;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.httpclient.HttpClient;

public class BruteForceURLFuzz
implements Runnable {
    private String[] list;
    private int minLen;
    private int maxLen;
    private Manager manager = Manager.getInstance();
    private BlockingQueue<WorkUnit> workQueue;
    private String firstPart;
    private String finished;
    private String started;
    HttpClient httpclient;
    private String urlFuzzStart;
    private String urlFuzzEnd;
    private int counter = 0;
    private boolean isWorking = true;

    public BruteForceURLFuzz() {
        this.maxLen = this.manager.getMaxLen();
        this.minLen = this.manager.getMinLen();
        this.list = this.manager.getCharSet();
        this.workQueue = this.manager.workQueue;
        this.firstPart = this.manager.getFirstPartOfURL();
        this.httpclient = this.manager.getHttpclient();
        this.urlFuzzStart = this.manager.getUrlFuzzStart();
        this.urlFuzzEnd = this.manager.getUrlFuzzEnd();
    }

    public void run() {
        HeadRequestCheck.test(this.firstPart);
        System.out.println("Starting fuzz on " + this.firstPart + this.urlFuzzStart + "{dir}" + this.urlFuzzEnd);
        this.manager.setStatus("Starting fuzz on " + this.firstPart + this.urlFuzzStart + "{dir}" + this.urlFuzzEnd);
        BaseCase baseCaseObj = null;
        try {
            baseCaseObj = GenBaseCase.genURLFuzzBaseCase(this.firstPart + this.urlFuzzStart, this.urlFuzzEnd);
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        BruteForceIterator bfi = new BruteForceIterator(this.minLen, this.maxLen, this.list);
        this.manager.setTotalPass(bfi.getTotalToDo());
        while (bfi.hasNext()) {
            String method = this.manager.getAuto() && !baseCaseObj.useContentAnalysisMode() && !baseCaseObj.isUseRegexInstead() ? "HEAD" : "GET";
            String item = bfi.next();
            try {
                URL currentURL = new URL(this.firstPart + this.urlFuzzStart + item + this.urlFuzzEnd);
                this.workQueue.put(new WorkUnit(currentURL, true, method, baseCaseObj, item));
                ++this.counter;
            }
            catch (InterruptedException ex) {
                Logger.getLogger(BruteForceURLFuzz.class.getName()).log(Level.SEVERE, null, ex);
            }
            catch (MalformedURLException ex) {
                Logger.getLogger(BruteForceURLFuzz.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
        this.isWorking = false;
    }

    public int getCurrentDone() {
        return this.counter;
    }

    public boolean isWorking() {
        return this.isWorking;
    }

    public String getStartPoint() {
        return this.urlFuzzStart + "{dir}" + this.urlFuzzEnd;
    }
}

