//-----------------------------------------------------------------------------
// File: extensions.h
//
// Copyright (C) 2001-2002 Tomohide Kano. All rights reserved.
// Rearranged to live with nVidia stuff by Daniele Paccaloni
//-----------------------------------------------------------------------------

#pragma once

#ifdef WIN32
#  include "glati.h"
#  include "glext.h"
//#  include <OpenGL/glext.h>
#  if defined(DECLARE_EXTENSION_SUBSTANCE)
#    define EXTERN
#  else
#    define EXTERN extern
#  endif


// GL_ARB_multitexture
EXTERN PFNGLACTIVETEXTUREARBPROC              glActiveTextureARB;
EXTERN PFNGLCLIENTACTIVETEXTUREARBPROC        glClientActiveTextureARB;

// GL_EXT_texture3D
EXTERN PFNGLTEXIMAGE3DEXTPROC                 glTexImage3DEXT;

// ATI_vertex_array_object
EXTERN PFNGLNEWOBJECTBUFFERATIPROC            glNewObjectBufferATI;
EXTERN PFNGLISOBJECTBUFFERATIPROC             glIsObjectBufferATI;
EXTERN PFNGLUPDATEOBJECTBUFFERATIPROC         glUpdateObjectBufferATI;
EXTERN PFNGLGETOBJECTBUFFERFVATIPROC          glGetObjectBufferfvATI;
EXTERN PFNGLGETOBJECTBUFFERIVATIPROC          glGetObjectBufferivATI;
EXTERN PFNGLFREEOBJECTBUFFERATIPROC           glFreeObjectBufferATI;
EXTERN PFNGLARRAYOBJECTATIPROC                glArrayObjectATI;
EXTERN PFNGLGETARRAYOBJECTFVATIPROC           glGetArrayObjectfvATI;
EXTERN PFNGLGETARRAYOBJECTIVATIPROC           glGetArrayObjectivATI;
EXTERN PFNGLVARIANTARRAYOBJECTATIPROC         glVariantArrayObjectATI;
EXTERN PFNGLGETVARIANTARRAYOBJECTFVATIPROC    glGetVariantArrayObjectfvATI;
EXTERN PFNGLGETVARIANTARRAYOBJECTIVATIPROC    glGetVariantArrayObjectivATI;

// ATI_element_arrays
EXTERN PFNGLELEMENTPOINTERATIPROC             glElementPointerATI;
EXTERN PFNGLDRAWELEMENTARRAYATIPROC           glDrawElementArrayATI;
EXTERN PFNGLDRAWRANGEELEMENTARRAYATIPROC      glDrawRangeElementArrayATI;

// GL_EXT_vertex_shader
EXTERN PFNGLBEGINVERTEXSHADEREXTPROC          glBeginVertexShaderEXT;
EXTERN PFNGLENDVERTEXSHADEREXTPROC            glEndVertexShaderEXT;
EXTERN PFNGLBINDVERTEXSHADEREXTPROC           glBindVertexShaderEXT;
EXTERN PFNGLGENVERTEXSHADERSEXTPROC           glGenVertexShadersEXT;
EXTERN PFNGLDELETEVERTEXSHADEREXTPROC         glDeleteVertexShaderEXT;
EXTERN PFNGLSHADEROP1EXTPROC                  glShaderOp1EXT;
EXTERN PFNGLSHADEROP2EXTPROC                  glShaderOp2EXT;
EXTERN PFNGLSHADEROP3EXTPROC                  glShaderOp3EXT;
EXTERN PFNGLSWIZZLEEXTPROC                    glSwizzleEXT;
EXTERN PFNGLWRITEMASKEXTPROC                  glWriteMaskEXT;
EXTERN PFNGLINSERTCOMPONENTEXTPROC            glInsertComponentEXT;
EXTERN PFNGLEXTRACTCOMPONENTEXTPROC           glExtractComponentEXT;
EXTERN PFNGLGENSYMBOLSEXTPROC                 glGenSymbolsEXT;
EXTERN PFNGLSETINVARIANTEXTPROC               glSetInvariantEXT;
EXTERN PFNGLSETLOCALCONSTANTEXTPROC           glSetLocalConstantEXT;
EXTERN PFNGLVARIANTBVEXTPROC                  glVariantbvEXT;
EXTERN PFNGLVARIANTSVEXTPROC                  glVariantsvEXT;
EXTERN PFNGLVARIANTIVEXTPROC                  glVariantivEXT;
EXTERN PFNGLVARIANTFVEXTPROC                  glVariantfvEXT;
EXTERN PFNGLVARIANTDVEXTPROC                  glVariantdvEXT;
EXTERN PFNGLVARIANTUBVEXTPROC                 glVariantubvEXT;
EXTERN PFNGLVARIANTUSVEXTPROC                 glVariantusvEXT;
EXTERN PFNGLVARIANTUIVEXTPROC                 glVariantuivEXT;
EXTERN PFNGLVARIANTPOINTEREXTPROC             glVariantPointerEXT;
EXTERN PFNGLENABLEVARIANTCLIENTSTATEEXTPROC   glEnableVariantClientStateEXT;
EXTERN PFNGLDISABLEVARIANTCLIENTSTATEEXTPROC  glDisableVariantClientStateEXT;
EXTERN PFNGLBINDLIGHTPARAMETEREXTPROC         glBindLightParameterEXT;
EXTERN PFNGLBINDMATERIALPARAMETEREXTPROC      glBindMaterialParameterEXT;
EXTERN PFNGLBINDTEXGENPARAMETEREXTPROC        glBindTexGenParameterEXT;
EXTERN PFNGLBINDTEXTUREUNITPARAMETEREXTPROC   glBindTextureUnitParameterEXT;
EXTERN PFNGLBINDPARAMETEREXTPROC              glBindParameterEXT;
EXTERN PFNGLISVARIANTENABLEDEXTPROC           glIsVariantEnabledEXT;
EXTERN PFNGLGETVARIANTBOOLEANVEXTPROC         glGetVariantBooleanvEXT;
EXTERN PFNGLGETVARIANTINTEGERVEXTPROC         glGetVariantIntegervEXT;
EXTERN PFNGLGETVARIANTFLOATVEXTPROC           glGetVariantFloatvEXT;
EXTERN PFNGLGETVARIANTPOINTERVEXTPROC         glGetVariantPointervEXT;
EXTERN PFNGLGETINVARIANTBOOLEANVEXTPROC       glGetInvariantBooleanvEXT;
EXTERN PFNGLGETINVARIANTINTEGERVEXTPROC       glGetInvariantIntegervEXT;
EXTERN PFNGLGETINVARIANTFLOATVEXTPROC         glGetInvariantFloatvEXT;
EXTERN PFNGLGETLOCALCONSTANTBOOLEANVEXTPROC   glGetLocalConstantBooleanvEXT;
EXTERN PFNGLGETLOCALCONSTANTINTEGERVEXTPROC   glGetLocalConstantIntegervEXT;
EXTERN PFNGLGETLOCALCONSTANTFLOATVEXTPROC     glGetLocalConstantFloatvEXT;

// GL_ATI_fragment_shader
EXTERN PFNGLGENFRAGMENTSHADERSATIPROC         glGenFragmentShadersATI;
EXTERN PFNGLBINDFRAGMENTSHADERATIPROC         glBindFragmentShaderATI;
EXTERN PFNGLDELETEFRAGMENTSHADERATIPROC       glDeleteFragmentShaderATI;
EXTERN PFNGLBEGINFRAGMENTSHADERATIPROC        glBeginFragmentShaderATI;
EXTERN PFNGLENDFRAGMENTSHADERATIPROC          glEndFragmentShaderATI;
EXTERN PFNGLPASSTEXCOORDATIPROC               glPassTexCoordATI;
EXTERN PFNGLSAMPLEMAPATIPROC                  glSampleMapATI;
EXTERN PFNGLCOLORFRAGMENTOP1ATIPROC           glColorFragmentOp1ATI;
EXTERN PFNGLCOLORFRAGMENTOP2ATIPROC           glColorFragmentOp2ATI;
EXTERN PFNGLCOLORFRAGMENTOP3ATIPROC           glColorFragmentOp3ATI;
EXTERN PFNGLALPHAFRAGMENTOP1ATIPROC           glAlphaFragmentOp1ATI;
EXTERN PFNGLALPHAFRAGMENTOP2ATIPROC           glAlphaFragmentOp2ATI;
EXTERN PFNGLALPHAFRAGMENTOP3ATIPROC           glAlphaFragmentOp3ATI;
EXTERN PFNGLSETFRAGMENTSHADERCONSTANTATIPROC  glSetFragmentShaderConstantATI;

// GL_ARB_fragment_program
EXTERN PFNGLGENPROGRAMSARBPROC                glGenProgramsARB;
EXTERN PFNGLDELETEPROGRAMSARBPROC             glDeleteProgramsARB;
EXTERN PFNGLBINDPROGRAMARBPROC                glBindProgramARB;
EXTERN PFNGLPROGRAMSTRINGARBPROC              glProgramStringARB;
EXTERN PFNGLPROGRAMENVPARAMETER4FARBPROC      glProgramEnvParameter4fARB;
EXTERN PFNGLGETPROGRAMIVARBPROC               glGetProgramivARB;

  #undef EXTERN

#elif defined(__APPLE__) || defined(__linux__)

typedef void (* glActiveTextureARBProcPtr) (GLenum);
typedef void (* glClientActiveTextureARBProcPtr) (GLenum);
typedef void (* glGenProgramsARBProcPtr) (GLsizei n, GLuint *programs);
typedef void (* glDeleteProgramsARBProcPtr) (GLsizei n, const GLuint *programs);
typedef void (* glBindProgramARBProcPtr) (GLenum target, GLuint program);
typedef void (* glProgramStringARBProcPtr) (GLenum target, GLenum format, GLsizei len, const GLvoid *string);
typedef void (* glProgramEnvParameter4fARBProcPtr) (GLenum target, GLuint index, GLfloat x, GLfloat y, GLfloat z, GLfloat w);
typedef void (* glGetProgramivARBProcPtr) (GLenum target, GLenum pname, GLint *params);

#endif

extern bool CheckExtension(const char *ext);
extern bool InitExtensions(void);
extern bool InitExtensionsATI(void);
extern bool InitExtensionsARB(void);

