/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.jasperserver.api.metadata.user.service.impl;

import com.jaspersoft.jasperserver.api.JSException;
import com.jaspersoft.jasperserver.api.common.domain.ExecutionContext;
import com.jaspersoft.jasperserver.api.metadata.common.domain.Resource;
import com.jaspersoft.jasperserver.api.metadata.common.domain.impl.IdedObject;
import com.jaspersoft.jasperserver.api.metadata.common.service.ResourceFactory;
import com.jaspersoft.jasperserver.api.metadata.common.service.impl.HibernateDaoImpl;
import com.jaspersoft.jasperserver.api.metadata.common.service.impl.hibernate.HibernateRepositoryService;
import com.jaspersoft.jasperserver.api.metadata.common.service.impl.hibernate.PersistentObjectResolver;
import com.jaspersoft.jasperserver.api.metadata.common.service.impl.hibernate.persistent.RepoResource;
import com.jaspersoft.jasperserver.api.metadata.user.domain.ProfileAttribute;
import com.jaspersoft.jasperserver.api.metadata.user.domain.Role;
import com.jaspersoft.jasperserver.api.metadata.user.domain.User;
import com.jaspersoft.jasperserver.api.metadata.user.domain.impl.client.MetadataUserDetails;
import com.jaspersoft.jasperserver.api.metadata.user.domain.impl.hibernate.RepoProfileAttribute;
import com.jaspersoft.jasperserver.api.metadata.user.service.ProfileAttributeService;
import com.jaspersoft.jasperserver.api.metadata.user.service.UserAuthorityService;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hibernate.Hibernate;
import org.hibernate.HibernateException;
import org.hibernate.Query;
import org.hibernate.Session;
import org.hibernate.type.Type;
import org.springframework.orm.hibernate3.HibernateCallback;
import org.springframework.security.Authentication;
import org.springframework.security.context.SecurityContextHolder;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

@Transactional(propagation=Propagation.SUPPORTS, readOnly=true)
public class ProfileAttributeServiceImpl
extends HibernateDaoImpl
implements ProfileAttributeService,
PersistentObjectResolver {
    protected static final Log log = LogFactory.getLog(ProfileAttributeServiceImpl.class);
    private HibernateRepositoryService repoService;
    private UserAuthorityService userService;
    private ResourceFactory objectFactory;
    private ResourceFactory persistentClassFactory;

    public HibernateRepositoryService getRepositoryService() {
        return this.repoService;
    }

    public void setRepositoryService(HibernateRepositoryService repoService) {
        this.repoService = repoService;
    }

    public UserAuthorityService getUserAuthorityService() {
        return this.userService;
    }

    public void setUserAuthorityService(UserAuthorityService userService) {
        this.userService = userService;
    }

    public ResourceFactory getObjectMappingFactory() {
        return this.objectFactory;
    }

    public void setObjectMappingFactory(ResourceFactory objectFactory) {
        this.objectFactory = objectFactory;
    }

    public ResourceFactory getPersistentClassFactory() {
        return this.persistentClassFactory;
    }

    public void setPersistentClassFactory(ResourceFactory persistentClassFactory) {
        this.persistentClassFactory = persistentClassFactory;
    }

    @Transactional(propagation=Propagation.REQUIRED)
    public ProfileAttribute newProfileAttribute(ExecutionContext context) {
        return (ProfileAttribute)this.getObjectMappingFactory().newObject(ProfileAttribute.class);
    }

    @Transactional(propagation=Propagation.REQUIRED, readOnly=false)
    public void putProfileAttribute(ExecutionContext context, ProfileAttribute attr) {
        RepoProfileAttribute existingAttr = this.getRepoProfileAttribute(attr);
        if (existingAttr == null) {
            existingAttr = (RepoProfileAttribute)this.getPersistentClassFactory().newObject(ProfileAttribute.class);
        }
        existingAttr.copyFromClient(attr, this);
        this.getHibernateTemplate().saveOrUpdate((Object)existingAttr);
    }

    @Transactional(propagation=Propagation.REQUIRED)
    public ProfileAttribute getProfileAttribute(ExecutionContext context, ProfileAttribute attr) {
        RepoProfileAttribute existingPerm = this.getRepoProfileAttribute(attr);
        if (existingPerm == null) {
            return null;
        }
        return (ProfileAttribute)existingPerm.toClient(this.getObjectMappingFactory());
    }

    private RepoProfileAttribute getRepoProfileAttribute(ProfileAttribute attr) {
        final IdedObject principalObject = (IdedObject)this.getPersistentObject(attr.getPrincipal());
        String attrClassName = this.getPersistentClassFactory().getImplementationClassName(ProfileAttribute.class);
        if (principalObject == null) {
            throw new JSException("jsexception.no.principal");
        }
        final String queryString = "from " + attrClassName + " as profileAttr " + "where profileAttr.principal.id = ? " + "and profileAttr.principal.class = ? " + "and profileAttr.attrName = ?";
        final String attrName = attr.getAttrName();
        List objList = this.getHibernateTemplate().executeFind(new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException {
                Query query = session.createQuery(queryString);
                query.setParameter(0, (Object)principalObject.getId(), (Type)Hibernate.LONG);
                query.setParameter(1, (Object)ProfileAttributeServiceImpl.this.getObjectClass(principalObject.getClass()), (Type)Hibernate.CLASS);
                query.setParameter(2, (Object)attrName, (Type)Hibernate.STRING);
                return query.list();
            }
        });
        if (objList.size() == 0) {
            return null;
        }
        return (RepoProfileAttribute)objList.get(0);
    }

    private Class<?> getObjectClass(Class<?> classObj) {
        if (classObj.toString().indexOf("_$$_") > 0) {
            return classObj.getSuperclass();
        }
        return classObj;
    }

    private List getRepoProfileAttributes(Object principal) {
        final IdedObject principalObject = (IdedObject)this.getPersistentObject(principal);
        String attrClassName = this.getPersistentClassFactory().getImplementationClassName(ProfileAttribute.class);
        if (principalObject == null) {
            throw new JSException("jsexception.no.principal");
        }
        final String queryString = "from " + attrClassName + " as profileAttr " + "where profileAttr.principal.id = ? " + "and profileAttr.principal.class = ?";
        List objList = this.getHibernateTemplate().executeFind(new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException {
                Query query = session.createQuery(queryString);
                query.setParameter(0, (Object)principalObject.getId(), (Type)Hibernate.LONG);
                query.setParameter(1, (Object)ProfileAttributeServiceImpl.this.getObjectClass(principalObject.getClass()), (Type)Hibernate.CLASS);
                return query.list();
            }
        });
        return objList;
    }

    @Transactional(propagation=Propagation.REQUIRED)
    public List getProfileAttributesForPrincipal(ExecutionContext context, Object principal) {
        List objList = this.getRepoProfileAttributes(principal);
        return this.makeProfileAttributeClientList(objList);
    }

    private List makeProfileAttributeClientList(List objList) {
        ArrayList<ProfileAttribute> resultList = new ArrayList<ProfileAttribute>(objList.size());
        Iterator it = objList.iterator();
        while (!objList.isEmpty() && it.hasNext()) {
            RepoProfileAttribute repoPerm = (RepoProfileAttribute)it.next();
            ProfileAttribute clientPermission = (ProfileAttribute)repoPerm.toClient(this.getObjectMappingFactory());
            resultList.add(clientPermission);
        }
        return resultList;
    }

    @Override
    @Transactional(propagation=Propagation.REQUIRED)
    public Object getPersistentObject(Object clientObject) {
        if (clientObject == null) {
            return null;
        }
        if (clientObject instanceof IdedObject) {
            return clientObject;
        }
        if (clientObject instanceof Role || clientObject instanceof User) {
            return ((PersistentObjectResolver)this.userService).getPersistentObject(clientObject);
        }
        if (clientObject instanceof Resource) {
            String uri = ((Resource)clientObject).getPath();
            return this.repoService.findByURI(RepoResource.class, uri, false);
        }
        if (clientObject instanceof ProfileAttribute) {
            return this.getRepoProfileAttribute((ProfileAttribute)clientObject);
        }
        return null;
    }

    @Transactional(propagation=Propagation.REQUIRED)
    public String getCurrentUserPreferenceValue(String attrName) {
        String attrValue = null;
        MetadataUserDetails user = this.getCurrentUserDetails();
        ProfileAttribute attr = this.newProfileAttribute(null);
        attr.setPrincipal((Object)user);
        attr.setAttrName(attrName);
        ProfileAttribute savedAttr = this.getProfileAttribute(null, attr);
        if (savedAttr != null) {
            attrValue = savedAttr.getAttrValue();
        }
        return attrValue;
    }

    @Transactional(propagation=Propagation.REQUIRED, readOnly=false)
    public void setCurrentUserPreferenceValue(String attrName, String attrValue) {
        MetadataUserDetails user = this.getCurrentUserDetails();
        ProfileAttribute attr = this.newProfileAttribute(null);
        attr.setPrincipal((Object)user);
        attr.setAttrName(attrName);
        ProfileAttribute savedAttr = this.getProfileAttribute(null, attr);
        if (savedAttr == null) {
            savedAttr = attr;
        }
        if (!ProfileAttributeServiceImpl.equalsWithNull(savedAttr.getAttrValue(), attrValue)) {
            savedAttr.setAttrValue(attrValue);
            this.putProfileAttribute(null, savedAttr);
        }
    }

    public static boolean equalsWithNull(Object o1, Object o2) {
        return o1 == null && o2 == null || o1 != null && o1.equals(o2);
    }

    public MetadataUserDetails getCurrentUserDetails() {
        Authentication auth = SecurityContextHolder.getContext().getAuthentication();
        if (auth != null) {
            return (MetadataUserDetails)auth.getPrincipal();
        }
        return null;
    }
}

