/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.jasperserver.api.security;

import com.jaspersoft.jasperserver.api.JSSecurityException;
import com.jaspersoft.jasperserver.api.security.SecurityConfiguration;
import com.jaspersoft.jasperserver.api.security.validators.Validator;
import com.jaspersoft.jasperserver.core.util.StringUtil;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.regex.Pattern;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.log4j.Logger;
import org.owasp.csrfguard.CsrfGuard;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.MessageSource;

public class JSCsrfGuardFilter
implements Filter {
    private static final Logger log = Logger.getLogger(JSCsrfGuardFilter.class);
    private Map<String, Map<String, Pattern>> protectedActions = null;
    private static final String REQUEST_FILTER_CONFIG = "esapi/Owasp.CsrfGuard.RequestFilterConfig.properties";
    @Autowired
    @Qualifier(value="messageSource")
    private MessageSource messages;

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain filterChain) throws IOException, ServletException {
        if (SecurityConfiguration.isCSRFValidationOn() && this.filterRequest((HttpServletRequest)request)) {
            HttpServletRequest httpRequest = (HttpServletRequest)request;
            HttpServletResponse httpResponse = (HttpServletResponse)response;
            HttpSession session = httpRequest.getSession(true);
            CsrfGuard csrfGuard = (CsrfGuard)session.getAttribute("Owasp_CsrfGuard_Session_Key");
            log.info((Object)String.format("CsrfGuard analyzing request %s", httpRequest.getRequestURI()));
            if (session.isNew()) {
                csrfGuard.writeLandingPage(httpRequest, httpResponse);
            } else if (csrfGuard.isValidRequest(httpRequest, httpResponse)) {
                filterChain.doFilter((ServletRequest)httpRequest, (ServletResponse)httpResponse);
            }
            csrfGuard.updateTokens(httpRequest);
        } else {
            filterChain.doFilter(request, response);
        }
    }

    public JSCsrfGuardFilter() {
        this.loadRequestFilterConfig();
    }

    private boolean filterRequest(HttpServletRequest request) {
        Map paramsMap = StringUtil.getDecodedMap((Map)request.getParameterMap(), (String)Validator.getDefaultEncoding(), (String)Validator.getDefaultEncodingErrorMessage());
        if (paramsMap.size() == 0) {
            return false;
        }
        for (Map.Entry<String, Map<String, Pattern>> actionEntry : this.protectedActions.entrySet()) {
            Map<String, Pattern> params = actionEntry.getValue();
            int paramsMatch = 0;
            block1: for (Map.Entry<String, Pattern> paramEntry : params.entrySet()) {
                if (!paramsMap.containsKey(paramEntry.getKey())) continue;
                for (String value : (String[])paramsMap.get(paramEntry.getKey())) {
                    if (!paramEntry.getValue().matcher(value).matches()) continue;
                    ++paramsMatch;
                    continue block1;
                }
            }
            if (params.size() != paramsMatch) continue;
            return true;
        }
        return false;
    }

    private void loadRequestFilterConfig() {
        if (this.protectedActions != null) {
            return;
        }
        Properties requestFilterConfig = new Properties();
        try {
            InputStream is = this.getClass().getClassLoader().getResourceAsStream(REQUEST_FILTER_CONFIG);
            requestFilterConfig.load(is);
            is.close();
        }
        catch (Exception e) {
            throw new JSSecurityException("CSRF request filter config cannot be loaded.", log, (Throwable)e);
        }
        log.info((Object)"CSRF request filter config loaded.");
        this.protectedActions = this.resolveProtectedActions(requestFilterConfig);
    }

    public Map<String, Map<String, Pattern>> resolveProtectedActions(Properties props) {
        HashMap<String, Map<String, Pattern>> actions = new HashMap<String, Map<String, Pattern>>();
        try {
            String separatorPropName = "ActionSeparator";
            String separator = props.getProperty(separatorPropName, "|");
            for (String propName : props.stringPropertyNames()) {
                Map<String, Pattern> params;
                if (propName.equals(separatorPropName)) continue;
                String[] propNameArray = propName.split("\\" + separator);
                String action = propNameArray[0];
                String param = propNameArray[1];
                Pattern actionPattern = Pattern.compile(props.getProperty(propName), 2);
                if (actions.containsKey(action)) {
                    params = (Map)actions.get(action);
                    params.put(param, actionPattern);
                    continue;
                }
                params = new HashMap();
                params.put(param, actionPattern);
                actions.put(action, params);
            }
            log.info((Object)"CSRF request filter config resolved.");
        }
        catch (Exception e) {
            throw new JSSecurityException("CSRF request filter parameters cannot be resolved.", log, (Throwable)e);
        }
        return actions;
    }

    public void init(FilterConfig filterConfig) throws ServletException {
    }

    public void destroy() {
    }

    public MessageSource getMessages() {
        return this.messages;
    }

    public void setMessages(MessageSource messages) {
        this.messages = messages;
    }
}

