/*
 * Decompiled with CFR 0.152.
 */
package org.directwebremoting.impl;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.directwebremoting.WebContext;
import org.directwebremoting.WebContextFactory;
import org.directwebremoting.extend.Creator;
import org.directwebremoting.extend.CreatorManager;
import org.directwebremoting.util.LocalUtil;
import org.directwebremoting.util.Logger;
import org.directwebremoting.util.Messages;

public class DefaultCreatorManager
implements CreatorManager {
    private static final Logger log = Logger.getLogger(class$org$directwebremoting$impl$DefaultCreatorManager == null ? (class$org$directwebremoting$impl$DefaultCreatorManager = DefaultCreatorManager.class$("org.directwebremoting.impl.DefaultCreatorManager")) : class$org$directwebremoting$impl$DefaultCreatorManager);
    private Map creatorTypes = new HashMap();
    private Map creators = new HashMap();
    private boolean debug = false;
    private boolean initApplicationScopeCreatorsAtStartup = false;
    private static List ignore = Arrays.asList("creator", "class");
    static /* synthetic */ Class class$org$directwebremoting$extend$Creator;
    static /* synthetic */ Class class$org$directwebremoting$impl$DefaultCreatorManager;

    public void setDebug(boolean debug) {
        this.debug = debug;
    }

    public boolean isDebug() {
        return this.debug;
    }

    public void addCreatorType(String typeName, String className) {
        if (!LocalUtil.isJavaIdentifier(typeName)) {
            log.error("Illegal identifier: '" + typeName + "'");
            return;
        }
        Class clazz = LocalUtil.classForName(typeName, className, class$org$directwebremoting$extend$Creator == null ? (class$org$directwebremoting$extend$Creator = DefaultCreatorManager.class$("org.directwebremoting.extend.Creator")) : class$org$directwebremoting$extend$Creator);
        if (clazz != null) {
            log.debug("- adding creator type: " + typeName + " = " + clazz);
            this.creatorTypes.put(typeName, clazz);
        }
    }

    public void addCreator(String scriptName, String typeName, Map params) throws InstantiationException, IllegalAccessException, IllegalArgumentException {
        if (!LocalUtil.isJavaIdentifier(scriptName)) {
            log.error("Illegal identifier: '" + scriptName + "'");
            return;
        }
        Class clazz = (Class)this.creatorTypes.get(typeName);
        if (clazz == null) {
            log.error("Missing creator: " + typeName + " (while initializing creator for: " + scriptName + ".js)");
            return;
        }
        Creator creator = (Creator)clazz.newInstance();
        LocalUtil.setParams(creator, params, ignore);
        creator.setProperties(params);
        this.addCreator(scriptName, creator);
    }

    public void addCreator(String scriptName, Creator creator) throws IllegalArgumentException {
        Creator other = (Creator)this.creators.get(scriptName);
        if (other != null) {
            throw new IllegalArgumentException(Messages.getString("DefaultCreatorManager.DuplicateName", scriptName, other.getType().getName(), creator));
        }
        try {
            Class test = creator.getType();
            if (test == null) {
                log.error("Creator: '" + creator + "' for " + scriptName + ".js is returning null for type queries.");
            } else {
                log.debug("- adding creator: " + LocalUtil.getShortClassName(creator.getClass()) + " for " + scriptName);
                this.creators.put(scriptName, creator);
            }
        }
        catch (NoClassDefFoundError ex) {
            log.error("Missing class for creator '" + creator + "'. Cause: " + ex.getMessage());
        }
        catch (Exception ex) {
            log.error("Error loading class for creator '" + creator + "'.", ex);
        }
        if (this.initApplicationScopeCreatorsAtStartup && creator.getScope().equals("application")) {
            try {
                WebContext webcx = WebContextFactory.get();
                Object object = creator.getInstance();
                webcx.getServletContext().setAttribute(creator.getJavascript(), object);
                log.debug("Created new " + creator.getJavascript() + ", stored in application.");
            }
            catch (InstantiationException ex) {
                log.warn("Failed to create " + creator.getJavascript(), ex);
                log.debug("Maybe it will succeed when the application is in flight. If so you should probably set initApplicationScopeCreatorsAtStartup=false in web.xml");
            }
        }
    }

    public Collection getCreatorNames() throws SecurityException {
        if (!this.debug) {
            throw new SecurityException();
        }
        return Collections.unmodifiableSet(this.creators.keySet());
    }

    public Creator getCreator(String scriptName) throws SecurityException {
        Creator creator = (Creator)this.creators.get(scriptName);
        if (creator == null) {
            StringBuffer buffer = new StringBuffer("Names of known classes are: ");
            Iterator it = this.creators.keySet().iterator();
            while (it.hasNext()) {
                String key = (String)it.next();
                buffer.append(key);
                buffer.append(' ');
            }
            log.warn(buffer.toString());
            throw new SecurityException(Messages.getString("DefaultCreatorManager.MissingName", scriptName));
        }
        return creator;
    }

    public void setCreators(Map creators) {
        this.creators = creators;
    }

    public boolean isInitApplicationScopeCreatorsAtStartup() {
        return this.initApplicationScopeCreatorsAtStartup;
    }

    public void setInitApplicationScopeCreatorsAtStartup(boolean initApplicationScopeCreatorsAtStartup) {
        this.initApplicationScopeCreatorsAtStartup = initApplicationScopeCreatorsAtStartup;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

