/*
 * Decompiled with CFR 0.152.
 */
package org.directwebremoting.spring;

import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.directwebremoting.AjaxFilter;
import org.directwebremoting.Container;
import org.directwebremoting.extend.AccessControl;
import org.directwebremoting.extend.AjaxFilterManager;
import org.directwebremoting.extend.Configurator;
import org.directwebremoting.extend.ConverterManager;
import org.directwebremoting.extend.Creator;
import org.directwebremoting.extend.CreatorManager;
import org.directwebremoting.impl.SignatureParser;
import org.directwebremoting.spring.ConverterConfig;
import org.directwebremoting.spring.CreatorConfig;
import org.directwebremoting.util.LocalUtil;
import org.directwebremoting.util.Messages;
import org.springframework.util.StringUtils;

public class SpringConfigurator
implements Configurator {
    private Map creatorTypes;
    private Map converterTypes;
    private Map creators;
    private Map converters;
    private String signatures;
    static /* synthetic */ Class class$org$directwebremoting$extend$AccessControl;
    static /* synthetic */ Class class$org$directwebremoting$extend$AjaxFilterManager;
    static /* synthetic */ Class class$org$directwebremoting$extend$ConverterManager;
    static /* synthetic */ Class class$org$directwebremoting$extend$CreatorManager;
    static /* synthetic */ Class class$org$directwebremoting$AjaxFilter;

    public void configure(Container container) {
        String className;
        String typeName;
        Map.Entry entry;
        Iterator it;
        AccessControl accessControl = (AccessControl)container.getBean((class$org$directwebremoting$extend$AccessControl == null ? (class$org$directwebremoting$extend$AccessControl = SpringConfigurator.class$("org.directwebremoting.extend.AccessControl")) : class$org$directwebremoting$extend$AccessControl).getName());
        AjaxFilterManager ajaxFilterManager = (AjaxFilterManager)container.getBean((class$org$directwebremoting$extend$AjaxFilterManager == null ? (class$org$directwebremoting$extend$AjaxFilterManager = SpringConfigurator.class$("org.directwebremoting.extend.AjaxFilterManager")) : class$org$directwebremoting$extend$AjaxFilterManager).getName());
        ConverterManager converterManager = (ConverterManager)container.getBean((class$org$directwebremoting$extend$ConverterManager == null ? (class$org$directwebremoting$extend$ConverterManager = SpringConfigurator.class$("org.directwebremoting.extend.ConverterManager")) : class$org$directwebremoting$extend$ConverterManager).getName());
        CreatorManager creatorManager = (CreatorManager)container.getBean((class$org$directwebremoting$extend$CreatorManager == null ? (class$org$directwebremoting$extend$CreatorManager = SpringConfigurator.class$("org.directwebremoting.extend.CreatorManager")) : class$org$directwebremoting$extend$CreatorManager).getName());
        if (this.creatorTypes != null) {
            it = this.creatorTypes.entrySet().iterator();
            while (it.hasNext()) {
                entry = it.next();
                typeName = (String)entry.getKey();
                className = (String)entry.getValue();
                creatorManager.addCreatorType(typeName, className);
            }
        }
        if (this.converterTypes != null) {
            it = this.converterTypes.entrySet().iterator();
            while (it.hasNext()) {
                entry = it.next();
                typeName = (String)entry.getKey();
                className = (String)entry.getValue();
                converterManager.addConverterType(typeName, className);
            }
        }
        if (this.creators != null) {
            try {
                it = this.creators.entrySet().iterator();
                while (it.hasNext()) {
                    entry = it.next();
                    String scriptName = (String)entry.getKey();
                    CreatorConfig creatorConfig = (CreatorConfig)entry.getValue();
                    if (creatorConfig.getCreator() != null) {
                        Creator creator = creatorConfig.getCreator();
                        creatorManager.addCreator(scriptName, creator);
                    } else {
                        String creatorName = creatorConfig.getCreatorType();
                        Map params = creatorConfig.getParams();
                        creatorManager.addCreator(scriptName, creatorName, params);
                    }
                    List excludes = creatorConfig.getExcludes();
                    Iterator eit = excludes.iterator();
                    while (eit.hasNext()) {
                        String exclude = (String)eit.next();
                        accessControl.addExcludeRule(scriptName, exclude);
                    }
                    List includes = creatorConfig.getIncludes();
                    Iterator iit = includes.iterator();
                    while (iit.hasNext()) {
                        String include = (String)iit.next();
                        accessControl.addIncludeRule(scriptName, include);
                    }
                    Properties auth = creatorConfig.getAuth();
                    Iterator<Map.Entry<Object, Object>> ait = auth.entrySet().iterator();
                    while (ait.hasNext()) {
                        Map.Entry<Object, Object> aentry = ait.next();
                        String methodName = (String)aentry.getKey();
                        String role = (String)aentry.getValue();
                        accessControl.addRoleRestriction(scriptName, methodName, role);
                    }
                    List filters = creatorConfig.getFilters();
                    Iterator fit = filters.iterator();
                    while (fit.hasNext()) {
                        Object obj = fit.next();
                        if (obj instanceof String) {
                            String filterName = (String)obj;
                            AjaxFilter filter = (AjaxFilter)LocalUtil.classNewInstance(filterName, filterName, class$org$directwebremoting$AjaxFilter == null ? SpringConfigurator.class$("org.directwebremoting.AjaxFilter") : class$org$directwebremoting$AjaxFilter);
                            if (filter == null) continue;
                            ajaxFilterManager.addAjaxFilter(filter, scriptName);
                            continue;
                        }
                        if (obj instanceof AjaxFilter) {
                            AjaxFilter filter = (AjaxFilter)obj;
                            ajaxFilterManager.addAjaxFilter(filter, scriptName);
                            continue;
                        }
                        throw new IllegalArgumentException(Messages.getString("SpringConfigurator.InvalidFilter", scriptName, obj));
                    }
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
                throw new IllegalArgumentException(ex.toString());
            }
        }
        if (this.converters != null) {
            try {
                it = this.converters.entrySet().iterator();
                while (it.hasNext()) {
                    entry = it.next();
                    String match = (String)entry.getKey();
                    ConverterConfig converterConfig = (ConverterConfig)entry.getValue();
                    Map params = converterConfig.getParams();
                    if (converterConfig.getIncludes().size() > 0) {
                        params.put("include", StringUtils.collectionToCommaDelimitedString((Collection)converterConfig.getIncludes()));
                    }
                    if (converterConfig.getExcludes().size() > 0) {
                        params.put("exclude", StringUtils.collectionToCommaDelimitedString((Collection)converterConfig.getExcludes()));
                    }
                    if (StringUtils.hasText((String)converterConfig.getJavascriptClassName())) {
                        params.put("javascript", converterConfig.getJavascriptClassName());
                    }
                    converterManager.addConverter(match, converterConfig.getType(), params);
                }
            }
            catch (Exception ex) {
                throw new IllegalArgumentException(Messages.getString("SpringConfigurator.ConfigureConverterError"));
            }
        }
        if (StringUtils.hasText((String)this.signatures)) {
            SignatureParser sigp = new SignatureParser(converterManager, creatorManager);
            sigp.parse(this.signatures);
        }
    }

    public void setCreatorTypes(Map creatorTypes) {
        this.creatorTypes = creatorTypes;
    }

    public void setConverterTypes(Map converterTypes) {
        this.converterTypes = converterTypes;
    }

    public void setCreators(Map creators) {
        this.creators = creators;
    }

    public void setConverters(Map converters) {
        this.converters = converters;
    }

    public void setSignatures(String signatures) {
        this.signatures = signatures;
    }

    public String getSignatures() {
        return this.signatures;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

