/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.hadoop.hive.query;

import com.jaspersoft.hadoop.hive.HiveDataSource;
import com.jaspersoft.hadoop.hive.connection.HiveConnection;
import java.util.Map;
import net.sf.jasperreports.engine.JRDataSource;
import net.sf.jasperreports.engine.JRDataset;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRValueParameter;
import net.sf.jasperreports.engine.query.JRClauseFunction;
import net.sf.jasperreports.engine.query.JRJdbcQueryExecuter;
import net.sf.jasperreports.engine.query.JRSqlInClause;
import net.sf.jasperreports.engine.query.JRSqlNotInClause;
import org.apache.log4j.Logger;

public class HiveQueryExecuter
extends JRJdbcQueryExecuter {
    private static final Logger logger = Logger.getLogger(HiveQueryExecuter.class);

    public HiveQueryExecuter(JRDataset dataset, Map<String, ? extends JRValueParameter> parameters) throws JRException {
        super(dataset, parameters);
        HiveConnection hiveConnection = (HiveConnection)((Map)this.getParameterValue("REPORT_PARAMETERS_MAP")).get("REPORT_CONNECTION");
        if (hiveConnection == null) {
            JRValueParameter valueParameter;
            logger.warn((Object)"No Hive connection, trying default REPORT_CONNECTION");
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("REPORT_PARAMETERS_MAP: " + ((Map)this.getParameterValue("REPORT_PARAMETERS_MAP")).keySet()));
            }
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Direct parameters: " + parameters.keySet()));
            }
            if ((valueParameter = parameters.get("REPORT_CONNECTION")) == null) {
                throw new JRException("No Hive connection");
            }
            hiveConnection = (HiveConnection)valueParameter.getValue();
            if (hiveConnection == null) {
                throw new JRException("No MongoDB connection");
            }
        }
        this.connection = hiveConnection.getSqlConnection();
    }

    protected void registerFunctions() {
        this.registerClauseFunction("IN", (JRClauseFunction)JRSqlInClause.instance());
        this.registerClauseFunction("NOTIN", (JRClauseFunction)JRSqlNotInClause.instance());
    }

    public JRDataSource createDatasource() throws JRException {
        super.createDatasource();
        try {
            return new HiveDataSource(this.resultSet);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new JRException(e.getMessage());
        }
    }
}

